
set SCRIPTPATH=%~dp0
set BLENDED_HOME=%SCRIPTPATH%..

set JAVA_HOME=%BLENDED_HOME%\jre
set JVM=%JAVA_HOME%\bin\client\jvm.dll

call %SCRIPTPATH%\setenv.bat

if "%SERVICE_NAME%"=="" (set SERVICE_NAME="BlendedDemo")

set SERVICE_ENV=BLENDED_HOME=%BLENDED_HOME%;JAVA_HOME=%JAVA_HOME%

if defined BLENDED_ENV set SERVICE_ENV=%SERVICE_ENV%;%BLENDED_ENV%

REM Restart delay in seconds, provide default if not set in setenv.bat
if not defined RESTART_DELAY set RESTART_DELAY=0

set CP=%BLENDED_HOME%/etc^
;%BLENDED_HOME%/lib/blended.launcher_2.12-3.0-M5.jar^
;%BLENDED_HOME%/lib/config-1.3.3.jar^
;%BLENDED_HOME%/lib/org.osgi.core-6.0.0.jar^
;%BLENDED_HOME%/lib/blended.updater.config_2.12-3.0-M5.jar^
;%BLENDED_HOME%/lib/blended.util.logging_2.12-3.0-M5.jar^
;%BLENDED_HOME%/lib/de.tototec.cmdoption-0.6.0.jar^
;%BLENDED_HOME%/lib/scala-library-2.12.8.jar^
;%BLENDED_HOME%/lib/slf4j-api-1.7.25.jar^
;%BLENDED_HOME%/lib/logback-core-1.2.3.jar^
;%BLENDED_HOME%/lib/logback-classic-1.2.3.jar

set LOGBACK_CONFIG_SETTING='-Dlogback.configurationFile=%BLENDED_HOME%/etc/logback.xml'

set CONTAINER_JAVA_OPTS='-jvmOpt=-Dsun.net.client.defaultConnectTimeout=500'
set CONTAINER_JAVA_OPTS=%CONTAINER_JAVA_OPTS%;'-jvmOpt=-Dsun.net.client.defaultReadTimeout=500'
set CONTAINER_JAVA_OPTS=%CONTAINER_JAVA_OPTS%;'-jvmOpt=%LOGBACK_CONFIG_SETTING%'
set CONTAINER_JAVA_OPTS=%CONTAINER_JAVA_OPTS%;'-jvmOpt=-Dblended.home=%BLENDED_HOME%'
REM set CONTAINER_JAVA_OPTS=%CONTAINER_JAVA_OPTS;'-jvmOpt=-Djavax.net.debug=ssl'


set CLASS=blended.launcher.jvmrunner.JvmLauncher

%SCRIPTPATH%prunsrv.exe ^
  //IS//%SERVICE_NAME% ^
  --DisplayName="%SERVICE_NAME%" ^
  --Environment=%SERVICE_ENV% ^
  --Jvm=%JVM% ^
  --Startup=auto ^
  --StartMode=jvm ^
  --StopMode=jvm ^
  --StartClass=%CLASS% ^
  --StartParams="start;-interactive=false;%CONTAINER_JAVA_OPTS%;-cp='%CP%';-restartDelay=%RESTART_DELAY%;--;blended.launcher.Launcher;--profile-lookup;%BLENDED_HOME%/launch.conf;--init-container-id;--framework-restart;false" ^
  --JvmOptions="%LOGBACK_CONFIG_SETTING%" ^
  ++JvmOptions="-Dblended.home=%BLENDED_HOME%" ^
  ++JvmOptions="-Xmx24m" ^
  --StopClass=%CLASS% ^
  --StopParams="stop" ^
  --Classpath="%CP%" ^
  --StdOutput=auto ^
  --StdError=auto ^
  --LogPath=%BLENDED_HOME%/log ^
  --LogLevel=Debug ^
  --LibraryPath=%JAVA_HOME/bin
