/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class BooleanOptionHandler
implements CmdOptionHandler {
    public void applyParams(Object config, AccessibleObject element, String[] args, String optionName) {
        try {
            if (element instanceof Field) {
                Field field = (Field)element;
                field.set(config, true);
            } else {
                Method method = (Method)element;
                if (method.getParameterTypes().length == 1) {
                    method.invoke(config, true);
                } else {
                    method.invoke(config, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canHandle(AccessibleObject element, int argCount) {
        if (argCount != 0) {
            return false;
        }
        if (element instanceof Field) {
            Field field = (Field)element;
            Class<?> type = field.getType();
            return !Modifier.isFinal(field.getModifiers()) && (Boolean.TYPE.equals(type) || Boolean.class.equals(type));
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            if (method.getParameterTypes().length == 0) {
                return true;
            }
            if (method.getParameterTypes().length == 1) {
                Class<?> type = method.getParameterTypes()[0];
                return Boolean.TYPE.equals(type) || Boolean.class.equals(type);
            }
        }
        return false;
    }
}

