/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.annotation.InternalApi;
import akka.io.Dns;
import akka.io.Dns$Resolved$;
import akka.io.PeriodicCacheCleanup;
import akka.io.SimpleDnsCache;
import akka.io.SimpleDnsCache$;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsResolver;
import akka.io.dns.internal.AsyncDnsResolver$Ipv4Type$;
import akka.io.dns.internal.AsyncDnsResolver$Ipv6Type$;
import akka.io.dns.internal.DnsClient;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0006\r\u0001UAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013%!\u0005\u0003\u0004^\u0001\u0001\u0006Ia\t\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0011\u0019\u0019\u0007\u0001)A\u0005A\")A\r\u0001C!K\")!\u000f\u0001C\tg\"1A\u000f\u0001C\u0003!UDa!\u001f\u0001\u0005\u0006AQ\bbBA\u0012\u0001\u0011\u0015\u0013Q\u0005\u0002\u000e\u0003NLhn\u0019#og\u000e\u000b7\r[3\u000b\u00055q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005=\u0001\u0012a\u00013og*\u0011\u0011CE\u0001\u0003S>T\u0011aE\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u00011\"\u0004\u0005\u0002\u001815\t\u0001#\u0003\u0002\u001a!\t\u0019AI\\:\u0011\u0005]Y\u0012B\u0001\u000f\u0011\u0005Q\u0001VM]5pI&\u001c7)Y2iK\u000ecW-\u00198va\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011\u0001D\u0001\tG\u0006\u001c\u0007.\u001a*fMV\t1\u0005E\u0002%[=j\u0011!\n\u0006\u0003M\u001d\na!\u0019;p[&\u001c'B\u0001\u0015*\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003U-\nA!\u001e;jY*\tA&\u0001\u0003kCZ\f\u0017B\u0001\u0018&\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007\u0003\u0002\u0019;{Ys!!\r\u001d\u000f\u0005I:dBA\u001a7\u001b\u0005!$BA\u001b\u0015\u0003\u0019a$o\\8u}%\t1#\u0003\u0002\u0012%%\u0011\u0011\bE\u0001\u000f'&l\u0007\u000f\\3E]N\u001c\u0015m\u00195f\u0013\tYDHA\u0003DC\u000eDWM\u0003\u0002:!A!a(Q\"L\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$A\u0002+va2,'\u0007\u0005\u0002E\u0011:\u0011QI\u0012\t\u0003g}J!aR \u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000f~\u0002\"\u0001T*\u000f\u00055\u000bfB\u0001(Q\u001d\t\tt*\u0003\u0002\u0010!%\u0011QBD\u0005\u0003%2\t\u0001#Q:z]\u000e$en\u001d*fg>dg/\u001a:\n\u0005Q+&!C)vKJLH+\u001f9f\u0015\t\u0011F\u0002\u0005\u0002X5:\u0011Q\nW\u0005\u000332\t\u0011\u0002\u00128t\u00072LWM\u001c;\n\u0005mc&AB!og^,'O\u0003\u0002Z\u0019\u0005I1-Y2iKJ+g\rI\u0001\t]\u0006twNQ1tKV\t\u0001\r\u0005\u0002?C&\u0011!m\u0010\u0002\u0005\u0019>tw-A\u0005oC:|')Y:fA\u000511-Y2iK\u0012$\"A\u001a9\u0011\u0007y:\u0017.\u0003\u0002i\u007f\t1q\n\u001d;j_:\u0004\"A[7\u000f\u0005]Y\u0017B\u00017\u0011\u0003\r!en]\u0005\u0003]>\u0014\u0001BU3t_24X\r\u001a\u0006\u0003YBAQ!\u001d\u0004A\u0002\r\u000bAA\\1nK\u0006)1\r\\8dWR\t\u0001-A\u0002hKR$\"A^<\u0011\u0007y:g\u000bC\u0003y\u0011\u0001\u0007Q(A\u0002lKf\f1\u0001];u)\u0015Yhp`A\u0002!\tqD0\u0003\u0002~\u007f\t!QK\\5u\u0011\u0015A\u0018\u00021\u0001>\u0011\u0019\t\t!\u0003a\u0001-\u00069!/Z2pe\u0012\u001c\bbBA\u0003\u0013\u0001\u0007\u0011qA\u0001\u0004iRd\u0007\u0003BA\u0005\u0003\u001fq1ATA\u0006\u0013\r\tiAD\u0001\f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u00170\u0003\u0003\u0002\u0012\u0005M!aC\"bG\",\u0007k\u001c7jGfT1!!\u0004\u000fQ\rI\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\"\u0005m!a\u0002;bS2\u0014XmY\u0001\bG2,\u0017M\\;q)\u0005Y\bf\u0001\u0006\u0002\u0018!\u001a\u0001!a\u000b\u0011\t\u00055\u0012\u0011G\u0007\u0003\u0003_Q1!!\b\u0013\u0013\u0011\t\u0019$a\f\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b")
public class AsyncDnsCache
extends Dns
implements PeriodicCacheCleanup {
    private final AtomicReference<SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer>> cacheRef = new AtomicReference(new SimpleDnsCache.Cache((SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, SimpleDnsCache$.MODULE$.expiryEntryOrdering()), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.clock()));
    private final long nanoBase = System.nanoTime();

    private AtomicReference<SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer>> cacheRef() {
        return this.cacheRef;
    }

    private long nanoBase() {
        return this.nanoBase;
    }

    @Override
    public Option<Dns.Resolved> cached(String name) {
        return this.cacheRef().get().get((Tuple2<String, AsyncDnsResolver.QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv4Type$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)ipv4 -> this.cacheRef().get().get((Tuple2<String, AsyncDnsResolver.QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv6Type$.MODULE$)).map((Function1 & Serializable & scala.Serializable)ipv6 -> Dns$Resolved$.MODULE$.apply(name, (Iterable<InetAddress>)((Iterable)((TraversableLike)ipv4.rrs().$plus$plus(ipv6.rrs(), Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ResourceRecord, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ARecord) {
                    ARecord aRecord = (ARecord)A1;
                    object = aRecord.ip();
                } else if (A1 instanceof AAAARecord) {
                    AAAARecord aAAARecord = (AAAARecord)A1;
                    object = aAAARecord.ip();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ResourceRecord x1) {
                ResourceRecord resourceRecord = x1;
                boolean bl = resourceRecord instanceof ARecord ? true : resourceRecord instanceof AAAARecord;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())))));
    }

    public long clock() {
        long now = System.nanoTime();
        return now - this.nanoBase() < 0L ? 0L : (now - this.nanoBase()) / 1000000L;
    }

    public final Option<DnsClient.Answer> get(Tuple2<String, AsyncDnsResolver.QueryType> key) {
        return this.cacheRef().get().get(key);
    }

    public final void put(Tuple2<String, AsyncDnsResolver.QueryType> key, DnsClient.Answer records, CachePolicy.CachePolicy ttl) {
        SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer> cache;
        do {
            cache = this.cacheRef().get();
        } while (!this.cacheRef().compareAndSet(cache, cache.put(key, records, ttl)));
    }

    @Override
    public final void cleanup() {
        SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer> c;
        do {
            c = this.cacheRef().get();
        } while (!this.cacheRef().compareAndSet(c, c.cleanup()));
    }
}

