/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ByteHandler
implements CmdOptionHandler {
    public boolean canHandle(AccessibleObject element, int argCount) {
        Method method;
        if (element instanceof Field && argCount == 1) {
            Field field = (Field)element;
            return !Modifier.isFinal(field.getModifiers()) && (field.getType().equals(Byte.class) || field.getType().equals(Byte.TYPE));
        }
        if (element instanceof Method && argCount == 1 && (method = (Method)element).getParameterTypes().length == 1) {
            Class<?> type = method.getParameterTypes()[0];
            return Byte.TYPE.equals(type) || Byte.class.equals(type);
        }
        return false;
    }

    public void applyParams(Object config, AccessibleObject element, String[] args, String optionName) throws CmdOptionHandlerException {
        byte parsedValue = 0;
        try {
            String arg = args[0];
            parsedValue = Byte.parseByte(arg);
        }
        catch (NumberFormatException e) {
            I18n i18n = I18nFactory.getI18n(ByteHandler.class);
            I18n.PreparedI18n msg = i18n.preparetr("Could not read byte value \"{0}\".", args[0]);
            throw new CmdOptionHandlerException(msg.notr(), e, msg.tr());
        }
        try {
            if (element instanceof Field) {
                Field field = (Field)element;
                field.set(config, parsedValue);
            } else {
                Method method = (Method)element;
                method.invoke(config, parsedValue);
            }
        }
        catch (Exception e) {
            I18n i18n = I18nFactory.getI18n(ByteHandler.class);
            I18n.PreparedI18n msg = i18n.preparetr("Could not apply argument \"{0}\".", args[0]);
            throw new CmdOptionHandlerException(msg.notr(), e, msg.tr());
        }
    }
}

