/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class BooleanHandler
implements CmdOptionHandler {
    private final String[] trueWords;
    private final String[] falseWords;
    private final boolean caseSensitive;

    public BooleanHandler() {
        this(new String[]{"on", "true", "1"}, new String[]{"off", "false", "0"}, false);
    }

    public BooleanHandler(String[] trueWords, String[] falseWords, boolean caseSensitive) {
        this.trueWords = trueWords;
        this.falseWords = falseWords;
        this.caseSensitive = caseSensitive;
    }

    public boolean canHandle(AccessibleObject element, int argCount) {
        Method method;
        if (element instanceof Field && argCount == 1) {
            Field field = (Field)element;
            return !Modifier.isFinal(field.getModifiers()) && (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE));
        }
        if (element instanceof Method && argCount == 1 && (method = (Method)element).getParameterTypes().length == 1) {
            Class<?> type = method.getParameterTypes()[0];
            return Boolean.TYPE.equals(type) || Boolean.class.equals(type);
        }
        return false;
    }

    public void applyParams(Object config, AccessibleObject element, String[] args, String optionName) throws CmdOptionHandlerException {
        String arg = args[0];
        if (!this.caseSensitive) {
            arg = arg.toLowerCase();
        }
        Boolean decission = null;
        for (String word : this.trueWords) {
            if (!arg.equals(this.caseSensitive ? word : word.toLowerCase())) continue;
            decission = true;
            break;
        }
        if (decission == null) {
            if (this.falseWords == null || this.falseWords.length == 0) {
                decission = false;
            } else {
                for (String word : this.falseWords) {
                    if (!arg.equals(this.caseSensitive ? word : word.toLowerCase())) continue;
                    decission = false;
                    break;
                }
            }
        }
        if (decission == null) {
            I18n i18n = I18nFactory.getI18n(BooleanHandler.class);
            I18n.PreparedI18n msg = i18n.preparetr("Could not parse argument \"{0}\" as boolean parameter.", args[0]);
            throw new CmdOptionHandlerException(msg.notr(), msg.tr());
        }
        try {
            if (element instanceof Field) {
                Field field = (Field)element;
                field.set(config, decission);
            } else {
                Method method = (Method)element;
                method.invoke(config, (boolean)decission);
            }
        }
        catch (Exception e) {
            I18n i18n = I18nFactory.getI18n(BooleanHandler.class);
            I18n.PreparedI18n msg = i18n.preparetr("Could not apply argument \"{0}\".", args[0]);
            throw new CmdOptionHandlerException(msg.notr(), e, msg.tr());
        }
    }
}

