/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption;

import de.tototec.cmdoption.CmdCommand;
import de.tototec.cmdoption.CmdOption;
import de.tototec.cmdoption.CmdOptionDelegate;
import de.tototec.cmdoption.CmdlineModel;
import de.tototec.cmdoption.CmdlineParserException;
import de.tototec.cmdoption.CommandHandle;
import de.tototec.cmdoption.DefaultUsageFormatter2;
import de.tototec.cmdoption.OptionHandle;
import de.tototec.cmdoption.TtyLineLengthDetector;
import de.tototec.cmdoption.UsageFormatter;
import de.tototec.cmdoption.UsageFormatter2;
import de.tototec.cmdoption.WrappingUsageFormatter;
import de.tototec.cmdoption.handler.AddToCollectionHandler;
import de.tototec.cmdoption.handler.BooleanHandler;
import de.tototec.cmdoption.handler.BooleanOptionHandler;
import de.tototec.cmdoption.handler.ByteHandler;
import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.handler.EnumHandler;
import de.tototec.cmdoption.handler.IntegerHandler;
import de.tototec.cmdoption.handler.LongHandler;
import de.tototec.cmdoption.handler.PutIntoMapHandler;
import de.tototec.cmdoption.handler.StringFieldHandler;
import de.tototec.cmdoption.handler.StringMethodHandler;
import de.tototec.cmdoption.internal.F0;
import de.tototec.cmdoption.internal.F1;
import de.tototec.cmdoption.internal.FList;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import de.tototec.cmdoption.internal.Logger;
import de.tototec.cmdoption.internal.LoggerFactory;
import de.tototec.cmdoption.internal.Optional;
import de.tototec.cmdoption.internal.Procedure1;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdlineParser {
    private final I18n i18n = I18nFactory.getI18n(CmdlineParser.class);
    private final Logger log = LoggerFactory.getLogger(CmdlineParser.class);
    private Optional<OptionHandle> parameter = Optional.none();
    private final List<OptionHandle> options = new LinkedList<OptionHandle>();
    private final Map<String, OptionHandle> quickOptionMap = new LinkedHashMap<String, OptionHandle>();
    private final List<CommandHandle> commands = new LinkedList<CommandHandle>();
    private final Map<String, CommandHandle> quickCommandMap = new LinkedHashMap<String, CommandHandle>();
    private String defaultCommandName = null;
    private final Map<Class<? extends CmdOptionHandler>, CmdOptionHandler> handlerRegistry;
    private UsageFormatter2 usageFormatter;
    private String programName;
    private String parsedCommandName;
    private String aboutLine;
    private boolean debugAllowed = true;
    private boolean debugMode = false;
    final String DEBUG_PREFIX = "CMDOPTION_DEBUG: ";
    private final CmdlineParser parent;
    private ResourceBundle resourceBundle;
    private Optional<String> argsFromFilePrefix = Optional.some("@");
    private Optional<String> aggregateShortOptionsWithPrefix = Optional.none();

    protected CmdlineParser(CmdlineParser parent, String commandName, Object commandObject) {
        this.parent = parent;
        this.debugAllowed = parent.debugAllowed;
        this.debugMode = parent.debugMode;
        this.programName = commandName;
        this.handlerRegistry = parent.handlerRegistry;
        this.resourceBundle = parent.resourceBundle;
        this.argsFromFilePrefix = parent.argsFromFilePrefix;
        this.usageFormatter = parent.usageFormatter;
        this.scanOptions(commandObject);
    }

    public CmdlineParser(Object ... objects) {
        this.parent = null;
        this.programName = "<main class>";
        this.usageFormatter = new DefaultUsageFormatter2(true, 80, new TtyLineLengthDetector());
        this.handlerRegistry = new LinkedHashMap<Class<? extends CmdOptionHandler>, CmdOptionHandler>();
        FList.foreach(this.defaultHandlers(), new Procedure1<CmdOptionHandler>(){

            @Override
            public void apply(CmdOptionHandler h) {
                CmdlineParser.this.registerHandler(h);
            }
        });
        this.addObject(objects);
    }

    public List<CmdOptionHandler> defaultHandlers() {
        return Arrays.asList(new BooleanOptionHandler(), new BooleanHandler(), new StringFieldHandler(), new PutIntoMapHandler(), new AddToCollectionHandler(), new StringMethodHandler(), new LongHandler(), new IntegerHandler(), new ByteHandler(), new EnumHandler());
    }

    private void debug(String msg, Object ... args) {
        if (this.log.isDebugEnabled()) {
            if (args == null || args.length == 0) {
                this.log.debug(msg, new Object[0]);
            } else {
                this.log.debug(MessageFormat.format(msg, args), new Object[0]);
            }
        }
        if (this.parent != null) {
            this.parent.debug(msg, args);
        } else if (this.debugMode) {
            if (args == null || args.length == 0) {
                System.out.println("CMDOPTION_DEBUG: " + msg);
            } else {
                System.out.println("CMDOPTION_DEBUG: " + MessageFormat.format(msg, args));
            }
        }
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setDebugModeAllowed(boolean debugAllowed) {
        this.debugAllowed = debugAllowed;
    }

    @Deprecated
    public void setUsageFormatter(UsageFormatter usageFormatter) {
        this.usageFormatter = new WrappingUsageFormatter(usageFormatter);
    }

    public void setUsageFormatter(UsageFormatter2 usageFormatter) {
        this.usageFormatter = usageFormatter;
    }

    public void setDefaultCommandName(String defaultCommandName) {
        this.defaultCommandName = defaultCommandName;
    }

    public void setDefaultCommandClass(Class<?> defaultCommandClass) {
        CmdCommand anno = defaultCommandClass.getAnnotation(CmdCommand.class);
        if (anno == null) {
            throw new IllegalArgumentException("Given class is not annotated with @" + CmdCommand.class.getSimpleName());
        }
        if (anno.names() == null || anno.names().length == 0 || anno.names()[0].length() == 0) {
            throw new IllegalArgumentException("Given default command class has no valid name");
        }
        this.setDefaultCommandName(anno.names()[0]);
    }

    public void parse(String ... cmdline) {
        this.parse(false, true, cmdline);
    }

    private String debugState(String prefix) {
        return prefix + "Parameter: " + this.parameter.orNull() + "\n" + prefix + "Options: " + FList.mkString(this.options, "\n" + prefix + "  ", ",\n" + prefix + "  ", "") + "\n" + prefix + "Commands: " + FList.mkString(this.commands, "\n" + prefix + "  ", ",\n" + prefix + "  ", "") + "\n" + prefix + "ResourceBundle: " + this.resourceBundle + "\n" + prefix + "Locale: " + (this.resourceBundle == null ? null : this.resourceBundle.getLocale()) + "\n" + prefix + "CmdOptionHandlers: " + FList.mkString(this.handlerRegistry.entrySet(), "\n" + prefix + "  ", "\n" + prefix + "  ", "");
    }

    public void parse(boolean dryrun, boolean detectHelpAndSkipValidation, String ... cmdline) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("About to start parsing. dryrun: " + dryrun + ", detectHelpAndSkipValidation: " + detectHelpAndSkipValidation + ", state: " + this.debugState("  "), new Object[0]);
        }
        if (this.defaultCommandName != null && !this.quickCommandMap.containsKey(this.defaultCommandName)) {
            I18n.PreparedI18n msg = this.i18n.preparetr("Default command \"{0}\" is not a known command.", this.defaultCommandName);
            throw new CmdlineParserException(msg.notr(), msg.tr());
        }
        String[] stringArray = cmdline = cmdline == null ? new String[]{} : cmdline;
        if (this.argsFromFilePrefix.isDefined()) {
            cmdline = FList.flatMap(cmdline, new F1<String, List<String>>(){

                @Override
                public List<String> apply(String arg) {
                    if (arg.startsWith((String)CmdlineParser.this.argsFromFilePrefix.get())) {
                        CmdlineParser.this.debug("Expanding {0} into argument list", new Object[]{arg});
                        File file = new File(arg.substring(1));
                        if (file.exists() && file.isFile()) {
                            try {
                                String line;
                                BufferedReader reader = new BufferedReader(new FileReader(file));
                                LinkedList<String> args = new LinkedList<String>();
                                while ((line = reader.readLine()) != null) {
                                    args.add(line);
                                }
                                reader.close();
                                return args;
                            }
                            catch (FileNotFoundException e) {
                                I18n.PreparedI18n msg = CmdlineParser.this.i18n.preparetr("File referenced via {0} does not exist.", arg);
                                throw new CmdlineParserException(msg.notr(), e, msg.tr());
                            }
                            catch (IOException e) {
                                I18n.PreparedI18n msg = CmdlineParser.this.i18n.preparetr("File referenced via {0} could not be read.", arg);
                                throw new CmdlineParserException(msg.notr(), e, msg.tr());
                            }
                        }
                        I18n.PreparedI18n msg = CmdlineParser.this.i18n.preparetr("File referenced via {0} does not exist.", arg);
                        throw new CmdlineParserException(msg.notr(), msg.tr());
                    }
                    return Arrays.asList(arg);
                }
            }).toArray(new String[0]);
        }
        if (!dryrun) {
            this.debug("Parsing...", new Object[0]);
            this.parse(true, detectHelpAndSkipValidation, cmdline);
        }
        if (dryrun) {
            this.validateOptions();
        }
        boolean parseOptions = true;
        String stopOption = "--";
        LinkedHashMap<OptionHandle, Integer> optionCount = new LinkedHashMap<OptionHandle, Integer>();
        for (OptionHandle option : this.options) {
            optionCount.put(option, 0);
        }
        if (this.parameter.isDefined()) {
            optionCount.put(this.parameter.get(), 0);
        }
        boolean helpDetected = false;
        String aggregatePrefix = this.aggregateShortOptionsWithPrefix.getOrElse(new F0<String>(){

            @Override
            public String apply() {
                return "";
            }
        });
        LinkedHashMap<String, OptionHandle> shortOptionMap = new LinkedHashMap<String, OptionHandle>();
        int aggregatePrefixSize = aggregatePrefix.length();
        if (this.aggregateShortOptionsWithPrefix.isDefined()) {
            int expectedSize = 1 + aggregatePrefixSize;
            for (Map.Entry<String, OptionHandle> oh : this.quickOptionMap.entrySet()) {
                if (!oh.getKey().startsWith(aggregatePrefix) || oh.getKey().length() != expectedSize) continue;
                shortOptionMap.put(oh.getKey().substring(aggregatePrefixSize), oh.getValue());
            }
        }
        int index = -1;
        String[] rest = cmdline;
        while (rest.length > index + 1) {
            AccessibleObject element;
            Object[] optionArgs;
            if (index >= 0) {
                rest = Arrays.copyOfRange(rest, ++index, rest.length);
            }
            index = 0;
            String param = rest[index];
            if (parseOptions && "--".equals(param)) {
                parseOptions = false;
            } else {
                if (this.debugAllowed && param.equals("--CMDOPTION_DEBUG")) {
                    if (this.debugMode) continue;
                    this.debugMode = true;
                    this.debug("Enabled debug mode\n" + this.debugState(""), new Object[0]);
                    continue;
                }
                if (parseOptions && this.quickOptionMap.containsKey(param)) {
                    OptionHandle optionHandle = this.quickOptionMap.get(param);
                    optionCount.put(optionHandle, (Integer)optionCount.get(optionHandle) + 1);
                    if (optionHandle.isHelp()) {
                        this.debug("Detected a help request through: " + param, new Object[0]);
                        helpDetected = true;
                    }
                    if (rest.length <= index + optionHandle.getArgsCount()) {
                        I18n.PreparedI18n msg = this.i18n.preparetr("Missing argument(s): {0}. Option \"{1}\" requires {2} arguments, but you gave {3}.", FList.mkString(Arrays.asList(optionHandle.getArgs()).subList(rest.length - index - 1, optionHandle.getArgsCount()), ", "), param, optionHandle.getArgsCount(), rest.length - index - 1);
                        throw new CmdlineParserException(msg.notr(), msg.tr());
                    }
                    optionArgs = Arrays.copyOfRange(rest, index + 1, index + 1 + optionHandle.getArgsCount());
                    index += optionHandle.getArgsCount();
                    element = optionHandle.getElement();
                    CmdOptionHandler handler = optionHandle.getCmdOptionHandler();
                    if (dryrun) continue;
                    try {
                        boolean origAccessibleFlag = element.isAccessible();
                        if (!origAccessibleFlag) {
                            element.setAccessible(true);
                        }
                        handler.applyParams(optionHandle.getObject(), element, (String[])optionArgs, param);
                        if (origAccessibleFlag) continue;
                        element.setAccessible(origAccessibleFlag);
                        continue;
                    }
                    catch (CmdOptionHandlerException e) {
                        throw new CmdlineParserException(e.getMessage(), e, e.getLocalizedMessage());
                    }
                    catch (Exception e) {
                        I18n.PreparedI18n msg = this.i18n.preparetr("Could not apply parameters {0} to field/method {1}", Arrays.toString(optionArgs), element);
                        throw new CmdlineParserException(msg.notr(), e, msg.tr());
                    }
                }
                if (parseOptions && this.quickCommandMap.containsKey(param)) {
                    CommandHandle commandHandle = this.quickCommandMap.get(param);
                    if (!dryrun) {
                        this.parsedCommandName = param;
                    }
                    commandHandle.getCmdlineParser().parse(dryrun, detectHelpAndSkipValidation, Arrays.copyOfRange(rest, index + 1, rest.length));
                    break;
                }
            }
            if (parseOptions && this.aggregateShortOptionsWithPrefix.isDefined() && param.startsWith(aggregatePrefix) && param.length() > aggregatePrefixSize + 1) {
                boolean failed = false;
                char[] singleOptions = param.substring(aggregatePrefixSize).toCharArray();
                LinkedList<String> rewritten = new LinkedList<String>();
                int procCount = 1;
                for (char c : singleOptions) {
                    OptionHandle oh = (OptionHandle)shortOptionMap.get(String.valueOf(c));
                    if (oh == null) {
                        failed = true;
                        break;
                    }
                    if (rest.length < procCount + oh.getArgsCount()) {
                        I18n.PreparedI18n msg = this.i18n.preparetr("Missing argument(s): {0}. Option \"{1}\" requires {2} arguments, but you gave {3}.", FList.mkString(Arrays.asList(oh.getArgs()).subList(rest.length - procCount, oh.getArgsCount()), ", "), aggregatePrefix + c, oh.getArgsCount(), rest.length - procCount);
                        throw new CmdlineParserException(msg.notr(), msg.tr());
                    }
                    rewritten.add(aggregatePrefix + c);
                    for (int i = 0; i < oh.getArgsCount(); ++i) {
                        rewritten.add(rest[i + procCount]);
                        ++procCount;
                    }
                }
                if (!failed) {
                    String[] newRest = Arrays.copyOfRange(rest, procCount, rest.length);
                    rewritten.addAll(Arrays.asList(newRest));
                    rest = rewritten.toArray(new String[0]);
                    index = -1;
                    continue;
                }
            }
            if (this.parameter.isEmpty() && this.defaultCommandName != null && this.quickCommandMap.containsKey(this.defaultCommandName)) {
                this.debug("Unsupported option '" + param + "' found, assuming default command: " + this.defaultCommandName, new Object[0]);
                CommandHandle commandHandle = this.quickCommandMap.get(this.defaultCommandName);
                if (!dryrun) {
                    this.parsedCommandName = this.defaultCommandName;
                }
                commandHandle.getCmdlineParser().parse(dryrun, detectHelpAndSkipValidation, Arrays.copyOfRange(rest, index, rest.length));
                break;
            }
            if (this.parameter.isDefined()) {
                OptionHandle paramHandle = this.parameter.get();
                optionCount.put(paramHandle, (Integer)optionCount.get(paramHandle) + 1);
                if (rest.length <= index + paramHandle.getArgsCount() - 1) {
                    int countOfGivenParams = rest.length - index;
                    I18n.PreparedI18n msg = this.i18n.preparetr("Missing arguments: {0} Parameter requires {1} arguments, but you gave {2}.", Arrays.asList(paramHandle.getArgs()).subList(countOfGivenParams, paramHandle.getArgsCount()), paramHandle.getArgsCount(), countOfGivenParams);
                    throw new CmdlineParserException(msg.notr(), msg.tr());
                }
                optionArgs = Arrays.copyOfRange(rest, index, index + paramHandle.getArgsCount());
                index += paramHandle.getArgsCount() - 1;
                element = paramHandle.getElement();
                CmdOptionHandler handler = paramHandle.getCmdOptionHandler();
                if (dryrun) continue;
                try {
                    this.debug("Apply main parameter from parameters: {0}", FList.mkString(optionArgs, ", "));
                    boolean origAccessibleFlag = element.isAccessible();
                    if (!origAccessibleFlag) {
                        element.setAccessible(true);
                    }
                    handler.applyParams(paramHandle.getObject(), element, (String[])optionArgs, param);
                    if (origAccessibleFlag) continue;
                    element.setAccessible(origAccessibleFlag);
                    continue;
                }
                catch (CmdOptionHandlerException e) {
                    throw new CmdlineParserException(e.getMessage(), e, e.getLocalizedMessage());
                }
                catch (Exception e) {
                    I18n.PreparedI18n msg = this.i18n.preparetr("Could not apply parameters {0} to field/method {1}", Arrays.toString(optionArgs), element);
                    throw new CmdlineParserException(msg.notr(), e, msg.tr());
                }
            }
            I18n.PreparedI18n msg = this.i18n.preparetr("Unsupported option or parameter found: {0}", param);
            throw new CmdlineParserException(msg.notr(), msg.tr());
        }
        if (!detectHelpAndSkipValidation || !helpDetected) {
            for (Map.Entry optionC : optionCount.entrySet()) {
                Object[] msgArgsTr;
                Object[] msgArgs;
                String msg;
                OptionHandle option = (OptionHandle)optionC.getKey();
                Integer count = (Integer)optionC.getValue();
                if (count >= option.getMinCount() && (option.getMaxCount() <= 0 || count <= option.getMaxCount())) continue;
                I18n.PreparedI18n rangeMsg = option.getMaxCount() < 0 ? this.i18n.preparetr("at least {0}", option.getMinCount()) : (option.getMinCount() == option.getMaxCount() ? this.i18n.preparetr("exactly {0}", option.getMinCount()) : this.i18n.preparetr("between {0} and {1}", option.getMinCount(), option.getMaxCount()));
                if (option.getNames() == null || option.getNames().length == 0) {
                    msg = I18n.marktr("Main parameter \"{0}\" was given {1} times, but must be given {2} times");
                    msgArgs = new Object[]{FList.mkString(option.getArgs(), " "), count, rangeMsg.notr()};
                    msgArgsTr = new Object[]{FList.mkString(option.getArgs(), " "), count, rangeMsg.tr()};
                } else {
                    msg = I18n.marktr("Option \"{0}\" was given {1} times, but must be given {2} times");
                    msgArgs = new Object[]{option.getNames()[0], count, rangeMsg.notr()};
                    msgArgsTr = new Object[]{option.getNames()[0], count, rangeMsg.tr()};
                }
                throw new CmdlineParserException(MessageFormat.format(msg, msgArgs), this.i18n.tr(msg, msgArgsTr));
            }
            for (Map.Entry optionC : optionCount.entrySet()) {
                I18n.PreparedI18n msg;
                if ((Integer)optionC.getValue() <= 0) continue;
                OptionHandle calledOption = (OptionHandle)optionC.getKey();
                for (String required : calledOption.getRequires()) {
                    Integer reqOptionCount;
                    OptionHandle reqOptionHandle = this.quickOptionMap.get(required);
                    if (reqOptionHandle == null || (reqOptionCount = (Integer)optionCount.get(reqOptionHandle)) != null && reqOptionCount > 0) continue;
                    msg = this.i18n.preparetr("When using option \"{0}\" also option \"{1}\" must be given.", calledOption.getNames()[0], required);
                    throw new CmdlineParserException(msg.notr(), msg.tr());
                }
                for (String conflict : calledOption.getConflictsWith()) {
                    Integer conflictOptionCount;
                    OptionHandle conflictOptionHandle = this.quickOptionMap.get(conflict);
                    if (conflictOptionHandle == null || (conflictOptionCount = (Integer)optionCount.get(conflictOptionHandle)) == null || conflictOptionCount <= 0) continue;
                    msg = this.i18n.preparetr("Options \"{0}\" and \"{1}\" cannot be used at the same time.", calledOption.getNames()[0], conflict);
                    throw new CmdlineParserException(msg.notr(), msg.tr());
                }
            }
        }
    }

    public String getParsedCommandName() {
        return this.parsedCommandName;
    }

    public Object getParsedCommandObject() {
        if (this.parsedCommandName != null) {
            return this.quickCommandMap.get(this.parsedCommandName).getObject();
        }
        return null;
    }

    protected CmdOptionHandler findHandler(AccessibleObject element, int argsCount, Class<? extends CmdOptionHandler> cmdOptionHandlerType) {
        CmdOptionHandler handler;
        block7: {
            block6: {
                CmdOptionHandler dedicatedHandler;
                handler = null;
                if (cmdOptionHandlerType == null || cmdOptionHandlerType.equals(CmdOptionHandler.class)) break block6;
                if (this.handlerRegistry.containsKey(cmdOptionHandlerType)) {
                    dedicatedHandler = this.handlerRegistry.get(cmdOptionHandlerType);
                } else {
                    try {
                        dedicatedHandler = cmdOptionHandlerType.newInstance();
                    }
                    catch (Exception e) {
                        I18n.PreparedI18n msg = this.i18n.preparetr("Could not create handler: {0}", cmdOptionHandlerType);
                        throw new CmdlineParserException(msg.notr(), e, msg.tr());
                    }
                }
                if (!dedicatedHandler.canHandle(element, argsCount)) break block7;
                handler = dedicatedHandler;
                break block7;
            }
            for (CmdOptionHandler regHandle : this.handlerRegistry.values()) {
                if (!regHandle.canHandle(element, argsCount)) continue;
                handler = regHandle;
                break;
            }
        }
        if (handler == null && this.parent != null) {
            return this.parent.findHandler(element, argsCount, cmdOptionHandlerType);
        }
        return handler;
    }

    public void addObject(Object ... objects) {
        for (Object object : objects) {
            if (object.getClass().getAnnotation(CmdCommand.class) != null) {
                CommandHandle command = this.scanCommand(object);
                for (String name : command.getNames()) {
                    if (this.quickCommandMap.containsKey(name) || this.quickOptionMap.containsKey(name)) {
                        I18n.PreparedI18n msg = this.i18n.preparetr("Duplicate command/option name \"{0}\" found in: {1}", name, object);
                        throw new CmdlineParserException(msg.notr(), msg.tr());
                    }
                    this.quickCommandMap.put(name, command);
                }
                this.commands.add(command);
                continue;
            }
            this.scanOptions(object);
        }
    }

    protected CommandHandle scanCommand(Object object) {
        CmdCommand commandAnno = object.getClass().getAnnotation(CmdCommand.class);
        String[] names = commandAnno.names();
        if (names == null || names.length == 0) {
            I18n.PreparedI18n msg = this.i18n.preparetr("Command found without required name in: {0}", object);
            throw new CmdlineParserException(msg.notr(), msg.tr());
        }
        CmdlineParser subCmdlineParser = new CmdlineParser(this, names[0], object);
        return new CommandHandle(names, commandAnno.description(), subCmdlineParser, object, commandAnno.hidden());
    }

    public void validate() {
        this.validateOptions();
        for (CommandHandle command : this.commands) {
            command.getCmdlineParser().validate();
        }
    }

    protected void validateOptions() {
        int noNameCount = 0;
        for (OptionHandle optionHandle : this.options) {
            String optionName;
            if (optionHandle.getNames() == null) {
                optionName = "<no name>";
                ++noNameCount;
            } else {
                optionName = optionHandle.getNames()[0];
            }
            if (optionHandle.getMaxCount() >= 0 && optionHandle.getMaxCount() < optionHandle.getMinCount()) {
                I18n.PreparedI18n msg = this.i18n.preparetr("The option \"{0}\" has inconsistent min..max count configuration (min={1}, max={2}).", optionName, optionHandle.getMinCount(), optionHandle.getMaxCount());
                throw new CmdlineParserException(msg.notr(), msg.tr());
            }
            for (String reqOptionName : optionHandle.getRequires()) {
                if (this.quickOptionMap.get(reqOptionName) != null) continue;
                I18n.PreparedI18n msg = this.i18n.preparetr("The option \"{0}\" requires the unknown/missing option \"{1}\".", optionName, reqOptionName);
                throw new CmdlineParserException(msg.notr(), msg.tr());
            }
            for (String conflictOptionName : optionHandle.getConflictsWith()) {
                if (Arrays.asList(optionHandle.getNames()).contains(conflictOptionName)) {
                    I18n.PreparedI18n msg = this.i18n.preparetr("Option \"{0}\" is configured to conflicts with itself.", optionName);
                    throw new CmdlineParserException(msg.notr(), msg.tr());
                }
                if (this.quickOptionMap.get(conflictOptionName) != null) continue;
                I18n.PreparedI18n msg = this.i18n.preparetr("The option \"{0}\" conflicts with a unknown/missing option \"{1}\".", optionName, conflictOptionName);
                throw new CmdlineParserException(msg.notr(), msg.tr());
            }
        }
        if (noNameCount > 1) {
            I18n.PreparedI18n msg = this.i18n.preparetr("More than one main parameter detected ({0}).", noNameCount);
            throw new CmdlineParserException(msg.notr(), msg.tr());
        }
    }

    protected boolean isVisible(Class<?> baseClass, Member element) {
        if (baseClass == null || element == null) {
            return false;
        }
        int modifiers = element.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        if (Modifier.isProtected(modifiers)) {
            return true;
        }
        return !Modifier.isPrivate(modifiers) && baseClass.getPackage().equals(element.getDeclaringClass().getPackage());
    }

    protected boolean isPublicOrProtected(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
    }

    protected boolean isPackagePrivate(Method method) {
        int modifiers = method.getModifiers();
        return !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers);
    }

    protected boolean isPrivate(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPrivate(modifiers);
    }

    protected boolean containsMethod(Iterable<Method> methods, Method method) {
        return this.findMethod(methods, method) != null;
    }

    protected Method findMethod(Iterable<Method> methods, Method method) {
        for (Method existsingMethod : methods) {
            Class<?>[] newTypes;
            Class<?>[] existingTypes;
            if (!existsingMethod.getName().equals(method.getName()) || (existingTypes = existsingMethod.getParameterTypes()).length != (newTypes = method.getParameterTypes()).length) continue;
            boolean same = true;
            for (int i = 0; i < existingTypes.length; ++i) {
                same &= existingTypes[i].equals(newTypes[i]);
            }
            if (!same) continue;
            return existsingMethod;
        }
        return null;
    }

    protected void scanOptions(Object object) {
        Class<?> class1 = object.getClass();
        LinkedList<Field> fields = new LinkedList<Field>();
        LinkedList<Method> privateMethods = new LinkedList<Method>();
        LinkedList<Method> otherPackageNonPrivateMethods = new LinkedList<Method>();
        LinkedList<Method> currentPackageNonPrivateMethods = new LinkedList<Method>();
        for (Class<?> parentClass = class1; parentClass != null && !parentClass.equals(Object.class); parentClass = parentClass.getSuperclass()) {
            fields.addAll(Arrays.asList(parentClass.getDeclaredFields()));
            for (Method method : parentClass.getDeclaredMethods()) {
                if (this.isPrivate(method)) {
                    privateMethods.add(method);
                    continue;
                }
                if (this.isPublicOrProtected(method)) {
                    if (this.containsMethod(otherPackageNonPrivateMethods, method) || this.containsMethod(currentPackageNonPrivateMethods, method)) continue;
                    currentPackageNonPrivateMethods.add(method);
                    continue;
                }
                if (!this.isPackagePrivate(method) || !this.isPackagePrivate(method) || this.containsMethod(currentPackageNonPrivateMethods, method)) continue;
                currentPackageNonPrivateMethods.add(method);
            }
            Package pack = parentClass.getPackage();
            if ((pack != null || parentClass.getPackage() == null) && (pack == null || pack.equals(parentClass.getPackage()))) continue;
            otherPackageNonPrivateMethods.addAll(currentPackageNonPrivateMethods);
            currentPackageNonPrivateMethods.clear();
        }
        LinkedHashSet<AccessibleObject> elements = new LinkedHashSet<AccessibleObject>();
        elements.addAll(fields);
        elements.addAll(privateMethods);
        elements.addAll(otherPackageNonPrivateMethods);
        elements.addAll(currentPackageNonPrivateMethods);
        this.options.addAll(this.inspectElements(object, elements));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<OptionHandle> inspectElements(Object object, Set<AccessibleObject> elements) {
        LinkedList<OptionHandle> options = new LinkedList<OptionHandle>();
        for (AccessibleObject element : elements) {
            I18n.PreparedI18n msg;
            if (element instanceof Field && element.getAnnotation(CmdOptionDelegate.class) != null) {
                this.debug("Found delegate object at: {0}", element);
                try {
                    Object delegate;
                    boolean origAccessibleFlag = element.isAccessible();
                    try {
                        if (!origAccessibleFlag) {
                            element.setAccessible(true);
                        }
                        delegate = ((Field)element).get(object);
                    }
                    finally {
                        if (!origAccessibleFlag) {
                            element.setAccessible(origAccessibleFlag);
                        }
                    }
                    if (delegate == null) continue;
                    this.scanOptions(delegate);
                }
                catch (IllegalArgumentException e) {
                    this.debug("Could not scan delegate object at: {0}", element);
                }
                catch (IllegalAccessException e) {
                    this.debug("Could not scan delegate object at: {0}", element);
                }
                continue;
            }
            CmdOption anno = element.getAnnotation(CmdOption.class);
            if (anno == null) continue;
            if (element instanceof Field && Modifier.isFinal(((Field)element).getModifiers())) {
                this.debug("Detected option on final field: {0}", element);
            }
            String[] names = anno.names();
            CmdOptionHandler handler = this.findHandler(element, anno.args().length, anno.handler());
            if (handler == null) {
                msg = this.i18n.preparetr("No suitable handler found for option(s): {0} ({1} argument(s))", FList.mkString(anno.names(), ","), anno.args().length);
                throw new CmdlineParserException(msg.notr(), msg.tr());
            }
            if (names == null || names.length == 0) {
                if (this.parameter.isDefined()) {
                    msg = this.i18n.preparetr("More than one parameter definition found. First definition: {0} Second definition: {1}", this.parameter.get().getElement(), element);
                    throw new CmdlineParserException(msg.notr(), msg.tr());
                }
                OptionHandle paramHandle = new OptionHandle(new String[0], anno.description(), handler, object, element, anno.args(), anno.minCount(), anno.maxCount(), false, anno.hidden(), anno.requires(), anno.conflictsWith());
                if (paramHandle.getArgsCount() <= 0) {
                    I18n.PreparedI18n msg2 = this.i18n.preparetr("Parameter definition must support at least on argument.", new Object[0]);
                    throw new CmdlineParserException(msg2.notr(), msg2.tr());
                }
                this.parameter = Optional.some(paramHandle);
                continue;
            }
            OptionHandle option = new OptionHandle(names, anno.description(), handler, object, element, anno.args(), anno.minCount(), anno.maxCount(), anno.isHelp(), anno.hidden(), anno.requires(), anno.conflictsWith());
            for (String name : names) {
                if (this.quickCommandMap.containsKey(name) || this.quickOptionMap.containsKey(name)) {
                    I18n.PreparedI18n msg3 = this.i18n.preparetr("Duplicate command/option name \"{0}\" found in: {1}", name, element);
                    throw new CmdlineParserException(msg3.notr(), msg3.tr());
                }
                this.quickOptionMap.put(name, option);
            }
            options.add(option);
        }
        return options;
    }

    public void unregisterAllHandler() {
        this.handlerRegistry.clear();
    }

    public void unregisterHandler(Class<? extends CmdOptionHandler> type) {
        if (type != null) {
            this.handlerRegistry.remove(type);
        }
    }

    public void registerHandler(CmdOptionHandler handler) {
        if (handler != null) {
            this.debug("Register CmdOptionHandler: {0}", handler);
            this.handlerRegistry.put(handler.getClass(), handler);
        }
    }

    public void commandUsage(Class<?> command) {
        for (CommandHandle cmdHandle : this.commands) {
            if (!cmdHandle.getObject().getClass().equals(command)) continue;
            cmdHandle.getCmdlineParser().usage();
            return;
        }
        throw new IllegalArgumentException("Given command is not known or does not have a @" + CmdCommand.class.getSimpleName() + "-annotation");
    }

    public void usage() {
        this.usage(System.out);
    }

    @Deprecated
    public void usage(StringBuilder output) {
        new WrappingUsageFormatter(this.usageFormatter).format(output, this.getCmdlineModel());
    }

    public void usage(PrintStream output) {
        this.usageFormatter.format(output, this.getCmdlineModel());
    }

    public CmdlineModel getCmdlineModel() {
        String programName = this.programName;
        if (this.parent != null) {
            programName = this.parent.programName + " " + programName;
        }
        return new CmdlineModel(programName, this.options, this.commands, this.parameter.orNull(), this.aboutLine, this.resourceBundle);
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    public void setAboutLine(String aboutLine) {
        this.aboutLine = aboutLine;
    }

    public void setResourceBundle(String resourceBundleName, ClassLoader classloader) {
        this.setResourceBundle(resourceBundleName, Locale.getDefault(), classloader);
    }

    public void setResourceBundle(String resourceBundleName, Locale locale, ClassLoader classloader) {
        try {
            this.resourceBundle = ResourceBundle.getBundle(resourceBundleName, locale, classloader);
            this.debug("Loaded a ResourceBundle with name \"{0}\" using classloader \"{1}\". Locale: {2}", resourceBundleName, classloader, this.resourceBundle.getLocale());
        }
        catch (MissingResourceException e) {
            this.debug("Could not load a ResourceBundle with name \"{0}\" using classloader \"{1}\" for locale {2}", resourceBundleName, classloader, Locale.getDefault());
            this.resourceBundle = null;
        }
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setReadArgsFromFilePrefix(String prefix) {
        this.argsFromFilePrefix = prefix == null || prefix.trim().isEmpty() ? Optional.none() : Optional.some(prefix.trim());
    }

    public void setAggregateShortOptionsWithPrefix(String prefix) {
        this.aggregateShortOptionsWithPrefix = prefix == null || prefix.trim().isEmpty() ? Optional.none() : Optional.some(prefix.trim());
    }
}

