/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class StringFieldHandler
implements CmdOptionHandler {
    public boolean canHandle(AccessibleObject element, int argCount) {
        if (element instanceof Field && argCount == 1) {
            Field field = (Field)element;
            return !Modifier.isFinal(field.getModifiers()) && field.getType().equals(String.class);
        }
        return false;
    }

    public void applyParams(Object config, AccessibleObject element, String[] args, String optionName) throws CmdOptionHandlerException {
        try {
            Field field = (Field)element;
            field.set(config, args[0]);
        }
        catch (Exception e) {
            I18n i18n = I18nFactory.getI18n(StringFieldHandler.class);
            I18n.PreparedI18n msg = i18n.preparetr("Could not apply parameters: {0} to field {1}", Arrays.toString(args), element);
            throw new CmdOptionHandlerException(msg.notr(), e, msg.tr());
        }
    }
}

