/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.internal;

import de.tototec.cmdoption.internal.F0;
import de.tototec.cmdoption.internal.F1;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Optional<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Optional<?> NONE = new Optional();
    private final boolean isNone;
    private final T optional;

    public static <S> Optional<S> some(S some) {
        return new Optional<S>(some);
    }

    public static <S> Optional<S> lift(S someOrNull) {
        if (someOrNull == null) {
            return new Optional();
        }
        return new Optional<S>(someOrNull);
    }

    public static <N> Optional<N> none() {
        return NONE;
    }

    private Optional() {
        this.isNone = true;
        this.optional = null;
    }

    private Optional(T optional) {
        this.isNone = false;
        this.optional = optional;
    }

    public T get() {
        if (this.isDefined()) {
            return this.optional;
        }
        throw new NullPointerException("Optional value not defined.");
    }

    public T getOrElse(F0<T> f) {
        if (this.isDefined()) {
            return this.optional;
        }
        return f.apply();
    }

    public T orNull() {
        return this.isDefined() ? (T)this.optional : null;
    }

    public boolean isDefined() {
        return !this.isNone;
    }

    public boolean isEmpty() {
        return this.isNone;
    }

    public Optional<?> adapt() {
        return this.isDefined() ? Optional.some(this.get()) : Optional.none();
    }

    public List<T> toList() {
        return this.isDefined() ? Arrays.asList(this.optional) : Collections.emptyList();
    }

    @Override
    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    public <R> Optional<R> map(F1<? super T, ? extends R> f) {
        return this.isEmpty() ? Optional.none() : Optional.some(f.apply(this.get()));
    }

    public <R> Optional<R> flatMap(F1<? super T, ? extends Optional<R>> f) {
        return this.isEmpty() ? Optional.none() : f.apply(this.get());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (this.isDefined() ? this.optional : "") + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isNone ? 1231 : 1237);
        result = 31 * result + (this.optional == null ? 0 : this.optional.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Optional other = (Optional)obj;
        if (this.isNone != other.isNone) {
            return false;
        }
        return !(this.optional == null ? other.optional != null : !this.optional.equals(other.optional));
    }
}

