/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.internal;

import de.tototec.cmdoption.internal.I18n;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class I18nFactory {
    public static I18n getI18n(Class<?> context) {
        return I18nFactory.getI18n(context, Locale.getDefault());
    }

    public static I18n getI18n(final Class<?> context, final Locale locale) {
        return new I18n(){

            public String trn(String msgid, String msgidPlural, long n, Object ... params) {
                String translated = n == 1L ? msgid : msgidPlural;
                return this.tr(translated, params);
            }

            public String trcn(String context2, String msgid, String msgidPlural, long n, Object ... params) {
                return this.trn(msgid, msgidPlural, n, params);
            }

            public String trc(String context2, String msgid, Object ... params) {
                return this.tr(msgid, params);
            }

            public String tr(String msgid, Object ... params) {
                String translated;
                try {
                    translated = ResourceBundle.getBundle(context.getPackage().getName() + ".Messages", locale, context.getClassLoader()).getString(msgid);
                }
                catch (MissingResourceException e) {
                    translated = msgid;
                }
                return params == null || params.length == 0 ? translated : MessageFormat.format(translated, params);
            }

            public I18n.PreparedI18n preparetr(final String msg, final Object ... params) {
                final 1 outer = this;
                return new I18n.PreparedI18n(){

                    public String tr() {
                        return outer.tr(msg, params);
                    }

                    public String notr() {
                        if (params != null && params.length > 0) {
                            return MessageFormat.format(msg, params);
                        }
                        return msg;
                    }
                };
            }

            public Locale getLocale() {
                return locale;
            }
        };
    }
}

