/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.internal;

import de.tototec.cmdoption.internal.Logger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    private static volatile transient boolean slf4ClassTestedButUnavailable = false;

    public static Logger getLogger(Class<?> clazz) {
        if (!slf4ClassTestedButUnavailable) {
            try {
                return new Slf4jLogger(clazz);
            }
            catch (NoClassDefFoundError e) {
                slf4ClassTestedButUnavailable = true;
            }
        }
        return new JavaUtilLogger(clazz);
    }

    public static class DummyLogger
    implements Logger {
        public boolean isErrorEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public void error(String msg, Object ... args) {
        }

        public void warn(String msg, Object ... args) {
        }

        public void info(String msg, Object ... args) {
        }

        public void debug(String msg, Object ... args) {
        }

        public void trace(String msg, Object ... args) {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaUtilLogger
    implements Logger {
        private final java.util.logging.Logger underlying;

        public JavaUtilLogger(Class<?> clazz) {
            this.underlying = java.util.logging.Logger.getLogger(clazz.getName());
        }

        protected Object[] formattedMsgAndCause(String msg, Object ... args) {
            String formattedMsg;
            Throwable thrown;
            if (args != null && args.length > 0) {
                int l;
                if (args[args.length - 1] instanceof Throwable) {
                    l = args.length - 1;
                    thrown = (Throwable)args[args.length - 1];
                } else {
                    l = args.length;
                    thrown = null;
                }
                if (l > 0) {
                    StringBuilder strBuilder = new StringBuilder();
                    boolean braceOpen = false;
                    int argNr = 0;
                    for (int i = 0; i < msg.length(); ++i) {
                        char charAt = msg.charAt(i);
                        if (argNr < l) {
                            if (braceOpen) {
                                braceOpen = false;
                                if (charAt == '}') {
                                    strBuilder.append(args[argNr]);
                                    ++argNr;
                                    continue;
                                }
                                strBuilder.append("{");
                            } else if (charAt == '{') {
                                braceOpen = true;
                                continue;
                            }
                        }
                        strBuilder.append(charAt);
                    }
                    if (braceOpen) {
                        strBuilder.append("{");
                    }
                    formattedMsg = strBuilder.toString();
                } else {
                    formattedMsg = msg;
                }
            } else {
                formattedMsg = msg;
                thrown = null;
            }
            return new Object[]{formattedMsg, thrown};
        }

        private void log(Level level, String msg, Object ... args) {
            if (this.underlying.isLoggable(level)) {
                Object[] formattedMsgAndCause = this.formattedMsgAndCause(msg, args);
                String formattedMsg = (String)formattedMsgAndCause[0];
                Throwable thrown = (Throwable)formattedMsgAndCause[1];
                this.underlying.log(level, formattedMsg, thrown);
            }
        }

        @Override
        public boolean isErrorEnabled() {
            return this.underlying.isLoggable(Level.SEVERE);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.underlying.isLoggable(Level.WARNING);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.underlying.isLoggable(Level.INFO);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.underlying.isLoggable(Level.FINE);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.underlying.isLoggable(Level.FINER);
        }

        @Override
        public void error(String msg, Object ... args) {
            this.log(Level.SEVERE, msg, args);
        }

        @Override
        public void warn(String msg, Object ... args) {
            this.log(Level.WARNING, msg, args);
        }

        @Override
        public void info(String msg, Object ... args) {
            this.log(Level.INFO, msg, args);
        }

        @Override
        public void debug(String msg, Object ... args) {
            this.log(Level.FINE, msg, args);
        }

        @Override
        public void trace(String msg, Object ... args) {
            this.log(Level.FINER, msg, args);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.underlying + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Slf4jLogger
    implements Logger {
        private final org.slf4j.Logger underlying;

        public Slf4jLogger(Class<?> clazz) {
            this.underlying = org.slf4j.LoggerFactory.getLogger(clazz);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.underlying.isErrorEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.underlying.isWarnEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.underlying.isInfoEnabled();
        }

        @Override
        public boolean isDebugEnabled() {
            return this.underlying.isDebugEnabled();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.underlying.isTraceEnabled();
        }

        @Override
        public void error(String msg, Object ... args) {
            this.underlying.error(msg, args);
        }

        @Override
        public void warn(String msg, Object ... args) {
            this.underlying.warn(msg, args);
        }

        @Override
        public void info(String msg, Object ... args) {
            this.underlying.info(msg, args);
        }

        @Override
        public void debug(String msg, Object ... args) {
            this.underlying.debug(msg, args);
        }

        @Override
        public void trace(String msg, Object ... args) {
            this.underlying.trace(msg, args);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.underlying + ")";
        }
    }
}

