/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.internal;

import de.tototec.cmdoption.internal.F1;
import de.tototec.cmdoption.internal.F2;
import de.tototec.cmdoption.internal.Optional;
import de.tototec.cmdoption.internal.Procedure1;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FList {
    public static <T> List<T> distinct(Iterable<T> source) {
        LinkedList<T> result = new LinkedList<T>();
        for (T t : source) {
            if (result.contains(source)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> distinct(T[] source) {
        return FList.distinct(Arrays.asList(source));
    }

    public static <T> List<T> dropWhile(Iterable<T> source, F1<? super T, Boolean> accept) {
        LinkedList<T> result = new LinkedList<T>();
        boolean drop = true;
        for (T t : source) {
            if (drop && !accept.apply(t).booleanValue()) {
                drop = false;
            }
            if (drop) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> dropWhile(T[] source, F1<? super T, Boolean> accept) {
        return FList.dropWhile(Arrays.asList(source), accept);
    }

    public static <T> boolean exists(Iterable<T> source, F1<? super T, Boolean> exists) {
        for (T t : source) {
            if (!exists.apply(t).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean exists(T[] source, F1<? super T, Boolean> exists) {
        return FList.exists(Arrays.asList(source), exists);
    }

    public static <T> List<T> filter(Iterable<T> source, F1<? super T, Boolean> accept) {
        LinkedList<T> result = new LinkedList<T>();
        for (T t : source) {
            if (!accept.apply(t).booleanValue()) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> filter(T[] source, F1<? super T, Boolean> accept) {
        return FList.filter(Arrays.asList(source), accept);
    }

    public static <T> List<T> filterType(Iterable<?> source, Class<T> type) {
        LinkedList result = new LinkedList();
        for (Object object : source) {
            if (object == null || !type.isAssignableFrom(object.getClass())) continue;
            Object t = object;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> filterType(Object[] source, Class<T> type) {
        return FList.filterType(Arrays.asList(source), type);
    }

    public static <T> Optional<T> find(Iterable<T> source, F1<? super T, Boolean> accept) {
        for (T t : source) {
            if (!accept.apply(t).booleanValue()) continue;
            return Optional.some(t);
        }
        return Optional.none();
    }

    public static <T> Optional<T> find(T[] source, F1<? super T, Boolean> accept) {
        return FList.find(Arrays.asList(source), accept);
    }

    public static <T, R> List<R> flatMap(Iterable<T> source, F1<? super T, ? extends Iterable<R>> convert) {
        AbstractList result = source instanceof Collection ? new ArrayList(((Collection)source).size()) : new LinkedList();
        for (T t : source) {
            Iterable<R> subList = convert.apply(t);
            if (subList instanceof Collection) {
                result.addAll((Collection)subList);
                continue;
            }
            for (R r : subList) {
                result.add(r);
            }
        }
        return result;
    }

    public static <T, R> List<R> flatMap(T[] source, F1<? super T, ? extends Iterable<R>> convert) {
        return FList.flatMap(Arrays.asList(source), convert);
    }

    public static <T> List<T> flatten(Iterable<Iterable<T>> source) {
        LinkedList<T> result = new LinkedList<T>();
        for (Iterable<T> list : source) {
            if (list instanceof Collection) {
                result.addAll((Collection)list);
                continue;
            }
            for (T t : list) {
                result.add(t);
            }
        }
        return result;
    }

    public static <T> List<T> flatten(Iterable<T>[] source) {
        return FList.flatten(Arrays.asList(source));
    }

    public static <T> List<T> flatten(T[][] source) {
        LinkedList<T> result = new LinkedList<T>();
        T[][] TArray = source;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] list;
            for (T t : list = TArray[i]) {
                result.add(t);
            }
        }
        return result;
    }

    public static <T, R> R foldLeft(Iterable<T> source, R left, F2<R, ? super T, R> fold) {
        R theLeft = left;
        for (T t : source) {
            theLeft = fold.apply(theLeft, t);
        }
        return theLeft;
    }

    public static <T, R> R foldLeft(T[] source, R left, F2<R, ? super T, R> fold) {
        return FList.foldLeft(Arrays.asList(source), left, fold);
    }

    public static <T, R> R foldRight(Iterable<T> source, F2<? super T, R, R> fold, R right) {
        List<R> list = source instanceof List ? (List<R>)source : FList.map(source, new F1.Identity());
        R theRight = right;
        for (int i = list.size() - 1; i >= 0; --i) {
            theRight = fold.apply(list.get(i), theRight);
        }
        return theRight;
    }

    public static <T, R> R foldRight(T[] source, F2<? super T, R, R> fold, R right) {
        R theRight = right;
        for (int i = source.length - 1; i >= 0; --i) {
            theRight = fold.apply(source[i], theRight);
        }
        return theRight;
    }

    public static <T> boolean forall(Iterable<T> source, F1<? super T, Boolean> forall) {
        for (T t : source) {
            if (forall.apply(t).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean forall(T[] source, F1<? super T, Boolean> forall) {
        return FList.forall(Arrays.asList(source), forall);
    }

    public static <T> void foreach(Iterable<T> source, Procedure1<? super T> foreach) {
        for (T t : source) {
            foreach.apply(t);
        }
    }

    public static <T> void foreach(T[] source, Procedure1<? super T> foreach) {
        FList.foreach(Arrays.asList(source), foreach);
    }

    public static <T, K> Map<K, List<T>> groupBy(T[] source, F1<? super T, ? extends K> groupBy) {
        return FList.groupBy(Arrays.asList(source), groupBy);
    }

    public static <T, K> Map<K, List<T>> groupBy(Iterable<T> source, F1<? super T, ? extends K> groupBy) {
        LinkedHashMap result = new LinkedHashMap();
        for (T t : source) {
            List<T> list;
            K key = groupBy.apply(t);
            if (result.containsKey(key)) {
                list = (List)result.get(key);
            } else {
                list = new LinkedList();
                result.put(key, list);
            }
            list.add(t);
        }
        return result;
    }

    public static <T, R> List<R> map(Iterable<T> source, F1<? super T, ? extends R> convert) {
        AbstractList result = source instanceof Collection ? new ArrayList(((Collection)source).size()) : new LinkedList();
        for (T t : source) {
            result.add(convert.apply(t));
        }
        return result;
    }

    public static <T, R> List<R> map(T[] source, F1<? super T, ? extends R> convert) {
        return FList.map(Arrays.asList(source), convert);
    }

    public static String mkString(Iterable<?> source, String separator) {
        return FList.mkString(source, null, separator, null);
    }

    public static String mkString(Object[] source, String separator) {
        return FList.mkString(Arrays.asList(source), separator);
    }

    public static String mkString(Iterable<?> source, String prefix, String separator, String suffix) {
        return FList.mkString(source, prefix, separator, suffix, null);
    }

    public static <T> String mkString(T[] source, String prefix, String separator, String suffix) {
        return FList.mkString(Arrays.asList(source), prefix, separator, suffix);
    }

    public static <T> String mkString(Iterable<T> source, String prefix, String separator, String suffix, F1<? super T, String> convert) {
        StringBuilder result = new StringBuilder();
        if (prefix != null) {
            result.append(prefix);
        }
        boolean sep = false;
        for (T t : source) {
            if (sep && separator != null) {
                result.append(separator);
            }
            sep = true;
            if (convert != null) {
                result.append(convert.apply(t));
                continue;
            }
            result.append(t == null ? null : t.toString());
        }
        if (suffix != null) {
            result.append(suffix);
        }
        return result.toString();
    }

    public static <T> String mkString(T[] source, String prefix, String separator, String suffix, F1<? super T, String> convert) {
        return FList.mkString(Arrays.asList(source), prefix, separator, suffix, convert);
    }

    public static <T> List<T> reverse(Iterable<T> source) {
        if (source instanceof Collection) {
            ArrayList result = new ArrayList((Collection)source);
            Collections.reverse(result);
            return result;
        }
        LinkedList<T> result = new LinkedList<T>();
        for (T t : source) {
            result.add(0, t);
        }
        return result;
    }

    public static <T> List<T> reverse(T[] source) {
        return FList.reverse(Arrays.asList(source));
    }

    public static <T> List<T> sort(Iterable<T> source, Comparator<? super T> comparator) {
        ArrayList<T> result;
        if (source instanceof Collection) {
            result = new ArrayList((Collection)source);
        } else {
            result = new ArrayList<T>();
            for (T t : source) {
                result.add(t);
            }
        }
        Collections.sort(result, comparator);
        return result;
    }

    public static <T> List<T> sort(T[] source, Comparator<? super T> comparator) {
        return FList.sort(Arrays.asList(source), comparator);
    }

    public static <T, C extends Comparable<C>> List<T> sortWith(Iterable<T> source, final F1<? super T, C> convert) {
        return FList.sort(source, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)convert.apply(o1)).compareTo(convert.apply(o2));
            }
        });
    }

    public static <T, C extends Comparable<C>> List<T> sortWith(T[] source, F1<? super T, C> convert) {
        return FList.sortWith(Arrays.asList(source), convert);
    }

    public static <T> List<T> takeWhile(Iterable<T> source, F1<? super T, Boolean> accept) {
        LinkedList<T> result = new LinkedList<T>();
        for (T t : source) {
            if (!accept.apply(t).booleanValue()) break;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> takeWhile(T[] source, F1<? super T, Boolean> accept) {
        return FList.takeWhile(Arrays.asList(source), accept);
    }

    private FList() {
    }
}

