/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.internal.FList;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumSet;

public class EnumHandler
implements CmdOptionHandler {
    public boolean canHandle(AccessibleObject element, int argCount) {
        if (argCount == 1) {
            if (element instanceof Field) {
                Field field = (Field)element;
                return !Modifier.isFinal(field.getModifiers()) && field.getType().isEnum();
            }
            if (element instanceof Method) {
                Class<?>[] params = ((Method)element).getParameterTypes();
                return params.length == 1 && params[0].isEnum();
            }
        }
        return false;
    }

    public void applyParams(Object config, AccessibleObject element, String[] args, String optionName) throws CmdOptionHandlerException {
        try {
            if (element instanceof Field) {
                Field field = (Field)element;
                Class<?> type = field.getType();
                Object value = Enum.valueOf(type, args[0]);
                field.set(config, value);
            } else if (element instanceof Method) {
                Method method = (Method)element;
                Class<?> type = method.getParameterTypes()[0];
                Object value = Enum.valueOf(type, args[0]);
                method.invoke(config, value);
            }
        }
        catch (IllegalArgumentException e) {
            Class<Object> type = element instanceof Field ? ((Field)element).getType() : (element instanceof Method ? ((Method)element).getParameterTypes()[0] : Enum.class);
            I18n i18n = I18nFactory.getI18n(EnumHandler.class);
            I18n.PreparedI18n msg = i18n.preparetr("Invalid enum value: \"{0}\". Supported values: {1}", args[0], FList.mkString(EnumSet.allOf(type), ", "));
            throw new CmdOptionHandlerException(msg.notr(), e, msg.tr());
        }
        catch (Exception e) {
            I18n i18n = I18nFactory.getI18n(EnumHandler.class);
            I18n.PreparedI18n msg = i18n.preparetr("Could not apply parameters: {0} to field/method {1}", Arrays.toString(args), element);
            throw new CmdOptionHandlerException(msg.notr(), e, msg.tr());
        }
    }
}

