/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption;

import de.tototec.cmdoption.LineLengthDetector;
import de.tototec.cmdoption.internal.Logger;
import de.tototec.cmdoption.internal.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TtyLineLengthDetector
implements LineLengthDetector {
    private final Logger log = LoggerFactory.getLogger(TtyLineLengthDetector.class);

    public Integer detectOrNull() {
        File tty = new File("/dev/tty");
        if (!tty.exists()) {
            this.log.debug("/dev/tty does not exist", new Object[0]);
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ProcessBuilder pb = new ProcessBuilder("stty", "-a", "-F", tty.getPath());
            Process process = pb.start();
            InputStream pOut = process.getInputStream();
            this.copy(pOut, out);
            process.waitFor();
            pOut.close();
            String stty = out.toString();
            this.log.trace("Output of stty: {}", stty);
            Pattern pattern1 = Pattern.compile("columns\\s+=\\s+([^;]*)[;\\n\\r]");
            Matcher matcher1 = pattern1.matcher(stty);
            if (matcher1.find()) {
                return Integer.parseInt(matcher1.group(1));
            }
            Pattern pattern2 = Pattern.compile("columns\\s+([^;]*)[;\\n\\r]");
            Matcher matcher2 = pattern2.matcher(stty);
            if (matcher2.find()) {
                return Integer.parseInt(matcher2.group(1));
            }
            return null;
        }
        catch (Exception e) {
            this.log.debug("Could not eval columns with tty", e);
            return null;
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }
}

