/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import de.tototec.cmdoption.internal.I18n;
import de.tototec.cmdoption.internal.I18nFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;

public class StringMethodHandler
implements CmdOptionHandler {
    public boolean canHandle(AccessibleObject element, int argCount) {
        Method method;
        if (element instanceof Method && (method = (Method)element).getParameterTypes().length == argCount) {
            boolean areStrings = true;
            for (Class<?> p : method.getParameterTypes()) {
                areStrings &= String.class.isAssignableFrom(p);
            }
            return areStrings;
        }
        return false;
    }

    public void applyParams(Object config, AccessibleObject element, String[] args, String optionName) throws CmdOptionHandlerException {
        try {
            Method method = (Method)element;
            method.invoke(config, (Object[])args);
        }
        catch (Exception e) {
            I18n i18n = I18nFactory.getI18n(StringMethodHandler.class);
            I18n.PreparedI18n msg = i18n.preparetr("Could not apply parameters: {0} to method {1}", Arrays.toString(args), element);
            throw new CmdOptionHandlerException(msg.notr(), e, msg.tr());
        }
    }
}

