/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils.internal;

import blended.jms.utils.ConnectionConfig;
import blended.jms.utils.JMSSupport;
import blended.jms.utils.internal.PingFailed;
import blended.jms.utils.internal.PingInfo;
import blended.jms.utils.internal.PingPending$;
import blended.jms.utils.internal.PingResult;
import blended.jms.utils.internal.PingSuccess;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005eaAC\u0005\u000b!\u0003\r\tA\u0003\n\u0002\f!)\u0011\u0004\u0001C\u00017!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003\"B\u0015\u0001\t\u0003Q\u0003\"B\u001f\u0001\t\u0003q\u0004\"\u0002)\u0001\t\u0003\t\u0006\"B4\u0001\t\u0003A\u0007\"B8\u0001\t\u0003\u0001\b\"\u0002?\u0001\t\u0003i(A\u0004)j]\u001e|\u0005/\u001a:bi&|gn\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\tQ!\u001e;jYNT!a\u0004\t\u0002\u0007)l7OC\u0001\u0012\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uI\r\u0001A#\u0001\u000f\u0011\u0005Qi\u0012B\u0001\u0010\u0016\u0005\u0011)f.\u001b;\u0002\u00071|w-F\u0001\"!\t\u0011s%D\u0001$\u0015\t!S%A\u0004m_\u001e<\u0017N\\4\u000b\u0005\u0019\u0002\u0012\u0001B;uS2L!\u0001K\u0012\u0003\r1{wmZ3s\u0003E\u0019Gn\\:f\u00156\u001c(+Z:pkJ\u001cWm\u001d\u000b\u0003Wm\"\"\u0001\f\u001c\u0011\u00075\u0002$'D\u0001/\u0015\tyS#\u0001\u0006d_:\u001cWO\u001d:f]RL!!\r\u0018\u0003\r\u0019+H/\u001e:f!\t\u0019D'D\u0001\u000b\u0013\t)$B\u0001\u0005QS:<\u0017J\u001c4p\u0011\u001594\u0001q\u00019\u0003\u0015)7\t\u001e=u!\ti\u0013(\u0003\u0002;]\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006y\r\u0001\rAM\u0001\u0005S:4w.A\u0007de\u0016\fG/Z*fgNLwN\u001c\u000b\u0003\u007f-\u00032\u0001\u0011\"E\u001b\u0005\t%B\u0001\u0014\u0016\u0013\t\u0019\u0015IA\u0002Uef\u0004\"!R%\u000e\u0003\u0019S!aD$\u000b\u0003!\u000bQA[1wCbL!A\u0013$\u0003\u000fM+7o]5p]\")A\n\u0002a\u0001\u001b\u0006\u00191m\u001c8\u0011\u0005\u0015s\u0015BA(G\u0005)\u0019uN\u001c8fGRLwN\\\u0001\u000fGJ,\u0017\r^3D_:\u001cX/\\3s)\u0011\u0011f\u000bW3\u0011\u0007\u0001\u00135\u000b\u0005\u0002F)&\u0011QK\u0012\u0002\u0010\u001b\u0016\u001c8/Y4f\u0007>t7/^7fe\")q+\u0002a\u0001\t\u0006\t1\u000fC\u0003Z\u000b\u0001\u0007!,\u0001\u0003eKN$\bCA.c\u001d\ta\u0006\r\u0005\u0002^+5\taL\u0003\u0002`5\u00051AH]8pizJ!!Y\u000b\u0002\rA\u0013X\rZ3g\u0013\t\u0019GM\u0001\u0004TiJLgn\u001a\u0006\u0003CVAQAZ\u0003A\u0002i\u000b\u0001b]3mK\u000e$xN]\u0001\u000fGJ,\u0017\r^3Qe>$WoY3s)\rIWN\u001c\t\u0004\u0001\nS\u0007CA#l\u0013\tagIA\bNKN\u001c\u0018mZ3Qe>$WoY3s\u0011\u00159f\u00011\u0001E\u0011\u0015If\u00011\u0001[\u00039Ig.\u001b;jC2L7/\u001a)j]\u001e$B!]:uuR\u0011AF\u001d\u0005\u0006o\u001d\u0001\u001d\u0001\u000f\u0005\u0006\u0019\u001e\u0001\r!\u0014\u0005\u0006k\u001e\u0001\rA^\u0001\u0007G>tg-[4\u0011\u0005]DX\"\u0001\u0007\n\u0005ed!\u0001E\"p]:,7\r^5p]\u000e{gNZ5h\u0011\u0015Yx\u00011\u0001[\u0003\u0019\u0001\u0018N\\4JI\u0006I\u0001O]8cKBKgn\u001a\u000b\u0004}\u0006%AcA@\u0002\bA!Q\u0006MA\u0001!\r\u0019\u00141A\u0005\u0004\u0003\u000bQ!A\u0003)j]\u001e\u0014Vm];mi\")q\u0007\u0003a\u0002q!)A\b\u0003a\u0001eI1\u0011QBA\t\u0003'1a!a\u0004\u0001\u0001\u0005-!\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004CA\u001a\u0001!\r9\u0018QC\u0005\u0004\u0003/a!A\u0003&N'N+\b\u000f]8si\u0002")
public interface PingOperations {
    public void blended$jms$utils$internal$PingOperations$_setter_$blended$jms$utils$internal$PingOperations$$log_$eq(Logger var1);

    public Logger blended$jms$utils$internal$PingOperations$$log();

    public static /* synthetic */ Future closeJmsResources$(PingOperations $this, PingInfo info, ExecutionContext eCtxt) {
        return $this.closeJmsResources(info, eCtxt);
    }

    default public Future<PingInfo> closeJmsResources(PingInfo info, ExecutionContext eCtxt) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            PingInfo pingInfo;
            info.consumer().foreach((Function1 & Serializable & scala.Serializable)c -> {
                PingOperations.$anonfun$closeJmsResources$2(this, info, c);
                return BoxedUnit.UNIT;
            });
            info.producer().foreach((Function1 & Serializable & scala.Serializable)p -> {
                PingOperations.$anonfun$closeJmsResources$4(this, info, p);
                return BoxedUnit.UNIT;
            });
            try {
                info.session().foreach((Function1 & Serializable & scala.Serializable)i -> {
                    PingOperations.$anonfun$closeJmsResources$6(this, info, i);
                    return BoxedUnit.UNIT;
                });
                None$ x$1 = None$.MODULE$;
                None$ x$2 = None$.MODULE$;
                None$ x$3 = None$.MODULE$;
                ConnectionConfig x$4 = info.copy$default$1();
                long x$5 = info.copy$default$2();
                String x$6 = info.copy$default$3();
                Option<Throwable> x$7 = info.copy$default$7();
                pingInfo = info.copy(x$4, x$5, x$6, (Option<Session>)x$1, (Option<MessageProducer>)x$3, (Option<MessageConsumer>)x$2, x$7);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                this.blended$jms$utils$internal$PingOperations$$log().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Error closing session for [").append(info.cfg().vendor()).append(":").append(info.cfg().provider()).append("] with id [").append(info.pingId()).append("]").toString());
                PingInfo pingInfo2 = info;
                pingInfo = pingInfo2;
            }
            return pingInfo;
        }, eCtxt);
    }

    public static /* synthetic */ Try createSession$(PingOperations $this, Connection con) {
        return $this.createSession(con);
    }

    default public Try<Session> createSession(Connection con) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> con.createSession(false, 1));
    }

    public static /* synthetic */ Try createConsumer$(PingOperations $this, Session s, String dest, String selector) {
        return $this.createConsumer(s, dest, selector);
    }

    default public Try<MessageConsumer> createConsumer(Session s, String dest, String selector) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> s.createConsumer(((JMSSupport)((Object)this)).destination(s, dest), selector));
    }

    public static /* synthetic */ Try createProducer$(PingOperations $this, Session s, String dest) {
        return $this.createProducer(s, dest);
    }

    default public Try<MessageProducer> createProducer(Session s, String dest) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> s.createProducer(((JMSSupport)((Object)this)).destination(s, dest)));
    }

    public static /* synthetic */ Future initialisePing$(PingOperations $this, Connection con, ConnectionConfig config, String pingId, ExecutionContext eCtxt) {
        return $this.initialisePing(con, config, pingId, eCtxt);
    }

    default public Future<PingInfo> initialisePing(Connection con, ConnectionConfig config, String pingId, ExecutionContext eCtxt) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            PingInfo pingInfo;
            long timeOutMillis = config.pingTimeout().toMillis();
            None$ session = None$.MODULE$;
            ObjectRef consumer = ObjectRef.create((Object)None$.MODULE$);
            ObjectRef producer = ObjectRef.create((Object)None$.MODULE$);
            try {
                String selector = new StringBuilder(19).append("JMSCorrelationID='").append(pingId).append("'").toString();
                session = new Some(this.createSession(con).get());
                session.foreach((Function1 & Serializable & scala.Serializable)s -> {
                    PingOperations.$anonfun$initialisePing$2(this, config, pingId, consumer, selector, producer, timeOutMillis, s);
                    return BoxedUnit.UNIT;
                });
                ConnectionConfig x$1 = config;
                long x$2 = System.currentTimeMillis();
                None$ x$3 = session;
                Option x$4 = (Option)producer.elem;
                Option x$5 = (Option)consumer.elem;
                String x$6 = pingId;
                None$ x$7 = None$.MODULE$;
                pingInfo = new PingInfo(x$1, x$2, x$6, (Option<Session>)x$3, (Option<MessageProducer>)x$4, (Option<MessageConsumer>)x$5, (Option<Throwable>)x$7);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.blended$jms$utils$internal$PingOperations$$log().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Error initialising ping [").append(e.getMessage()).append("] for for [").append(config.vendor()).append(":").append(config.provider()).append("] with id [").append(pingId).append("]").toString());
                ConnectionConfig x$8 = config;
                long x$9 = System.currentTimeMillis();
                None$ x$10 = session;
                Option x$11 = (Option)producer.elem;
                Option x$12 = (Option)consumer.elem;
                String x$13 = pingId;
                Some x$14 = new Some((Object)e);
                PingInfo pingInfo2 = new PingInfo(x$8, x$9, x$13, (Option<Session>)x$10, (Option<MessageProducer>)x$11, (Option<MessageConsumer>)x$12, (Option<Throwable>)x$14);
                pingInfo = pingInfo2;
            }
            return pingInfo;
        }, eCtxt);
    }

    public static /* synthetic */ Future probePing$(PingOperations $this, PingInfo info, ExecutionContext eCtxt) {
        return $this.probePing(info, eCtxt);
    }

    default public Future<PingResult> probePing(PingInfo info, ExecutionContext eCtxt) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            PingResult pingResult;
            this.blended$jms$utils$internal$PingOperations$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Probing ping for [").append(info.cfg().vendor()).append(":").append(info.cfg().provider()).append("] with id [").append(info.pingId()).append("]").toString());
            Option<MessageConsumer> option = info.consumer();
            if (None$.MODULE$.equals(option)) {
                pingResult = new PingFailed(new Exception(new StringBuilder(41).append("No consumer defined for [").append(info.cfg().vendor()).append(":").append(info.cfg().provider()).append("] and pingId [").append(info.pingId()).append("]").toString()));
            } else if (option instanceof Some) {
                PingResult pingResult2;
                Some some = (Some)option;
                MessageConsumer c = (MessageConsumer)some.value();
                try {
                    PingResult pingResult3;
                    Option option2 = Option$.MODULE$.apply((Object)c.receive(100L));
                    if (None$.MODULE$.equals(option2)) {
                        pingResult3 = PingPending$.MODULE$;
                    } else if (option2 instanceof Some) {
                        Object object;
                        Some some2 = (Some)option2;
                        Message m = (Message)some2.value();
                        String id = m.getJMSCorrelationID();
                        if (!info.pingId().equals(id)) {
                            String msg = new StringBuilder(63).append("Received ping id [").append(id).append("] for [").append(info.cfg().vendor()).append(":").append(info.cfg().provider()).append("] did not match expected is [").append(info).append(".pingId]").toString();
                            this.blended$jms$utils$internal$PingOperations$$log().debug((Function0 & Serializable & scala.Serializable)() -> msg);
                            object = new PingFailed(new Exception(msg));
                        } else {
                            this.blended$jms$utils$internal$PingOperations$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Ping successful for [").append(info.cfg().vendor()).append(":").append(info.cfg().provider()).append("] with id [").append(info.pingId()).append("]").toString());
                            object = BoxedUnit.UNIT;
                        }
                        pingResult3 = new PingSuccess(info.pingId());
                    } else {
                        throw new MatchError((Object)option2);
                    }
                    pingResult2 = pingResult3;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option3 = NonFatal$.MODULE$.unapply(throwable2);
                    if (option3.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option3.get();
                    PingFailed pingFailed = new PingFailed(e);
                    pingResult2 = pingFailed;
                }
                pingResult = pingResult2;
            } else {
                throw new MatchError(option);
            }
            return pingResult;
        }, eCtxt);
    }

    public static /* synthetic */ void $anonfun$closeJmsResources$2(PingOperations $this, PingInfo info$1, MessageConsumer c) {
        try {
            c.close();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                $this.blended$jms$utils$internal$PingOperations$$log().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Error closing consumer for [").append(info$1.cfg().vendor()).append(":").append(info$1.cfg().provider()).append("] with id [").append(info$1.pingId()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static /* synthetic */ void $anonfun$closeJmsResources$4(PingOperations $this, PingInfo info$1, MessageProducer p) {
        try {
            p.close();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                $this.blended$jms$utils$internal$PingOperations$$log().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Error closing producer for [").append(info$1.cfg().vendor()).append(":").append(info$1.cfg().provider()).append("] with id [").append(info$1.pingId()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static /* synthetic */ void $anonfun$closeJmsResources$6(PingOperations $this, PingInfo info$1, Session i) {
        $this.blended$jms$utils$internal$PingOperations$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Closing JMS session for [").append(info$1.cfg().vendor()).append(":").append(info$1.cfg().provider()).append("] with id [").append(info$1.pingId()).append("]").toString());
        i.close();
        $this.blended$jms$utils$internal$PingOperations$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("JMS session closed for [").append(info$1.cfg().vendor()).append(":").append(info$1.cfg().provider()).append("] with id [").append(info$1.pingId()).append("]").toString());
    }

    public static /* synthetic */ void $anonfun$initialisePing$4(PingOperations $this, ConnectionConfig config$1, String pingId$1, MessageConsumer x$1) {
        $this.blended$jms$utils$internal$PingOperations$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Consumer created for ping of [").append(config$1.vendor()).append(":").append(config$1.provider()).append("] and id [").append(pingId$1).append("]").toString());
    }

    public static /* synthetic */ void $anonfun$initialisePing$6(PingOperations $this, ConnectionConfig config$1, String pingId$1, Session s$3, long timeOutMillis$1, MessageProducer p) {
        $this.blended$jms$utils$internal$PingOperations$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Producer created for ping of [").append(config$1.vendor()).append(":").append(config$1.provider()).append("] and id [").append(pingId$1).append("]").toString());
        Message msg = s$3.createMessage();
        msg.setJMSCorrelationID(pingId$1);
        p.send(msg, 1, 4, timeOutMillis$1 * 2L);
        $this.blended$jms$utils$internal$PingOperations$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Sent ping message for [").append(config$1.vendor()).append(":").append(config$1.provider()).append("] with id [").append(pingId$1).append("]").toString());
    }

    public static /* synthetic */ void $anonfun$initialisePing$2(PingOperations $this, ConnectionConfig config$1, String pingId$1, ObjectRef consumer$1, String selector$2, ObjectRef producer$1, long timeOutMillis$1, Session s) {
        $this.blended$jms$utils$internal$PingOperations$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Session created for ping of [").append(config$1.vendor()).append(":").append(config$1.provider()).append("] and id [").append(pingId$1).append("]").toString());
        consumer$1.elem = new Some($this.createConsumer(s, config$1.pingDestination(), selector$2).get());
        ((Option)consumer$1.elem).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            PingOperations.$anonfun$initialisePing$4($this, config$1, pingId$1, x$1);
            return BoxedUnit.UNIT;
        });
        producer$1.elem = new Some($this.createProducer(s, config$1.pingDestination()).get());
        ((Option)producer$1.elem).foreach((Function1 & Serializable & scala.Serializable)p -> {
            PingOperations.$anonfun$initialisePing$6($this, config$1, pingId$1, s, timeOutMillis$1, p);
            return BoxedUnit.UNIT;
        });
    }

    public static void $init$(PingOperations $this) {
        $this.blended$jms$utils$internal$PingOperations$_setter_$blended$jms$utils$internal$PingOperations$$log_$eq(Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(PingOperations.class)));
    }
}

