/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils.internal;

import blended.jms.utils.internal.ConnectionCommand;
import blended.jms.utils.internal.ConnectionCommand$;
import blended.jms.utils.internal.ConnectionMonitorMBean;
import blended.jms.utils.internal.ConnectionState;
import blended.jms.utils.internal.ConnectionState$;
import java.text.SimpleDateFormat;
import java.util.Date;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y4Aa\u0006\r\u0001C!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00059\u0001\t\u0005\t\u0015!\u0003.\u0011!I\u0004A!A!\u0002\u0013i\u0003\"\u0002\u001e\u0001\t\u0003Y\u0004B\u0002!\u0001A\u0003%\u0011\t\u0003\u0004J\u0001\u0001\u0006KA\u0013\u0005\u0007\u001b\u0002\u0001\u000b\u0015\u0002(\t\u000bE\u0003A\u0011\t*\t\u000bM\u0003A\u0011\t*\t\u000bQ\u0003A\u0011A+\t\u000bY\u0003A\u0011A,\t\u000bm\u0003A\u0011\u0001/\t\u000b}\u0003A\u0011\u00011\t\u000b\u0005\u0004A\u0011\t*\t\u000b\t\u0004A\u0011\t*\t\u000b\r\u0004A\u0011\t*\t\u000b\u0011\u0004A\u0011I3\t\u000b%\u0004A\u0011I3\t\u000b)\u0004A\u0011I6\t\u000b9\u0004A\u0011I8\t\u000bM\u0004A\u0011\t;\t\u000b]\u0004A\u0011\t=\u0003#\r{gN\\3di&|g.T8oSR|'O\u0003\u0002\u001a5\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u001c9\u0005)Q\u000f^5mg*\u0011QDH\u0001\u0004U6\u001c(\"A\u0010\u0002\u000f\tdWM\u001c3fI\u000e\u00011c\u0001\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0016\u000e\u0003aI!a\u000b\r\u0003-\r{gN\\3di&|g.T8oSR|'/\u0014\"fC:\faA^3oI>\u0014\bC\u0001\u00186\u001d\ty3\u0007\u0005\u00021I5\t\u0011G\u0003\u00023A\u00051AH]8pizJ!\u0001\u000e\u0013\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003i\u0011\n\u0001\u0002\u001d:pm&$WM]\u0001\tG2LWM\u001c;JI\u00061A(\u001b8jiz\"B\u0001P\u001f?\u007fA\u0011\u0011\u0006\u0001\u0005\u0006Y\u0011\u0001\r!\f\u0005\u0006q\u0011\u0001\r!\f\u0005\u0006s\u0011\u0001\r!L\u0001\u0003I\u001a\u0004\"AQ$\u000e\u0003\rS!\u0001R#\u0002\tQ,\u0007\u0010\u001e\u0006\u0002\r\u0006!!.\u0019<b\u0013\tA5I\u0001\tTS6\u0004H.\u001a#bi\u00164uN]7bi\u0006)1\u000f^1uKB\u0011\u0011fS\u0005\u0003\u0019b\u0011qbQ8o]\u0016\u001cG/[8o'R\fG/Z\u0001\u0004G6$\u0007CA\u0015P\u0013\t\u0001\u0006DA\tD_:tWm\u0019;j_:\u001cu.\\7b]\u0012\f1bZ3u!J|g/\u001b3feR\tQ&A\u0006hKR\u001cE.[3oi&#\u0017AC4fi\u000e{W.\\1oIR\ta*\u0001\u0007sKN,GoQ8n[\u0006tG\rF\u0001Y!\t\u0019\u0013,\u0003\u0002[I\t!QK\\5u\u0003!\u0019X\r^*uCR,GC\u0001-^\u0011\u0015qF\u00021\u0001K\u0003!qWm^*uCR,\u0017\u0001C4fiN#\u0018\r^3\u0015\u0003)\u000b\u0011bZ3u'R\fG/^:\u0002\u001d\u001d,G\u000fT1ti\u000e{gN\\3di\u0006\tr-\u001a;MCN$H)[:d_:tWm\u0019;\u0002\u001d\u001d,GOR1jY\u0016$\u0007+\u001b8hgR\ta\r\u0005\u0002$O&\u0011\u0001\u000e\n\u0002\u0004\u0013:$\u0018\u0001D4fi6\u000b\u00070\u0012<f]R\u001c\u0018\u0001D:fi6\u000b\u00070\u0012<f]R\u001cHC\u0001-m\u0011\u0015i7\u00031\u0001g\u0003\u0005q\u0017!C4fi\u00163XM\u001c;t)\u0005\u0001\bcA\u0012r[%\u0011!\u000f\n\u0002\u0006\u0003J\u0014\u0018-_\u0001\u000bI&\u001c8m\u001c8oK\u000e$HC\u0001-v\u0011\u00151X\u00031\u0001.\u0003\u0019\u0011X-Y:p]\u000691m\u001c8oK\u000e$HC\u0001-z\u0011\u0015Qh\u00031\u0001|\u0003\rqwn\u001e\t\u0003GqL!! \u0013\u0003\u000f\t{w\u000e\\3b]\u0002")
public class ConnectionMonitor
implements ConnectionMonitorMBean {
    private final String vendor;
    private final String provider;
    private final String clientId;
    private final SimpleDateFormat df;
    private ConnectionState state;
    private ConnectionCommand cmd;

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public ConnectionCommand getCommand() {
        return this.cmd;
    }

    public void resetCommand() {
        this.cmd = new ConnectionCommand(this.vendor, this.provider, ConnectionCommand$.MODULE$.apply$default$3(), ConnectionCommand$.MODULE$.apply$default$4(), ConnectionCommand$.MODULE$.apply$default$5(), ConnectionCommand$.MODULE$.apply$default$6());
    }

    public void setState(ConnectionState newState) {
        this.state = newState;
    }

    public ConnectionState getState() {
        return this.state;
    }

    @Override
    public String getStatus() {
        return this.state.status();
    }

    @Override
    public String getLastConnect() {
        String string;
        Option<Date> option = this.state.lastConnect();
        if (None$.MODULE$.equals(option)) {
            string = "n/a";
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Date d = (Date)some.value();
            string = this.df.format(d);
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    @Override
    public String getLastDisconnect() {
        String string;
        Option<Date> option = this.state.lastDisconnect();
        if (None$.MODULE$.equals(option)) {
            string = "n/a";
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Date d = (Date)some.value();
            string = this.df.format(d);
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    @Override
    public int getFailedPings() {
        return this.state.failedPings();
    }

    @Override
    public int getMaxEvents() {
        return this.state.maxEvents();
    }

    @Override
    public void setMaxEvents(int n) {
        ConnectionCommand qual$1 = this.cmd;
        int x$1 = n;
        String x$2 = qual$1.copy$default$1();
        String x$3 = qual$1.copy$default$2();
        boolean x$4 = qual$1.copy$default$4();
        boolean x$5 = qual$1.copy$default$5();
        boolean x$6 = qual$1.copy$default$6();
        this.cmd = qual$1.copy(x$2, x$3, x$1, x$4, x$5, x$6);
    }

    @Override
    public String[] getEvents() {
        return (String[])this.state.events().toArray(ClassTag$.MODULE$.apply(String.class));
    }

    @Override
    public void disconnect(String reason) {
        ConnectionCommand qual$1 = this.cmd;
        boolean x$1 = true;
        String x$2 = qual$1.copy$default$1();
        String x$3 = qual$1.copy$default$2();
        int x$4 = qual$1.copy$default$3();
        boolean x$5 = qual$1.copy$default$5();
        boolean x$6 = qual$1.copy$default$6();
        this.cmd = qual$1.copy(x$2, x$3, x$4, x$1, x$5, x$6);
    }

    @Override
    public void connect(boolean now) {
        ConnectionCommand qual$1 = this.cmd;
        boolean x$1 = true;
        boolean x$2 = now;
        String x$3 = qual$1.copy$default$1();
        String x$4 = qual$1.copy$default$2();
        int x$5 = qual$1.copy$default$3();
        boolean x$6 = qual$1.copy$default$4();
        this.cmd = qual$1.copy(x$3, x$4, x$5, x$6, x$1, x$2);
    }

    public ConnectionMonitor(String vendor, String provider, String clientId) {
        this.vendor = vendor;
        this.provider = provider;
        this.clientId = clientId;
        this.df = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss:SSS");
        ConnectionState qual$1 = new ConnectionState(provider, ConnectionState$.MODULE$.apply$default$2(), ConnectionState$.MODULE$.apply$default$3(), ConnectionState$.MODULE$.apply$default$4(), ConnectionState$.MODULE$.apply$default$5(), ConnectionState$.MODULE$.apply$default$6(), ConnectionState$.MODULE$.apply$default$7(), ConnectionState$.MODULE$.apply$default$8(), ConnectionState$.MODULE$.apply$default$9());
        String x$1 = ConnectionState$.MODULE$.DISCONNECTED();
        String x$2 = qual$1.copy$default$1();
        Option<Date> x$3 = qual$1.copy$default$3();
        Option<Date> x$4 = qual$1.copy$default$4();
        int x$5 = qual$1.copy$default$5();
        int x$6 = qual$1.copy$default$6();
        List<String> x$7 = qual$1.copy$default$7();
        Option<Date> x$8 = qual$1.copy$default$8();
        Option<Date> x$9 = qual$1.copy$default$9();
        this.state = qual$1.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
        this.cmd = new ConnectionCommand(vendor, provider, ConnectionCommand$.MODULE$.apply$default$3(), ConnectionCommand$.MODULE$.apply$default$4(), ConnectionCommand$.MODULE$.apply$default$5(), ConnectionCommand$.MODULE$.apply$default$6());
    }
}

