/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils.internal;

import akka.actor.ActorSystem;
import blended.jms.utils.BlendedJMSConnection;
import blended.jms.utils.ConnectionConfig;
import blended.jms.utils.Reconnect;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ub!\u0002\t\u0012\u0003\u0003Q\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011\u0019\u0002!\u0011!Q\u0001\f\u001dBQa\f\u0001\u0005\u0002ABqA\u000e\u0001C\u0002\u0013\u0005q\u0007\u0003\u0004D\u0001\u0001\u0006I\u0001\u000f\u0005\b\t\u0002\u0011\r\u0011\"\u00018\u0011\u0019)\u0005\u0001)A\u0005q!1a\t\u0001Q\u0001\n\u001dCaa\u0014\u0001!B\u0013\u0001\u0006B\u0002,\u0001A\u0003&q\u000b\u0003\u0004c\u0001\u0001\u0006Ka\u0016\u0005\u0006G\u00021\t\u0001\u001a\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006]\u0002!\ta\u001c\u0005\b\u0003S\u0001A\u0011AA\u0016\u0005A\u0019uN\u001c8fGRLwN\u001c%pY\u0012,'O\u0003\u0002\u0013'\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0015+\u0005)Q\u000f^5mg*\u0011acF\u0001\u0004U6\u001c(\"\u0001\r\u0002\u000f\tdWM\u001c3fI\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u000611m\u001c8gS\u001e\u0004\"a\t\u0013\u000e\u0003MI!!J\n\u0003!\r{gN\\3di&|gnQ8oM&<\u0017AB:zgR,W\u000e\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005)\u0011m\u0019;pe*\tA&\u0001\u0003bW.\f\u0017B\u0001\u0018*\u0005-\t5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\t\tT\u0007\u0006\u00023iA\u00111\u0007A\u0007\u0002#!)ae\u0001a\u0002O!)\u0011e\u0001a\u0001E\u00051a/\u001a8e_J,\u0012\u0001\u000f\t\u0003s\u0001s!A\u000f \u0011\u0005mjR\"\u0001\u001f\u000b\u0005uJ\u0012A\u0002\u001fs_>$h(\u0003\u0002@;\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\tyT$A\u0004wK:$wN\u001d\u0011\u0002\u0011A\u0014xN^5eKJ\f\u0011\u0002\u001d:pm&$WM\u001d\u0011\u0002\u00071|w\r\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u00069An\\4hS:<'B\u0001'\u0018\u0003\u0011)H/\u001b7\n\u00059K%A\u0002'pO\u001e,'/\u0001\u0003d_:t\u0007c\u0001\u000fR'&\u0011!+\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\r\"\u0016BA+\u0014\u0005Q\u0011E.\u001a8eK\u0012TUjU\"p]:,7\r^5p]\u0006Q1m\u001c8oK\u000e$\u0018N\\4\u0011\u0005a\u0003W\"A-\u000b\u0005i[\u0016AB1u_6L7M\u0003\u0002];\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00051s&\"A0\u0002\t)\fg/Y\u0005\u0003Cf\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!\u0003:fG>tg.Z2u\u0003Q9W\r^\"p]:,7\r^5p]\u001a\u000b7\r^8ssR\tQ\r\u0005\u0002gU6\tqM\u0003\u0002\u0017Q*\t\u0011.A\u0003kCZ\f\u00070\u0003\u0002lO\n\t2i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u0002\u001b\u001d,GoQ8o]\u0016\u001cG/[8o)\u0005\u0001\u0016aB2p]:,7\r\u001e\u000b\u0002aB\u0011a-]\u0005\u0003e\u001e\u0014!bQ8o]\u0016\u001cG/[8oQ\rqAO\u001f\t\u00049U<\u0018B\u0001<\u001e\u0005\u0019!\bN]8xgB\u0011a\r_\u0005\u0003s\u001e\u0014ABS'T\u000bb\u001cW\r\u001d;j_:\fTA\b\u001d|\u0003O\tta\t?\u0000\u0003;\t\t!\u0006\u00028{\u00121a0\u0007b\u0001\u0003\u000f\u0011\u0011\u0001V\u0005\u0005\u0003\u0003\t\u0019!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003\u000bi\u0012A\u0002;ie><8/\u0005\u0003\u0002\n\u0005=\u0001c\u0001\u000f\u0002\f%\u0019\u0011QB\u000f\u0003\u000f9{G\u000f[5oOB!\u0011\u0011CA\f\u001d\ra\u00121C\u0005\u0004\u0003+i\u0012a\u00029bG.\fw-Z\u0005\u0005\u00033\tYBA\u0005UQJ|w/\u00192mK*\u0019\u0011QC\u000f2\u0013\r\ny\"!\t\u0002$\u0005\u0015ab\u0001\u000f\u0002\"%\u0019\u0011QA\u000f2\u000b\tbR$!\n\u0003\u000bM\u001c\u0017\r\\12\u0005\u0019:\u0018!B2m_N,GCAA\u0017!\u0019\ty#a\r\u000285\u0011\u0011\u0011\u0007\u0006\u0003\u0019vIA!!\u000e\u00022\t\u0019AK]=\u0011\u0007q\tI$C\u0002\u0002<u\u0011A!\u00168ji\u0002")
public abstract class ConnectionHolder {
    private final ConnectionConfig config;
    public final ActorSystem blended$jms$utils$internal$ConnectionHolder$$system;
    private final String vendor;
    private final String provider;
    public final Logger blended$jms$utils$internal$ConnectionHolder$$log;
    private Option<BlendedJMSConnection> conn;
    private AtomicBoolean connecting;
    private AtomicBoolean reconnect;

    public String vendor() {
        return this.vendor;
    }

    public String provider() {
        return this.provider;
    }

    public abstract ConnectionFactory getConnectionFactory();

    public Option<BlendedJMSConnection> getConnection() {
        this.blended$jms$utils$internal$ConnectionHolder$$log.trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Underlying connection is established : [").append($this.conn.isDefined()).append("]").toString());
        return this.conn;
    }

    public Connection connect() throws JMSException {
        BlendedJMSConnection blendedJMSConnection;
        Option<BlendedJMSConnection> option = this.conn;
        if (option instanceof Some) {
            BlendedJMSConnection c;
            Some some = (Some)option;
            blendedJMSConnection = c = (BlendedJMSConnection)some.value();
        } else if (None$.MODULE$.equals(option)) {
            BlendedJMSConnection blendedJMSConnection2;
            block17: {
                if (!this.connecting.getAndSet(true)) {
                    try {
                        try {
                            Connection connection;
                            this.blended$jms$utils$internal$ConnectionHolder$$log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Creating underlying connection for provider [").append(this.vendor()).append(":").append(this.provider()).append("] with client id [").append($this.config.clientId()).append("]").toString());
                            ConnectionFactory cf = this.getConnectionFactory();
                            Option<String> option2 = this.config.defaultUser();
                            if (None$.MODULE$.equals(option2)) {
                                connection = cf.createConnection();
                            } else if (option2 instanceof Some) {
                                Some some = (Some)option2;
                                String user = (String)some.value();
                                connection = cf.createConnection(user, (String)this.config.defaultPassword().getOrElse((Function0 & Serializable & scala.Serializable)() -> null));
                            } else {
                                throw new MatchError(option2);
                            }
                            Connection c = connection;
                            try {
                                c.setClientID(this.config.clientId());
                                c.setExceptionListener(new ExceptionListener(this){
                                    private final /* synthetic */ ConnectionHolder $outer;

                                    public void onException(JMSException e) {
                                        this.$outer.blended$jms$utils$internal$ConnectionHolder$$log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Exception encountered in connection for provider [").append($this.$outer.vendor()).append(":").append($this.$outer.provider()).append("] : ").append(e.getMessage()).toString());
                                        this.$outer.blended$jms$utils$internal$ConnectionHolder$$system.eventStream().publish((Object)new Reconnect(this.$outer.vendor(), this.$outer.provider(), (Option<Throwable>)new Some((Object)((Object)e))));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }

                                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onException$1(blended.jms.utils.internal.ConnectionHolder$$anon$1 javax.jms.JMSException )}, serializedLambda);
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                Option option3 = NonFatal$.MODULE$.unapply(throwable2);
                                if (!option3.isEmpty()) {
                                    Throwable e = (Throwable)option3.get();
                                    this.blended$jms$utils$internal$ConnectionHolder$$log.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Error setting client Id [").append($this.config.clientId()).append("]...Closing Connection...").toString());
                                    c.close();
                                    throw e;
                                }
                                throw throwable;
                            }
                            c.start();
                            this.reconnect.set(false);
                            this.blended$jms$utils$internal$ConnectionHolder$$log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Successfully connected to [").append(this.vendor()).append(":").append(this.provider()).append("] with clientId [").append($this.config.clientId()).append("]").toString());
                            BlendedJMSConnection wrappedConnection = new BlendedJMSConnection(c);
                            this.conn = new Some((Object)wrappedConnection);
                            blendedJMSConnection2 = wrappedConnection;
                            break block17;
                        }
                        catch (JMSException e) {
                            this.blended$jms$utils$internal$ConnectionHolder$$log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error creating connection [").append(this.vendor()).append(":").append(this.provider()).append("] : [").append(e.getMessage()).append("] ").toString());
                            throw e;
                        }
                    }
                    finally {
                        this.connecting.set(false);
                    }
                }
                throw new JMSException(new StringBuilder(55).append("Connection Factory for provider [").append(this.provider()).append("] is still connecting.").toString());
            }
            blendedJMSConnection = blendedJMSConnection2;
        } else {
            throw new MatchError(option);
        }
        return blendedJMSConnection;
    }

    public Try<BoxedUnit> close() {
        Success success;
        Option<BlendedJMSConnection> option = this.conn;
        if (None$.MODULE$.equals(option)) {
            success = new Success((Object)BoxedUnit.UNIT);
        } else if (option instanceof Some) {
            Success success2;
            Some some = (Some)option;
            BlendedJMSConnection c = (BlendedJMSConnection)some.value();
            this.blended$jms$utils$internal$ConnectionHolder$$log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Closing underlying connection for provider [").append(this.provider()).append("]").toString());
            try {
                try {
                    c.connection().close();
                    success2 = new Success((Object)BoxedUnit.UNIT);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                    if (option2.isEmpty()) {
                        throw throwable;
                    }
                    Throwable t = (Throwable)option2.get();
                    Failure failure = new Failure(t);
                    success2 = failure;
                }
            }
            finally {
                this.conn = None$.MODULE$;
            }
            success = success2;
        } else {
            throw new MatchError(option);
        }
        return success;
    }

    public ConnectionHolder(ConnectionConfig config, ActorSystem system) {
        this.config = config;
        this.blended$jms$utils$internal$ConnectionHolder$$system = system;
        this.vendor = config.vendor();
        this.provider = config.provider();
        this.blended$jms$utils$internal$ConnectionHolder$$log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(ConnectionHolder.class));
        this.conn = None$.MODULE$;
        this.connecting = new AtomicBoolean(false);
        this.reconnect = new AtomicBoolean(false);
    }
}

