/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.util.Timeout;
import blended.jms.utils.BlendedJMSConnection;
import blended.jms.utils.ConnectionConfig;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.ProviderAware;
import blended.jms.utils.internal.CheckConnection;
import blended.jms.utils.internal.ConnectionHolder;
import blended.jms.utils.internal.ConnectionMonitor;
import blended.jms.utils.internal.ConnectionStateManager$;
import blended.jms.utils.internal.ConnectionStateMonitor$;
import blended.jms.utils.internal.JndiConnectionHolder;
import blended.jms.utils.internal.ReflectionConfigHolder;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\f\u0019\u0001}A\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\ta\u0001\u0011\t\u0011)A\u0005c!A\u0011\t\u0001B\u0001B\u0003-!\tC\u0003K\u0001\u0011\u00051\nC\u0004R\u0001\t\u0007I\u0011\t*\t\ry\u0003\u0001\u0015!\u0003T\u0011\u001dy\u0006A1A\u0005BICa\u0001\u0019\u0001!\u0002\u0013\u0019\u0006BB1\u0001A\u0003-!\r\u0003\u0004i\u0001\u0001\u0006Y!\u001b\u0005\u0007_\u0002\u0001\u000b\u0011\u00029\t\r]\u0004\u0001\u0015!\u0003T\u0011\u0019A\b\u0001)A\u0005'\"9\u0011\u0010\u0001b\u0001\n\u0003\u0012\u0006B\u0002>\u0001A\u0003%1\u000bC\u0003|\u0001\u0011EA\u0010C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!9\u0011q\u0002\u0001!\u0002\u0013i\bBCA\t\u0001!\u0015\r\u0015\"\u0003\u0002\u0014!9Q\t\u0001Q\u0001\n\u0005m\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003G\u0001A\u0011IA<\u0005y\u0011E.\u001a8eK\u0012\u001c\u0016N\\4mK\u000e{gN\\3di&|gNR1di>\u0014\u0018P\u0003\u0002\u001a5\u0005)Q\u000f^5mg*\u00111\u0004H\u0001\u0004U6\u001c(\"A\u000f\u0002\u000f\tdWM\u001c3fI\u000e\u00011c\u0001\u0001!QA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005Y\u0006twMC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#AB(cU\u0016\u001cG\u000f\u0005\u0002*U5\t\u0001$\u0003\u0002,1\tA\u0012\nZ!xCJ,7i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u0002\r\r|gNZ5h!\tIc&\u0003\u000201\t\u00012i\u001c8oK\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\u000eEVtG\r\\3D_:$X\r\u001f;\u0011\u0007I*t'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001hP\u0007\u0002s)\u0011!hO\u0001\nMJ\fW.Z<pe.T!\u0001P\u001f\u0002\t=\u001cx-\u001b\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001K$!\u0004\"v]\u0012dWmQ8oi\u0016DH/\u0001\u0004tsN$X-\u001c\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bQ!Y2u_JT\u0011aR\u0001\u0005C.\\\u0017-\u0003\u0002J\t\nY\u0011i\u0019;peNK8\u000f^3n\u0003\u0019a\u0014N\\5u}Q\u0019Aj\u0014)\u0015\u00055s\u0005CA\u0015\u0001\u0011\u0015\tE\u0001q\u0001C\u0011\u0015aC\u00011\u0001.\u0011\u0015\u0001D\u00011\u00012\u0003\u00191XM\u001c3peV\t1\u000b\u0005\u0002U7:\u0011Q+\u0017\t\u0003-Nj\u0011a\u0016\u0006\u00031z\ta\u0001\u0010:p_Rt\u0014B\u0001.4\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i\u001b\u0014a\u0002<f]\u0012|'\u000fI\u0001\taJ|g/\u001b3fe\u0006I\u0001O]8wS\u0012,'\u000fI\u0001\u0006K\u000e#\b\u0010\u001e\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003KN\n!bY8oGV\u0014(/\u001a8u\u0013\t9GM\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00069A/[7f_V$\bC\u00016n\u001b\u0005Y'B\u00017G\u0003\u0011)H/\u001b7\n\u00059\\'a\u0002+j[\u0016|W\u000f^\u0001\u0004Y><\u0007CA9v\u001b\u0005\u0011(BA:u\u0003\u001dawnZ4j]\u001eT!\u0001\u001c\u000f\n\u0005Y\u0014(A\u0002'pO\u001e,'/A\u0006n_:LGo\u001c:OC6,\u0017\u0001D:uCR,Wj\u001a:OC6,\u0017\u0001C2mS\u0016tG/\u00133\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013\u0001D2sK\u0006$X\rS8mI\u0016\u0014HcA?\u0002\bA\u0019a0a\u0001\u000e\u0003}T1!!\u0001\u0019\u0003!Ig\u000e^3s]\u0006d\u0017bAA\u0003\u007f\n\u00012i\u001c8oK\u000e$\u0018n\u001c8I_2$WM\u001d\u0005\u0007\u0003\u0013\u0001\u0002\u0019A\u0017\u0002\u0007\r4w-\u0001\u0004i_2$WM]\u000b\u0002{\u00069\u0001n\u001c7eKJ\u0004\u0013!C2g\u000b:\f'\r\\3e+\t\t)\u0002E\u00023\u0003/I1!!\u00074\u0005\u001d\u0011un\u001c7fC:\u0004BAM\u001b\u0002\u001eA\u00191)a\b\n\u0007\u0005\u0005BI\u0001\u0005BGR|'OU3g\u0003A\u0019'/Z1uK\u000e{gN\\3di&|g\u000e\u0006\u0002\u0002(A!\u0011\u0011FA\u0019\u001b\t\tYCC\u0002\u001c\u0003[Q!!a\f\u0002\u000b)\fg/\u0019=\n\t\u0005M\u00121\u0006\u0002\u000b\u0007>tg.Z2uS>t\u0007&B\u000b\u00028\u0005\r\u0003#\u0002\u001a\u0002:\u0005u\u0012bAA\u001eg\t1A\u000f\u001b:poN\u0004B!!\u000b\u0002@%!\u0011\u0011IA\u0016\u00051QUjU#yG\u0016\u0004H/[8oc\u0019q2+!\u0012\u0002vEJ1%a\u0012\u0002N\u0005-\u0014qJ\u000b\u0004%\u0006%CaBA&=\t\u0007\u0011Q\u000b\u0002\u0002)&!\u0011qJA)\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u00111K\u001a\u0002\rQD'o\\<t#\u0011\t9&!\u0018\u0011\u0007I\nI&C\u0002\u0002\\M\u0012qAT8uQ&tw\r\u0005\u0003\u0002`\u0005\u0015db\u0001\u001a\u0002b%\u0019\u00111M\u001a\u0002\u000fA\f7m[1hK&!\u0011qMA5\u0005%!\u0006N]8xC\ndWMC\u0002\u0002dM\n\u0014bIA7\u0003_\n\t(a\u0015\u000f\u0007I\ny'C\u0002\u0002TM\nTA\t\u001a4\u0003g\u0012Qa]2bY\u0006\f4AJA\u001f)\u0019\t9#!\u001f\u0002~!1\u00111\u0010\fA\u0002M\u000bA!^:fe\"1\u0011q\u0010\fA\u0002M\u000b\u0001\u0002]1tg^|'\u000f\u001a")
public class BlendedSingleConnectionFactory
implements IdAwareConnectionFactory {
    private boolean cfEnabled;
    private final ConnectionConfig config;
    private final ActorSystem system;
    private final String vendor;
    private final String provider;
    private final ExecutionContext eCtxt;
    private final Timeout timeout;
    private final Logger log;
    private final String monitorName;
    private final String stateMgrName;
    private final String clientId;
    private final ConnectionHolder holder;
    private final Option<ActorRef> actor;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ String blended$jms$utils$IdAwareConnectionFactory$$super$id() {
        return ProviderAware.id$(this);
    }

    @Override
    public String id() {
        return IdAwareConnectionFactory.id$(this);
    }

    @Override
    public String vendor() {
        return this.vendor;
    }

    @Override
    public String provider() {
        return this.provider;
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    public ConnectionHolder createHolder(ConnectionConfig cfg) {
        return this.config.useJndi() ? new JndiConnectionHolder(cfg, this.system) : new ReflectionConfigHolder(cfg, this.system);
    }

    private ConnectionHolder holder() {
        return this.holder;
    }

    private boolean cfEnabled$lzycompute() {
        BlendedSingleConnectionFactory blendedSingleConnectionFactory = this;
        synchronized (blendedSingleConnectionFactory) {
            if (!this.bitmap$0) {
                this.cfEnabled = this.config.enabled() && this.config.cfEnabled().forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)BlendedSingleConnectionFactory.$anonfun$cfEnabled$1(this, f)));
                this.bitmap$0 = true;
            }
        }
        return this.cfEnabled;
    }

    private boolean cfEnabled() {
        return !this.bitmap$0 ? this.cfEnabled$lzycompute() : this.cfEnabled;
    }

    public Connection createConnection() throws JMSException {
        BlendedJMSConnection blendedJMSConnection;
        if (this.cfEnabled()) {
            try {
                BlendedJMSConnection c;
                Option<BlendedJMSConnection> option = this.holder().getConnection();
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new Exception(new StringBuilder(23).append("Error connecting to [").append(this.id()).append("].").toString());
                    }
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                BlendedJMSConnection blendedJMSConnection2 = c = (BlendedJMSConnection)some.value();
                blendedJMSConnection = blendedJMSConnection2;
            }
            catch (Exception e) {
                String msg = new StringBuilder(35).append("Error getting Connection Factory [").append(e.getMessage()).append("]").toString();
                this.log.error((Function0 & Serializable & scala.Serializable)() -> msg);
                JMSException jmsEx = new JMSException(msg);
                jmsEx.setLinkedException(e);
                throw jmsEx;
            }
        } else {
            throw new JMSException(new StringBuilder(39).append("Connection for provider [").append(this.id()).append("] is disabled.").toString());
        }
        return blendedJMSConnection;
    }

    public Connection createConnection(String user, String password) {
        this.log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(161).append("BlendedSingleConnectionFactory.createConnection() for [").append(this.id()).append("]called with username and password, which is not supported.\nFalling back to default username and password.").toString());
        return this.createConnection();
    }

    public static final /* synthetic */ boolean $anonfun$cfEnabled$1(BlendedSingleConnectionFactory $this, Function1 f) {
        return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)$this.config));
    }

    private static final void liftedTree1$1(MBeanServer jmxServer$1, ObjectName objName$1) {
        try {
            jmxServer$1.unregisterMBean(objName$1);
        }
        catch (Throwable throwable) {}
    }

    private final Object liftedTree2$1(MBeanServer jmxServer$1, ConnectionMonitor jmxBean$1, ObjectName objName$1) {
        ObjectInstance objectInstance;
        try {
            objectInstance = jmxServer$1.registerMBean(jmxBean$1, objName$1);
        }
        catch (Throwable t) {
            this.log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Could not register MBean [").append(objName$1.toString()).append("]:[").append(t.getMessage()).append("]").toString());
            objectInstance = BoxedUnit.UNIT;
        }
        return objectInstance;
    }

    public static final /* synthetic */ void $anonfun$new$1(ActorRef a) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(a);
        CheckConnection x$1 = new CheckConnection(false);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public BlendedSingleConnectionFactory(ConnectionConfig config, Option<BundleContext> bundleContext, ActorSystem system) {
        None$ none$;
        this.config = config;
        this.system = system;
        ProviderAware.$init$(this);
        IdAwareConnectionFactory.$init$(this);
        this.vendor = config.vendor();
        this.provider = config.provider();
        this.eCtxt = system.dispatcher();
        this.timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis());
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(BlendedSingleConnectionFactory.class));
        this.monitorName = new StringBuilder(9).append("Monitor-").append(this.vendor()).append("-").append(this.provider()).toString();
        this.stateMgrName = new StringBuilder(5).append("JMS-").append(this.vendor()).append("-").append(this.provider()).toString();
        this.clientId = config.clientId();
        this.holder = this.createHolder(config);
        if (this.cfEnabled()) {
            None$ none$2;
            if (config.jmxEnabled()) {
                MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
                ConnectionMonitor jmxBean = new ConnectionMonitor(this.vendor(), this.provider(), this.clientId());
                ObjectName objName = new ObjectName(new StringBuilder(48).append("blended:type=ConnectionMonitor,vendor=").append(this.vendor()).append(",provider=").append(this.provider()).toString());
                if (jmxServer.isRegistered(objName)) {
                    BlendedSingleConnectionFactory.liftedTree1$1(jmxServer, objName);
                }
                this.liftedTree2$1(jmxServer, jmxBean, objName);
                none$2 = new Some((Object)jmxBean);
            } else {
                none$2 = None$.MODULE$;
            }
            None$ mbean = none$2;
            ActorRef monitor = system.actorOf(ConnectionStateMonitor$.MODULE$.props(bundleContext, (Option<ConnectionMonitor>)mbean), this.monitorName);
            this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Connection State Monitor [").append($this.stateMgrName).append("] created.").toString());
            none$ = new Some((Object)system.actorOf(ConnectionStateManager$.MODULE$.props(config, monitor, this.holder()), this.stateMgrName));
        } else {
            this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Connection State Monitor [").append($this.stateMgrName).append("] is disabled by config setting.").toString());
            none$ = None$.MODULE$;
        }
        this.actor = none$;
        this.actor.foreach((Function1 & Serializable & scala.Serializable)a -> {
            BlendedSingleConnectionFactory.$anonfun$new$1(a);
            return BoxedUnit.UNIT;
        });
    }
}

