/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils.internal;

import blended.jms.utils.BlendedJMSConnectionConfig;
import blended.jms.utils.JMSSupport;
import blended.jms.utils.internal.PingInfo;
import blended.jms.utils.internal.PingOperations;
import blended.jms.utils.internal.PingOperations$;
import blended.jms.utils.internal.PingResult;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.control.NonFatal$;

public abstract class PingOperations$class {
    public static void closeJmsResources(PingOperations $this, PingInfo info) {
        if ($this.blended$jms$utils$internal$PingOperations$$log().isInfoEnabled()) {
            $this.blended$jms$utils$internal$PingOperations$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing JMS resources for [", ":", "] with id [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info.cfg().vendor(), info.cfg().provider(), info.pingId()})));
        }
        try {
            info.consumer().foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final void apply(MessageConsumer x$1) {
                    x$1.close();
                }
            });
        }
        catch (Throwable throwable) {
            try {
                info.producer().foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(MessageProducer x$2) {
                        x$2.close();
                    }
                });
            }
            catch (Throwable throwable2) {
                if ($this.blended$jms$utils$internal$PingOperations$$log().isDebugEnabled()) {
                    $this.blended$jms$utils$internal$PingOperations$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closing session for [", ":", "] with id [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info.cfg().vendor(), info.cfg().provider(), info.pingId()})));
                }
                info.session().foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Session x$3) {
                        x$3.close();
                    }
                });
                throw throwable2;
            }
            if ($this.blended$jms$utils$internal$PingOperations$$log().isDebugEnabled()) {
                $this.blended$jms$utils$internal$PingOperations$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closing session for [", ":", "] with id [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info.cfg().vendor(), info.cfg().provider(), info.pingId()})));
            }
            info.session().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        try {
            info.producer().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        }
        catch (Throwable throwable) {
            if ($this.blended$jms$utils$internal$PingOperations$$log().isDebugEnabled()) {
                $this.blended$jms$utils$internal$PingOperations$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closing session for [", ":", "] with id [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info.cfg().vendor(), info.cfg().provider(), info.pingId()})));
            }
            info.session().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        if ($this.blended$jms$utils$internal$PingOperations$$log().isDebugEnabled()) {
            $this.blended$jms$utils$internal$PingOperations$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closing session for [", ":", "] with id [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info.cfg().vendor(), info.cfg().provider(), info.pingId()})));
        }
        info.session().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public static PingInfo initialisePing(PingOperations $this, Connection con, BlendedJMSConnectionConfig config) {
        PingInfo pingInfo;
        String pingId = UUID.randomUUID().toString();
        long timeOutMillis = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(config.pingTimeout())).seconds().toMillis();
        None$ session = None$.MODULE$;
        ObjectRef consumer = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef producer = ObjectRef.create((Object)None$.MODULE$);
        try {
            String selector = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JMSCorrelationID='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pingId}));
            session = new Some((Object)con.createSession(false, 1));
            session.foreach((Function1)new Serializable($this, pingId, timeOutMillis, consumer, producer, selector, config){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PingOperations $outer;
                private final String pingId$1;
                public final long timeOutMillis$1;
                private final ObjectRef consumer$1;
                private final ObjectRef producer$1;
                private final String selector$1;
                private final BlendedJMSConnectionConfig config$2;

                public final void apply(Session s) {
                    Destination dest = ((JMSSupport)((Object)this.$outer)).destination(s, this.config$2.pingDestination());
                    this.consumer$1.elem = new Some((Object)s.createConsumer(dest, this.selector$1));
                    this.producer$1.elem = new Some((Object)s.createProducer(dest));
                    Message msg = s.createMessage();
                    msg.setJMSCorrelationID(this.pingId$1);
                    ((Option)this.producer$1.elem).foreach((Function1)new Serializable(this, msg){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PingOperations$.anonfun.initialisePing.1 $outer;
                        private final Message msg$1;

                        public final void apply(MessageProducer p) {
                            p.send(this.msg$1, 1, 4, this.$outer.timeOutMillis$1 * 2L);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.msg$1 = msg$1;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.pingId$1 = pingId$1;
                    this.timeOutMillis$1 = timeOutMillis$1;
                    this.consumer$1 = consumer$1;
                    this.producer$1 = producer$1;
                    this.selector$1 = selector$1;
                    this.config$2 = config$2;
                }
            });
            if ($this.blended$jms$utils$internal$PingOperations$$log().isDebugEnabled()) {
                $this.blended$jms$utils$internal$PingOperations$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sent ping message for [", ":", "] with id [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.vendor(), config.provider(), pingId})));
            }
            BlendedJMSConnectionConfig x$4 = config;
            long x$5 = System.currentTimeMillis();
            None$ x$6 = session;
            Option x$7 = (Option)producer.elem;
            Option x$8 = (Option)consumer.elem;
            String x$9 = pingId;
            None$ x$10 = None$.MODULE$;
            pingInfo = new PingInfo(x$4, x$5, x$9, (Option<Session>)x$6, (Option<MessageProducer>)x$7, (Option<MessageConsumer>)x$8, (Option<Throwable>)x$10);
        }
        catch (Throwable throwable) {
            PingInfo pingInfo2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if ($this.blended$jms$utils$internal$PingOperations$$log().isWarnEnabled()) {
                $this.blended$jms$utils$internal$PingOperations$$log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error initialising ping [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})));
            }
            BlendedJMSConnectionConfig x$11 = config;
            long x$12 = System.currentTimeMillis();
            None$ x$13 = session;
            Option x$14 = (Option)producer.elem;
            Option x$15 = (Option)consumer.elem;
            String x$16 = pingId;
            Some x$17 = new Some((Object)e);
            pingInfo = pingInfo2 = new PingInfo(x$11, x$12, x$16, (Option<Session>)x$13, (Option<MessageProducer>)x$14, (Option<MessageConsumer>)x$15, (Option<Throwable>)x$17);
        }
        return pingInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Option probePing(PingOperations $this, PingInfo info) {
        Some some;
        Option<MessageConsumer> option;
        if ($this.blended$jms$utils$internal$PingOperations$$log().isDebugEnabled()) {
            $this.blended$jms$utils$internal$PingOperations$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Probing ping for [", ":", "] with id [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info.cfg().vendor(), info.cfg().provider(), info.pingId()})));
        }
        if (None$.MODULE$.equals(option = info.consumer())) {
            return new Some((Object)new PingResult((Either<Throwable, String>)package$.MODULE$.Left().apply((Object)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No consumer defined for [", ":", "] and pingId [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info.cfg().vendor(), info.cfg().provider(), info.pingId()}))))));
        }
        if (!(option instanceof Some)) throw new MatchError(option);
        Some some3 = (Some)option;
        MessageConsumer c = (MessageConsumer)some3.x();
        try {
            None$ none$;
            Option option2 = Option$.MODULE$.apply((Object)c.receive(100L));
            if (None$.MODULE$.equals(option2)) {
                none$ = None$.MODULE$;
            } else {
                BoxedUnit boxedUnit;
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                Some some4 = (Some)option2;
                Message m = (Message)some4.x();
                String id = m.getJMSCorrelationID();
                if (info.pingId().equals(id)) {
                    if ($this.blended$jms$utils$internal$PingOperations$$log().isDebugEnabled()) {
                        $this.blended$jms$utils$internal$PingOperations$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ping successful for [", ":", "] with id [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info.cfg().vendor(), info.cfg().provider(), info.pingId()})));
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received ping id [", "] for [", ":", "] did not match expected is [", ".pingId]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id, info.cfg().vendor(), info.cfg().provider(), info}));
                    if ($this.blended$jms$utils$internal$PingOperations$$log().isDebugEnabled()) {
                        $this.blended$jms$utils$internal$PingOperations$$log().debug(msg);
                    }
                    boxedUnit = new Some((Object)new PingResult((Either<Throwable, String>)package$.MODULE$.Left().apply((Object)new Exception(msg))));
                }
                none$ = new Some((Object)new PingResult((Either<Throwable, String>)package$.MODULE$.Right().apply((Object)info.pingId())));
            }
            some = none$;
            return some;
        }
        catch (JMSException jMSException) {
            some = new Some((Object)new PingResult((Either<Throwable, String>)package$.MODULE$.Left().apply((Object)jMSException)));
        }
        return some;
    }

    public static void $init$(PingOperations $this) {
        $this.blended$jms$utils$internal$PingOperations$_setter_$blended$jms$utils$internal$PingOperations$$log_$eq(LoggerFactory.getLogger(PingOperations.class));
    }
}

