/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils;

import blended.jms.utils.JMSErrorHandler;
import blended.jms.utils.JMSMessageFactory;
import blended.jms.utils.JMSMessageHandler;
import blended.jms.utils.JMSSupport;
import blended.jms.utils.JMSSupport$;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public abstract class JMSSupport$class {
    public static Option withSession(JMSSupport $this, Function1 f, Connection con, boolean transacted, int mode) {
        None$ none$;
        None$ session = None$.MODULE$;
        try {
            try {
                session = new Some((Object)con.createSession(transacted, mode));
                f.apply(session.get());
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                $this.blended$jms$utils$JMSSupport$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered JMS Exception [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})), e);
                Some some = new Some((Object)e);
                none$ = some;
            }
        }
        catch (Throwable throwable) {
            session.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final void apply(Session x$1) {
                    x$1.close();
                }
            });
            throw throwable;
        }
        session.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        return none$;
    }

    public static boolean withSession$default$3(JMSSupport $this, Function1 f) {
        return false;
    }

    public static int withSession$default$4(JMSSupport $this, Function1 f) {
        return 1;
    }

    public static Option withConnection(JMSSupport $this, Function1 f, ConnectionFactory cf) {
        None$ none$;
        None$ connection = None$.MODULE$;
        try {
            try {
                connection = new Some((Object)cf.createConnection());
                connection.foreach((Function1)new Serializable($this, f){
                    public static final long serialVersionUID = 0L;
                    private final Function1 f$1;

                    public final void apply(Connection c) {
                        c.start();
                        this.f$1.apply((Object)c);
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                Some some = new Some((Object)e);
                none$ = some;
            }
        }
        catch (Throwable throwable) {
            connection.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final void apply(Connection x$2) {
                    x$2.close();
                }
            });
            throw throwable;
        }
        connection.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        return none$;
    }

    public static Destination destination(JMSSupport $this, Session session, String destName) {
        return destName.startsWith($this.TOPICTAG()) ? session.createTopic(destName.substring($this.TOPICTAG().length())) : (destName.startsWith($this.QUEUETAG()) ? session.createQueue(destName.substring($this.QUEUETAG().length())) : session.createQueue(destName));
    }

    public static void receiveMessage(JMSSupport $this, ConnectionFactory cf, String destName, JMSMessageHandler msgHandler, JMSErrorHandler errorHandler, int maxMessages, long receiveTimeout, Option subscriptionName) {
        if ($this.blended$jms$utils$JMSSupport$$log().isTraceEnabled()) {
            String maxMsg = maxMessages <= 0 ? "Unbounded" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxMessages)}));
            $this.blended$jms$utils$JMSSupport$$log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receiving messages from [", "], maximum count is [", "], receiveTimeout [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destName, maxMsg, BoxesRunTime.boxToLong((long)receiveTimeout)})));
        }
        $this.withConnection((Function1<Connection, BoxedUnit>)new Serializable($this, destName, msgHandler, errorHandler, maxMessages, receiveTimeout, subscriptionName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JMSSupport $outer;
            public final String destName$1;
            public final JMSMessageHandler msgHandler$1;
            public final JMSErrorHandler errorHandler$1;
            public final int maxMessages$1;
            public final long receiveTimeout$1;
            public final Option subscriptionName$1;

            public final void apply(Connection conn) {
                this.$outer.withSession((Function1<Session, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JMSSupport$.anonfun.receiveMessage.1 $outer;

                    public final void apply(Session session) {
                        Option option;
                        block13: {
                            None$ none$;
                            block9: {
                                Option<Throwable> option2;
                                block10: {
                                    MessageConsumer messageConsumer;
                                    block12: {
                                        Destination d;
                                        block11: {
                                            d = this.$outer.blended$jms$utils$JMSSupport$$anonfun$$$outer().destination(session, this.$outer.destName$1);
                                            if (!(d instanceof Queue)) break block11;
                                            this.$outer.blended$jms$utils$JMSSupport$$anonfun$$$outer().blended$jms$utils$JMSSupport$$log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating consumer for [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.destName$1})));
                                            messageConsumer = session.createConsumer(d);
                                            break block12;
                                        }
                                        option = this.$outer.subscriptionName$1;
                                        if (!(option instanceof Some)) break block13;
                                        Some some = (Some)option;
                                        String n = (String)some.x();
                                        this.$outer.blended$jms$utils$JMSSupport$$anonfun$$$outer().blended$jms$utils$JMSSupport$$log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating durable subscriber for [", "] with subscription Name [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.destName$1, n})));
                                        TopicSubscriber topicSubscriber = session.createDurableSubscriber((Topic)d, n);
                                        messageConsumer = topicSubscriber;
                                    }
                                    MessageConsumer consumer = messageConsumer;
                                    None$ msg = None$.MODULE$;
                                    int msgCount = 0;
                                    do {
                                        BoxedUnit boxedUnit;
                                        BoxedUnit boxedUnit2;
                                        if (None$.MODULE$.equals(none$ = (msg = Option$.MODULE$.apply((Object)consumer.receive(this.$outer.receiveTimeout$1))))) {
                                            this.$outer.blended$jms$utils$JMSSupport$$anonfun$$$outer().blended$jms$utils$JMSSupport$$log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No more messages to receive from [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.destName$1})));
                                            boxedUnit2 = BoxedUnit.UNIT;
                                            continue;
                                        }
                                        if (!(none$ instanceof Some)) break block9;
                                        Some some = (Some)none$;
                                        Message m = (Message)some.x();
                                        ++msgCount;
                                        String id = m.getJMSMessageID();
                                        this.$outer.blended$jms$utils$JMSSupport$$anonfun$$$outer().blended$jms$utils$JMSSupport$$log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Handling received message [", "] from [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id, this.$outer.destName$1})));
                                        option2 = this.$outer.msgHandler$1.handleMessage(m);
                                        if (option2 instanceof Some) {
                                            BoxedUnit boxedUnit3;
                                            Some some2 = (Some)option2;
                                            Throwable t = (Throwable)some2.x();
                                            this.$outer.blended$jms$utils$JMSSupport$$anonfun$$$outer().blended$jms$utils$JMSSupport$$log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error handling message [", "] from [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id, this.$outer.destName$1})));
                                            if (this.$outer.errorHandler$1.handleError(m, t)) {
                                                m.acknowledge();
                                                boxedUnit3 = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit3 = BoxedUnit.UNIT;
                                            }
                                            boxedUnit = boxedUnit3;
                                        } else {
                                            if (!None$.MODULE$.equals(option2)) break block10;
                                            this.$outer.blended$jms$utils$JMSSupport$$anonfun$$$outer().blended$jms$utils$JMSSupport$$log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully handled message [", "] from [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id, this.$outer.destName$1})));
                                            m.acknowledge();
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } while (msg.isDefined() && (this.$outer.maxMessages$1 <= 0 || msgCount < this.$outer.maxMessages$1));
                                    consumer.close();
                                    return;
                                }
                                throw new MatchError(option2);
                            }
                            throw new MatchError((Object)none$);
                        }
                        if (None$.MODULE$.equals(option)) {
                            throw new JMSException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Subscriber Name undefined for creating durable subscriber for [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.destName$1})));
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, conn, false, 2);
            }

            public /* synthetic */ JMSSupport blended$jms$utils$JMSSupport$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.destName$1 = destName$1;
                this.msgHandler$1 = msgHandler$1;
                this.errorHandler$1 = errorHandler$1;
                this.maxMessages$1 = maxMessages$1;
                this.receiveTimeout$1 = receiveTimeout$1;
                this.subscriptionName$1 = subscriptionName$1;
            }
        }, cf);
    }

    public static int receiveMessage$default$5(JMSSupport $this) {
        return 0;
    }

    public static long receiveMessage$default$6(JMSSupport $this) {
        return 50L;
    }

    public static Option receiveMessage$default$7(JMSSupport $this) {
        return None$.MODULE$;
    }

    public static Option sendMessage(JMSSupport $this, ConnectionFactory cf, String destName, Object content, JMSMessageFactory msgFactory, int deliveryMode, int priority, long ttl) {
        return $this.withConnection((Function1<Connection, BoxedUnit>)new Serializable($this, destName, content, msgFactory, deliveryMode, priority, ttl){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JMSSupport $outer;
            public final String destName$2;
            public final Object content$1;
            public final JMSMessageFactory msgFactory$1;
            public final int deliveryMode$1;
            public final int priority$1;
            public final long ttl$1;

            public final void apply(Connection conn) {
                Serializable x$3 = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JMSSupport$.anonfun.sendMessage.1 $outer;

                    public final void apply(Session session) {
                        try {
                            MessageProducer producer = session.createProducer(this.$outer.blended$jms$utils$JMSSupport$$anonfun$$$outer().destination(session, this.$outer.destName$2));
                            Message msg = this.$outer.msgFactory$1.createMessage(session, this.$outer.content$1);
                            producer.send(msg, this.$outer.deliveryMode$1, this.$outer.priority$1, this.$outer.ttl$1);
                            this.$outer.blended$jms$utils$JMSSupport$$anonfun$$$outer().blended$jms$utils$JMSSupport$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message sent successfully to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.destName$2})));
                            producer.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable t = (Throwable)option.get();
                            this.$outer.blended$jms$utils$JMSSupport$$anonfun$$$outer().blended$jms$utils$JMSSupport$$log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error sending message to [", "] : [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.destName$2, t.getMessage()})));
                            new Some((Object)t);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                Connection x$4 = conn;
                boolean x$5 = this.$outer.withSession$default$3((Function1<Session, BoxedUnit>)x$3);
                int x$6 = this.$outer.withSession$default$4((Function1<Session, BoxedUnit>)x$3);
                this.$outer.withSession((Function1<Session, BoxedUnit>)x$3, x$4, x$5, x$6);
            }

            public /* synthetic */ JMSSupport blended$jms$utils$JMSSupport$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.destName$2 = destName$2;
                this.content$1 = content$1;
                this.msgFactory$1 = msgFactory$1;
                this.deliveryMode$1 = deliveryMode$1;
                this.priority$1 = priority$1;
                this.ttl$1 = ttl$1;
            }
        }, cf);
    }

    public static int sendMessage$default$5(JMSSupport $this) {
        return 1;
    }

    public static int sendMessage$default$6(JMSSupport $this) {
        return 4;
    }

    public static long sendMessage$default$7(JMSSupport $this) {
        return 0L;
    }

    public static void $init$(JMSSupport $this) {
        $this.blended$jms$utils$JMSSupport$_setter_$blended$jms$utils$JMSSupport$$log_$eq(LoggerFactory.getLogger(JMSSupport.class));
        $this.blended$jms$utils$JMSSupport$_setter_$TOPICTAG_$eq("topic:");
        $this.blended$jms$utils$JMSSupport$_setter_$QUEUETAG_$eq("queue:");
    }
}

