/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils;

import blended.container.context.api.ContainerIdentifierService$;
import blended.jms.utils.BlendedJMSConnectionConfig;
import blended.jms.utils.ConnectionFactoryActivator$;
import blended.updater.config.util.ConfigPropertyMapConverter$;
import blended.util.config.Implicits$;
import com.typesafe.config.Config;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple22;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class BlendedJMSConnectionConfig$
implements Serializable {
    public static final BlendedJMSConnectionConfig$ MODULE$;
    private final BlendedJMSConnectionConfig defaultConfig;

    static {
        new BlendedJMSConnectionConfig$();
    }

    public BlendedJMSConnectionConfig defaultConfig() {
        return this.defaultConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlendedJMSConnectionConfig fromConfig(Function1<String, Try<String>> stringResolver, String vendor, String provider, Config cfg) {
        String string;
        String prov = Implicits$.MODULE$.RichDefaultConfig(cfg).getString("provider", provider);
        boolean enabled = Implicits$.MODULE$.RichDefaultConfig(cfg).getBoolean("enabled", this.defaultConfig().enabled());
        boolean jmxEnabled = Implicits$.MODULE$.RichDefaultConfig(cfg).getBoolean("jmxEnabled", this.defaultConfig().jmxEnabled());
        boolean pingEnabled = Implicits$.MODULE$.RichDefaultConfig(cfg).getBoolean("pingEnabled", this.defaultConfig().pingEnabled());
        int pingTolerance = Implicits$.MODULE$.RichDefaultConfig(cfg).getInt("pingTolerance", this.defaultConfig().pingTolerance());
        int pingInterval = Implicits$.MODULE$.RichDefaultConfig(cfg).getInt("pingInterval", this.defaultConfig().pingInterval());
        int pingTimeout = Implicits$.MODULE$.RichDefaultConfig(cfg).getInt("pingTimeout", this.defaultConfig().pingTimeout());
        int retryInterval = Implicits$.MODULE$.RichDefaultConfig(cfg).getInt("retryInterval", this.defaultConfig().retryInterval());
        int minReconnect = Implicits$.MODULE$.RichDefaultConfig(cfg).getInt("minReconnect", this.defaultConfig().minReconnect());
        int maxReconnectTimeout = Implicits$.MODULE$.RichDefaultConfig(cfg).getInt("maxReconnectTimeout", this.defaultConfig().maxReconnectTimeout());
        if (cfg.hasPath("clientId")) {
            String id;
            String string2;
            Try try_ = (Try)stringResolver.apply((Object)cfg.getString("clientId"));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                throw t;
            }
            if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
            Success success = (Success)try_;
            string = string2 = (id = (String)success.value());
        } else {
            string = this.defaultConfig().clientId();
        }
        String clientId = string;
        Option defaultUser = Implicits$.MODULE$.RichOptionConfig(cfg).getStringOption(ConnectionFactoryActivator$.MODULE$.DEFAULT_USER());
        Option defaultPasswd = Implicits$.MODULE$.RichOptionConfig(cfg).getStringOption(ConnectionFactoryActivator$.MODULE$.DEFAULT_PWD());
        String destination = Implicits$.MODULE$.RichDefaultConfig(cfg).getString("destination", this.defaultConfig().pingDestination());
        Map properties = ConfigPropertyMapConverter$.MODULE$.getKeyAsPropertyMap(cfg, "properties", Option$.MODULE$.apply((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply() {
                return BlendedJMSConnectionConfig$.MODULE$.defaultConfig().properties();
            }
        })).mapValues((Function1)new Serializable(stringResolver){
            public static final long serialVersionUID = 0L;
            private final Function1 stringResolver$1;

            public final String apply(String v) {
                Try try_ = (Try)this.stringResolver$1.apply((Object)v);
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable t = failure.exception();
                    throw t;
                }
                if (try_ instanceof Success) {
                    String s;
                    Success success = (Success)try_;
                    String string = s = (String)success.value();
                    return string;
                }
                throw new MatchError((Object)try_);
            }
            {
                this.stringResolver$1 = stringResolver$1;
            }
        });
        Option jndiName = Implicits$.MODULE$.RichOptionConfig(cfg).getStringOption(ConnectionFactoryActivator$.MODULE$.CF_JNDI_NAME());
        boolean useJndi = Implicits$.MODULE$.RichDefaultConfig(cfg).getBoolean(ConnectionFactoryActivator$.MODULE$.USE_JNDI(), this.defaultConfig().useJndi());
        String x$1 = vendor;
        boolean x$2 = enabled;
        String x$3 = prov;
        boolean x$4 = jmxEnabled;
        boolean x$5 = pingEnabled;
        int x$6 = pingTolerance;
        int x$7 = pingInterval;
        int x$8 = pingTimeout;
        int x$9 = retryInterval;
        int x$10 = minReconnect;
        int x$11 = maxReconnectTimeout;
        String x$12 = clientId;
        Option x$13 = defaultUser;
        Option x$14 = defaultPasswd;
        String x$15 = destination;
        Map x$16 = properties;
        Option x$17 = jndiName;
        boolean x$18 = useJndi;
        None$ x$19 = None$.MODULE$;
        Option<ClassLoader> x$20 = this.defaultConfig().jmsClassloader();
        Option<String> x$21 = this.defaultConfig().ctxtClassName();
        Option<String> x$22 = this.defaultConfig().cfClassName();
        return new BlendedJMSConnectionConfig(x$1, x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Option<String>)x$13, (Option<String>)x$14, x$15, (Map<String, String>)x$16, x$18, (Option<String>)x$17, (Option<Function1<BlendedJMSConnectionConfig, Object>>)x$19, x$22, x$21, x$20);
    }

    public BlendedJMSConnectionConfig apply(String vendor, String provider, boolean enabled, boolean jmxEnabled, boolean pingEnabled, int pingTolerance, int pingInterval, int pingTimeout, int retryInterval, int minReconnect, int maxReconnectTimeout, String clientId, Option<String> defaultUser, Option<String> defaultPassword, String pingDestination, Map<String, String> properties, boolean useJndi, Option<String> jndiName, Option<Function1<BlendedJMSConnectionConfig, Object>> cfEnabled2, Option<String> cfClassName, Option<String> ctxtClassName, Option<ClassLoader> jmsClassloader) {
        return new BlendedJMSConnectionConfig(vendor, provider, enabled, jmxEnabled, pingEnabled, pingTolerance, pingInterval, pingTimeout, retryInterval, minReconnect, maxReconnectTimeout, clientId, defaultUser, defaultPassword, pingDestination, properties, useJndi, jndiName, cfEnabled2, cfClassName, ctxtClassName, jmsClassloader);
    }

    public Option<Tuple22<String, String, Object, Object, Object, Object, Object, Object, Object, Object, Object, String, Option<String>, Option<String>, String, Map<String, String>, Object, Option<String>, Option<Function1<BlendedJMSConnectionConfig, Object>>, Option<String>, Option<String>, Option<ClassLoader>>> unapply(BlendedJMSConnectionConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple22((Object)x$0.vendor(), (Object)x$0.provider(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.enabled()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.jmxEnabled()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.pingEnabled()), (Object)BoxesRunTime.boxToInteger((int)x$0.pingTolerance()), (Object)BoxesRunTime.boxToInteger((int)x$0.pingInterval()), (Object)BoxesRunTime.boxToInteger((int)x$0.pingTimeout()), (Object)BoxesRunTime.boxToInteger((int)x$0.retryInterval()), (Object)BoxesRunTime.boxToInteger((int)x$0.minReconnect()), (Object)BoxesRunTime.boxToInteger((int)x$0.maxReconnectTimeout()), (Object)x$0.clientId(), x$0.defaultUser(), x$0.defaultPassword(), (Object)x$0.pingDestination(), x$0.properties(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.useJndi()), x$0.jndiName(), x$0.cfEnabled(), x$0.cfClassName(), x$0.ctxtClassName(), x$0.jmsClassloader()));
    }

    public Option<String> $lessinit$greater$default$18() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$18() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BlendedJMSConnectionConfig$() {
        MODULE$ = this;
        this.defaultConfig = new BlendedJMSConnectionConfig("", "", true, true, true, 5, 30, 3, 5, 300, -1, new StringBuilder().append((Object)"$[[").append((Object)ContainerIdentifierService$.MODULE$.containerId()).append((Object)"]]").toString(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, "topic:blended.ping", (Map<String, String>)Predef$.MODULE$.Map().empty(), false, (Option<String>)None$.MODULE$, (Option<Function1<BlendedJMSConnectionConfig, Object>>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ClassLoader>)None$.MODULE$);
    }
}

