/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.event.LoggingReceive$;
import blended.jms.utils.BlendedJMSConnection;
import blended.jms.utils.BlendedJMSConnectionConfig;
import blended.jms.utils.internal.CheckConnection;
import blended.jms.utils.internal.CloseTimeout$;
import blended.jms.utils.internal.Connect;
import blended.jms.utils.internal.ConnectResult;
import blended.jms.utils.internal.ConnectTimeout;
import blended.jms.utils.internal.ConnectionClosed$;
import blended.jms.utils.internal.ConnectionCommand;
import blended.jms.utils.internal.ConnectionException;
import blended.jms.utils.internal.ConnectionHolder;
import blended.jms.utils.internal.ConnectionPingActor$;
import blended.jms.utils.internal.ConnectionState;
import blended.jms.utils.internal.ConnectionState$;
import blended.jms.utils.internal.ConnectionStateChanged;
import blended.jms.utils.internal.ConnectionStateManager$;
import blended.jms.utils.internal.Disconnect;
import blended.jms.utils.internal.JmsConnectionController$;
import blended.jms.utils.internal.JmsPingPerformer$;
import blended.jms.utils.internal.PingResult;
import blended.jms.utils.internal.PingTimeout$;
import blended.jms.utils.internal.RestartContainer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tEs!B\u0001\u0003\u0011\u0003Y\u0011AF\"p]:,7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\u000b\u0005\r!\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u00151\u0011!B;uS2\u001c(BA\u0004\t\u0003\rQWn\u001d\u0006\u0002\u0013\u00059!\r\\3oI\u0016$7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u0017\u0007>tg.Z2uS>t7\u000b^1uK6\u000bg.Y4feN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001\"\u0002\u000e\u000e\t\u0003Y\u0012!\u00029s_B\u001cH\u0003\u0002\u000f%U=\u0002\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003\u0005\nA!Y6lC&\u00111E\b\u0002\u0006!J|\u0007o\u001d\u0005\u0006Ke\u0001\rAJ\u0001\u0007G>tg-[4\u0011\u0005\u001dBS\"\u0001\u0003\n\u0005%\"!A\u0007\"mK:$W\r\u001a&N'\u000e{gN\\3di&|gnQ8oM&<\u0007\"B\u0016\u001a\u0001\u0004a\u0013aB7p]&$xN\u001d\t\u0003;5J!A\f\u0010\u0003\u0011\u0005\u001bGo\u001c:SK\u001aDQ\u0001M\rA\u0002E\na\u0001[8mI\u0016\u0014\bC\u0001\u00073\u0013\t\u0019$A\u0001\tD_:tWm\u0019;j_:Du\u000e\u001c3fe\u001a!aB\u0001\u00016'\u0011!\u0004CN\u001d\u0011\u0005u9\u0014B\u0001\u001d\u001f\u0005\u0015\t5\r^8s!\ti\"(\u0003\u0002<=\ta\u0011i\u0019;pe2{wmZ5oO\"AQ\u0005\u000eB\u0001B\u0003%a\u0005\u0003\u0005,i\t\u0005\t\u0015!\u0003-\u0011!\u0001DG!A!\u0002\u0013\t\u0004\"B\f5\t\u0003\u0001E\u0003B!C\u0007\u0012\u0003\"\u0001\u0004\u001b\t\u000b\u0015z\u0004\u0019\u0001\u0014\t\u000b-z\u0004\u0019\u0001\u0017\t\u000bAz\u0004\u0019A\u0019\u0006\t\u0019#\u0004a\u0012\u0002\r'R\fG/\u001a*fG\u0016Lg/\u001a\t\u0005#!SU*\u0003\u0002J%\tIa)\u001e8di&|g.\r\t\u0003\u0019-K!\u0001\u0014\u0002\u0003\u001f\r{gN\\3di&|gn\u0015;bi\u0016\u0004\"AT(\u000e\u0003QJ!\u0001U\u001c\u0003\u000fI+7-Z5wK\"1!\u000b\u000eQ\u0001\nM\u000b!\u0001\u001a4\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016\u0001\u0002;fqRT\u0011\u0001W\u0001\u0005U\u00064\u0018-\u0003\u0002[+\n\u00012+[7qY\u0016$\u0015\r^3G_Jl\u0017\r\u001e\u0005\u00079R\u0002\u000b1B/\u0002\u000b\u0015\u001cE\u000f\u001f;\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\u0014\u0012AC2p]\u000e,(O]3oi&\u0011!m\u0018\u0002\u0019\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u0014\bB\u000235A\u0003%Q-\u0001\u0005qe>4\u0018\u000eZ3s!\t1\u0017N\u0004\u0002\u0012O&\u0011\u0001NE\u0001\u0007!J,G-\u001a4\n\u0005)\\'AB*ue&twM\u0003\u0002i%!1Q\u000e\u000eQ\u0001\n\u0015\faA^3oI>\u0014\bBB85A\u0003&\u0001/\u0001\u0003d_:t\u0007cA\trg&\u0011!O\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u001d\"\u0018BA;\u0005\u0005Q\u0011E.\u001a8eK\u0012TUjU\"p]:,7\r^5p]\"1q\u000f\u000eQ!\na\fabY;se\u0016tGOU3dK&4X\r\u0005\u0002O\u000b\"1!\u0010\u000eQ!\n)\u000bAbY;se\u0016tGo\u0015;bi\u0016Da\u0001 \u001b!B\u0013i\u0018A\u00029j]\u001e,'\u000fE\u0002\u0012c2Bqa \u001b!\u0002\u0013\t\t!A\u0007sKR\u0014\u0018pU2iK\u0012,H.\u001a\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA0\u0002\u0011\u0011,(/\u0019;j_:LA!a\u0003\u0002\u0006\tqa)\u001b8ji\u0016$UO]1uS>t\u0007\u0002CA\bi\u0001\u0006I!!\u0001\u0002\u0011M\u001c\u0007.\u001a3vY\u0016D\u0001\"a\u00055A\u0003&\u0011QC\u0001\na&tw\rV5nKJ\u0004B!E9\u0002\u0018A\u0019Q$!\u0007\n\u0007\u0005maDA\u0006DC:\u001cW\r\u001c7bE2,\u0007bBA\u0010i\u0001\u0006I\u0001L\u0001\u000bG>tGO]8mY\u0016\u0014\bbBA\u0012i\u0011\u0005\u0013QE\u0001\u000baJ,'+Z:uCJ$HCBA\u0014\u0003[\tI\u0005E\u0002\u0012\u0003SI1!a\u000b\u0013\u0005\u0011)f.\u001b;\t\u0011\u0005=\u0012\u0011\u0005a\u0001\u0003c\taA]3bg>t\u0007\u0003BA\u001a\u0003\u0007rA!!\u000e\u0002@9!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<)\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u0007\u0005\u0005##A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0013q\t\u0002\n)\"\u0014xn^1cY\u0016T1!!\u0011\u0013\u0011!\tY%!\tA\u0002\u00055\u0013aB7fgN\fw-\u001a\t\u0005#E\fy\u0005E\u0002\u0012\u0003#J1!a\u0015\u0013\u0005\r\te.\u001f\u0005\b\u0003/\"D\u0011IA-\u0003!\u0001xn\u001d;Ti>\u0004HCAA\u0014\u0011\u001d\ti\u0006\u000eC!\u0003?\nqA]3dK&4X-\u0006\u0002\u0002bA!\u00111MA5\u001d\ri\u0012QM\u0005\u0004\u0003Or\u0012!B!di>\u0014\u0018b\u0001)\u0002l)\u0019\u0011q\r\u0010\t\u000f\u0005=D\u0007\"\u0011\u0002Z\u0005A\u0001O]3Ti\u0006\u0014H\u000fC\u0004\u0002tQ\"\t!!\u001e\u0002\u0019\u0011L7oY8o]\u0016\u001cG/\u001a3\u0015\u0005\u0005]DcA'\u0002z!9\u00111PA9\u0001\u0004Q\u0015!B:uCR,\u0007bBA@i\u0011\u0005\u0011\u0011Q\u0001\nG>tg.Z2uK\u0012$\"!a!\u0015\u00075\u000b)\tC\u0004\u0002|\u0005u\u0004\u0019\u0001&\t\u000f\u0005%E\u0007\"\u0001\u0002\f\u0006Q1m\u001c8oK\u000e$\u0018N\\4\u0015\u0005\u00055EcA'\u0002\u0010\"9\u00111PAD\u0001\u0004Q\u0005bBAJi\u0011\u0005\u0011QS\u0001\bG2|7/\u001b8h)\t\t9\nF\u0002N\u00033Cq!a\u001f\u0002\u0012\u0002\u0007!\nC\u0004\u0002\u001eR\"\t!a(\u0002\u001b)l\u0007p\u00149fe\u0006$\u0018n\u001c8t)\ri\u0015\u0011\u0015\u0005\b\u0003w\nY\n1\u0001K\u0011\u001d\t)\u000b\u000eC\u0001\u0003O\u000bQ\u0003[1oI2,7i\u001c8oK\u000e$\u0018n\u001c8FeJ|'\u000fF\u0002N\u0003SCq!a\u001f\u0002$\u0002\u0007!\n\u0003\u0005\u0002.R\u0002K\u0011BAX\u0003-\u0019x/\u001b;dQN#\u0018\r^3\u0015\r\u0005\u001d\u0012\u0011WA[\u0011\u001d\t\u0019,a+A\u0002a\f1A]3d\u0011\u001d\t9,a+A\u0002)\u000b\u0001B\\3x'R\fG/\u001a\u0005\b\u0003w#D\u0011AA_\u0003%)h\u000e[1oI2,G-F\u0001N\u0011\u001d\t\t\r\u000eC\u0001\u0003\u0007\fQ\u0002];cY&\u001c\b.\u0012<f]R\u001cH#\u0002&\u0002F\u0006%\u0007bBAd\u0003\u007f\u0003\rAS\u0001\u0002g\"A\u00111ZA`\u0001\u0004\ti-A\u0002ng\u001e\u0004B!EAhK&\u0019\u0011\u0011\u001b\n\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0003\u0005\u0002VR\u0002K\u0011BAl\u00039Ig.\u001b;D_:tWm\u0019;j_:$b!a\n\u0002Z\u0006m\u0007bBAd\u0003'\u0004\rA\u0013\u0005\t\u0003;\f\u0019\u000e1\u0001\u0002`\u0006\u0019an\\<\u0011\u0007E\t\t/C\u0002\u0002dJ\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002hR\u0002K\u0011BAu\u0003=\u0019\u0007.Z2l\u0007>tg.Z2uS>tGCBA\u0014\u0003W\fy\u000f\u0003\u0005\u0002n\u0006\u0015\b\u0019AA\u0001\u0003\u0015!W\r\\1z\u0011)\t\t0!:\u0011\u0002\u0003\u0007\u0011q\\\u0001\u0006M>\u00148-\u001a\u0005\t\u0003k$\u0004\u0015\"\u0003\u0002x\u000691m\u001c8oK\u000e$Hc\u0001&\u0002z\"9\u00111PAz\u0001\u0004Q\u0005\u0002CA\u007fi\u0001&I!a@\u0002=\rDWmY6SKN$\u0018M\u001d;G_J4\u0015-\u001b7fIJ+7m\u001c8oK\u000e$HCBAp\u0005\u0003\u0011\u0019\u0001C\u0004\u0002H\u0006m\b\u0019\u0001&\t\u0011\t\u0015\u00111 a\u0001\u0003c\t\u0011!\u001a\u0005\t\u0005\u0013!\u0004\u0015\"\u0003\u0003\f\u0005QA-[:d_:tWm\u0019;\u0015\t\u0005\u001d\"Q\u0002\u0005\b\u0003\u000f\u00149\u00011\u0001K\u0011!\u0011\t\u0002\u000eQ\u0005\n\tM\u0011AD2iK\u000e\\'+Z2p]:,7\r\u001e\u000b\u0005\u0003O\u0011)\u0002C\u0004\u0002H\n=\u0001\u0019\u0001&\t\u0011\teA\u0007)C\u0005\u00057\t\u0011B]3d_:tWm\u0019;\u0015\t\u0005\u001d\"Q\u0004\u0005\b\u0003\u000f\u00149\u00021\u0001K\u0011!\u0011\t\u0003\u000eQ\u0005\n\t\r\u0012\u0001\u00029j]\u001e$B!a\n\u0003&!A!q\u0005B\u0010\u0001\u0004\u0011I#A\u0001d!\u0011\u0011YCa\r\u000e\u0005\t5\"bA\u0004\u00030)\u0011!\u0011G\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0005k\u0011iC\u0001\u0006D_:tWm\u0019;j_:D\u0011B!\u000f5#\u0003%IAa\u000f\u00023\rDWmY6D_:tWm\u0019;j_:$C-\u001a4bk2$HEM\u000b\u0003\u0005{QC!a8\u0003@-\u0012!\u0011\t\t\u0005\u0005\u0007\u0012i%\u0004\u0002\u0003F)!!q\tB%\u0003%)hn\u00195fG.,GMC\u0002\u0003LI\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yE!\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ConnectionStateManager
implements Actor,
ActorLogging {
    public final BlendedJMSConnectionConfig blended$jms$utils$internal$ConnectionStateManager$$config;
    public final ActorRef blended$jms$utils$internal$ConnectionStateManager$$monitor;
    public final SimpleDateFormat blended$jms$utils$internal$ConnectionStateManager$$df;
    private final ExecutionContextExecutor eCtxt;
    public final String blended$jms$utils$internal$ConnectionStateManager$$provider;
    public final String blended$jms$utils$internal$ConnectionStateManager$$vendor;
    public Option<BlendedJMSConnection> blended$jms$utils$internal$ConnectionStateManager$$conn;
    private Function1<ConnectionState, PartialFunction<Object, BoxedUnit>> currentReceive;
    private ConnectionState currentState;
    public Option<ActorRef> blended$jms$utils$internal$ConnectionStateManager$$pinger;
    public final FiniteDuration blended$jms$utils$internal$ConnectionStateManager$$retrySchedule;
    public final FiniteDuration blended$jms$utils$internal$ConnectionStateManager$$schedule;
    public Option<Cancellable> blended$jms$utils$internal$ConnectionStateManager$$pingTimer;
    private final ActorRef controller;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public static Props props(BlendedJMSConnectionConfig blendedJMSConnectionConfig, ActorRef actorRef, ConnectionHolder connectionHolder) {
        return ConnectionStateManager$.MODULE$.props(blendedJMSConnectionConfig, actorRef, connectionHolder);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public LoggingAdapter log() {
        return ActorLogging.class.log((ActorLogging)this);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public final ActorRef sender() {
        return Actor.class.sender((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.class.aroundReceive((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.class.aroundPreStart((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.class.aroundPostStop((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.class.aroundPreRestart((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.class.aroundPostRestart((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.class.supervisorStrategy((Actor)this);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.class.postRestart((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.class.unhandled((Actor)this, (Object)message);
    }

    public void preRestart(Throwable reason, Option<Object> message) {
        this.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error encountered in Connection State Manager [", "] : [", "], restarting ..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$provider, reason.getMessage()})));
        Actor.class.preRestart((Actor)this, (Throwable)reason, message);
    }

    public void postStop() {
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping Connection State Manager for provider [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$provider})));
        this.blended$jms$utils$internal$ConnectionStateManager$$disconnect(this.currentState);
        Actor.class.postStop((Actor)this);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return Actor.emptyBehavior$.MODULE$;
    }

    public void preStart() {
        Actor.class.preStart((Actor)this);
        this.blended$jms$utils$internal$ConnectionStateManager$$switchState((Function1<ConnectionState, PartialFunction<Object, BoxedUnit>>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;

            public final PartialFunction<Object, BoxedUnit> apply(ConnectionState state) {
                return this.$outer.disconnected(state);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.currentState);
        this.context().system().eventStream().subscribe(this.self(), ConnectionCommand.class);
        this.context().system().eventStream().subscribe(this.self(), ConnectionException.class);
    }

    public PartialFunction<Object, BoxedUnit> disconnected(ConnectionState state) {
        return LoggingReceive$.MODULE$.apply((PartialFunction)new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;
            private final ConnectionState state$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CheckConnection) {
                    CheckConnection checkConnection2 = (CheckConnection)A1;
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$pingTimer = None$.MODULE$;
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$initConnection(this.state$1, checkConnection2.now());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof CheckConnection;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.state$1 = state$1;
            }
        }, this.context());
    }

    public PartialFunction<Object, BoxedUnit> connected(ConnectionState state) {
        return new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;
            private final ConnectionState state$2;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Either<Throwable, String> either;
                void var6_12;
                boolean bl = false;
                PingResult pingResult = null;
                A1 A1 = x2;
                if (A1 instanceof ConnectTimeout) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var6_12;
                }
                if (A1 instanceof CheckConnection) {
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$pingTimer = None$.MODULE$;
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$conn.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$connected$1 $outer;

                        public final void apply(Connection c) {
                            this.$outer.blended$jms$utils$internal$ConnectionStateManager$$anonfun$$$outer().blended$jms$utils$internal$ConnectionStateManager$$ping(c);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var6_12;
                }
                if (A1 instanceof PingResult) {
                    bl = true;
                    pingResult = (PingResult)A1;
                    Either<Throwable, String> either2 = pingResult.result();
                    if (either2 instanceof Right) {
                        Right right = (Right)either2;
                        String m = (String)right.b();
                        this.$outer.blended$jms$utils$internal$ConnectionStateManager$$pinger = None$.MODULE$;
                        ConnectionState qual$2 = this.$outer.publishEvents(this.state$2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JMS connection for provider [", ":", "] seems healthy [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$provider, m}))}));
                        int x$14 = 0;
                        String x$15 = qual$2.copy$default$1();
                        String x$16 = qual$2.copy$default$2();
                        Option<Date> x$17 = qual$2.copy$default$3();
                        Option<Date> x$18 = qual$2.copy$default$4();
                        int x$19 = qual$2.copy$default$6();
                        List<String> x$20 = qual$2.copy$default$7();
                        Option<Date> x$21 = qual$2.copy$default$8();
                        Option<Date> x$22 = qual$2.copy$default$9();
                        this.$outer.blended$jms$utils$internal$ConnectionStateManager$$switchState((Function1<ConnectionState, PartialFunction<Object, BoxedUnit>>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$connected$1 $outer;

                            public final PartialFunction<Object, BoxedUnit> apply(ConnectionState state) {
                                return this.$outer.blended$jms$utils$internal$ConnectionStateManager$$anonfun$$$outer().connected(state);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, qual$2.copy(x$15, x$16, x$17, x$18, x$14, x$19, x$20, x$21, x$22));
                        this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkConnection(this.$outer.blended$jms$utils$internal$ConnectionStateManager$$schedule, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkConnection$default$2());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return var6_12;
                    }
                }
                if (bl && (either = pingResult.result()) instanceof Left) {
                    Left left = (Left)either;
                    Throwable t = (Throwable)left.a();
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$pinger = None$.MODULE$;
                    ConnectionState qual$3 = this.$outer.publishEvents(this.state$2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error sending connection ping for provider [", ":", "] : [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$provider, t.getMessage()}))}));
                    int x$23 = this.state$2.failedPings() + 1;
                    String x$24 = qual$3.copy$default$1();
                    String x$25 = qual$3.copy$default$2();
                    Option<Date> x$26 = qual$3.copy$default$3();
                    Option<Date> x$27 = qual$3.copy$default$4();
                    int x$28 = qual$3.copy$default$6();
                    List<String> x$29 = qual$3.copy$default$7();
                    Option<Date> x$30 = qual$3.copy$default$8();
                    Option<Date> x$31 = qual$3.copy$default$9();
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkReconnect(qual$3.copy(x$24, x$25, x$26, x$27, x$23, x$28, x$29, x$30, x$31));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var6_12;
                }
                if (PingTimeout$.MODULE$.equals(A1)) {
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$pinger = None$.MODULE$;
                    ConnectionState qual$4 = this.$outer.publishEvents(this.state$2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ping for provider [", ":", "] timed out."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$provider}))}));
                    int x$32 = this.state$2.failedPings() + 1;
                    String x$33 = qual$4.copy$default$1();
                    String x$34 = qual$4.copy$default$2();
                    Option<Date> x$35 = qual$4.copy$default$3();
                    Option<Date> x$36 = qual$4.copy$default$4();
                    int x$37 = qual$4.copy$default$6();
                    List<String> x$38 = qual$4.copy$default$7();
                    Option<Date> x$39 = qual$4.copy$default$8();
                    Option<Date> x$40 = qual$4.copy$default$9();
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkReconnect(qual$4.copy(x$33, x$34, x$35, x$36, x$32, x$37, x$38, x$39, x$40));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var6_12;
                }
                Object object = function1.apply(x2);
                return var6_12;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x2) {
                Either<Throwable, String> either;
                boolean bl = false;
                PingResult pingResult = null;
                Object object = x2;
                if (object instanceof ConnectTimeout) {
                    return true;
                }
                if (object instanceof CheckConnection) {
                    return true;
                }
                if (object instanceof PingResult) {
                    bl = true;
                    pingResult = (PingResult)object;
                    Either<Throwable, String> either2 = pingResult.result();
                    if (either2 instanceof Right) {
                        return true;
                    }
                }
                if (bl && (either = pingResult.result()) instanceof Left) {
                    return true;
                }
                if (!PingTimeout$.MODULE$.equals(object)) return false;
                return true;
            }

            public /* synthetic */ ConnectionStateManager blended$jms$utils$internal$ConnectionStateManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.state$2 = state$2;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> connecting(ConnectionState state) {
        return new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;
            private final ConnectionState state$3;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                void var6_11;
                boolean bl = false;
                ConnectResult connectResult = null;
                A1 A1 = x3;
                if (A1 instanceof CheckConnection) {
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$pingTimer = None$.MODULE$;
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    return var6_11;
                }
                if (A1 instanceof ConnectResult) {
                    bl = true;
                    connectResult = (ConnectResult)A1;
                    Date t = connectResult.ts();
                    Either<Throwable, Connection> either = connectResult.r();
                    if (either instanceof Left) {
                        BoxedUnit boxedUnit3;
                        Left left = (Left)either;
                        Throwable e = (Throwable)left.a();
                        Date date = t;
                        Object object = this.state$3.lastConnectAttempt().getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        });
                        if (!(date != null ? !((Object)date).equals(object) : object != null)) {
                            String x$41 = ConnectionState$.MODULE$.DISCONNECTED();
                            String x$42 = this.state$3.copy$default$1();
                            Option<Date> x$43 = this.state$3.copy$default$3();
                            Option<Date> x$44 = this.state$3.copy$default$4();
                            int x$45 = this.state$3.copy$default$5();
                            int x$46 = this.state$3.copy$default$6();
                            List<String> x$47 = this.state$3.copy$default$7();
                            Option<Date> x$48 = this.state$3.copy$default$8();
                            Option<Date> x$49 = this.state$3.copy$default$9();
                            this.$outer.blended$jms$utils$internal$ConnectionStateManager$$switchState((Function1<ConnectionState, PartialFunction<Object, BoxedUnit>>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$connecting$1 $outer;

                                public final PartialFunction<Object, BoxedUnit> apply(ConnectionState state) {
                                    return this.$outer.blended$jms$utils$internal$ConnectionStateManager$$anonfun$$$outer().disconnected(state);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, this.state$3.copy(x$42, x$41, x$43, x$44, x$45, x$46, x$47, x$48, x$49));
                            if (this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkRestartForFailedReconnect(this.state$3, e)) {
                                boxedUnit3 = BoxedUnit.UNIT;
                            } else {
                                this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkConnection(this.$outer.blended$jms$utils$internal$ConnectionStateManager$$retrySchedule, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkConnection$default$2());
                                boxedUnit3 = BoxedUnit.UNIT;
                            }
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit4 = boxedUnit3;
                        return var6_11;
                    }
                }
                if (bl) {
                    Date t = connectResult.ts();
                    Either<Throwable, Connection> either = connectResult.r();
                    if (either instanceof Right) {
                        BoxedUnit boxedUnit5;
                        Right right = (Right)either;
                        Connection c = (Connection)right.b();
                        Date date = t;
                        Object object = this.state$3.lastConnectAttempt().getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        });
                        if (!(date != null ? !((Object)date).equals(object) : object != null)) {
                            this.$outer.blended$jms$utils$internal$ConnectionStateManager$$conn = new Some((Object)new BlendedJMSConnection(c));
                            this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkConnection(this.$outer.blended$jms$utils$internal$ConnectionStateManager$$schedule, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkConnection$default$2());
                            ConnectionState qual$5 = this.$outer.publishEvents(this.state$3, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully connected to provider [", ":", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$provider}))}));
                            String x$50 = ConnectionState$.MODULE$.CONNECTED();
                            None$ x$51 = None$.MODULE$;
                            Some x$52 = new Some((Object)new Date());
                            int x$53 = 0;
                            String x$54 = qual$5.copy$default$1();
                            Option<Date> x$55 = qual$5.copy$default$4();
                            int x$56 = qual$5.copy$default$6();
                            List<String> x$57 = qual$5.copy$default$7();
                            Option<Date> x$58 = qual$5.copy$default$9();
                            this.$outer.blended$jms$utils$internal$ConnectionStateManager$$switchState((Function1<ConnectionState, PartialFunction<Object, BoxedUnit>>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$connecting$1 $outer;

                                public final PartialFunction<Object, BoxedUnit> apply(ConnectionState state) {
                                    return this.$outer.blended$jms$utils$internal$ConnectionStateManager$$anonfun$$$outer().connected(state);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, qual$5.copy(x$54, x$50, (Option<Date>)x$52, x$55, x$53, x$56, x$57, (Option<Date>)x$51, x$58));
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit6 = boxedUnit5;
                        return var6_11;
                    }
                }
                if (!(A1 instanceof ConnectTimeout)) {
                    Object object = function1.apply(x3);
                    return var6_11;
                }
                ConnectTimeout connectTimeout = (ConnectTimeout)A1;
                long t = connectTimeout.t();
                if (BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)t), (Object)this.state$3.lastConnectAttempt().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                }))) {
                    String x$59 = ConnectionState$.MODULE$.DISCONNECTED();
                    String x$60 = this.state$3.copy$default$1();
                    Option<Date> x$61 = this.state$3.copy$default$3();
                    Option<Date> x$62 = this.state$3.copy$default$4();
                    int x$63 = this.state$3.copy$default$5();
                    int x$64 = this.state$3.copy$default$6();
                    List<String> x$65 = this.state$3.copy$default$7();
                    Option<Date> x$66 = this.state$3.copy$default$8();
                    Option<Date> x$67 = this.state$3.copy$default$9();
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$switchState((Function1<ConnectionState, PartialFunction<Object, BoxedUnit>>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$connecting$1 $outer;

                        public final PartialFunction<Object, BoxedUnit> apply(ConnectionState state) {
                            return this.$outer.blended$jms$utils$internal$ConnectionStateManager$$anonfun$$$outer().disconnected(state);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, this.state$3.copy(x$60, x$59, x$61, x$62, x$63, x$64, x$65, x$66, x$67));
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkConnection(this.$outer.blended$jms$utils$internal$ConnectionStateManager$$retrySchedule, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkConnection$default$2());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit7 = boxedUnit;
                return var6_11;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x3) {
                Either<Throwable, Connection> either;
                boolean bl = false;
                ConnectResult connectResult = null;
                Object object = x3;
                if (object instanceof CheckConnection) {
                    return true;
                }
                if (object instanceof ConnectResult) {
                    bl = true;
                    connectResult = (ConnectResult)object;
                    Either<Throwable, Connection> either2 = connectResult.r();
                    if (either2 instanceof Left) {
                        return true;
                    }
                }
                if (bl && (either = connectResult.r()) instanceof Right) {
                    return true;
                }
                if (!(object instanceof ConnectTimeout)) return false;
                return true;
            }

            public /* synthetic */ ConnectionStateManager blended$jms$utils$internal$ConnectionStateManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.state$3 = state$3;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> closing(ConnectionState state) {
        return new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;
            private final ConnectionState state$4;

            public final <A1, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof CheckConnection) {
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$pingTimer = None$.MODULE$;
                    object = BoxedUnit.UNIT;
                } else if (ConnectionClosed$.MODULE$.equals(A1)) {
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$conn = None$.MODULE$;
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$checkConnection(this.$outer.blended$jms$utils$internal$ConnectionStateManager$$schedule, true);
                    ConnectionState qual$6 = this.$outer.publishEvents(this.state$4, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection for provider [", ":", "] successfully closed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$provider}))}));
                    String x$68 = ConnectionState$.MODULE$.DISCONNECTED();
                    Some x$69 = new Some((Object)new Date());
                    String x$70 = qual$6.copy$default$1();
                    Option<Date> x$71 = qual$6.copy$default$3();
                    int x$72 = qual$6.copy$default$5();
                    int x$73 = qual$6.copy$default$6();
                    List<String> x$74 = qual$6.copy$default$7();
                    Option<Date> x$75 = qual$6.copy$default$8();
                    Option<Date> x$76 = qual$6.copy$default$9();
                    this.$outer.blended$jms$utils$internal$ConnectionStateManager$$switchState((Function1<ConnectionState, PartialFunction<Object, BoxedUnit>>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$closing$1 $outer;

                        public final PartialFunction<Object, BoxedUnit> apply(ConnectionState state) {
                            return this.$outer.blended$jms$utils$internal$ConnectionStateManager$$anonfun$$$outer().disconnected(state);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, qual$6.copy(x$70, x$68, x$71, (Option<Date>)x$69, x$72, x$73, x$74, x$75, x$76));
                    object = BoxedUnit.UNIT;
                } else if (CloseTimeout$.MODULE$.equals(A1)) {
                    Exception e = new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to close connection for provider [", ":", "] in [", "]s]. Restarting container ..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$provider, BoxesRunTime.boxToInteger((int)this.$outer.blended$jms$utils$internal$ConnectionStateManager$$config.minReconnect())})));
                    package$.MODULE$.actorRef2Scala(this.$outer.blended$jms$utils$internal$ConnectionStateManager$$monitor).$bang((Object)new RestartContainer(e), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x4) {
                Object object = x4;
                boolean bl = object instanceof CheckConnection ? true : (ConnectionClosed$.MODULE$.equals(object) ? true : CloseTimeout$.MODULE$.equals(object));
                return bl;
            }

            public /* synthetic */ ConnectionStateManager blended$jms$utils$internal$ConnectionStateManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.state$4 = state$4;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> jmxOperations(ConnectionState state) {
        return new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;
            private final ConnectionState state$5;

            public final <A1, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x5;
                if (A1 instanceof ConnectionCommand) {
                    BoxedUnit boxedUnit;
                    ConnectionCommand connectionCommand = (ConnectionCommand)A1;
                    String string = connectionCommand.provider();
                    String string2 = this.$outer.blended$jms$utils$internal$ConnectionStateManager$$provider;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        if (connectionCommand.disconnectPending()) {
                            this.$outer.blended$jms$utils$internal$ConnectionStateManager$$disconnect(this.state$5);
                            boxedUnit = BoxedUnit.UNIT;
                        } else if (connectionCommand.connectPending()) {
                            package$.MODULE$.actorRef2Scala(this.$outer.self()).$bang((Object)new CheckConnection(connectionCommand.reconnectNow()), this.$outer.self());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else {
                    object = function1.apply(x5);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x5) {
                Object object = x5;
                boolean bl = object instanceof ConnectionCommand;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.state$5 = state$5;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> handleConnectionError(ConnectionState state) {
        return new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;
            private final ConnectionState state$6;

            public final <A1, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x6;
                if (A1 instanceof ConnectionException) {
                    BoxedUnit boxedUnit;
                    ConnectionException connectionException = (ConnectionException)A1;
                    String string = connectionException.provider();
                    String string2 = this.$outer.blended$jms$utils$internal$ConnectionStateManager$$provider;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initiating reconnect after connection exception [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectionException.e().getMessage()})));
                        this.$outer.blended$jms$utils$internal$ConnectionStateManager$$reconnect(this.state$6);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else {
                    object = function1.apply(x6);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x6) {
                Object object = x6;
                boolean bl = object instanceof ConnectionException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.state$6 = state$6;
            }
        };
    }

    public void blended$jms$utils$internal$ConnectionStateManager$$switchState(Function1<ConnectionState, PartialFunction<Object, BoxedUnit>> rec, ConnectionState newState) {
        ConnectionState nextState = this.publishEvents(newState, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection State Manager [", ":", "] switching to state [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.blended$jms$utils$internal$ConnectionStateManager$$provider, newState.status()}))}));
        this.currentReceive = rec;
        this.currentState = nextState;
        package$.MODULE$.actorRef2Scala(this.blended$jms$utils$internal$ConnectionStateManager$$monitor).$bang((Object)new ConnectionStateChanged(nextState), this.self());
        this.context().become(LoggingReceive$.MODULE$.apply(((PartialFunction)rec.apply((Object)nextState)).orElse(this.jmxOperations(nextState)).orElse(this.handleConnectionError(nextState)).orElse(this.unhandled()), this.context()));
    }

    public PartialFunction<Object, BoxedUnit> unhandled() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;

            public final <A1, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                A1 A1 = x7;
                this.$outer.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"received unhandled message for [", ":", "] : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$provider, A1.toString()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Object x7) {
                Object object = x7;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public ConnectionState publishEvents(ConnectionState s, Seq<String> msg) {
        msg.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;

            public final void apply(String m) {
                this.$outer.log().info(m);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq tsMsg = (Seq)msg.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;

            public final String apply(String m) {
                return new StringBuilder().append((Object)this.$outer.blended$jms$utils$internal$ConnectionStateManager$$df.format(new Date())).append((Object)" ").append((Object)m).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq newEvents = tsMsg.size() >= s.maxEvents() ? (Seq)((IterableLike)tsMsg.reverse()).take(s.maxEvents()) : (Seq)((TraversableLike)tsMsg.reverse()).$plus$plus((GenTraversableOnce)s.events().take(s.maxEvents() - tsMsg.size()), Seq$.MODULE$.canBuildFrom());
        List x$77 = newEvents.toList();
        String x$78 = s.copy$default$1();
        String x$79 = s.copy$default$2();
        Option<Date> x$80 = s.copy$default$3();
        Option<Date> x$81 = s.copy$default$4();
        int x$82 = s.copy$default$5();
        int x$83 = s.copy$default$6();
        Option<Date> x$84 = s.copy$default$8();
        Option<Date> x$85 = s.copy$default$9();
        return s.copy(x$78, x$79, x$80, x$81, x$82, x$83, (List<String>)x$77, x$84, x$85);
    }

    public void blended$jms$utils$internal$ConnectionStateManager$$initConnection(ConnectionState s, boolean now) {
        Option<Date> option;
        block7: {
            double d;
            block6: {
                block5: {
                    option = s.lastDisconnect();
                    if (!None$.MODULE$.equals(option)) break block5;
                    d = 0.0;
                    break block6;
                }
                if (!(option instanceof Some)) break block7;
                Some some = (Some)option;
                Date l = (Date)some.x();
                d = (double)this.blended$jms$utils$internal$ConnectionStateManager$$config.minReconnect() * 1000.0 - (double)(System.currentTimeMillis() - l.getTime());
            }
            double remaining = d;
            if (!now && s.lastDisconnect().isDefined() && remaining > 0.0) {
                this.blended$jms$utils$internal$ConnectionStateManager$$switchState(this.currentReceive, this.publishEvents(s, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Container is waiting to reconnect for provider [", ":", "], remaining wait time [", "]s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.blended$jms$utils$internal$ConnectionStateManager$$provider, BoxesRunTime.boxToDouble((double)(remaining / 1000.0))}))})));
                this.blended$jms$utils$internal$ConnectionStateManager$$checkConnection(this.blended$jms$utils$internal$ConnectionStateManager$$schedule, this.blended$jms$utils$internal$ConnectionStateManager$$checkConnection$default$2());
            } else {
                this.blended$jms$utils$internal$ConnectionStateManager$$switchState((Function1<ConnectionState, PartialFunction<Object, BoxedUnit>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ConnectionStateManager $outer;

                    public final PartialFunction<Object, BoxedUnit> apply(ConnectionState state) {
                        return this.$outer.connecting(state);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.connect(s));
            }
            return;
        }
        throw new MatchError(option);
    }

    public void blended$jms$utils$internal$ConnectionStateManager$$checkConnection(FiniteDuration delay, boolean force) {
        if (force) {
            this.blended$jms$utils$internal$ConnectionStateManager$$pingTimer.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Cancellable x$1) {
                    return x$1.cancel();
                }
            });
            this.blended$jms$utils$internal$ConnectionStateManager$$pingTimer = None$.MODULE$;
        }
        if (this.blended$jms$utils$internal$ConnectionStateManager$$pingTimer.isEmpty()) {
            this.blended$jms$utils$internal$ConnectionStateManager$$pingTimer = new Some((Object)this.context().system().scheduler().scheduleOnce(delay, this.self(), (Object)new CheckConnection(false), (ExecutionContext)this.eCtxt, this.self()));
        }
    }

    public boolean blended$jms$utils$internal$ConnectionStateManager$$checkConnection$default$2() {
        return false;
    }

    private ConnectionState connect(ConnectionState state) {
        ConnectionState connectionState;
        List events = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating connection to JMS provider [", ":", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.blended$jms$utils$internal$ConnectionStateManager$$provider}))}));
        Date lastConnectAttempt = new Date();
        this.context().system().scheduler().scheduleOnce(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds(), this.self(), (Object)new ConnectTimeout(lastConnectAttempt.getTime()), (ExecutionContext)this.eCtxt, this.self());
        if (this.blended$jms$utils$internal$ConnectionStateManager$$config.maxReconnectTimeout() > 0 && state.firstReconnectAttempt().isEmpty() && state.lastDisconnect().isDefined()) {
            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting max reconnect timeout monitor for provider [", ":", "] with [", "]s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.blended$jms$utils$internal$ConnectionStateManager$$provider, BoxesRunTime.boxToInteger((int)this.blended$jms$utils$internal$ConnectionStateManager$$config.maxReconnectTimeout())}));
            events = events.$colon$colon((Object)string);
            Some x$86 = new Some((Object)lastConnectAttempt);
            String x$87 = state.copy$default$1();
            String x$88 = state.copy$default$2();
            Option<Date> x$89 = state.copy$default$3();
            Option<Date> x$90 = state.copy$default$4();
            int x$91 = state.copy$default$5();
            int x$92 = state.copy$default$6();
            List<String> x$93 = state.copy$default$7();
            Option<Date> x$94 = state.copy$default$9();
            connectionState = state.copy(x$87, x$88, x$89, x$90, x$91, x$92, x$93, (Option<Date>)x$86, x$94);
        } else {
            connectionState = state;
        }
        ConnectionState newState = connectionState;
        package$.MODULE$.actorRef2Scala(this.controller).$bang((Object)new Connect(lastConnectAttempt, this.blended$jms$utils$internal$ConnectionStateManager$$config.clientId()), this.self());
        ConnectionState qual$7 = this.publishEvents(newState, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])events.reverse().toArray(ClassTag$.MODULE$.apply(String.class))));
        String x$95 = ConnectionState$.MODULE$.CONNECTING();
        Some x$96 = new Some((Object)lastConnectAttempt);
        String x$97 = qual$7.copy$default$1();
        Option<Date> x$98 = qual$7.copy$default$3();
        Option<Date> x$99 = qual$7.copy$default$4();
        int x$100 = qual$7.copy$default$5();
        int x$101 = qual$7.copy$default$6();
        List<String> x$102 = qual$7.copy$default$7();
        Option<Date> x$103 = qual$7.copy$default$8();
        return qual$7.copy(x$97, x$95, x$98, x$99, x$100, x$101, x$102, x$103, (Option<Date>)x$96);
    }

    public boolean blended$jms$utils$internal$ConnectionStateManager$$checkRestartForFailedReconnect(ConnectionState s, Throwable e) {
        BooleanRef result = BooleanRef.create((boolean)false);
        this.log().error(e, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error connecting to JMS provider [", ":", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.blended$jms$utils$internal$ConnectionStateManager$$provider})));
        if (this.blended$jms$utils$internal$ConnectionStateManager$$config.maxReconnectTimeout() > 0 && s.firstReconnectAttempt().isDefined()) {
            s.firstReconnectAttempt().foreach((Function1)new Serializable(this, result){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConnectionStateManager $outer;
                private final BooleanRef result$1;

                public final void apply(Date t) {
                    if ((System.currentTimeMillis() - t.getTime()) / 1000L > (long)this.$outer.blended$jms$utils$internal$ConnectionStateManager$$config.maxReconnectTimeout()) {
                        Exception e = new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to reconnect to JMS provider [", ":", "] in [", "]s. Restarting container ..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.$outer.blended$jms$utils$internal$ConnectionStateManager$$provider, BoxesRunTime.boxToInteger((int)this.$outer.blended$jms$utils$internal$ConnectionStateManager$$config.maxReconnectTimeout())})));
                        package$.MODULE$.actorRef2Scala(this.$outer.blended$jms$utils$internal$ConnectionStateManager$$monitor).$bang((Object)new RestartContainer(e), this.$outer.self());
                        this.result$1.elem = true;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.result$1 = result$1;
                }
            });
        }
        return result.elem;
    }

    public void blended$jms$utils$internal$ConnectionStateManager$$disconnect(ConnectionState s) {
        this.blended$jms$utils$internal$ConnectionStateManager$$pingTimer.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Cancellable x$3) {
                return x$3.cancel();
            }
        });
        this.blended$jms$utils$internal$ConnectionStateManager$$pingTimer = None$.MODULE$;
        package$.MODULE$.actorRef2Scala(this.controller).$bang((Object)new Disconnect(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(this.blended$jms$utils$internal$ConnectionStateManager$$config.minReconnect())).seconds()), this.self());
        String x$104 = ConnectionState$.MODULE$.CLOSING();
        String x$105 = s.copy$default$1();
        Option<Date> x$106 = s.copy$default$3();
        Option<Date> x$107 = s.copy$default$4();
        int x$108 = s.copy$default$5();
        int x$109 = s.copy$default$6();
        List<String> x$110 = s.copy$default$7();
        Option<Date> x$111 = s.copy$default$8();
        Option<Date> x$112 = s.copy$default$9();
        this.blended$jms$utils$internal$ConnectionStateManager$$switchState((Function1<ConnectionState, PartialFunction<Object, BoxedUnit>>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;

            public final PartialFunction<Object, BoxedUnit> apply(ConnectionState state) {
                return this.$outer.closing(state);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, s.copy(x$105, x$104, x$106, x$107, x$108, x$109, x$110, x$111, x$112));
    }

    public void blended$jms$utils$internal$ConnectionStateManager$$checkReconnect(ConnectionState s) {
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking reconnect for provider [", ":", "] state [", "] against tolerance [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.blended$jms$utils$internal$ConnectionStateManager$$provider, s, BoxesRunTime.boxToInteger((int)this.blended$jms$utils$internal$ConnectionStateManager$$config.pingTolerance())})));
        if (s.failedPings() == this.blended$jms$utils$internal$ConnectionStateManager$$config.pingTolerance()) {
            this.blended$jms$utils$internal$ConnectionStateManager$$reconnect(this.publishEvents(s, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum ping tolerance for provider [", ":", "] reached .... reconnecting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.blended$jms$utils$internal$ConnectionStateManager$$provider}))})));
        } else {
            this.blended$jms$utils$internal$ConnectionStateManager$$switchState(this.currentReceive, s);
            this.blended$jms$utils$internal$ConnectionStateManager$$checkConnection(this.blended$jms$utils$internal$ConnectionStateManager$$retrySchedule, this.blended$jms$utils$internal$ConnectionStateManager$$checkConnection$default$2());
        }
    }

    public void blended$jms$utils$internal$ConnectionStateManager$$reconnect(ConnectionState s) {
        this.blended$jms$utils$internal$ConnectionStateManager$$disconnect(s);
        this.blended$jms$utils$internal$ConnectionStateManager$$checkConnection(this.blended$jms$utils$internal$ConnectionStateManager$$retrySchedule, this.blended$jms$utils$internal$ConnectionStateManager$$checkConnection$default$2());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void blended$jms$utils$internal$ConnectionStateManager$$ping(Connection c) {
        if (this.blended$jms$utils$internal$ConnectionStateManager$$config.pingEnabled()) {
            Option<ActorRef> option = this.blended$jms$utils$internal$ConnectionStateManager$$pinger;
            if (None$.MODULE$.equals(option)) {
                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking JMS connection for provider [", ":", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$vendor, this.blended$jms$utils$internal$ConnectionStateManager$$provider})));
                this.blended$jms$utils$internal$ConnectionStateManager$$pinger = new Some((Object)this.context().actorOf(ConnectionPingActor$.MODULE$.props(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(this.blended$jms$utils$internal$ConnectionStateManager$$config.pingTimeout())).seconds())));
                this.blended$jms$utils$internal$ConnectionStateManager$$pinger.foreach((Function1)new Serializable(this, c){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ConnectionStateManager $outer;
                    private final Connection c$1;

                    public final void apply(ActorRef x$4) {
                        package$.MODULE$.actorRef2Scala(x$4).$bang((Object)JmsPingPerformer$.MODULE$.props(this.$outer.blended$jms$utils$internal$ConnectionStateManager$$config, this.c$1), this.$outer.self());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.c$1 = c$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!(option instanceof Some)) throw new MatchError(option);
                this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring ping request for provider [", "] as one pinger is already active."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$provider})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ping is disabled for connection factory [", ":", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$jms$utils$internal$ConnectionStateManager$$config.vendor(), this.blended$jms$utils$internal$ConnectionStateManager$$config.provider()})));
        }
    }

    public ConnectionStateManager(BlendedJMSConnectionConfig config, ActorRef monitor, ConnectionHolder holder) {
        this.blended$jms$utils$internal$ConnectionStateManager$$config = config;
        this.blended$jms$utils$internal$ConnectionStateManager$$monitor = monitor;
        Actor.class.$init$((Actor)this);
        ActorLogging.class.$init$((ActorLogging)this);
        this.blended$jms$utils$internal$ConnectionStateManager$$df = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
        this.eCtxt = this.context().system().dispatcher();
        this.blended$jms$utils$internal$ConnectionStateManager$$provider = config.provider();
        this.blended$jms$utils$internal$ConnectionStateManager$$vendor = config.vendor();
        this.blended$jms$utils$internal$ConnectionStateManager$$conn = None$.MODULE$;
        this.currentReceive = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConnectionStateManager $outer;

            public final PartialFunction<Object, BoxedUnit> apply(ConnectionState state) {
                return this.$outer.disconnected(state);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        ConnectionState qual$1 = new ConnectionState(config.provider(), ConnectionState$.MODULE$.apply$default$2(), ConnectionState$.MODULE$.apply$default$3(), ConnectionState$.MODULE$.apply$default$4(), ConnectionState$.MODULE$.apply$default$5(), ConnectionState$.MODULE$.apply$default$6(), ConnectionState$.MODULE$.apply$default$7(), ConnectionState$.MODULE$.apply$default$8(), ConnectionState$.MODULE$.apply$default$9());
        String x$5 = ConnectionState$.MODULE$.DISCONNECTED();
        String x$6 = qual$1.copy$default$1();
        Option<Date> x$7 = qual$1.copy$default$3();
        Option<Date> x$8 = qual$1.copy$default$4();
        int x$9 = qual$1.copy$default$5();
        int x$10 = qual$1.copy$default$6();
        List<String> x$11 = qual$1.copy$default$7();
        Option<Date> x$12 = qual$1.copy$default$8();
        Option<Date> x$13 = qual$1.copy$default$9();
        this.currentState = qual$1.copy(x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
        this.blended$jms$utils$internal$ConnectionStateManager$$pinger = None$.MODULE$;
        this.blended$jms$utils$internal$ConnectionStateManager$$retrySchedule = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(config.retryInterval())).seconds();
        this.blended$jms$utils$internal$ConnectionStateManager$$schedule = Duration$.MODULE$.apply((long)config.pingInterval(), TimeUnit.SECONDS);
        this.blended$jms$utils$internal$ConnectionStateManager$$pingTimer = None$.MODULE$;
        this.controller = this.context().actorOf(JmsConnectionController$.MODULE$.props(holder));
    }
}

