/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.util.Timeout;
import blended.jms.utils.BlendedJMSConnection;
import blended.jms.utils.BlendedJMSConnectionConfig;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.internal.CheckConnection;
import blended.jms.utils.internal.ConnectionHolder;
import blended.jms.utils.internal.ConnectionMonitor;
import blended.jms.utils.internal.ConnectionStateManager$;
import blended.jms.utils.internal.ConnectionStateMonitor$;
import java.lang.management.ManagementFactory;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001%\u0011aD\u00117f]\u0012,GmU5oO2,7i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u000b\u0005\r!\u0011!B;uS2\u001c(BA\u0003\u0007\u0003\rQWn\u001d\u0006\u0002\u000f\u00059!\r\\3oI\u0016$7\u0001A\n\u0004\u0001)\u0011\u0002CA\u0006\u0011\u001b\u0005a!BA\u0007\u000f\u0003\u0011a\u0017M\\4\u000b\u0003=\tAA[1wC&\u0011\u0011\u0003\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!\u0001G%e\u0003^\f'/Z\"p]:,7\r^5p]\u001a\u000b7\r^8ss\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0004d_:4\u0017n\u001a\t\u0003'eI!A\u0007\u0002\u00035\tcWM\u001c3fI*k5kQ8o]\u0016\u001cG/[8o\u0007>tg-[4\t\u0011q\u0001!\u0011!Q\u0001\nu\taa]=ti\u0016l\u0007C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0015\t7\r^8s\u0015\u0005\u0011\u0013\u0001B1lW\u0006L!\u0001J\u0010\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005i!-\u001e8eY\u0016\u001cuN\u001c;fqR\u00042\u0001K\u0016.\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB(qi&|g\u000e\u0005\u0002/k5\tqF\u0003\u00021c\u0005IaM]1nK^|'o\u001b\u0006\u0003eM\nAa\\:hS*\tA'A\u0002pe\u001eL!AN\u0018\u0003\u001b\t+h\u000e\u001a7f\u0007>tG/\u001a=u\u0011\u0015A\u0004\u0001\"\u0001:\u0003\u0019a\u0014N\\5u}Q!!h\u000f\u001f>!\t\u0019\u0002\u0001C\u0003\u0018o\u0001\u0007\u0001\u0004C\u0003\u001do\u0001\u0007Q\u0004C\u0003'o\u0001\u0007q\u0005\u0003\u0004@\u0001\u0001\u0006I\u0001Q\u0001\u0007m\u0016tGm\u001c:\u0011\u0005\u0005#eB\u0001\u0015C\u0013\t\u0019\u0015&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013aa\u0015;sS:<'BA\"*\u0011\u0019A\u0005\u0001)A\u0005\u0001\u0006A\u0001O]8wS\u0012,'\u000f\u0003\u0004K\u0001\u0001\u0006YaS\u0001\u0006K\u000e#\b\u0010\u001e\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d&\n!bY8oGV\u0014(/\u001a8u\u0013\t\u0001VJ\u0001\rFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0016CXmY;u_JDaA\u0015\u0001!\u0002\u0017\u0019\u0016a\u0002;j[\u0016|W\u000f\u001e\t\u0003)^k\u0011!\u0016\u0006\u0003-\u0006\nA!\u001e;jY&\u0011\u0001,\u0016\u0002\b)&lWm\\;u\u0011\u0019Q\u0006\u0001)A\u00057\u0006\u0019An\\4\u0011\u0005q{V\"A/\u000b\u0005y\u001b\u0014!B:mMRR\u0017B\u00011^\u0005\u0019aunZ4fe\"1!\r\u0001Q\u0001\n\u0001\u000b1\"\\8oSR|'OT1nK\"1A\r\u0001Q\u0001\n\u0001\u000bAb\u001d;bi\u0016luM\u001d(b[\u0016DqA\u001a\u0001C\u0002\u0013\u0005q-\u0001\u0004i_2$WM]\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111NA\u0001\tS:$XM\u001d8bY&\u0011QN\u001b\u0002\u0011\u0007>tg.Z2uS>t\u0007j\u001c7eKJDaa\u001c\u0001!\u0002\u0013A\u0017a\u00025pY\u0012,'\u000f\t\u0005\tc\u0002A)\u0019)C\u0005e\u0006I1MZ#oC\ndW\rZ\u000b\u0002gB\u0011\u0001\u0006^\u0005\u0003k&\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005x\u0001!\u0005\t\u0015)\u0003t\u0003)\u0019g-\u00128bE2,G\r\t\u0005\u0007A\u0001\u0001\u000b\u0011B=\u0011\u0007!Z#\u0010\u0005\u0002\u001fw&\u0011Ap\b\u0002\t\u0003\u000e$xN\u001d*fM\")a\u0010\u0001C!\u007f\u0006\u00012M]3bi\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\f5\u0011\u0011Q\u0001\u0006\u0004\u000b\u0005\u001d!BAA\u0005\u0003\u0015Q\u0017M^1y\u0013\u0011\ti!!\u0002\u0003\u0015\r{gN\\3di&|g\u000eK\u0003~\u0003#\ti\u0002E\u0003)\u0003'\t9\"C\u0002\u0002\u0016%\u0012a\u0001\u001e5s_^\u001c\b\u0003BA\u0002\u00033IA!a\u0007\u0002\u0006\ta!*T*Fq\u000e,\u0007\u000f^5p]F2a\u0004QA\u0010\u0003#\n\u0014bIA\u0011\u0003S\t9%a\u000b\u0016\t\u0005\r\u0012QE\u000b\u0002\u0001\u00129\u0011q\u0005\u0005C\u0002\u0005E\"!\u0001+\n\t\u0005-\u0012QF\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u0005=\u0012&\u0001\u0004uQJ|wo]\t\u0005\u0003g\tI\u0004E\u0002)\u0003kI1!a\u000e*\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u000f\u0002B9\u0019\u0001&!\u0010\n\u0007\u0005}\u0012&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0013Q\t\u0002\n)\"\u0014xn^1cY\u0016T1!a\u0010*c%\u0019\u0013\u0011JA&\u0003\u001b\nyCD\u0002)\u0003\u0017J1!a\f*c\u0015\u0011\u0003&KA(\u0005\u0015\u00198-\u00197bc\r1\u0013q\u0003\u0005\u0007}\u0002!\t%!\u0016\u0015\r\u0005\u0005\u0011qKA.\u0011\u001d\tI&a\u0015A\u0002\u0001\u000bA!^:fe\"9\u0011QLA*\u0001\u0004\u0001\u0015\u0001\u00039bgN<xN\u001d3\t\u0013\u0005\u0005\u0004A1A\u0005B\u0005\r\u0012\u0001C2mS\u0016tG/\u00133\t\u000f\u0005\u0015\u0004\u0001)A\u0005\u0001\u0006I1\r\\5f]RLE\r\t")
public class BlendedSingleConnectionFactory
implements IdAwareConnectionFactory {
    public final BlendedJMSConnectionConfig blended$jms$utils$BlendedSingleConnectionFactory$$config;
    private final String vendor;
    private final String provider;
    private final ExecutionContextExecutor eCtxt;
    private final Timeout timeout;
    private final Logger log;
    private final String monitorName;
    private final String stateMgrName;
    private final ConnectionHolder holder;
    private boolean cfEnabled;
    private final Option<ActorRef> actor;
    private final String clientId;
    private volatile boolean bitmap$0;

    private boolean cfEnabled$lzycompute() {
        BlendedSingleConnectionFactory blendedSingleConnectionFactory = this;
        synchronized (blendedSingleConnectionFactory) {
            if (!this.bitmap$0) {
                this.cfEnabled = this.blended$jms$utils$BlendedSingleConnectionFactory$$config.enabled() && this.blended$jms$utils$BlendedSingleConnectionFactory$$config.cfEnabled().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlendedSingleConnectionFactory $outer;

                    public final boolean apply(Function1<BlendedJMSConnectionConfig, Object> f) {
                        return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)this.$outer.blended$jms$utils$BlendedSingleConnectionFactory$$config));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.bitmap$0 = true;
            }
            return this.cfEnabled;
        }
    }

    public ConnectionHolder holder() {
        return this.holder;
    }

    private boolean cfEnabled() {
        return this.bitmap$0 ? this.cfEnabled : this.cfEnabled$lzycompute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection createConnection() throws JMSException {
        if (!this.cfEnabled()) throw new JMSException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection for provider [", ":", "] is disabled."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.vendor, this.provider})));
        try {
            Option<BlendedJMSConnection> option = this.holder().getConnection();
            if (option instanceof Some) {
                Some some = (Some)option;
                BlendedJMSConnection c = (BlendedJMSConnection)some.x();
                return c;
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error connecting to [", ":", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.vendor, this.provider})));
        }
        catch (Exception exception) {
            JMSException jmsEx = new JMSException("Error getting Connection Factory");
            jmsEx.setLinkedException(exception);
            throw jmsEx;
        }
    }

    public Connection createConnection(String user, String password) {
        this.log.warn("BlendedSingleConnectionFactory.createConnection() called with username and password, which is not supported.\nFalling back to default username and password.");
        return this.createConnection();
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    public BlendedSingleConnectionFactory(BlendedJMSConnectionConfig config, ActorSystem system, Option<BundleContext> bundleContext) {
        None$ none$;
        this.blended$jms$utils$BlendedSingleConnectionFactory$$config = config;
        this.vendor = config.vendor();
        this.provider = config.provider();
        this.eCtxt = system.dispatcher();
        this.timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis());
        this.log = LoggerFactory.getLogger(BlendedSingleConnectionFactory.class);
        this.monitorName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Monitor-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.vendor, this.provider}));
        this.stateMgrName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JMS-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.vendor, this.provider}));
        this.holder = new ConnectionHolder(config, system, bundleContext);
        if (this.cfEnabled()) {
            None$ none$2;
            if (config.jmxEnabled()) {
                MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
                ConnectionMonitor jmxBean = new ConnectionMonitor(this.provider, this.clientId());
                ObjectName objName = new ObjectName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blended:type=ConnectionMonitor,vendor=", ",provider=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.vendor, this.provider})));
                jmxServer.registerMBean(jmxBean, objName);
                none$2 = new Some((Object)jmxBean);
            } else {
                none$2 = None$.MODULE$;
            }
            None$ mbean = none$2;
            ActorRef monitor = system.actorOf(ConnectionStateMonitor$.MODULE$.props(bundleContext, (Option<ConnectionMonitor>)mbean), this.monitorName);
            this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection State Monitor [", "] created."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stateMgrName})));
            none$ = new Some((Object)system.actorOf(ConnectionStateManager$.MODULE$.props(config, monitor, this.holder()), this.stateMgrName));
        } else {
            this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection State Monitor [", "] is disabled by config setting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stateMgrName})));
            none$ = None$.MODULE$;
        }
        this.actor = none$;
        this.actor.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ActorRef a) {
                ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(a);
                CheckConnection x$1 = new CheckConnection(false);
                ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
                qual$1.$bang((Object)x$1, x$2);
            }
        });
        this.clientId = config.clientId();
    }
}

