/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.util.Timeout;
import blended.akka.OSGIActorConfig;
import blended.jms.utils.BlendedJMSConnection;
import blended.jms.utils.BlendedJMSConnectionConfig;
import blended.jms.utils.internal.CheckConnection;
import blended.jms.utils.internal.ConnectionHolder;
import blended.jms.utils.internal.ConnectionMonitor;
import blended.jms.utils.internal.ConnectionStateManager$;
import blended.jms.utils.internal.ConnectionStateMonitor$;
import java.lang.management.ManagementFactory;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u0001%\u0011aD\u00117f]\u0012,GmU5oO2,7i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u000b\u0005\r!\u0011!B;uS2\u001c(BA\u0003\u0007\u0003\rQWn\u001d\u0006\u0002\u000f\u00059!\r\\3oI\u0016$7\u0001A\n\u0004\u0001)\u0011\u0002CA\u0006\u0011\u001b\u0005a!BA\u0007\u000f\u0003\u0011a\u0017M\\4\u000b\u0003=\tAA[1wC&\u0011\u0011\u0003\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005M9R\"\u0001\u000b\u000b\u0005\u0015)\"\"\u0001\f\u0002\u000b)\fg/\u0019=\n\u0005a!\"!E\"p]:,7\r^5p]\u001a\u000b7\r^8ss\"A!\u0004\u0001B\u0001B\u0003%1$A\u0002dM\u001e\u0004\"\u0001H\u0010\u000e\u0003uQ!A\b\u0004\u0002\t\u0005\\7.Y\u0005\u0003Au\u0011qbT*H\u0013\u0006\u001bGo\u001c:D_:4\u0017n\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005%\u0005\u00111M\u001a\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u0005A\u0001O]8wS\u0012,'\u000f\u0005\u0002'Y9\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\u00051\u0001K]3eK\u001aL!!\f\u0018\u0003\rM#(/\u001b8h\u0015\tY\u0003\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0003\u0019\u0019wN\u001c4jOB\u0011!gM\u0007\u0002\u0005%\u0011AG\u0001\u0002\u001b\u00052,g\u000eZ3e\u00156\u001b6i\u001c8oK\u000e$\u0018n\u001c8D_:4\u0017n\u001a\u0005\u0006m\u0001!\taN\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000baJ$h\u000f\u001f\u0011\u0005I\u0002\u0001\"\u0002\u000e6\u0001\u0004Y\u0002\"\u0002\u00126\u0001\u0004\u0011\u0002\"\u0002\u00136\u0001\u0004)\u0003\"\u0002\u00196\u0001\u0004\t\u0004B\u0002 \u0001A\u0003-q(A\u0003f\u0007RDH\u000f\u0005\u0002A\u00076\t\u0011I\u0003\u0002CQ\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0011\u000b%\u0001G#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;pe\"1a\t\u0001Q\u0001\f\u001d\u000bq\u0001^5nK>,H\u000f\u0005\u0002I\u00196\t\u0011J\u0003\u0002K\u0017\u0006!Q\u000f^5m\u0015\u0005q\u0012BA'J\u0005\u001d!\u0016.\\3pkRDaa\u0014\u0001!\u0002\u0013\u0001\u0016a\u00017pOB\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\u0006g24GG\u001b\u0006\u0002+\u0006\u0019qN]4\n\u0005]\u0013&A\u0002'pO\u001e,'\u000f\u0003\u0004Z\u0001\u0001\u0006I!J\u0001\f[>t\u0017\u000e^8s\u001d\u0006lW\r\u0003\u0004\\\u0001\u0001\u0006I!J\u0001\rgR\fG/Z'he:\u000bW.\u001a\u0005\b;\u0002\u0011\r\u0011\"\u0001_\u0003\u0019Aw\u000e\u001c3feV\tq\f\u0005\u0002aG6\t\u0011M\u0003\u0002c\u0005\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002eC\n\u00012i\u001c8oK\u000e$\u0018n\u001c8I_2$WM\u001d\u0005\u0007M\u0002\u0001\u000b\u0011B0\u0002\u000f!|G\u000eZ3sA!1\u0001\u000e\u0001Q\u0001\n%\fQ!Y2u_J\u00042a\n6m\u0013\tY\u0007F\u0001\u0004PaRLwN\u001c\t\u0003[>l\u0011A\u001c\u0006\u0003Q.K!\u0001\u001d8\u0003\u0011\u0005\u001bGo\u001c:SK\u001aDQA\u001d\u0001\u0005BM\f\u0001c\u0019:fCR,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0003Q\u0004\"aE;\n\u0005Y$\"AC\"p]:,7\r^5p]\"\u001a\u0011\u000f\u001f@\u0011\u0007\u001dJ80\u0003\u0002{Q\t1A\u000f\u001b:poN\u0004\"a\u0005?\n\u0005u$\"\u0001\u0004&N'\u0016C8-\u001a9uS>t\u0017'\u0002\u0010&\u007f\u0006E\u0012'C\u0012\u0002\u0002\u0005%\u0011qEA\u0006+\u0011\t\u0019!!\u0002\u0016\u0003\u0015\"q!a\u0002\t\u0005\u0004\t\tBA\u0001U\u0013\u0011\tY!!\u0004\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\ty\u0001K\u0001\u0007i\"\u0014xn^:\u0012\t\u0005M\u0011\u0011\u0004\t\u0004O\u0005U\u0011bAA\fQ\t9aj\u001c;iS:<\u0007\u0003BA\u000e\u0003Cq1aJA\u000f\u0013\r\ty\u0002K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019#!\n\u0003\u0013QC'o\\<bE2,'bAA\u0010QEJ1%!\u000b\u0002,\u00055\u0012q\u0002\b\u0004O\u0005-\u0012bAA\bQE*!e\n\u0015\u00020\t)1oY1mCF\u0012ae\u001f\u0005\u0007e\u0002!\t%!\u000e\u0015\u000bQ\f9$a\u000f\t\u000f\u0005e\u00121\u0007a\u0001K\u0005!Qo]3s\u0011\u001d\ti$a\rA\u0002\u0015\n\u0001\u0002]1tg^|'\u000f\u001a")
public class BlendedSingleConnectionFactory
implements ConnectionFactory {
    private final String provider;
    private final BlendedJMSConnectionConfig config;
    private final ExecutionContextExecutor eCtxt;
    private final Timeout timeout;
    private final Logger log;
    private final String monitorName;
    private final String stateMgrName;
    private final ConnectionHolder holder;
    private final Option<ActorRef> actor;

    public ConnectionHolder holder() {
        return this.holder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection createConnection() throws JMSException {
        if (!this.config.enabled()) throw new JMSException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection for provider [", "] is disabled."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.provider})));
        try {
            Option<BlendedJMSConnection> option = this.holder().getConnection();
            if (option instanceof Some) {
                Some some = (Some)option;
                BlendedJMSConnection c = (BlendedJMSConnection)some.x();
                return c;
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error connecting to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.provider})));
        }
        catch (Exception exception) {
            JMSException jmsEx = new JMSException("Error getting Connection Factory");
            jmsEx.setLinkedException(exception);
            throw jmsEx;
        }
    }

    public Connection createConnection(String user, String password) {
        this.log.warn("BlendedSingleConnectionFactory.createConnection() called with username and password, which is not supported.\nFalling back to default username and password.");
        return this.createConnection();
    }

    public BlendedSingleConnectionFactory(OSGIActorConfig cfg, ConnectionFactory cf, String provider, BlendedJMSConnectionConfig config) {
        None$ none$;
        this.provider = provider;
        this.config = config;
        this.eCtxt = cfg.system().dispatcher();
        this.timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis());
        this.log = LoggerFactory.getLogger(BlendedSingleConnectionFactory.class);
        this.monitorName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Monitor-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider}));
        this.stateMgrName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JMS-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider}));
        this.holder = new ConnectionHolder(provider, cf);
        if (config.enabled()) {
            MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
            ConnectionMonitor mBean = new ConnectionMonitor(provider);
            ObjectName objName = new ObjectName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blended:type=ConnectionMonitor,provider=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider})));
            jmxServer.registerMBean(mBean, objName);
            ActorRef monitor = cfg.system().actorOf(ConnectionStateMonitor$.MODULE$.props(cfg.bundleContext(), mBean), this.monitorName);
            this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection State Monitor [", "] created."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stateMgrName})));
            none$ = new Some((Object)cfg.system().actorOf(ConnectionStateManager$.MODULE$.props(monitor, this.holder(), config), this.stateMgrName));
        } else {
            this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection State Monitor [", "] is disabled by config setting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stateMgrName})));
            none$ = None$.MODULE$;
        }
        this.actor = none$;
        this.actor.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ActorRef a) {
                ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(a);
                CheckConnection x$1 = new CheckConnection(false);
                ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
                qual$1.$bang((Object)x$1, x$2);
            }
        });
    }
}

