/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.bridge;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.stream.FanOutShape2;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.KillSwitch;
import akka.stream.Materializer;
import akka.stream.UniformFanInShape;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Merge$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import blended.jms.bridge.BridgeProviderConfig;
import blended.jms.bridge.InvalidBridgeConfigurationException;
import blended.jms.bridge.JmsStreamConfig;
import blended.jms.bridge.TrackTransaction$;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.JmsDestination;
import blended.streams.FlowProcessor$;
import blended.streams.StreamControllerConfig;
import blended.streams.StreamControllerConfig$;
import blended.streams.jms.AcknowledgeMode$;
import blended.streams.jms.JMSConsumerSettings;
import blended.streams.jms.JMSConsumerSettings$;
import blended.streams.jms.JmsAckSourceStage;
import blended.streams.jms.JmsDeliveryMode$;
import blended.streams.jms.JmsDestinationResolver;
import blended.streams.jms.JmsProducerSettings;
import blended.streams.jms.JmsProducerSettings$;
import blended.streams.jms.JmsStreamSupport;
import blended.streams.jms.MessageDestinationResolver;
import blended.streams.jms.SettingsDestinationResolver;
import blended.streams.message.FlowEnvelope;
import blended.streams.processor.Collector;
import blended.streams.processor.HeaderTransformProcessor;
import blended.streams.transaction.FlowHeaderConfig;
import blended.streams.transaction.TransactionWiretap;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0010!\u0001\u001dB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0006w!A1\t\u0001B\u0001B\u0003-A\tC\u0003K\u0001\u0011\u00051\nC\u0004R\u0001\t\u0007I\u0011\u0002*\t\ry\u0003\u0001\u0015!\u0003T\u0011\u001dy\u0006A1A\u0005\nICa\u0001\u0019\u0001!\u0002\u0013\u0019\u0006bB1\u0001\u0005\u0004%IA\u0015\u0005\u0007E\u0002\u0001\u000b\u0011B*\t\u000f\r\u0004!\u0019!C\u0005I\"1Q\u000e\u0001Q\u0001\n\u0015DqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004t\u0001\u0001\u0006I\u0001\u001d\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0011\u001d\tY\u0001\u0001Q\u0001\nYD\u0011\"!\u0004\u0001\u0005\u0004%I!a\u0004\t\u000f\u0005E\u0001\u0001)A\u0005s\"I\u00111\u0003\u0001C\u0002\u0013%\u0011Q\u0003\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111\u0006\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002.!I\u0011Q\u0007\u0001C\u0002\u0013%\u0011q\u0007\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002:!Q\u0011\u0011\n\u0001C\u0002\u0013\u0005\u0001%a\u0013\t\u0011\u00055\u0004\u0001)A\u0005\u0003\u001bB\u0001b\u0012\u0001C\u0002\u0013%\u0011q\u000e\u0005\t\u0003{\u0002\u0001\u0015!\u0003\u0002r!I\u0011q\u0010\u0001C\u0002\u0013\u0005\u0011\u0011\u0011\u0005\t\u0003\u0017\u0003\u0001\u0015!\u0003\u0002\u0004\n\u0001\"*\\:TiJ,\u0017-\u001c\"vS2$WM\u001d\u0006\u0003C\t\naA\u0019:jI\u001e,'BA\u0012%\u0003\rQWn\u001d\u0006\u0002K\u00059!\r\\3oI\u0016$7\u0001A\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020g5\t\u0001G\u0003\u0002$c)\u0011!\u0007J\u0001\bgR\u0014X-Y7t\u0013\t!\u0004G\u0001\tK[N\u001cFO]3b[N+\b\u000f]8si\u0006\u00191MZ4\u0011\u0005]BT\"\u0001\u0011\n\u0005e\u0002#a\u0004&ngN#(/Z1n\u0007>tg-[4\u0002\rML8\u000f^3n!\ta\u0014)D\u0001>\u0015\tqt(A\u0003bGR|'OC\u0001A\u0003\u0011\t7n[1\n\u0005\tk$aC!di>\u00148+_:uK6\fA\"\\1uKJL\u0017\r\\5{KJ\u0004\"!\u0012%\u000e\u0003\u0019S!aR \u0002\rM$(/Z1n\u0013\tIeI\u0001\u0007NCR,'/[1mSj,'/\u0001\u0004=S:LGO\u0010\u000b\u0003\u0019B#2!\u0014(P!\t9\u0004\u0001C\u0003;\t\u0001\u000f1\bC\u0003D\t\u0001\u000fA\tC\u00036\t\u0001\u0007a'\u0001\u0003j]&#W#A*\u0011\u0005Q[fBA+Z!\t1&&D\u0001X\u0015\tAf%\u0001\u0004=e>|GOP\u0005\u00035*\na\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!LK\u0001\u0006S:LE\rI\u0001\u0006_V$\u0018\nZ\u0001\u0007_V$\u0018\n\u001a\u0011\u0002\u0011M$(/Z1n\u0013\u0012\f\u0011b\u001d;sK\u0006l\u0017\n\u001a\u0011\u0002\u0019\t\u0014\u0018\u000eZ4f\u0019><w-\u001a:\u0016\u0003\u0015\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u000f1|wmZ5oO*\u0011!\u000eJ\u0001\u0005kRLG.\u0003\u0002mO\n1Aj\\4hKJ\fQB\u0019:jI\u001e,Gj\\4hKJ\u0004\u0013aC:sGN+G\u000f^5oON,\u0012\u0001\u001d\t\u0003_EL!A\u001d\u0019\u0003')k5kQ8ogVlWM]*fiRLgnZ:\u0002\u0019M\u00148mU3ui&twm\u001d\u0011\u0002\u0019\u0011,7\u000f\u001e*fg>dg/\u001a:\u0016\u0003Y\u0004B!K<zy&\u0011\u0001P\u000b\u0002\n\rVt7\r^5p]F\u0002\"a\f>\n\u0005m\u0004$a\u0005&ngB\u0013x\u000eZ;dKJ\u001cV\r\u001e;j]\u001e\u001c(\u0003B?\u0000\u0003\u000b1AA \u0001\u0001y\naAH]3gS:,W.\u001a8u}A\u0019q&!\u0001\n\u0007\u0005\r\u0001G\u0001\fK[N$Um\u001d;j]\u0006$\u0018n\u001c8SKN|GN^3s!\ry\u0013qA\u0005\u0004\u0003\u0013\u0001$!\u0005&ng\u0016sg/\u001a7pa\u0016DU-\u00193fe\u0006iA-Z:u%\u0016\u001cx\u000e\u001c<fe\u0002\n!\u0002^8TKR$\u0018N\\4t+\u0005I\u0018a\u0003;p'\u0016$H/\u001b8hg\u0002\n\u0001#\u001b8uKJt\u0017\r\u001c)s_ZLG-\u001a:\u0016\u0005\u0005]\u0001CBA\r\u0003;\t\t#\u0004\u0002\u0002\u001c)\u0011!NK\u0005\u0005\u0003?\tYBA\u0002Uef\u00042aNA\u0012\u0013\r\t)\u0003\t\u0002\u0015\u0005JLGmZ3Qe>4\u0018\u000eZ3s\u0007>tg-[4\u0002#%tG/\u001a:oC2\u0004&o\u001c<jI\u0016\u0014\b%\u0001\u0006j]R,'O\\1m\u0013\u0012,\"!!\f\u0011\u000b%\nycU*\n\u0007\u0005E\"F\u0001\u0004UkBdWMM\u0001\fS:$XM\u001d8bY&#\u0007%\u0001\u0006j]R,'O\\1m\u0007\u001a,\"!!\u000f\u0011\r\u0005e\u0011QDA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!E\u0005)Q\u000f^5mg&!\u0011QIA \u0005aIE-Q<be\u0016\u001cuN\u001c8fGRLwN\u001c$bGR|'/_\u0001\fS:$XM\u001d8bY\u000e3\u0007%A\u0006ue\u0006\u001c7NR5mi\u0016\u0014XCAA'!\u001d)\u0015qJA*\u0003KJ1!!\u0015G\u0005\u00159%/\u00199i!%)\u0015QKA-\u00033\nI&C\u0002\u0002X\u0019\u0013ABR1o\u001fV$8\u000b[1qKJ\u0002B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?\n\u0014aB7fgN\fw-Z\u0005\u0005\u0003G\niF\u0001\u0007GY><XI\u001c<fY>\u0004X\r\u0005\u0003\u0002h\u0005%T\"A \n\u0007\u0005-tHA\u0004O_R,6/\u001a3\u0002\u0019Q\u0014\u0018mY6GS2$XM\u001d\u0011\u0016\u0005\u0005E\u0004\u0003CA:\u0003s\nI&!\u001a\u000e\u0005\u0005U$bAA<\r\u0006A1oY1mC\u0012\u001cH.\u0003\u0003\u0002|\u0005U$AB*pkJ\u001cW-A\u0004tiJ,\u0017-\u001c\u0011\u0002\u0013M$(/Z1n\u0007\u001a<WCAAB!\u0011\t))a\"\u000e\u0003EJ1!!#2\u0005Y\u0019FO]3b[\u000e{g\u000e\u001e:pY2,'oQ8oM&<\u0017AC:ue\u0016\fWn\u00114hA\u0001")
public class JmsStreamBuilder
implements JmsStreamSupport {
    private final JmsStreamConfig cfg;
    private final ActorSystem system;
    private final Materializer materializer;
    private final String inId;
    private final String outId;
    private final String streamId;
    private final Logger bridgeLogger;
    private final JMSConsumerSettings srcSettings;
    private final Function1<JmsProducerSettings, JmsDestinationResolver> destResolver;
    private final JmsProducerSettings toSettings;
    private final Try<BridgeProviderConfig> internalProvider;
    private final Tuple2<String, String> internalId;
    private final Try<IdAwareConnectionFactory> internalCf;
    private final Graph<FanOutShape2<FlowEnvelope, FlowEnvelope, FlowEnvelope>, NotUsed> trackFilter;
    private final Source<FlowEnvelope, NotUsed> stream;
    private final StreamControllerConfig streamCfg;

    public Try<KillSwitch> processMessages(Flow<FlowEnvelope, FlowEnvelope, ?> processFlow, Seq<FlowEnvelope> msgs, ActorSystem system) {
        return JmsStreamSupport.processMessages$((JmsStreamSupport)this, processFlow, msgs, (ActorSystem)system);
    }

    public Try<KillSwitch> sendMessages(JmsProducerSettings producerSettings, Logger log, Seq<FlowEnvelope> msgs, ActorSystem system, Materializer materializer, ExecutionContext ectxt) {
        return JmsStreamSupport.sendMessages$((JmsStreamSupport)this, (JmsProducerSettings)producerSettings, (Logger)log, msgs, (ActorSystem)system, (Materializer)materializer, (ExecutionContext)ectxt);
    }

    public Collector<FlowEnvelope> receiveMessages(FlowHeaderConfig headerCfg, IdAwareConnectionFactory cf, JmsDestination dest, Logger log, Integer listener, Option<String> selector, FiniteDuration timeout, ActorSystem system, Materializer materializer) {
        return JmsStreamSupport.receiveMessages$((JmsStreamSupport)this, (FlowHeaderConfig)headerCfg, (IdAwareConnectionFactory)cf, (JmsDestination)dest, (Logger)log, (Integer)listener, selector, (FiniteDuration)timeout, (ActorSystem)system, (Materializer)materializer);
    }

    public Integer receiveMessages$default$5() {
        return JmsStreamSupport.receiveMessages$default$5$((JmsStreamSupport)this);
    }

    public Option<String> receiveMessages$default$6() {
        return JmsStreamSupport.receiveMessages$default$6$((JmsStreamSupport)this);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> jmsProducer(String name, JmsProducerSettings settings, boolean autoAck, ActorSystem system, Materializer materializer) {
        return JmsStreamSupport.jmsProducer$((JmsStreamSupport)this, (String)name, (JmsProducerSettings)settings, (boolean)autoAck, (ActorSystem)system, (Materializer)materializer);
    }

    public boolean jmsProducer$default$3() {
        return JmsStreamSupport.jmsProducer$default$3$((JmsStreamSupport)this);
    }

    public Source<FlowEnvelope, NotUsed> jmsConsumer(String name, JMSConsumerSettings settings, FlowHeaderConfig headerConfig, ActorSystem system) {
        return JmsStreamSupport.jmsConsumer$((JmsStreamSupport)this, (String)name, (JMSConsumerSettings)settings, (FlowHeaderConfig)headerConfig, (ActorSystem)system);
    }

    public Source<FlowEnvelope, NotUsed> restartableConsumer(String name, JMSConsumerSettings settings, FlowHeaderConfig headerConfig, ActorSystem system) {
        return JmsStreamSupport.restartableConsumer$((JmsStreamSupport)this, (String)name, (JMSConsumerSettings)settings, (FlowHeaderConfig)headerConfig, (ActorSystem)system);
    }

    private String inId() {
        return this.inId;
    }

    private String outId() {
        return this.outId;
    }

    private String streamId() {
        return this.streamId;
    }

    private Logger bridgeLogger() {
        return this.bridgeLogger;
    }

    private JMSConsumerSettings srcSettings() {
        return this.srcSettings;
    }

    private Function1<JmsProducerSettings, JmsDestinationResolver> destResolver() {
        return this.destResolver;
    }

    private JmsProducerSettings toSettings() {
        return this.toSettings;
    }

    private Try<BridgeProviderConfig> internalProvider() {
        return this.internalProvider;
    }

    private Tuple2<String, String> internalId() {
        return this.internalId;
    }

    private Try<IdAwareConnectionFactory> internalCf() {
        return this.internalCf;
    }

    public Graph<FanOutShape2<FlowEnvelope, FlowEnvelope, FlowEnvelope>, NotUsed> trackFilter() {
        return this.trackFilter;
    }

    private Source<FlowEnvelope, NotUsed> stream() {
        return this.stream;
    }

    public StreamControllerConfig streamCfg() {
        return this.streamCfg;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$trackFilter$1(JmsStreamBuilder $this, FlowEnvelope env) {
        void var3_8;
        boolean bl;
        Enumeration.Value value = $this.cfg.trackTransaction();
        Enumeration.Value value2 = TrackTransaction$.MODULE$.Off();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = false;
        } else {
            Enumeration.Value value4 = TrackTransaction$.MODULE$.On();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = TrackTransaction$.MODULE$.FromMessage();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    $this.bridgeLogger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Getting tracking mode from message property [").append($this.cfg.headerCfg().headerTrack()).append("]").toString());
                    Option msgTrack = env.header($this.cfg.headerCfg().headerTrack(), (Manifest)ManifestFactory$.MODULE$.Boolean());
                    bl = BoxesRunTime.unboxToBoolean((Object)msgTrack.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        boolean doTrack = bl;
        $this.bridgeLogger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Tracking for envelope [").append(env.id()).append("] is [").append(doTrack).append("]").toString());
        return (boolean)var3_8;
    }

    public JmsStreamBuilder(JmsStreamConfig cfg, ActorSystem system, Materializer materializer) {
        Source source;
        Function1 & Serializable & scala.Serializable intersect;
        this.cfg = cfg;
        this.system = system;
        this.materializer = materializer;
        JmsStreamSupport.$init$((JmsStreamSupport)this);
        this.inId = new StringBuilder(2).append(cfg.fromCf().vendor()).append(":").append(cfg.fromCf().provider()).append(":").append(cfg.fromDest().asString()).toString();
        this.outId = new StringBuilder(2).append(cfg.toCf().vendor()).append(":").append(cfg.toCf().provider()).append(":").append(cfg.toDest().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "out")).toString();
        this.streamId = new StringBuilder(21).append(cfg.headerCfg().prefix()).append(".bridge.JmsStream(").append(this.inId()).append("->").append(this.outId()).append(")").toString();
        this.bridgeLogger = Logger$.MODULE$.apply(this.streamId());
        this.srcSettings = new JMSConsumerSettings(this.bridgeLogger(), cfg.fromCf(), JMSConsumerSettings$.MODULE$.apply$default$3(), JMSConsumerSettings$.MODULE$.apply$default$4(), JMSConsumerSettings$.MODULE$.apply$default$5(), JMSConsumerSettings$.MODULE$.apply$default$6(), JMSConsumerSettings$.MODULE$.apply$default$7(), JMSConsumerSettings$.MODULE$.apply$default$8(), JMSConsumerSettings$.MODULE$.apply$default$9(), JMSConsumerSettings$.MODULE$.apply$default$10(), JMSConsumerSettings$.MODULE$.apply$default$11()).withAcknowledgeMode(AcknowledgeMode$.MODULE$.ClientAcknowledge()).withDestination((Option)new Some((Object)cfg.fromDest())).withSessionCount(cfg.listener()).withSelector(cfg.selector()).withSubScriberName(cfg.subscriberName());
        Option<JmsDestination> option = cfg.toDest();
        if (option instanceof Some) {
            intersect = (Function1 & Serializable & scala.Serializable)s -> new SettingsDestinationResolver(s);
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable & scala.Serializable)s -> new MessageDestinationResolver($this.cfg.headerCfg(), s);
        } else {
            throw new MatchError(option);
        }
        this.destResolver = intersect;
        this.toSettings = new JmsProducerSettings(this.bridgeLogger(), cfg.toCf(), JmsProducerSettings$.MODULE$.apply$default$3(), JmsProducerSettings$.MODULE$.apply$default$4(), JmsProducerSettings$.MODULE$.apply$default$5(), JmsProducerSettings$.MODULE$.apply$default$6(), JmsProducerSettings$.MODULE$.apply$default$7(), JmsProducerSettings$.MODULE$.apply$default$8(), JmsProducerSettings$.MODULE$.apply$default$9(), JmsProducerSettings$.MODULE$.apply$default$10(), JmsProducerSettings$.MODULE$.apply$default$11()).withDestination(cfg.toDest()).withDestinationResolver(this.destResolver()).withDeliveryMode(JmsDeliveryMode$.MODULE$.Persistent());
        this.internalProvider = cfg.registry().internalProvider();
        this.internalId = new Tuple2((Object)((BridgeProviderConfig)this.internalProvider().get()).vendor(), (Object)((BridgeProviderConfig)this.internalProvider().get()).provider());
        this.internalCf = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            IdAwareConnectionFactory idAwareConnectionFactory;
            Tuple2 tuple2 = new Tuple2((Object)$this.cfg.fromCf().vendor(), (Object)$this.cfg.fromCf().provider());
            Tuple2<String, String> tuple22 = this.internalId();
            if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                idAwareConnectionFactory = $this.cfg.fromCf();
            } else {
                Tuple2 tuple23 = new Tuple2((Object)$this.cfg.toCf().vendor(), (Object)$this.cfg.toCf().provider());
                Tuple2<String, String> tuple24 = this.internalId();
                if (!(tuple23 != null ? !tuple23.equals(tuple24) : tuple24 != null)) {
                    idAwareConnectionFactory = $this.cfg.toCf();
                } else {
                    throw new InvalidBridgeConfigurationException("One leg of the JMS bridge must be internal");
                }
            }
            return idAwareConnectionFactory;
        });
        this.trackFilter = FlowProcessor$.MODULE$.partition((Function1 & Serializable & scala.Serializable)env -> BoxesRunTime.boxToBoolean((boolean)JmsStreamBuilder.$anonfun$trackFilter$1(this, env)));
        Graph g = GraphDSL$.MODULE$.create((Function1 & Serializable & scala.Serializable)b -> {
            FanOutShape2 trackSplit = (FanOutShape2)b.add(this.trackFilter());
            UniformFanInShape mergeResult = (UniformFanInShape)b.add((Graph)Merge$.MODULE$.apply(2, Merge$.MODULE$.apply$default$2()));
            Flow wiretap = new TransactionWiretap((IdAwareConnectionFactory)this.internalCf().get(), ((BridgeProviderConfig)this.internalProvider().get()).transactions(), $this.cfg.headerCfg(), $this.cfg.inbound(), this.streamId(), this.bridgeLogger(), $this.system, $this.materializer).flow();
            GraphDSL.Implicits$.MODULE$.port2flow(trackSplit.out0(), b).$tilde$greater((Graph)wiretap, b).$tilde$greater(mergeResult.in(0), b);
            GraphDSL.Implicits$.MODULE$.port2flow(trackSplit.out1(), b).$tilde$greater(mergeResult.in(1), b);
            return new FlowShape(trackSplit.in(), mergeResult.out());
        });
        Source src = Source$.MODULE$.fromGraph((Graph)new JmsAckSourceStage(new StringBuilder(7).append(this.streamId()).append("-source").toString(), this.srcSettings(), cfg.headerCfg(), system));
        if (cfg.inbound() && cfg.header().nonEmpty()) {
            this.bridgeLogger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Creating Stream with header configs [").append($this.cfg.header()).append("]").toString());
            Graph header = new HeaderTransformProcessor(new StringBuilder(7).append(this.streamId()).append("-header").toString(), this.bridgeLogger(), cfg.header(), cfg.idSvc()).flow(this.bridgeLogger());
            source = src.via(header);
        } else {
            this.bridgeLogger().info((Function0 & Serializable & scala.Serializable)() -> "Creating Stream without additional header configs");
            source = src;
        }
        Source jmsSource = source;
        this.stream = jmsSource.via((Graph)Flow$.MODULE$.fromGraph(g)).via(this.jmsProducer(new StringBuilder(5).append(this.streamId()).append("-sink").toString(), this.toSettings(), true, system, materializer));
        this.bridgeLogger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Starting bridge stream with config [inbound=").append($this.cfg.inbound()).append(",trackTransaction=").append($this.cfg.trackTransaction()).append("]").toString());
        StreamControllerConfig qual$1 = (StreamControllerConfig)StreamControllerConfig$.MODULE$.fromConfig(cfg.rawConfig()).get();
        String x$12 = this.streamId();
        Source<FlowEnvelope, NotUsed> x$2 = this.stream();
        FiniteDuration x$3 = qual$1.copy$default$3();
        FiniteDuration x$4 = qual$1.copy$default$4();
        boolean x$5 = qual$1.copy$default$5();
        boolean x$6 = qual$1.copy$default$6();
        double x$7 = qual$1.copy$default$7();
        this.streamCfg = qual$1.copy(x$12, x$2, x$3, x$4, x$5, x$6, x$7);
    }
}

