/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.bridge.internal;

import blended.container.context.api.ContainerIdentifierService;
import blended.jms.bridge.internal.InboundConfig;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsDestination$;
import blended.jms.utils.JmsDurableTopic;
import blended.jms.utils.JmsQueue;
import blended.jms.utils.JmsTopic;
import blended.streams.jms.JmsDeliveryMode;
import blended.streams.jms.JmsDeliveryMode$;
import blended.streams.processor.HeaderProcessorConfig;
import blended.streams.processor.HeaderProcessorConfig$;
import blended.util.config.Implicits$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple10;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class InboundConfig$
implements scala.Serializable {
    public static InboundConfig$ MODULE$;

    static {
        new InboundConfig$();
    }

    public Try<InboundConfig> create(ContainerIdentifierService idSvc, Config cfg) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            JmsQueue jmsQueue;
            String name = InboundConfig$.resolve$1(cfg.getString("name"), idSvc);
            String vendor = InboundConfig$.resolve$1(cfg.getString("vendor"), idSvc);
            Option provider = Implicits$.MODULE$.RichOptionConfig(cfg).getStringOption("provider").map((Function1 & Serializable & scala.Serializable)value -> InboundConfig$.resolve$1(value, idSvc));
            JmsDestination jmsDestination = (JmsDestination)JmsDestination$.MODULE$.create(InboundConfig$.resolve$1(cfg.getString("from"), idSvc)).get();
            if (jmsDestination instanceof JmsQueue) {
                JmsQueue jmsQueue2;
                jmsQueue = jmsQueue2 = (JmsQueue)jmsDestination;
            } else if (jmsDestination instanceof JmsTopic) {
                JmsTopic jmsTopic;
                JmsTopic jmsTopic2 = (JmsTopic)jmsDestination;
                Option option = Implicits$.MODULE$.RichOptionConfig(cfg).getStringOption("subscriberName");
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String sn = (String)some.value();
                    jmsTopic = new JmsDurableTopic(jmsTopic2.name(), sn);
                } else if (None$.MODULE$.equals(option)) {
                    jmsTopic = jmsTopic2;
                } else {
                    throw new MatchError((Object)option);
                }
                jmsQueue = jmsTopic;
            } else if (jmsDestination instanceof JmsDurableTopic) {
                JmsDurableTopic jmsDurableTopic = (JmsDurableTopic)jmsDestination;
                jmsQueue = jmsDurableTopic;
            } else {
                throw new MatchError((Object)jmsDestination);
            }
            JmsQueue inDest = jmsQueue;
            Option selector = Implicits$.MODULE$.RichOptionConfig(cfg).getStringOption("selector");
            JmsDeliveryMode persistent = (JmsDeliveryMode)JmsDeliveryMode$.MODULE$.create(Implicits$.MODULE$.RichDefaultConfig(cfg).getString("persistent", JmsDeliveryMode$.MODULE$.Persistent().asString())).get();
            Option subscriberName = Implicits$.MODULE$.RichOptionConfig(cfg).getStringOption("subscriberName");
            int listener = Implicits$.MODULE$.RichDefaultConfig(cfg).getInt("listener", 2);
            List header = (List)Implicits$.MODULE$.RichDefaultConfig(cfg).getConfigList("header", List$.MODULE$.empty()).map((Function1 & Serializable & scala.Serializable)cfg -> HeaderProcessorConfig$.MODULE$.create(cfg), List$.MODULE$.canBuildFrom());
            FiniteDuration sessionRecreateTimeout = Implicits$.MODULE$.RichDefaultConfig(cfg).getDuration("sessionRecreateTimeout", new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
            return new InboundConfig(name, vendor, (Option<String>)provider, (JmsDestination)inDest, (Option<String>)selector, persistent, (Option<String>)subscriberName, listener, (List<HeaderProcessorConfig>)header, sessionRecreateTimeout);
        });
    }

    public InboundConfig apply(String name, String vendor, Option<String> provider, JmsDestination from, Option<String> selector, JmsDeliveryMode persistent, Option<String> subscriberName, int listener, List<HeaderProcessorConfig> header, FiniteDuration sessionRecreateTimeout) {
        return new InboundConfig(name, vendor, provider, from, selector, persistent, subscriberName, listener, header, sessionRecreateTimeout);
    }

    public Option<Tuple10<String, String, Option<String>, JmsDestination, Option<String>, JmsDeliveryMode, Option<String>, Object, List<HeaderProcessorConfig>, FiniteDuration>> unapply(InboundConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)x$0.name(), (Object)x$0.vendor(), x$0.provider(), (Object)x$0.from(), x$0.selector(), (Object)x$0.persistent(), x$0.subscriberName(), (Object)BoxesRunTime.boxToInteger((int)x$0.listener()), x$0.header(), (Object)x$0.sessionRecreateTimeout()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final String resolve$1(String value, ContainerIdentifierService idSvc$1) {
        return (String)idSvc$1.resolvePropertyString(value).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).get();
    }

    private InboundConfig$() {
        MODULE$ = this;
    }
}

