/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.bridge.internal;

import akka.NotUsed;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow$;
import blended.jms.bridge.internal.JmsRetryConfig;
import blended.jms.bridge.internal.MissingHeaderException;
import blended.jms.bridge.internal.MissingRetryDestinationException;
import blended.jms.bridge.internal.RetryCountExceededException;
import blended.jms.bridge.internal.RetryTimeoutException;
import blended.streams.FlowProcessor$;
import blended.streams.message.FlowEnvelope;
import blended.streams.transaction.FlowHeaderConfig;
import blended.util.logging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001-4A\u0001D\u0007\u0001-!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!q\u0003A!A!\u0002\u0013y\u0003\"B\u001c\u0001\t\u0003A\u0004BB\u001f\u0001A\u0003%a\bC\u0004G\u0001\t\u0007I\u0011A$\t\rA\u0003\u0001\u0015!\u0003I\u0011\u001d\t\u0006A1A\u0005\u0002\u001dCaA\u0015\u0001!\u0002\u0013A\u0005bB*\u0001\u0005\u0004%\t\u0001\u0016\u0005\u0007U\u0002\u0001\u000b\u0011B+\u0003\u001d)k7OU3uef\u0014v.\u001e;fe*\u0011abD\u0001\tS:$XM\u001d8bY*\u0011\u0001#E\u0001\u0007EJLGmZ3\u000b\u0005I\u0019\u0012a\u00016ng*\tA#A\u0004cY\u0016tG-\u001a3\u0004\u0001M\u0011\u0001a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\t9\fW.\u001a\t\u0003?\u0019r!\u0001\t\u0013\u0011\u0005\u0005JR\"\u0001\u0012\u000b\u0005\r*\u0012A\u0002\u001fs_>$h(\u0003\u0002&3\u00051\u0001K]3eK\u001aL!a\n\u0015\u0003\rM#(/\u001b8h\u0015\t)\u0013$\u0001\u0005sKR\u0014\u0018p\u00114h!\tYC&D\u0001\u000e\u0013\tiSB\u0001\bK[N\u0014V\r\u001e:z\u0007>tg-[4\u0002\u00071|w\r\u0005\u00021k5\t\u0011G\u0003\u00023g\u00059An\\4hS:<'B\u0001\u001b\u0014\u0003\u0011)H/\u001b7\n\u0005Y\n$A\u0002'pO\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0005siZD\b\u0005\u0002,\u0001!)Q\u0004\u0002a\u0001=!)\u0011\u0006\u0002a\u0001U!)a\u0006\u0002a\u0001_\u0005I\u0001.Z1eKJ\u001cem\u001a\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b1\u0002\u001e:b]N\f7\r^5p]*\u00111iE\u0001\bgR\u0014X-Y7t\u0013\t)\u0005I\u0001\tGY><\b*Z1eKJ\u001cuN\u001c4jO\u00061\u0001.Z1eKJ,\u0012\u0001\u0013\t\u0003\u00136s!AS&\u000e\u0003\tK!\u0001\u0014\"\u0002\u001b\u0019cwn\u001e)s_\u000e,7o]8s\u0013\tquJA\bJ]R,wM]1uS>t7\u000b^3q\u0015\ta%)A\u0004iK\u0006$WM\u001d\u0011\u0002\u0011Y\fG.\u001b3bi\u0016\f\u0011B^1mS\u0012\fG/\u001a\u0011\u0002\t\u0019dwn^\u000b\u0002+B!akW/g\u001b\u00059&B\u0001-Z\u0003\u0019\u0019HO]3b[*\t!,\u0001\u0003bW.\f\u0017B\u0001/X\u0005\u00159%/\u00199i!\u00111f\f\u00191\n\u0005};&!\u0003$m_^\u001c\u0006.\u00199f!\t\tG-D\u0001c\u0015\t\u0019')A\u0004nKN\u001c\u0018mZ3\n\u0005\u0015\u0014'\u0001\u0004$m_^,eN^3m_B,\u0007CA4i\u001b\u0005I\u0016BA5Z\u0005\u001dqu\u000e^+tK\u0012\fQA\u001a7po\u0002\u0002")
public class JmsRetryRouter {
    private final JmsRetryConfig retryCfg;
    private final Logger log;
    private final FlowHeaderConfig headerCfg;
    private final Function1<FlowEnvelope, Try<FlowEnvelope>> header;
    private final Function1<FlowEnvelope, Try<FlowEnvelope>> validate;
    private final Graph<FlowShape<FlowEnvelope, FlowEnvelope>, NotUsed> flow;

    public Function1<FlowEnvelope, Try<FlowEnvelope>> header() {
        return this.header;
    }

    public Function1<FlowEnvelope, Try<FlowEnvelope>> validate() {
        return this.validate;
    }

    public Graph<FlowShape<FlowEnvelope, FlowEnvelope>, NotUsed> flow() {
        return this.flow;
    }

    public static final /* synthetic */ long $anonfun$validate$3(FlowEnvelope env$2, String h) {
        long l;
        Option option = env$2.header(h, (Manifest)ManifestFactory$.MODULE$.Long());
        if (None$.MODULE$.equals(option)) {
            throw new MissingHeaderException(h);
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        long l2 = l = BoxesRunTime.unboxToLong((Object)some.value());
        return l2;
    }

    public JmsRetryRouter(String name, JmsRetryConfig retryCfg, Logger log) {
        this.retryCfg = retryCfg;
        this.log = log;
        this.headerCfg = retryCfg.headerCfg();
        this.header = (Function1 & Serializable & scala.Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            long maxRetries = BoxesRunTime.unboxToLong((Object)env.header($this.headerCfg.headerMaxRetries(), (Manifest)ManifestFactory$.MODULE$.Long()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.retryCfg.maxRetries()));
            long retryCount = BoxesRunTime.unboxToLong((Object)env.header($this.headerCfg.headerRetryCount(), (Manifest)ManifestFactory$.MODULE$.Long()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) + 1L;
            long retryTimeout = BoxesRunTime.unboxToLong((Object)env.header($this.headerCfg.headerRetryTimeout(), (Manifest)ManifestFactory$.MODULE$.Long()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.retryCfg.retryTimeout().toMillis()));
            long firstRetry = BoxesRunTime.unboxToLong((Object)env.header($this.headerCfg.headerFirstRetry(), (Manifest)ManifestFactory$.MODULE$.Long()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.currentTimeMillis()));
            FlowEnvelope qual$1 = (FlowEnvelope)env.withHeader($this.headerCfg.headerMaxRetries(), (Object)BoxesRunTime.boxToLong((long)maxRetries), env.withHeader$default$3()).get();
            String x$1 = $this.headerCfg.headerRetryCount();
            long x$2 = retryCount;
            boolean x$3 = qual$1.withHeader$default$3();
            FlowEnvelope qual$2 = (FlowEnvelope)qual$1.withHeader(x$1, (Object)BoxesRunTime.boxToLong((long)x$2), x$3).get();
            String x$4 = $this.headerCfg.headerRetryTimeout();
            long x$5 = retryTimeout;
            boolean x$6 = qual$2.withHeader$default$3();
            FlowEnvelope qual$3 = (FlowEnvelope)qual$2.withHeader(x$4, (Object)BoxesRunTime.boxToLong((long)x$5), x$6).get();
            String x$7 = $this.headerCfg.headerFirstRetry();
            long x$8 = firstRetry;
            boolean x$9 = qual$3.withHeader$default$3();
            return (FlowEnvelope)qual$3.withHeader(x$7, (Object)BoxesRunTime.boxToLong((long)x$8), x$9).get();
        });
        this.validate = (Function1 & Serializable & scala.Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable mandatoryHeader = (Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToLong((long)JmsRetryRouter.$anonfun$validate$3(env, h));
            long maxRetries = BoxesRunTime.unboxToLong((Object)mandatoryHeader.apply((Object)$this.headerCfg.headerMaxRetries()));
            long retryCount = BoxesRunTime.unboxToLong((Object)mandatoryHeader.apply((Object)$this.headerCfg.headerRetryCount()));
            long retryTimeout = BoxesRunTime.unboxToLong((Object)mandatoryHeader.apply((Object)$this.headerCfg.headerRetryTimeout()));
            long firstRetry = BoxesRunTime.unboxToLong((Object)mandatoryHeader.apply((Object)$this.headerCfg.headerFirstRetry()));
            FiniteDuration remaining = new package.DurationLong(package$.MODULE$.DurationLong(retryTimeout - (System.currentTimeMillis() - firstRetry))).millis();
            $this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Retrying envelope [").append(env.id()).append("] : [").append(retryCount).append(" / ").append(maxRetries).append("] [").append(remaining).append("] remaining").toString());
            if (maxRetries > 0L && retryCount > maxRetries) {
                throw new RetryCountExceededException(maxRetries);
            }
            if (System.currentTimeMillis() - firstRetry > retryTimeout) {
                throw new RetryTimeoutException(firstRetry + retryTimeout);
            }
            if (env.header($this.headerCfg.headerRetryDestination(), ManifestFactory$.MODULE$.classType(String.class)).isEmpty()) {
                throw new MissingRetryDestinationException($this.headerCfg.headerRetryDestination());
            }
            return env;
        });
        this.flow = Flow$.MODULE$.fromGraph(FlowProcessor$.MODULE$.fromFunction(new StringBuilder(7).append(name).append(".header").toString(), log, this.header())).via(FlowProcessor$.MODULE$.fromFunction(new StringBuilder(9).append(name).append(".validate").toString(), log, this.validate()));
    }
}

