/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.bridge.internal;

import akka.NotUsed;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.stream.FanOutShape2;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.KillSwitch;
import akka.stream.Materializer;
import akka.stream.UniformFanInShape;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Merge$;
import akka.stream.scaladsl.Source;
import blended.jms.bridge.internal.JmsRetryConfig;
import blended.jms.bridge.internal.JmsRetryRouter;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsDestination$;
import blended.streams.FlowProcessor$;
import blended.streams.StreamController$;
import blended.streams.StreamControllerConfig;
import blended.streams.jms.AcknowledgeMode;
import blended.streams.jms.AcknowledgeMode$;
import blended.streams.jms.FlowHeaderConfigAware;
import blended.streams.jms.JMSConsumerSettings;
import blended.streams.jms.JMSConsumerSettings$;
import blended.streams.jms.JmsDeliveryMode;
import blended.streams.jms.JmsDeliveryMode$;
import blended.streams.jms.JmsDestinationResolver;
import blended.streams.jms.JmsEnvelopeHeader;
import blended.streams.jms.JmsProducerSettings;
import blended.streams.jms.JmsProducerSettings$;
import blended.streams.jms.JmsSendParameter;
import blended.streams.jms.JmsStreamSupport;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowMessage;
import blended.streams.processor.AckProcessor;
import blended.streams.processor.Collector;
import blended.streams.transaction.FlowHeaderConfig;
import blended.streams.transaction.TransactionWiretap;
import blended.util.logging.LogLevel$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Session;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001B\u0001B\u0003-a\t\u0003\u0005O\u0001\t\u0005\t\u0015a\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0019i\u0006\u0001)A\u0005k!1a\f\u0001Q\u0001\n}Caa\u001a\u0001!\u0002\u0013y\u0006BB%\u0001A\u0003&\u0001\u000e\u0003\u0004o\u0001\u0001\u0006Ia\u001c\u0004\u0005e\u0002\u00011\u000f\u0003\u0005{\u0017\t\u0015\r\u0011\"\u0011|\u0011%\t)a\u0003B\u0001B\u0003%A\u0010\u0003\u0006\u0002\b-\u0011)\u0019!C!\u0003\u0013A!\"!\u0005\f\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011)\t\u0019b\u0003BC\u0002\u0013\u0005\u0011Q\u0003\u0005\u000b\u0003OY!\u0011!Q\u0001\n\u0005]\u0001BB+\f\t\u0003\tI\u0003C\u0004\u00026-!\t%a\u000e\t\u000f\u0005-\u0004\u0001\"\u0005\u0002n!9\u00111\u0011\u0001\u0005\u0012\u0005\u0015\u0005bBAG\u0001\u0011E\u0011Q\u0011\u0005\b\u0003\u001f\u0003A\u0011CAC\u0011\u001d\t\t\n\u0001C\t\u0003\u000bCq!a%\u0001\t#\t)\nC\u0004\u0002$\u0002!\t!!*\t\u000f\u00055\u0006\u0001\"\u0001\u0002&\n\t\"*\\:SKR\u0014\u0018\u0010\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005yy\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u0001\n\u0013A\u00022sS\u0012<WM\u0003\u0002#G\u0005\u0019!.\\:\u000b\u0003\u0011\nqA\u00197f]\u0012,Gm\u0001\u0001\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]Ij\u0011a\f\u0006\u0003EAR!!M\u0012\u0002\u000fM$(/Z1ng&\u00111g\f\u0002\u0011\u00156\u001c8\u000b\u001e:fC6\u001cV\u000f\u001d9peR\fAA\\1nKB\u0011a'\u0010\b\u0003om\u0002\"\u0001O\u0015\u000e\u0003eR!AO\u0013\u0002\rq\u0012xn\u001c;?\u0013\ta\u0014&\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f*\u0003!\u0011X\r\u001e:z\u0007\u001a<\u0007C\u0001\"D\u001b\u0005i\u0012B\u0001#\u001e\u00059QUn\u001d*fiJL8i\u001c8gS\u001e\faa]=ti\u0016l\u0007CA$M\u001b\u0005A%BA%K\u0003\u0015\t7\r^8s\u0015\u0005Y\u0015\u0001B1lW\u0006L!!\u0014%\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\r[\u0006$XM]5bY&TXM\u001d\t\u0003!Nk\u0011!\u0015\u0006\u0003%*\u000baa\u001d;sK\u0006l\u0017B\u0001+R\u00051i\u0015\r^3sS\u0006d\u0017N_3s\u0003\u0019a\u0014N\\5u}Q\u0019qk\u0017/\u0015\u0007aK&\f\u0005\u0002C\u0001!)Q)\u0002a\u0002\r\")a*\u0002a\u0002\u001f\")A'\u0002a\u0001k!)\u0001)\u0002a\u0001\u0003\u0006\u0011\u0011\u000eZ\u0001\te\u0016$(/\u001f'pOB\u0011\u0001-Z\u0007\u0002C*\u0011!mY\u0001\bY><w-\u001b8h\u0015\t!7%\u0001\u0003vi&d\u0017B\u00014b\u0005\u0019aunZ4fe\u0006\u0019An\\4\u0011\u0007!J7.\u0003\u0002kS\t1q\n\u001d;j_:\u0004\"a\u00127\n\u00055D%\u0001C!di>\u0014(+\u001a4\u0002\rI|W\u000f^3s!\t\u0011\u0005/\u0003\u0002r;\tq!*\\:SKR\u0014\u0018PU8vi\u0016\u0014(\u0001\u0007*fiJLH)Z:uS:\fG/[8o%\u0016\u001cx\u000e\u001c<feN!1b\n;x!\tqS/\u0003\u0002w_\t)b\t\\8x\u0011\u0016\fG-\u001a:D_:4\u0017nZ!xCJ,\u0007C\u0001\u0018y\u0013\tIxFA\tK[N,eN^3m_B,\u0007*Z1eKJ\fA\u0002[3bI\u0016\u00148i\u001c8gS\u001e,\u0012\u0001 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}\u0004\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:L1!a\u0001\u007f\u0005A1En\\<IK\u0006$WM]\"p]\u001aLw-A\u0007iK\u0006$WM]\"p]\u001aLw\rI\u0001\tg\u0016$H/\u001b8hgV\u0011\u00111\u0002\t\u0004]\u00055\u0011bAA\b_\t\u0019\"*\\:Qe>$WoY3s'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\nm\u0006d\u0017\u000eZ1u_J,\"!a\u0006\u0011\t\u0005e\u0011\u0011\u0005\b\u0005\u00037\ti\"D\u00011\u0013\r\ty\u0002M\u0001\u000e\r2|w\u000f\u0015:pG\u0016\u001c8o\u001c:\n\t\u0005\r\u0012Q\u0005\u0002\u0010\u0013:$Xm\u001a:bi&|gn\u0015;fa*\u0019\u0011q\u0004\u0019\u0002\u0015Y\fG.\u001b3bi>\u0014\b\u0005\u0006\u0005\u0002,\u0005=\u0012\u0011GA\u001a!\r\ticC\u0007\u0002\u0001!)!P\u0005a\u0001y\"9\u0011q\u0001\nA\u0002\u0005-\u0001bBA\n%\u0001\u0007\u0011qC\u0001\u000eg\u0016tG\rU1sC6,G/\u001a:\u0015\r\u0005e\u0012\u0011JA.!\u0019\tY$a\u0010\u0002D5\u0011\u0011Q\b\u0006\u0003I&JA!!\u0011\u0002>\t\u0019AK]=\u0011\u00079\n)%C\u0002\u0002H=\u0012\u0001CS7t'\u0016tG\rU1sC6,G/\u001a:\t\u000f\u0005-3\u00031\u0001\u0002N\u000591/Z:tS>t\u0007\u0003BA(\u0003/j!!!\u0015\u000b\u0007\t\n\u0019F\u0003\u0002\u0002V\u0005)!.\u0019<bq&!\u0011\u0011LA)\u0005\u001d\u0019Vm]:j_:Dq!!\u0018\u0014\u0001\u0004\ty&A\u0002f]Z\u0004B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K\u0002\u0014aB7fgN\fw-Z\u0005\u0005\u0003S\n\u0019G\u0001\u0007GY><XI\u001c<fY>\u0004X-A\u0006sKR\u0014\u0018pU8ve\u000e,WCAA8!!\t\t(a\u001e\u0002`\u0005mTBAA:\u0015\r\t)(U\u0001\tg\u000e\fG.\u00193tY&!\u0011\u0011PA:\u0005\u0019\u0019v.\u001e:dKB!\u0011QPA@\u001b\u0005Q\u0015bAAA\u0015\n9aj\u001c;Vg\u0016$\u0017!\u0004:fg\u0016tG-T3tg\u0006<W-\u0006\u0002\u0002\bBQ\u0011\u0011OAE\u0003?\ny&a\u001f\n\t\u0005-\u00151\u000f\u0002\u0005\r2|w/A\btK:$GK]1og\u0006\u001cG/[8o\u00039\u0019XM\u001c3U_>\u0013\u0018nZ5oC2\f1b]3oIR{'+\u001a;ss\u0006Q!/\u001a;ss\u001e\u0013\u0018\r\u001d5\u0016\u0005\u0005]\u0005c\u0002)\u0002\u001a\u0006u\u00151P\u0005\u0004\u00037\u000b&!B$sCBD\u0007c\u0002)\u0002 \u0006}\u0013qL\u0005\u0004\u0003C\u000b&!\u0003$m_^\u001c\u0006.\u00199f\u0003\u0015\u0019H/\u0019:u)\t\t9\u000bE\u0002)\u0003SK1!a+*\u0005\u0011)f.\u001b;\u0002\tM$x\u000e\u001d")
public class JmsRetryProcessor
implements JmsStreamSupport {
    private final String name;
    public final JmsRetryConfig blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg;
    private final ActorSystem system;
    private final Materializer materializer;
    private final String id;
    private final Logger retryLog;
    private final Logger log;
    private Option<ActorRef> actor;
    private final JmsRetryRouter router;

    public Try<KillSwitch> processMessages(Flow<FlowEnvelope, FlowEnvelope, ?> processFlow, Seq<FlowEnvelope> msgs, ActorSystem system) {
        return JmsStreamSupport.processMessages$((JmsStreamSupport)this, processFlow, msgs, (ActorSystem)system);
    }

    public Try<KillSwitch> sendMessages(JmsProducerSettings producerSettings, Logger log, Seq<FlowEnvelope> msgs, ActorSystem system, Materializer materializer, ExecutionContext ectxt) {
        return JmsStreamSupport.sendMessages$((JmsStreamSupport)this, (JmsProducerSettings)producerSettings, (Logger)log, msgs, (ActorSystem)system, (Materializer)materializer, (ExecutionContext)ectxt);
    }

    public Collector<FlowEnvelope> receiveMessages(FlowHeaderConfig headerCfg, IdAwareConnectionFactory cf, JmsDestination dest, Logger log, Integer listener, Option<FiniteDuration> minMessageDelay, Option<String> selector, FiniteDuration timeout, ActorSystem system, Materializer materializer) {
        return JmsStreamSupport.receiveMessages$((JmsStreamSupport)this, (FlowHeaderConfig)headerCfg, (IdAwareConnectionFactory)cf, (JmsDestination)dest, (Logger)log, (Integer)listener, minMessageDelay, selector, (FiniteDuration)timeout, (ActorSystem)system, (Materializer)materializer);
    }

    public Integer receiveMessages$default$5() {
        return JmsStreamSupport.receiveMessages$default$5$((JmsStreamSupport)this);
    }

    public Option<FiniteDuration> receiveMessages$default$6() {
        return JmsStreamSupport.receiveMessages$default$6$((JmsStreamSupport)this);
    }

    public Option<String> receiveMessages$default$7() {
        return JmsStreamSupport.receiveMessages$default$7$((JmsStreamSupport)this);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> jmsProducer(String name, JmsProducerSettings settings, boolean autoAck, ActorSystem system, Materializer materializer) {
        return JmsStreamSupport.jmsProducer$((JmsStreamSupport)this, (String)name, (JmsProducerSettings)settings, (boolean)autoAck, (ActorSystem)system, (Materializer)materializer);
    }

    public boolean jmsProducer$default$3() {
        return JmsStreamSupport.jmsProducer$default$3$((JmsStreamSupport)this);
    }

    public Source<FlowEnvelope, NotUsed> jmsConsumer(String name, JMSConsumerSettings settings, Option<FiniteDuration> minMessageDelay, ActorSystem system) {
        return JmsStreamSupport.jmsConsumer$((JmsStreamSupport)this, (String)name, (JMSConsumerSettings)settings, minMessageDelay, (ActorSystem)system);
    }

    public Source<FlowEnvelope, NotUsed> retrySource() {
        Logger x$1 = this.retryLog;
        FlowHeaderConfig x$2 = this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.headerCfg();
        IdAwareConnectionFactory x$3 = this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.cf();
        AcknowledgeMode x$4 = AcknowledgeMode$.MODULE$.ClientAcknowledge();
        Some x$5 = new Some(JmsDestination$.MODULE$.create(this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.retryDestName()).get());
        FiniteDuration x$6 = JMSConsumerSettings$.MODULE$.apply$default$4();
        int x$7 = JMSConsumerSettings$.MODULE$.apply$default$6();
        FiniteDuration x$8 = JMSConsumerSettings$.MODULE$.apply$default$7();
        FiniteDuration x$9 = JMSConsumerSettings$.MODULE$.apply$default$8();
        int x$10 = JMSConsumerSettings$.MODULE$.apply$default$10();
        Option x$11 = JMSConsumerSettings$.MODULE$.apply$default$11();
        FiniteDuration x$12 = JMSConsumerSettings$.MODULE$.apply$default$12();
        Option x$13 = JMSConsumerSettings$.MODULE$.apply$default$13();
        FiniteDuration x$14 = JMSConsumerSettings$.MODULE$.apply$default$14();
        JMSConsumerSettings settings = new JMSConsumerSettings(x$1, x$2, x$3, x$6, (Option)x$5, x$7, x$8, x$9, x$4, x$10, x$11, x$12, x$13, x$14);
        return this.jmsConsumer(((JmsDestination)settings.jmsDestination().get()).asString(), settings, (Option<FiniteDuration>)new Some((Object)this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.retryInterval()), this.system);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> resendMessage() {
        Logger x$1 = this.retryLog;
        FlowHeaderConfig x$2 = this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.headerCfg();
        IdAwareConnectionFactory x$3 = this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.cf();
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)s -> new RetryDestinationResolver(this, $this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.headerCfg(), (JmsProducerSettings)s, $this.router.validate());
        JmsDeliveryMode x$5 = JmsDeliveryMode$.MODULE$.Persistent();
        None$ x$6 = None$.MODULE$;
        boolean x$7 = true;
        FiniteDuration x$8 = JmsProducerSettings$.MODULE$.apply$default$4();
        Option x$9 = JmsProducerSettings$.MODULE$.apply$default$5();
        int x$10 = JmsProducerSettings$.MODULE$.apply$default$6();
        int x$11 = JmsProducerSettings$.MODULE$.apply$default$8();
        Function0 x$12 = JmsProducerSettings$.MODULE$.apply$default$11();
        FiniteDuration x$13 = JmsProducerSettings$.MODULE$.apply$default$12();
        JmsProducerSettings producerSettings = new JmsProducerSettings(x$1, x$2, x$3, x$8, x$9, x$10, (Function1)x$4, x$11, x$5, (Option)x$6, x$12, x$13, x$7);
        return this.jmsProducer(new StringBuilder(9).append(this.name).append("routeSend").toString(), producerSettings, false, this.system, this.materializer);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> sendTransaction() {
        TransactionWiretap wiretap = new TransactionWiretap(this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.cf(), (JmsDestination)JmsDestination$.MODULE$.create(this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.eventDestName()).get(), this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.headerCfg(), false, this.id, this.retryLog, this.system, this.materializer);
        return Flow$.MODULE$.fromGraph(FlowProcessor$.MODULE$.fromFunction(this.name, this.retryLog, this.router.validate())).via(FlowProcessor$.MODULE$.log(LogLevel$.MODULE$.Debug(), this.retryLog, "Creating transaction failed event")).via((Graph)wiretap.flow());
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> sendToOriginal() {
        return this.resendMessage();
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> sendToRetry() {
        return this.resendMessage();
    }

    public Graph<FlowShape<FlowEnvelope, FlowEnvelope>, NotUsed> retryGraph() {
        return GraphDSL$.MODULE$.create((Function1 & Serializable & scala.Serializable)b -> {
            FlowShape route = (FlowShape)b.add($this.router.flow());
            FlowShape routeSend = (FlowShape)b.add(this.sendToOriginal());
            GraphDSL.Implicits$.MODULE$.port2flow(route.out(), b).$tilde$greater(routeSend.in(), b);
            FanOutShape2 routeErrorSplit = (FanOutShape2)b.add(FlowProcessor$.MODULE$.partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JmsRetryProcessor.$anonfun$retryGraph$2(x$1))));
            GraphDSL.Implicits$.MODULE$.port2flow(routeSend.out(), b).$tilde$greater(routeErrorSplit.in(), b);
            UniformFanInShape merge = (UniformFanInShape)b.add((Graph)Merge$.MODULE$.apply(2, Merge$.MODULE$.apply$default$2()));
            GraphDSL.Implicits$.MODULE$.port2flow(routeErrorSplit.out0(), b).$tilde$greater(merge.in(0), b);
            FlowShape retrySend = (FlowShape)b.add(this.sendToRetry());
            GraphDSL.Implicits$.MODULE$.port2flow(routeErrorSplit.out1(), b).$tilde$greater(retrySend, b).$tilde$greater(merge.in(1), b);
            FanOutShape2 transSplit = (FanOutShape2)b.add(FlowProcessor$.MODULE$.partition((Function1 & Serializable & scala.Serializable)env -> BoxesRunTime.boxToBoolean((boolean)JmsRetryProcessor.$anonfun$retryGraph$3(this, env))));
            UniformFanInShape transMerge = (UniformFanInShape)b.add((Graph)Merge$.MODULE$.apply(2, Merge$.MODULE$.apply$default$2()));
            GraphDSL.Implicits$.MODULE$.port2flow(merge.out(), b).$tilde$greater(transSplit.in(), b);
            GraphDSL.Implicits$.MODULE$.port2flow(transSplit.out0(), b).$tilde$greater(this.sendTransaction(), b).$tilde$greater(transMerge.in(0), b);
            GraphDSL.Implicits$.MODULE$.port2flow(transSplit.out1(), b).$tilde$greater(transMerge.in(1), b);
            FlowShape ack = (FlowShape)b.add((Graph)Flow$.MODULE$.fromGraph(FlowProcessor$.MODULE$.log(LogLevel$.MODULE$.Debug(), $this.retryLog, "Before Acknowledge")).via((Graph)new AckProcessor(new StringBuilder(4).append($this.name).append(".ack").toString()).flow()));
            GraphDSL.Implicits$.MODULE$.port2flow(transMerge.out(), b).$tilde$greater(ack.in(), b);
            return new FlowShape(route.in(), ack.out());
        });
    }

    public void start() {
        Option<ActorRef> option = this.actor;
        synchronized (option) {
            if (this.actor.isEmpty()) {
                this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Starting Jms Retry processor [").append($this.name).append("] with [").append($this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg).append("]").toString());
                StreamControllerConfig streamCfg = new StreamControllerConfig(this.name, new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds(), new package.DurationInt(package$.MODULE$.DurationInt(3)).minutes(), true, true, 0.2);
                this.actor = new Some((Object)this.system.actorOf(StreamController$.MODULE$.props(this.retrySource().via(this.retryGraph()), streamCfg, this.system, this.materializer)));
            }
        }
    }

    public void stop() {
        Option<ActorRef> option = this.actor;
        synchronized (option) {
            this.actor.foreach((Function1 & Serializable & scala.Serializable)actor -> {
                this.system.stop(actor);
                return BoxedUnit.UNIT;
            });
            this.actor = None$.MODULE$;
        }
    }

    public static final /* synthetic */ boolean $anonfun$retryGraph$2(FlowEnvelope x$1) {
        return x$1.exception().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$retryGraph$3(JmsRetryProcessor $this, FlowEnvelope env) {
        return env.exception().isEmpty() && ((Try)$this.router.validate().apply((Object)env)).isFailure();
    }

    public JmsRetryProcessor(String name, JmsRetryConfig retryCfg, ActorSystem system, Materializer materializer) {
        this.name = name;
        this.blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg = retryCfg;
        this.system = system;
        this.materializer = materializer;
        JmsStreamSupport.$init$((JmsStreamSupport)this);
        this.id = new StringBuilder(7).append(retryCfg.headerCfg().prefix()).append(".retry.").append(retryCfg.retryDestName()).toString();
        this.retryLog = Logger$.MODULE$.apply(this.id);
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(JmsRetryProcessor.class));
        this.actor = None$.MODULE$;
        this.router = new JmsRetryRouter("route", retryCfg, this.retryLog);
    }

    public class RetryDestinationResolver
    implements FlowHeaderConfigAware,
    JmsEnvelopeHeader {
        private final FlowHeaderConfig headerConfig;
        private final JmsProducerSettings settings;
        private final Function1<FlowEnvelope, Try<FlowEnvelope>> validator;
        private final Function1<String, String> jmsHeaderPrefix;
        private final Function1<String, String> srcVendorHeader;
        private final Function1<String, String> srcProviderHeader;
        private final Function1<String, String> srcDestHeader;
        private final Function1<String, String> destHeader;
        private final Function1<String, String> corrIdHeader;
        private final Function1<String, String> priorityHeader;
        private final Function1<String, String> expireHeader;
        private final Function1<String, String> deliveryModeHeader;
        private final Function1<String, String> replyToHeader;
        private final Function1<String, String> timestampHeader;
        private final Function1<String, String> typeHeader;
        private final Function1<String, String> msgIdHeader;
        private final String replyToQueueName;
        private final Logger log;
        private final Function1<FlowMessage, Try<JmsDestination>> destination;
        private final Function1<FlowMessage, Object> priority;
        private final Function1<FlowMessage, Option<FiniteDuration>> timeToLive;
        private final Function1<FlowMessage, JmsDeliveryMode> deliveryMode;
        public final /* synthetic */ JmsRetryProcessor $outer;

        public Option<String> correlationId(FlowEnvelope env) {
            return FlowHeaderConfigAware.correlationId$((FlowHeaderConfigAware)this, (FlowEnvelope)env);
        }

        public Try<Option<Destination>> replyTo(Session session, FlowEnvelope env) {
            return FlowHeaderConfigAware.replyTo$((FlowHeaderConfigAware)this, (Session)session, (FlowEnvelope)env);
        }

        public Try<Message> createJmsMessage(Session session, FlowEnvelope env) {
            return JmsDestinationResolver.createJmsMessage$((JmsDestinationResolver)this, (Session)session, (FlowEnvelope)env);
        }

        public Function1<String, String> jmsHeaderPrefix() {
            return this.jmsHeaderPrefix;
        }

        public Function1<String, String> srcVendorHeader() {
            return this.srcVendorHeader;
        }

        public Function1<String, String> srcProviderHeader() {
            return this.srcProviderHeader;
        }

        public Function1<String, String> srcDestHeader() {
            return this.srcDestHeader;
        }

        public Function1<String, String> destHeader() {
            return this.destHeader;
        }

        public Function1<String, String> corrIdHeader() {
            return this.corrIdHeader;
        }

        public Function1<String, String> priorityHeader() {
            return this.priorityHeader;
        }

        public Function1<String, String> expireHeader() {
            return this.expireHeader;
        }

        public Function1<String, String> deliveryModeHeader() {
            return this.deliveryModeHeader;
        }

        public Function1<String, String> replyToHeader() {
            return this.replyToHeader;
        }

        public Function1<String, String> timestampHeader() {
            return this.timestampHeader;
        }

        public Function1<String, String> typeHeader() {
            return this.typeHeader;
        }

        public Function1<String, String> msgIdHeader() {
            return this.msgIdHeader;
        }

        public String replyToQueueName() {
            return this.replyToQueueName;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$jmsHeaderPrefix_$eq(Function1<String, String> x$1) {
            this.jmsHeaderPrefix = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcVendorHeader_$eq(Function1<String, String> x$1) {
            this.srcVendorHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcProviderHeader_$eq(Function1<String, String> x$1) {
            this.srcProviderHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcDestHeader_$eq(Function1<String, String> x$1) {
            this.srcDestHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$destHeader_$eq(Function1<String, String> x$1) {
            this.destHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$corrIdHeader_$eq(Function1<String, String> x$1) {
            this.corrIdHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$priorityHeader_$eq(Function1<String, String> x$1) {
            this.priorityHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$expireHeader_$eq(Function1<String, String> x$1) {
            this.expireHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$deliveryModeHeader_$eq(Function1<String, String> x$1) {
            this.deliveryModeHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToHeader_$eq(Function1<String, String> x$1) {
            this.replyToHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$timestampHeader_$eq(Function1<String, String> x$1) {
            this.timestampHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$typeHeader_$eq(Function1<String, String> x$1) {
            this.typeHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$msgIdHeader_$eq(Function1<String, String> x$1) {
            this.msgIdHeader = x$1;
        }

        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToQueueName_$eq(String x$1) {
            this.replyToQueueName = x$1;
        }

        public Logger log() {
            return this.log;
        }

        public Function1<FlowMessage, Try<JmsDestination>> destination() {
            return this.destination;
        }

        public Function1<FlowMessage, Object> priority() {
            return this.priority;
        }

        public Function1<FlowMessage, Option<FiniteDuration>> timeToLive() {
            return this.timeToLive;
        }

        public Function1<FlowMessage, JmsDeliveryMode> deliveryMode() {
            return this.deliveryMode;
        }

        public void blended$streams$jms$FlowHeaderConfigAware$_setter_$log_$eq(Logger x$1) {
            this.log = x$1;
        }

        public void blended$streams$jms$FlowHeaderConfigAware$_setter_$destination_$eq(Function1<FlowMessage, Try<JmsDestination>> x$1) {
            this.destination = x$1;
        }

        public void blended$streams$jms$FlowHeaderConfigAware$_setter_$priority_$eq(Function1<FlowMessage, Object> x$1) {
            this.priority = x$1;
        }

        public void blended$streams$jms$FlowHeaderConfigAware$_setter_$timeToLive_$eq(Function1<FlowMessage, Option<FiniteDuration>> x$1) {
            this.timeToLive = x$1;
        }

        public void blended$streams$jms$FlowHeaderConfigAware$_setter_$deliveryMode_$eq(Function1<FlowMessage, JmsDeliveryMode> x$1) {
            this.deliveryMode = x$1;
        }

        public FlowHeaderConfig headerConfig() {
            return this.headerConfig;
        }

        public JmsProducerSettings settings() {
            return this.settings;
        }

        public Function1<FlowEnvelope, Try<FlowEnvelope>> validator() {
            return this.validator;
        }

        public Try<JmsSendParameter> sendParameter(Session session, FlowEnvelope env) {
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                JmsDestination jmsDestination;
                Option option = env.exception();
                if (None$.MODULE$.equals(option)) {
                    jmsDestination = (JmsDestination)JmsDestination$.MODULE$.create((String)env.headerWithDefault(this.headerConfig().headerRetryDestination(), (Object)$this.blended$jms$bridge$internal$JmsRetryProcessor$RetryDestinationResolver$$$outer().blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.failedDestName(), ManifestFactory$.MODULE$.classType(String.class))).get();
                } else if (option instanceof Some) {
                    JmsDestination jmsDestination2;
                    Try try_ = (Try)this.validator().apply((Object)env);
                    if (try_ instanceof Success) {
                        jmsDestination2 = (JmsDestination)JmsDestination$.MODULE$.create($this.blended$jms$bridge$internal$JmsRetryProcessor$RetryDestinationResolver$$$outer().blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.retryDestName()).get();
                    } else if (try_ instanceof Failure) {
                        jmsDestination2 = (JmsDestination)JmsDestination$.MODULE$.create($this.blended$jms$bridge$internal$JmsRetryProcessor$RetryDestinationResolver$$$outer().blended$jms$bridge$internal$JmsRetryProcessor$$retryCfg.failedDestName()).get();
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    jmsDestination = jmsDestination2;
                } else {
                    throw new MatchError((Object)option);
                }
                JmsDestination dest = jmsDestination;
                return new JmsSendParameter((Message)this.createJmsMessage(session, env).get(), dest, JmsDeliveryMode$.MODULE$.Persistent(), this.settings().priority(), this.settings().timeToLive());
            });
        }

        public /* synthetic */ JmsRetryProcessor blended$jms$bridge$internal$JmsRetryProcessor$RetryDestinationResolver$$$outer() {
            return this.$outer;
        }

        public RetryDestinationResolver(JmsRetryProcessor $outer, FlowHeaderConfig headerConfig, JmsProducerSettings settings, Function1<FlowEnvelope, Try<FlowEnvelope>> validator) {
            this.headerConfig = headerConfig;
            this.settings = settings;
            this.validator = validator;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            JmsDestinationResolver.$init$((JmsDestinationResolver)this);
            FlowHeaderConfigAware.$init$((FlowHeaderConfigAware)this);
            JmsEnvelopeHeader.$init$((JmsEnvelopeHeader)this);
        }
    }
}

