/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.bridge.internal;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.stream.FanOutShape2;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.KillSwitch;
import akka.stream.Materializer;
import akka.stream.UniformFanInShape;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Merge$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import blended.jms.bridge.BridgeProviderConfig;
import blended.jms.bridge.internal.BridgeStreamConfig;
import blended.jms.bridge.internal.InvalidBridgeConfigurationException;
import blended.jms.bridge.internal.TrackTransaction$;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsDestination$;
import blended.streams.FlowProcessor$;
import blended.streams.StreamControllerConfig;
import blended.streams.StreamControllerConfig$;
import blended.streams.jms.AcknowledgeMode;
import blended.streams.jms.AcknowledgeMode$;
import blended.streams.jms.JMSConsumerSettings;
import blended.streams.jms.JMSConsumerSettings$;
import blended.streams.jms.JmsAckSourceStage;
import blended.streams.jms.JmsAckSourceStage$;
import blended.streams.jms.JmsDeliveryMode;
import blended.streams.jms.JmsDeliveryMode$;
import blended.streams.jms.JmsProducerSettings;
import blended.streams.jms.JmsProducerSettings$;
import blended.streams.jms.JmsStreamSupport;
import blended.streams.jms.MessageDestinationResolver;
import blended.streams.jms.SettingsDestinationResolver;
import blended.streams.message.FlowEnvelope;
import blended.streams.processor.AckProcessor;
import blended.streams.processor.Collector;
import blended.streams.processor.HeaderTransformProcessor;
import blended.streams.transaction.FlowHeaderConfig;
import blended.streams.transaction.TransactionWiretap;
import blended.util.logging.LogLevel$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001\u0002\u0014(\u0001AB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0006\t\"AA\n\u0001B\u0001B\u0003-Q\nC\u0003T\u0001\u0011\u0005A\u000bC\u0004[\u0001\t\u0007I\u0011C.\t\r\u001d\u0004\u0001\u0015!\u0003]\u0011\u001dA\u0007A1A\u0005\u0012mCa!\u001b\u0001!\u0002\u0013a\u0006b\u00026\u0001\u0005\u0004%\tb\u0017\u0005\u0007W\u0002\u0001\u000b\u0011\u0002/\t\u000f1\u0004!\u0019!C\t[\"1a\u000f\u0001Q\u0001\n9Dqa\u001e\u0001C\u0002\u0013E\u0001\u0010C\u0004\u0002\u001a\u0001\u0001\u000b\u0011B=\t\u0013\u0005m\u0001A1A\u0005\u0012\u0005u\u0001\u0002CA\u0019\u0001\u0001\u0006I!a\b\t\u0013\u0005M\u0002A1A\u0005\u0012\u0005U\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\u000e\t\u0013\u0005}\u0002A1A\u0005\u0012\u0005\u0005\u0003\u0002CA\"\u0001\u0001\u0006I!a\u0002\t\u0019\u0005\u0015\u0003\u0001%A\u0001\u0004\u0003\u0006I!a\u0012\t\u0013\u0005E\u0003A1A\u0005\u0012\u0005M\u0003\u0002CA+\u0001\u0001\u0006I!!\u0013\t\u0013\u0005]\u0003A1A\u0005\u0012\u0005e\u0003\u0002CA.\u0001\u0001\u0006I!a\u0014\t\u000f\u0005u\u0003\u0001\"\u0005\u0002`!9\u0011\u0011\u0011\u0001\u0005\u0012\u0005\r\u0005bBAF\u0001\u0011E\u00111\u0011\u0005\u000b\u0003\u001b\u0003!\u0019!C\tS\u0005=\u0005\u0002CAO\u0001\u0001\u0006I!!%\t\u000f\u0005}\u0005\u0001\"\u0005\u0002\u0004\"9\u0011\u0011\u0015\u0001\u0005\u0012\u0005\r\u0005bBAR\u0001\u0011E\u0011Q\u0015\u0005\t!\u0002\u0011\r\u0011\"\u0001\u0002`!A\u00111\u0016\u0001!\u0002\u0013\t\t\u0007C\u0005\u0002.\u0002\u0011\r\u0011\"\u0001\u00020\"A\u0011\u0011\u0018\u0001!\u0002\u0013\t\tLA\nCe&$w-Z*ue\u0016\fWNQ;jY\u0012,'O\u0003\u0002)S\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002+W\u00051!M]5eO\u0016T!\u0001L\u0017\u0002\u0007)l7OC\u0001/\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001aE\u0002\u0001c]\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0007C\u0001\u001d=\u001b\u0005I$B\u0001\u0017;\u0015\tYT&A\u0004tiJ,\u0017-\\:\n\u0005uJ$\u0001\u0005&ngN#(/Z1n'V\u0004\bo\u001c:u\u0003\r\u0019gm\u001a\t\u0003\u0001\u0006k\u0011aJ\u0005\u0003\u0005\u001e\u0012!C\u0011:jI\u001e,7\u000b\u001e:fC6\u001cuN\u001c4jO\u000611/_:uK6\u0004\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003%\u000bA!Y6lC&\u00111J\u0012\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0007nCR,'/[1mSj,'\u000f\u0005\u0002O#6\tqJ\u0003\u0002Q\u0011\u000611\u000f\u001e:fC6L!AU(\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0002\rqJg.\u001b;?)\t)\u0016\fF\u0002W/b\u0003\"\u0001\u0011\u0001\t\u000b\r#\u00019\u0001#\t\u000b1#\u00019A'\t\u000by\"\u0001\u0019A \u0002\t%t\u0017\nZ\u000b\u00029B\u0011Q\f\u001a\b\u0003=\n\u0004\"aX\u001a\u000e\u0003\u0001T!!Y\u0018\u0002\rq\u0012xn\u001c;?\u0013\t\u00197'\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA24\u0003\u0015Ig.\u00133!\u0003\u0015yW\u000f^%e\u0003\u0019yW\u000f^%eA\u0005A1\u000f\u001e:fC6LE-A\u0005tiJ,\u0017-\\%eA\u0005a!M]5eO\u0016dunZ4feV\ta\u000e\u0005\u0002pi6\t\u0001O\u0003\u0002re\u00069An\\4hS:<'BA:.\u0003\u0011)H/\u001b7\n\u0005U\u0004(A\u0002'pO\u001e,'/A\u0007ce&$w-\u001a'pO\u001e,'\u000fI\u0001\u000bi>\u001cV\r\u001e;j]\u001e\u001cX#A=\u0011\u000bIRH0!\u0002\n\u0005m\u001c$!\u0003$v]\u000e$\u0018n\u001c82!\ri\u0018\u0011A\u0007\u0002}*\u0011qpK\u0001\u0006kRLGn]\u0005\u0004\u0003\u0007q(\u0001G%e\u0003^\f'/Z\"p]:,7\r^5p]\u001a\u000b7\r^8ssB1!G_A\u0004\u0003'\u0001RAMA\u0005\u0003\u001bI1!a\u00034\u0005\u0019y\u0005\u000f^5p]B\u0019Q0a\u0004\n\u0007\u0005EaP\u0001\bK[N$Um\u001d;j]\u0006$\u0018n\u001c8\u0011\u0007a\n)\"C\u0002\u0002\u0018e\u00121CS7t!J|G-^2feN+G\u000f^5oON\f1\u0002^8TKR$\u0018N\\4tA\u0005\u0001\u0012N\u001c;fe:\fG\u000e\u0015:pm&$WM]\u000b\u0003\u0003?\u0001b!!\t\u0002&\u0005%RBAA\u0012\u0015\t\u00198'\u0003\u0003\u0002(\u0005\r\"a\u0001+ssB!\u00111FA\u0017\u001b\u0005I\u0013bAA\u0018S\t!\"I]5eO\u0016\u0004&o\u001c<jI\u0016\u00148i\u001c8gS\u001e\f\u0011#\u001b8uKJt\u0017\r\u001c)s_ZLG-\u001a:!\u0003)Ig\u000e^3s]\u0006d\u0017\nZ\u000b\u0003\u0003o\u0001RAMA\u001d9rK1!a\u000f4\u0005\u0019!V\u000f\u001d7fe\u0005Y\u0011N\u001c;fe:\fG.\u00133!\u0003%\u0011X\r\u001e:z\t\u0016\u001cH/\u0006\u0002\u0002\b\u0005Q!/\u001a;ss\u0012+7\u000f\u001e\u0011\u0002\u0007a$#\u0007E\u00043\u0003s\tI%a\u0014\u0011\u0007I\nY%C\u0002\u0002NM\u0012qAQ8pY\u0016\fg\u000eE\u0003\u0002\"\u0005\u0015B0A\u0005jg&s'm\\;oIV\u0011\u0011\u0011J\u0001\u000bSNLeNY8v]\u0012\u0004\u0013AC5oi\u0016\u0014h.\u00197DMV\u0011\u0011qJ\u0001\fS:$XM\u001d8bY\u000e3\u0007%A\u0005k[N\u001cv.\u001e:dKV\u0011\u0011\u0011\r\t\t\u0003G\nI'!\u001c\u0002z5\u0011\u0011Q\r\u0006\u0004\u0003Oz\u0015\u0001C:dC2\fGm\u001d7\n\t\u0005-\u0014Q\r\u0002\u0007'>,(oY3\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d;\u0003\u001diWm]:bO\u0016LA!a\u001e\u0002r\taa\t\\8x\u000b:4X\r\\8qKB!\u00111PA?\u001b\u0005A\u0015bAA@\u0011\n9aj\u001c;Vg\u0016$\u0017a\u00026ngN+g\u000eZ\u000b\u0003\u0003\u000b\u0003\"\"a\u0019\u0002\b\u00065\u0014QNA=\u0013\u0011\tI)!\u001a\u0003\t\u0019cwn^\u0001\tU6\u001c(+\u001a;ss\u0006YAO]1dW\u001aKG\u000e^3s+\t\t\t\nE\u0004O\u0003'\u000b9*!\u001f\n\u0007\u0005UuJA\u0003He\u0006\u0004\b\u000eE\u0005O\u00033\u000bi'!\u001c\u0002n%\u0019\u00111T(\u0003\u0019\u0019\u000bgnT;u'\"\f\u0007/\u001a\u001a\u0002\u0019Q\u0014\u0018mY6GS2$XM\u001d\u0011\u0002\u001fM,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\fq\u0002\u001e:b]N\f7\r^5p]\u001acwn^\u0001\fY><WI\u001c<fY>\u0004X\r\u0006\u0003\u0002\u0006\u0006\u001d\u0006BBAUC\u0001\u0007A,A\u0002ng\u001e\fqa\u001d;sK\u0006l\u0007%A\u0005tiJ,\u0017-\\\"gOV\u0011\u0011\u0011\u0017\t\u0005\u0003g\u000b),D\u0001;\u0013\r\t9L\u000f\u0002\u0017'R\u0014X-Y7D_:$(o\u001c7mKJ\u001cuN\u001c4jO\u0006Q1\u000f\u001e:fC6\u001cem\u001a\u0011")
public class BridgeStreamBuilder
implements JmsStreamSupport {
    private final BridgeStreamConfig cfg;
    private final ActorSystem system;
    private final Materializer materializer;
    private final String inId;
    private final String outId;
    private final String streamId;
    private final Logger bridgeLogger;
    private final Function1<IdAwareConnectionFactory, Function1<Option<JmsDestination>, JmsProducerSettings>> toSettings;
    private final Try<BridgeProviderConfig> internalProvider;
    private final Tuple2<String, String> internalId;
    private final Option<JmsDestination> retryDest;
    private final /* synthetic */ Tuple2 x$2;
    private final boolean isInbound;
    private final Try<IdAwareConnectionFactory> internalCf;
    private final Graph<FanOutShape2<FlowEnvelope, FlowEnvelope, FlowEnvelope>, NotUsed> trackFilter;
    private final Source<FlowEnvelope, NotUsed> stream;
    private final StreamControllerConfig streamCfg;

    public Try<KillSwitch> processMessages(Flow<FlowEnvelope, FlowEnvelope, ?> processFlow, Seq<FlowEnvelope> msgs, ActorSystem system) {
        return JmsStreamSupport.processMessages$((JmsStreamSupport)this, processFlow, msgs, (ActorSystem)system);
    }

    public Try<KillSwitch> sendMessages(JmsProducerSettings producerSettings, Logger log, Seq<FlowEnvelope> msgs, ActorSystem system, Materializer materializer, ExecutionContext ectxt) {
        return JmsStreamSupport.sendMessages$((JmsStreamSupport)this, (JmsProducerSettings)producerSettings, (Logger)log, msgs, (ActorSystem)system, (Materializer)materializer, (ExecutionContext)ectxt);
    }

    public Collector<FlowEnvelope> receiveMessages(FlowHeaderConfig headerCfg, IdAwareConnectionFactory cf, JmsDestination dest, Logger log, Integer listener, Option<FiniteDuration> minMessageDelay, Option<String> selector, FiniteDuration timeout, ActorSystem system, Materializer materializer) {
        return JmsStreamSupport.receiveMessages$((JmsStreamSupport)this, (FlowHeaderConfig)headerCfg, (IdAwareConnectionFactory)cf, (JmsDestination)dest, (Logger)log, (Integer)listener, minMessageDelay, selector, (FiniteDuration)timeout, (ActorSystem)system, (Materializer)materializer);
    }

    public Integer receiveMessages$default$5() {
        return JmsStreamSupport.receiveMessages$default$5$((JmsStreamSupport)this);
    }

    public Option<FiniteDuration> receiveMessages$default$6() {
        return JmsStreamSupport.receiveMessages$default$6$((JmsStreamSupport)this);
    }

    public Option<String> receiveMessages$default$7() {
        return JmsStreamSupport.receiveMessages$default$7$((JmsStreamSupport)this);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> jmsProducer(String name, JmsProducerSettings settings, boolean autoAck, ActorSystem system, Materializer materializer) {
        return JmsStreamSupport.jmsProducer$((JmsStreamSupport)this, (String)name, (JmsProducerSettings)settings, (boolean)autoAck, (ActorSystem)system, (Materializer)materializer);
    }

    public boolean jmsProducer$default$3() {
        return JmsStreamSupport.jmsProducer$default$3$((JmsStreamSupport)this);
    }

    public Source<FlowEnvelope, NotUsed> jmsConsumer(String name, JMSConsumerSettings settings, Option<FiniteDuration> minMessageDelay, ActorSystem system) {
        return JmsStreamSupport.jmsConsumer$((JmsStreamSupport)this, (String)name, (JMSConsumerSettings)settings, minMessageDelay, (ActorSystem)system);
    }

    public String inId() {
        return this.inId;
    }

    public String outId() {
        return this.outId;
    }

    public String streamId() {
        return this.streamId;
    }

    public Logger bridgeLogger() {
        return this.bridgeLogger;
    }

    public Function1<IdAwareConnectionFactory, Function1<Option<JmsDestination>, JmsProducerSettings>> toSettings() {
        return this.toSettings;
    }

    public Try<BridgeProviderConfig> internalProvider() {
        return this.internalProvider;
    }

    public Tuple2<String, String> internalId() {
        return this.internalId;
    }

    public Option<JmsDestination> retryDest() {
        return this.retryDest;
    }

    public boolean isInbound() {
        return this.isInbound;
    }

    public Try<IdAwareConnectionFactory> internalCf() {
        return this.internalCf;
    }

    public Source<FlowEnvelope, NotUsed> jmsSource() {
        Source source;
        Source source2;
        Logger x$1 = this.bridgeLogger();
        IdAwareConnectionFactory x$2 = this.cfg.fromCf();
        FlowHeaderConfig x$3 = this.cfg.headerCfg();
        FiniteDuration x$4 = JMSConsumerSettings$.MODULE$.apply$default$4();
        Option x$5 = JMSConsumerSettings$.MODULE$.apply$default$5();
        int x$6 = JMSConsumerSettings$.MODULE$.apply$default$6();
        FiniteDuration x$7 = JMSConsumerSettings$.MODULE$.apply$default$7();
        FiniteDuration x$8 = JMSConsumerSettings$.MODULE$.apply$default$8();
        AcknowledgeMode x$9 = JMSConsumerSettings$.MODULE$.apply$default$9();
        int x$10 = JMSConsumerSettings$.MODULE$.apply$default$10();
        Option x$11 = JMSConsumerSettings$.MODULE$.apply$default$11();
        FiniteDuration x$12 = JMSConsumerSettings$.MODULE$.apply$default$12();
        Option x$13 = JMSConsumerSettings$.MODULE$.apply$default$13();
        FiniteDuration x$14 = JMSConsumerSettings$.MODULE$.apply$default$14();
        JMSConsumerSettings srcSettings = new JMSConsumerSettings(x$1, x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14).withAcknowledgeMode(AcknowledgeMode$.MODULE$.ClientAcknowledge()).withDestination((Option)new Some((Object)this.cfg.fromDest())).withSessionCount(this.cfg.listener()).withSelector(this.cfg.selector()).withSubScriberName(this.cfg.subscriberName());
        Source result = Source$.MODULE$.fromGraph((Graph)new JmsAckSourceStage(new StringBuilder(7).append(this.streamId()).append("-source").toString(), srcSettings, JmsAckSourceStage$.MODULE$.$lessinit$greater$default$3(), this.system));
        Option option = Option$.MODULE$.apply((Object)System.getProperty("blended.streams.transactionShard"));
        if (None$.MODULE$.equals(option)) {
            source2 = result;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String shard = (String)some.value();
            source2 = result.via((Graph)Flow$.MODULE$.fromFunction((Function1 & Serializable & scala.Serializable)env -> (FlowEnvelope)env.withHeader($this.cfg.headerCfg().headerTransShard(), (Object)shard, false).get()));
        } else {
            throw new MatchError((Object)option);
        }
        Source src = source2;
        if (this.cfg.inbound() && this.cfg.header().nonEmpty()) {
            this.bridgeLogger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Creating Stream with header configs [").append($this.cfg.header()).append("]").toString());
            Graph header = new HeaderTransformProcessor(new StringBuilder(7).append(this.streamId()).append("-header").toString(), this.bridgeLogger(), this.cfg.header(), this.cfg.idSvc()).flow(this.bridgeLogger());
            source = src.via(header);
        } else {
            this.bridgeLogger().info((Function0 & Serializable & scala.Serializable)() -> "Creating Stream without additional header configs");
            source = src;
        }
        return source;
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> jmsSend() {
        return this.jmsProducer(new StringBuilder(5).append(this.streamId()).append("-sink").toString(), (JmsProducerSettings)((Function1)this.toSettings().apply((Object)this.cfg.toCf())).apply(this.cfg.toDest()), false, this.system, this.materializer);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> jmsRetry() {
        Flow flow;
        Flow skipRetry = Flow$.MODULE$.fromGraph(FlowProcessor$.MODULE$.log(LogLevel$.MODULE$.Debug(), this.bridgeLogger(), "Skipping retry"));
        Option<JmsDestination> option = this.retryDest();
        if (None$.MODULE$.equals(option)) {
            this.bridgeLogger().debug((Function0 & Serializable & scala.Serializable)() -> "No retry destination set, retry mechanism will be disabled");
            flow = skipRetry;
        } else if (option instanceof Some) {
            Flow flow2;
            Some some = (Some)option;
            JmsDestination d = (JmsDestination)some.value();
            if (this.isInbound()) {
                this.bridgeLogger().debug((Function0 & Serializable & scala.Serializable)() -> "Retry mechanism will be disabled for inbound bridge direction");
                flow2 = skipRetry;
            } else {
                JmsProducerSettings qual$1 = (JmsProducerSettings)((Function1)this.toSettings().apply((Object)this.cfg.fromCf())).apply((Object)new Some((Object)d));
                boolean x$1 = true;
                Logger x$2 = qual$1.copy$default$1();
                FlowHeaderConfig x$3 = qual$1.copy$default$2();
                IdAwareConnectionFactory x$4 = qual$1.copy$default$3();
                FiniteDuration x$5 = qual$1.copy$default$4();
                Option x$6 = qual$1.copy$default$5();
                int x$7 = qual$1.copy$default$6();
                Function1 x$8 = qual$1.copy$default$7();
                int x$9 = qual$1.copy$default$8();
                JmsDeliveryMode x$10 = qual$1.copy$default$9();
                Option x$11 = qual$1.copy$default$10();
                Function0 x$12 = qual$1.copy$default$11();
                FiniteDuration x$13 = qual$1.copy$default$12();
                flow2 = this.logEnvelope(new StringBuilder(22).append("Forwarding to retry [").append(d).append("]").toString()).via((Graph)Flow$.MODULE$.fromFunction((Function1 & Serializable & scala.Serializable)env -> (FlowEnvelope)env.withHeader($this.cfg.headerCfg().headerRetryDestination(), (Object)JmsDestination$.MODULE$.asString($this.cfg.fromDest()), env.withHeader$default$3()).get())).via(this.jmsProducer(new StringBuilder(6).append(this.streamId()).append("-retry").toString(), qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$1), false, this.system, this.materializer));
            }
            flow = flow2;
        } else {
            throw new MatchError(option);
        }
        return flow;
    }

    public Graph<FanOutShape2<FlowEnvelope, FlowEnvelope, FlowEnvelope>, NotUsed> trackFilter() {
        return this.trackFilter;
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> sendTransaction() {
        return new TransactionWiretap((IdAwareConnectionFactory)this.internalCf().get(), ((BridgeProviderConfig)this.internalProvider().get()).transactions(), this.cfg.headerCfg(), this.cfg.inbound(), this.streamId(), this.bridgeLogger(), this.system, this.materializer).flow();
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> transactionFlow() {
        Graph g = GraphDSL$.MODULE$.create((Function1 & Serializable & scala.Serializable)b -> {
            FlowShape doLog = (FlowShape)b.add(this.logEnvelope("Before Tracking"));
            FanOutShape2 doTrack = (FanOutShape2)b.add(this.trackFilter());
            GraphDSL.Implicits$.MODULE$.port2flow(doLog.out(), b).$tilde$greater(doTrack.in(), b);
            Flow<FlowEnvelope, FlowEnvelope, NotUsed> send = this.sendTransaction();
            UniformFanInShape merge = (UniformFanInShape)b.add((Graph)Merge$.MODULE$.apply(2, Merge$.MODULE$.apply$default$2()));
            FanOutShape2 sendError = (FanOutShape2)b.add(FlowProcessor$.MODULE$.partition((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BridgeStreamBuilder.$anonfun$transactionFlow$2(x$3))));
            UniformFanInShape mergeError = (UniformFanInShape)b.add((Graph)Merge$.MODULE$.apply(2, Merge$.MODULE$.apply$default$2()));
            FlowShape retry = (FlowShape)b.add(this.jmsRetry());
            GraphDSL.Implicits$.MODULE$.port2flow(doTrack.out0(), b).$tilde$greater(send, b).$tilde$greater(sendError.in(), b);
            GraphDSL.Implicits$.MODULE$.port2flow(sendError.out0(), b).$tilde$greater(mergeError.in(0), b);
            GraphDSL.Implicits$.MODULE$.port2flow(sendError.out1(), b).$tilde$greater(retry, b).$tilde$greater(mergeError.in(1), b);
            GraphDSL.Implicits$.MODULE$.port2flow(mergeError.out(), b).$tilde$greater(merge.in(0), b);
            GraphDSL.Implicits$.MODULE$.port2flow(doTrack.out1(), b).$tilde$greater(merge.in(1), b);
            return new FlowShape(doLog.in(), merge.out());
        });
        return Flow$.MODULE$.fromGraph(g);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> logEnvelope(String msg) {
        return Flow$.MODULE$.fromGraph(FlowProcessor$.MODULE$.log(LogLevel$.MODULE$.Debug(), this.bridgeLogger(), msg));
    }

    public Source<FlowEnvelope, NotUsed> stream() {
        return this.stream;
    }

    public StreamControllerConfig streamCfg() {
        return this.streamCfg;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$trackFilter$1(BridgeStreamBuilder $this, FlowEnvelope env) {
        void var3_8;
        boolean bl;
        Enumeration.Value value = $this.cfg.trackTransaction();
        Enumeration.Value value2 = TrackTransaction$.MODULE$.Off();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = false;
        } else {
            Enumeration.Value value4 = TrackTransaction$.MODULE$.On();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = TrackTransaction$.MODULE$.FromMessage();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    $this.bridgeLogger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Getting tracking mode from message property [").append($this.cfg.headerCfg().headerTrack()).append("]").toString());
                    Option msgTrack = env.header($this.cfg.headerCfg().headerTrack(), (Manifest)ManifestFactory$.MODULE$.Boolean());
                    bl = BoxesRunTime.unboxToBoolean((Object)msgTrack.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        boolean doTrack = bl;
        $this.bridgeLogger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Tracking for envelope [").append(env.id()).append("] is [").append(doTrack).append("]").toString());
        return (boolean)var3_8;
    }

    public static final /* synthetic */ boolean $anonfun$transactionFlow$2(FlowEnvelope x$3) {
        return x$3.exception().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$stream$2(FlowEnvelope x$4) {
        return x$4.exception().isEmpty();
    }

    public BridgeStreamBuilder(BridgeStreamConfig cfg, ActorSystem system, Materializer materializer) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        this.cfg = cfg;
        this.system = system;
        this.materializer = materializer;
        JmsStreamSupport.$init$((JmsStreamSupport)this);
        this.inId = new StringBuilder(2).append(cfg.fromCf().vendor()).append(":").append(cfg.fromCf().provider()).append(":").append(cfg.fromDest().asString()).toString();
        this.outId = new StringBuilder(2).append(cfg.toCf().vendor()).append(":").append(cfg.toCf().provider()).append(":").append(cfg.toDest().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "out")).toString();
        this.streamId = new StringBuilder(21).append(cfg.headerCfg().prefix()).append(".bridge.JmsStream(").append(this.inId()).append("->").append(this.outId()).append(")").toString();
        this.bridgeLogger = Logger$.MODULE$.apply(this.streamId());
        this.toSettings = (Function1 & Serializable & scala.Serializable)cf -> (Function1 & Serializable & scala.Serializable)dest -> {
            Function1 & Serializable & scala.Serializable intersect;
            Option option = dest;
            if (option instanceof Some) {
                intersect = (Function1 & Serializable & scala.Serializable)s -> new SettingsDestinationResolver(s);
            } else if (None$.MODULE$.equals(option)) {
                intersect = (Function1 & Serializable & scala.Serializable)s -> new MessageDestinationResolver(s);
            } else {
                throw new MatchError((Object)option);
            }
            Function1 & Serializable & scala.Serializable resolver = intersect;
            Logger x$1 = this.bridgeLogger();
            IdAwareConnectionFactory x$2 = cf;
            FlowHeaderConfig x$3 = $this.cfg.headerCfg();
            FiniteDuration x$4 = JmsProducerSettings$.MODULE$.apply$default$4();
            Option x$5 = JmsProducerSettings$.MODULE$.apply$default$5();
            int x$6 = JmsProducerSettings$.MODULE$.apply$default$6();
            Function1 x$7 = JmsProducerSettings$.MODULE$.apply$default$7();
            int x$8 = JmsProducerSettings$.MODULE$.apply$default$8();
            JmsDeliveryMode x$9 = JmsProducerSettings$.MODULE$.apply$default$9();
            Option x$10 = JmsProducerSettings$.MODULE$.apply$default$10();
            Function0 x$11 = JmsProducerSettings$.MODULE$.apply$default$11();
            FiniteDuration x$12 = JmsProducerSettings$.MODULE$.apply$default$12();
            boolean x$13 = JmsProducerSettings$.MODULE$.apply$default$13();
            return new JmsProducerSettings(x$1, x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13).withDestination(dest).withDestinationResolver((Function1)resolver).withDeliveryMode(JmsDeliveryMode$.MODULE$.Persistent());
        };
        this.internalProvider = cfg.registry().internalProvider();
        this.internalId = new Tuple2((Object)((BridgeProviderConfig)this.internalProvider().get()).vendor(), (Object)((BridgeProviderConfig)this.internalProvider().get()).provider());
        this.retryDest = ((BridgeProviderConfig)this.internalProvider().get()).retry();
        Tuple2 tuple23 = new Tuple2((Object)cfg.fromCf().vendor(), (Object)cfg.fromCf().provider());
        Tuple2<String, String> tuple24 = this.internalId();
        if (!(tuple23 != null ? !tuple23.equals(tuple24) : tuple24 != null)) {
            tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Success((Object)cfg.fromCf()));
        } else {
            Tuple2 tuple25 = new Tuple2((Object)cfg.toCf().vendor(), (Object)cfg.toCf().provider());
            Tuple2<String, String> tuple26 = this.internalId();
            tuple22 = !(tuple25 != null ? !tuple25.equals(tuple26) : tuple26 != null) ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Success((Object)cfg.toCf())) : (tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Failure((Throwable)new InvalidBridgeConfigurationException("One leg of the JMS bridge must be internal"))));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean isInbound = tuple2._1$mcZ$sp();
        Try internalCf = (Try)tuple2._2();
        Tuple2 tuple27 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isInbound), (Object)internalCf);
        this.x$2 = tuple27;
        this.isInbound = this.x$2._1$mcZ$sp();
        this.internalCf = (Try)this.x$2._2();
        this.trackFilter = FlowProcessor$.MODULE$.partition((Function1 & Serializable & scala.Serializable)env -> BoxesRunTime.boxToBoolean((boolean)BridgeStreamBuilder.$anonfun$trackFilter$1(this, env)));
        Graph g = GraphDSL$.MODULE$.create((Function1 & Serializable & scala.Serializable)b -> {
            FlowShape forward = (FlowShape)b.add((Graph)this.jmsSend().via(this.logEnvelope("After Send")));
            FanOutShape2 sendError = (FanOutShape2)b.add(FlowProcessor$.MODULE$.partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)BridgeStreamBuilder.$anonfun$stream$2(x$4))));
            GraphDSL.Implicits$.MODULE$.flow2flow(forward, b).$tilde$greater(sendError.in(), b);
            UniformFanInShape merge = (UniformFanInShape)b.add((Graph)Merge$.MODULE$.apply(2, Merge$.MODULE$.apply$default$2()));
            FlowShape transaction = (FlowShape)b.add(this.transactionFlow());
            GraphDSL.Implicits$.MODULE$.port2flow(sendError.out0(), b).$tilde$greater(transaction, b).$tilde$greater(merge.in(0), b);
            FlowShape retry = (FlowShape)b.add(this.jmsRetry());
            GraphDSL.Implicits$.MODULE$.port2flow(sendError.out1(), b).$tilde$greater(retry, b).$tilde$greater(merge.in(1), b);
            FlowShape ack = (FlowShape)b.add((Graph)new AckProcessor(new StringBuilder(4).append(this.streamId()).append("-ack").toString()).flow());
            GraphDSL.Implicits$.MODULE$.port2flow(merge.out(), b).$tilde$greater(ack.in(), b);
            return new FlowShape(forward.in(), ack.out());
        });
        this.stream = this.jmsSource().via(g);
        this.bridgeLogger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Starting bridge stream with config [inbound=").append($this.cfg.inbound()).append(",trackTransaction=").append($this.cfg.trackTransaction()).append("]").toString());
        StreamControllerConfig qual$1 = (StreamControllerConfig)StreamControllerConfig$.MODULE$.fromConfig(cfg.rawConfig()).get();
        String x$14 = this.streamId();
        FiniteDuration x$15 = qual$1.copy$default$2();
        FiniteDuration x$16 = qual$1.copy$default$3();
        boolean x$17 = qual$1.copy$default$4();
        boolean x$18 = qual$1.copy$default$5();
        double x$19 = qual$1.copy$default$6();
        this.streamCfg = qual$1.copy(x$14, x$15, x$16, x$17, x$18, x$19);
    }
}

