/*
 * Decompiled with CFR 0.152.
 */
package blended.itestsupport.docker;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.event.LoggingReceive$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import blended.itestsupport.ContainerLink;
import blended.itestsupport.ContainerUnderTest;
import blended.itestsupport.NamedContainerPort;
import blended.itestsupport.VolumeConfig;
import blended.itestsupport.docker.ContainerManagerActor$;
import blended.itestsupport.docker.Docker;
import blended.itestsupport.docker.DockerClientProvider;
import blended.itestsupport.docker.DockerContainerHandler$;
import blended.itestsupport.docker.DockerContainerMapperActor;
import blended.itestsupport.docker.InternalContainersStarted;
import blended.itestsupport.docker.InternalDockerContainersMapped;
import blended.itestsupport.docker.InternalMapDockerContainers;
import blended.itestsupport.docker.InternalStartContainers;
import blended.itestsupport.docker.protocol.ContainerManagerStarted;
import blended.itestsupport.docker.protocol.ExecuteContainerCommand;
import blended.itestsupport.docker.protocol.GetContainerDirectory;
import blended.itestsupport.docker.protocol.StartContainerManager;
import blended.itestsupport.docker.protocol.StopContainerManager;
import blended.itestsupport.docker.protocol.WriteContainerDirectory;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u00055dAB\f\u0019\u0001}\t)\u0005C\u00036\u0001\u0011\u0005a\u0007C\u00049\u0001\t\u0007I1A\u001d\t\r\u0001\u0003\u0001\u0015!\u0003;\u0011\u001d\t\u0005A1A\u0005\u0004\tCa!\u0013\u0001!\u0002\u0013\u0019\u0005b\u0002&\u0001\u0005\u0004%\ta\u0013\u0005\u00071\u0002\u0001\u000b\u0011\u0002'\t\u000fe\u0003!\u0019!C!5\"1!\r\u0001Q\u0001\nmCqa\u0019\u0001C\u0002\u0013\u0005C\r\u0003\u0004l\u0001\u0001\u0006I!\u001a\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006c\u0002!\tA\u001d\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\t)\u0002\u0001C\u0001\u0003/A\u0001\"!\u0010\u0001A\u0013%\u0011qH\u0004\b\u0003#B\u0002\u0012AA*\r\u00199\u0002\u0004#\u0001\u0002V!1QG\u0005C\u0001\u0003/Bq!!\u0017\u0013\t\u0003\tY\u0006C\u0004\u0002ZI!\t!a\u001a\u0007\u0013\u0005%$\u0003%A\u0012\"\u0005-$!F\"p]R\f\u0017N\\3s\u001b\u0006t\u0017mZ3s\u0003\u000e$xN\u001d\u0006\u00033i\ta\u0001Z8dW\u0016\u0014(BA\u000e\u001d\u00031IG/Z:ugV\u0004\bo\u001c:u\u0015\u0005i\u0012a\u00022mK:$W\rZ\u0002\u0001'\u0015\u0001\u0001E\n\u00182!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fMB\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0006C\u000e$xN\u001d\u0006\u0002W\u0005!\u0011m[6b\u0013\ti\u0003FA\u0003BGR|'\u000f\u0005\u0002(_%\u0011\u0001\u0007\u000b\u0002\r\u0003\u000e$xN\u001d'pO\u001eLgn\u001a\t\u0003eMj\u0011\u0001G\u0005\u0003ia\u0011a\u0001R8dW\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u00018!\t\u0011\u0004!A\u0004uS6,w.\u001e;\u0016\u0003i\u0002\"a\u000f \u000e\u0003qR!!\u0010\u0016\u0002\tU$\u0018\u000e\\\u0005\u0003\u007fq\u0012q\u0001V5nK>,H/\u0001\u0005uS6,w.\u001e;!\u0003\u0015)7\t\u001e=u+\u0005\u0019\u0005C\u0001#H\u001b\u0005)%B\u0001$#\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0011\u0016\u0013\u0001$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s\u0003\u0019)7\t\u001e=uA\u000511\r\\5f]R,\u0012\u0001\u0014\t\u0003\u001bZk\u0011A\u0014\u0006\u0003\u001fB\u000b1!\u00199j\u0015\t\t&+\u0001\u0006e_\u000e\\WM\u001d6bm\u0006T!a\u0015+\u0002\r\u001dLG\u000f[;c\u0015\u0005)\u0016aA2p[&\u0011qK\u0014\u0002\r\t>\u001c7.\u001a:DY&,g\u000e^\u0001\bG2LWM\u001c;!\u0003\u0019\u0019wN\u001c4jOV\t1\f\u0005\u0002]A6\tQL\u0003\u0002Z=*\u0011q\fV\u0001\tif\u0004Xm]1gK&\u0011\u0011-\u0018\u0002\u0007\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u00051An\\4hKJ,\u0012!\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q*\nQ!\u001a<f]RL!A[4\u0003\u001d1{wmZ5oO\u0006#\u0017\r\u001d;fe\u00069An\\4hKJ\u0004\u0013AB7baB,'/F\u0001o!\t9s.\u0003\u0002qQ\tA\u0011i\u0019;peJ+g-A\u0004sK\u000e,\u0017N^3\u0016\u0003M\u0004\"\u0001\u001e@\u000f\u0005UdhB\u0001<|\u001d\t9(0D\u0001y\u0015\tIh$\u0001\u0004=e>|GOP\u0005\u0002W%\u0011\u0011FK\u0005\u0003{\"\nQ!Q2u_JL1a`A\u0001\u0005\u001d\u0011VmY3jm\u0016T!! \u0015\u0002\u0011M$\u0018M\u001d;j]\u001e$b!a\u0002\u0002\u000e\u0005E\u0001\u0003BA\u0005\u0003\u0017i\u0011\u0001A\u0005\u0003\u007f2Ba!a\u0004\u000f\u0001\u0004q\u0017!\u00043pG.,'\u000fS1oI2,'\u000f\u0003\u0004\u0002\u00149\u0001\rA\\\u0001\ne\u0016\fX/Z:u_J\fqA];o]&tw\r\u0006\u0004\u0002\b\u0005e\u00111\u0004\u0005\u0007\u0003\u001fy\u0001\u0019\u00018\t\u000f\u0005uq\u00021\u0001\u0002 \u0005!1-\u001e;t!!\t\t#!\u000b\u00020\u0005Ub\u0002BA\u0012\u0003K\u0001\"a\u001e\u0012\n\u0007\u0005\u001d\"%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\tiCA\u0002NCBT1!a\n#!\u0011\t\t#!\r\n\t\u0005M\u0012Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u0011\t\u0005]\u0012\u0011H\u0007\u00025%\u0019\u00111\b\u000e\u0003%\r{g\u000e^1j]\u0016\u0014XK\u001c3feR+7\u000f^\u0001\u0019G>tg-[4ve\u0016$unY6fe\u000e{g\u000e^1j]\u0016\u0014H\u0003BA\u0010\u0003\u0003Bq!a\u0011\u0011\u0001\u0004\ty\"A\u0002dkR\u0014R!a\u00128\u0003\u00172a!!\u0013\u0001\u0001\u0005\u0015#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004c\u0001\u001a\u0002N%\u0019\u0011q\n\r\u0003)\u0011{7m[3s\u00072LWM\u001c;Qe>4\u0018\u000eZ3s\u0003U\u0019uN\u001c;bS:,'/T1oC\u001e,'/Q2u_J\u0004\"A\r\n\u0014\u0005I\u0001CCAA*\u0003\u0015\u0001(o\u001c9t)\u0011\ti&a\u0019\u0011\u0007\u001d\ny&C\u0002\u0002b!\u0012Q\u0001\u0015:paNDq!!\u001a\u0015\u0001\u0004\tY%\u0001\u000be_\u000e\\WM]\"mS\u0016tG\u000f\u0015:pm&$WM\u001d\u000b\u0003\u0003;\u0012\u0001\u0002\u0015:pi>\u001cw\u000e\\\n\u0003-\u0001\u0002")
public class ContainerManagerActor
implements Actor,
ActorLogging,
Docker {
    private final Timeout timeout;
    private final ExecutionContextExecutor eCtxt;
    private final DockerClient client;
    private final Config config;
    private final LoggingAdapter logger;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    public static Props props() {
        return ContainerManagerActor$.MODULE$.props();
    }

    public static Props props(DockerClientProvider dockerClientProvider) {
        return ContainerManagerActor$.MODULE$.props(dockerClientProvider);
    }

    @Override
    public Function1<Image, Object> searchByTag(String s) {
        return Docker.searchByTag$(this, s);
    }

    @Override
    public List<Image> images() {
        return Docker.images$(this);
    }

    @Override
    public List<Container> running() {
        return Docker.running$(this);
    }

    @Override
    public List<Image> search(Function1<Image, Object> f) {
        return Docker.search$(this, f);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.postStop$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public ExecutionContextExecutor eCtxt() {
        return this.eCtxt;
    }

    @Override
    public DockerClient client() {
        return this.client;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public LoggingAdapter logger() {
        return this.logger;
    }

    public ActorRef mapper() {
        return this.context().actorOf(Props$.MODULE$.apply((Function0 & Serializable)() -> new DockerContainerMapperActor(), ClassTag$.MODULE$.apply(DockerContainerMapperActor.class)));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return LoggingReceive$.MODULE$.apply((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerManagerActor $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StartContainerManager) {
                    BoxedUnit boxedUnit;
                    StartContainerManager startContainerManager = (StartContainerManager)A1;
                    Map<String, ContainerUnderTest> containers = startContainerManager.containerUnderTest();
                    ActorRef requestor = this.$outer.sender();
                    boolean externalCt = this.$outer.config().getBoolean("docker.external");
                    this.$outer.log().info(new StringBuilder(43).append("Containers have been started externally: [").append(externalCt).append("]").toString());
                    ActorRef dockerHandler = this.$outer.context().actorOf(DockerContainerHandler$.MODULE$.props(this.$outer.client()), "DockerHandler");
                    boolean bl = externalCt;
                    if (bl) {
                        akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.self()).$bang((Object)new InternalContainersStarted((Either<Exception, Map<String, ContainerUnderTest>>)package$.MODULE$.Right().apply(this.$outer.blended$itestsupport$docker$ContainerManagerActor$$configureDockerContainer(containers))), this.$outer.self());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = akka.pattern.package$.MODULE$.pipe(AskableActorRef$.MODULE$.$qmark$extension(akka.pattern.package$.MODULE$.ask(dockerHandler), (Object)new InternalStartContainers(this.$outer.blended$itestsupport$docker$ContainerManagerActor$$configureDockerContainer(containers)), this.$outer.timeout(), this.$outer.self()), (ExecutionContext)this.$outer.eCtxt()).pipeTo(this.$outer.self(), this.$outer.self());
                    }
                    this.$outer.context().become(this.$outer.starting(dockerHandler, requestor));
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof StartContainerManager;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.context());
    }

    public PartialFunction<Object, BoxedUnit> starting(ActorRef dockerHandler, ActorRef requestor) {
        return LoggingReceive$.MODULE$.apply((PartialFunction)new Serializable(this, requestor, dockerHandler){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerManagerActor $outer;
            private final ActorRef requestor$1;
            private final ActorRef dockerHandler$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InternalContainersStarted) {
                    InternalContainersStarted internalContainersStarted = (InternalContainersStarted)A1;
                    Either<Exception, Map<String, ContainerUnderTest>> either = internalContainersStarted.result();
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        Map cuts = (Map)right.value();
                        akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.mapper()).$bang((Object)new InternalMapDockerContainers(this.$outer.self(), (Map<String, ContainerUnderTest>)cuts, this.$outer.client()), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        akka.actor.package$.MODULE$.actorRef2Scala(this.requestor$1).$bang(internalContainersStarted.result(), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof InternalDockerContainersMapped) {
                    InternalDockerContainersMapped internalDockerContainersMapped = (InternalDockerContainersMapped)A1;
                    this.$outer.log().info(new StringBuilder(68).append("Container Manager started with docker attached docker containers: [").append(internalDockerContainersMapped.result()).append("]").toString());
                    akka.actor.package$.MODULE$.actorRef2Scala(this.requestor$1).$bang((Object)new ContainerManagerStarted(internalDockerContainersMapped.result()), this.$outer.self());
                    Either<Exception, Map<String, ContainerUnderTest>> either = internalDockerContainersMapped.result();
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        Map cuts = (Map)right.value();
                        this.$outer.context().become(this.$outer.running(this.dockerHandler$1, (Map<String, ContainerUnderTest>)cuts));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.$outer.context().stop(this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof InternalContainersStarted ? true : object instanceof InternalDockerContainersMapped;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requestor$1 = requestor$1;
                this.dockerHandler$1 = dockerHandler$1;
            }
        }, this.context());
    }

    public PartialFunction<Object, BoxedUnit> running(ActorRef dockerHandler, Map<String, ContainerUnderTest> cuts) {
        return LoggingReceive$.MODULE$.apply((PartialFunction)new Serializable(this, dockerHandler){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerManagerActor $outer;
            private final ActorRef dockerHandler$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof GetContainerDirectory) {
                    GetContainerDirectory getContainerDirectory = (GetContainerDirectory)A1;
                    this.dockerHandler$2.tell((Object)getContainerDirectory, this.$outer.sender());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof WriteContainerDirectory) {
                    WriteContainerDirectory writeContainerDirectory = (WriteContainerDirectory)A1;
                    this.dockerHandler$2.tell((Object)writeContainerDirectory, this.$outer.sender());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ExecuteContainerCommand) {
                    ExecuteContainerCommand executeContainerCommand = (ExecuteContainerCommand)A1;
                    this.dockerHandler$2.tell((Object)executeContainerCommand, this.$outer.sender());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof StopContainerManager) {
                    StopContainerManager stopContainerManager = (StopContainerManager)A1;
                    this.$outer.log().info("Stopping Test Container Manager");
                    this.dockerHandler$2.forward((Object)stopContainerManager, this.$outer.context());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof GetContainerDirectory ? true : (object instanceof WriteContainerDirectory ? true : (object instanceof ExecuteContainerCommand ? true : object instanceof StopContainerManager));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dockerHandler$2 = dockerHandler$2;
            }
        }, this.context());
    }

    public Map<String, ContainerUnderTest> blended$itestsupport$docker$ContainerManagerActor$$configureDockerContainer(Map<String, ContainerUnderTest> cut) {
        Iterable cuts = (Iterable)cut.values().flatMap((Function1 & Serializable)ct -> {
            Function1<Image, Object> searchImg = this.searchByTag(ct.imgPattern());
            List<Image> found = this.search(searchImg);
            return ((List)found.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                String ctName;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Image img = (Image)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String x$1 = ctName = new StringBuilder(1).append(ct.ctName()).append("_").append(idx).toString();
                String x$2 = new StringBuilder(1).append(ctName).append("_").append(System.currentTimeMillis()).toString();
                String x$3 = img.getId();
                String x$4 = ct.copy$default$2();
                List<VolumeConfig> x$5 = ct.copy$default$5();
                List<ContainerLink> x$6 = ct.copy$default$6();
                Map<String, NamedContainerPort> x$7 = ct.copy$default$7();
                Map<String, String> x$8 = ct.copy$default$8();
                ContainerUnderTest containerUnderTest = ct.copy(x$1, x$4, x$3, x$2, x$5, x$6, x$7, x$8);
                return containerUnderTest;
            });
        });
        return ((IterableOnceOps)cuts.map((Function1 & Serializable)ct -> new Tuple2((Object)ct.ctName(), ct))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public ContainerManagerActor() {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        Docker.$init$(this);
        this.timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(60)).seconds());
        this.eCtxt = this.context().dispatcher();
        this.client = ((DockerClientProvider)((Object)this)).getClient();
        this.config = this.context().system().settings().config();
        this.logger = this.context().system().log();
        Statics.releaseFence();
    }

    public static interface Protocol {
    }
}

