/*
 * Decompiled with CFR 0.152.
 */
package blended.itestsupport.docker;

import blended.itestsupport.ContainerUnderTest;
import blended.itestsupport.NamedContainerPort;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\u0007\u000f\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tC\u0001\u0011\t\u0011)A\u0006E!)a\u0006\u0001C\u0001_!1Q\u0007\u0001Q\u0001\nYBQA\u0010\u0001\u0005\u0002}BQ\u0001\u0011\u0001\u0005\u0002\u0005CQa\u001b\u0001\u0005\u00021DQ!\u001e\u0001\u0005\u0002YDQ\u0001 \u0001\u0005\u0002uDq!!\u0006\u0001\t\u0003\t9\u0002C\u0004\u0002 \u0001!\t!!\t\t\r\u0005=\u0002\u0001\"\u0001@\u0005=!unY6fe\u000e{g\u000e^1j]\u0016\u0014(BA\b\u0011\u0003\u0019!wnY6fe*\u0011\u0011CE\u0001\rSR,7\u000f^:vaB|'\u000f\u001e\u0006\u0002'\u00059!\r\\3oI\u0016$7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017aA2viB\u0011adH\u0007\u0002!%\u0011\u0001\u0005\u0005\u0002\u0013\u0007>tG/Y5oKJ,f\u000eZ3s)\u0016\u001cH/\u0001\u0004dY&,g\u000e\u001e\t\u0003G1j\u0011\u0001\n\u0006\u0003K\u0019\n1!\u00199j\u0015\t9\u0003&\u0001\u0006e_\u000e\\WM\u001d6bm\u0006T!!\u000b\u0016\u0002\r\u001dLG\u000f[;c\u0015\u0005Y\u0013aA2p[&\u0011Q\u0006\n\u0002\r\t>\u001c7.\u001a:DY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\"DCA\u00194!\t\u0011\u0004!D\u0001\u000f\u0011\u0015\t3\u0001q\u0001#\u0011\u0015a2\u00011\u0001\u001e\u0003\u0019awnZ4feB\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\bY><w-\u001b8h\u0015\tY$#\u0001\u0003vi&d\u0017BA\u001f9\u0005\u0019aunZ4fe\u0006q1\u000f^1si\u000e{g\u000e^1j]\u0016\u0014X#A\u0019\u0002\u001d\u0015DXmY;uK\u000e{W.\\1oIR\u0019!\t\u001a4\u0011\t\r[e*\u0015\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!a\u0012\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012B\u0001&\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\r\u0015KG\u000f[3s\u0015\tQ\u0005\u0004\u0005\u0002D\u001f&\u0011\u0001+\u0014\u0002\n)\"\u0014xn^1cY\u0016\u0004Ra\u0006*U9rK!a\u0015\r\u0003\rQ+\b\u000f\\34!\t)\u0016L\u0004\u0002W/B\u0011Q\tG\u0005\u00031b\ta\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001\f\u0007\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\f!![8\u000b\u0003\u0005\fAA[1wC&\u00111M\u0018\u0002\u0016\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u0011\u0015)g\u00011\u0001U\u0003\u0011)8/\u001a:\t\u000b\u001d4\u0001\u0019\u00015\u0002\u0007\rlG\rE\u0002\u0018SRK!A\u001b\r\u0003\u0015q\u0012X\r]3bi\u0016$g(A\u0006j]N\u0004Xm\u0019;Fq\u0016\u001cGCA7t!\tq\u0017/D\u0001p\u0015\t\u0001H%A\u0004d_6l\u0017M\u001c3\n\u0005I|'aE%ogB,7\r^#yK\u000e\u0014Vm\u001d9p]N,\u0007\"\u0002;\b\u0001\u0004!\u0016AA5e\u0003U9W\r^\"p]R\f\u0017N\\3s\t&\u0014Xm\u0019;pef$\"a\u001e>\u0011\u0005uC\u0018BA=_\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000bmD\u0001\u0019\u0001+\u0002\u0007\u0011L'/A\fxe&$XmQ8oi\u0006Lg.\u001a:ESJ,7\r^8ssR)a0a\u0001\u0002\u0006A\u0011qc`\u0005\u0004\u0003\u0003A\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006w&\u0001\r\u0001\u0016\u0005\b\u0003\u000fI\u0001\u0019AA\u0005\u0003\u001d\u0019wN\u001c;f]R\u0004RaFA\u0006\u0003\u001fI1!!\u0004\u0019\u0005\u0015\t%O]1z!\r9\u0012\u0011C\u0005\u0004\u0003'A\"\u0001\u0002\"zi\u0016\fQbY8oi\u0006Lg.\u001a:J]\u001a|WCAA\r!\rq\u00171D\u0005\u0004\u0003;y'\u0001G%ogB,7\r^\"p]R\f\u0017N\\3s%\u0016\u001c\bo\u001c8tK\u0006y!/Z7pm\u0016\u001cuN\u001c;bS:,'/\u0006\u0002\u0002$A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*\u0001\fA\u0001\\1oO&!\u0011QFA\u0014\u0005\u00111v.\u001b3\u0002\u001bM$x\u000e]\"p]R\f\u0017N\\3s\u0001")
public class DockerContainer {
    private final ContainerUnderTest cut;
    private final DockerClient client;
    private final Logger logger;

    public DockerContainer startContainer() {
        List links = this.cut.links().map((Function1 & Serializable)l -> Link.parse((String)new StringBuilder(1).append(l.container()).append(":").append(l.hostname()).toString()));
        this.logger.info((Function0 & Serializable)() -> new StringBuilder(28).append("Links for container [").append($this.cut.dockerName()).append("] : [").append(links).append("].").toString());
        PortBinding[] ports = (PortBinding[])((IterableOnceOps)this.cut.ports().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            NamedContainerPort p = (NamedContainerPort)tuple2._2();
            PortBinding portBinding = p.binding();
            return portBinding;
        })).toArray(ClassTag$.MODULE$.apply(PortBinding.class));
        this.logger.info((Function0 & Serializable)() -> new StringBuilder(28).append("Ports for container [").append($this.cut.dockerName()).append("] : [").append($this.cut.ports()).append("].").toString());
        String[] env = (String[])((IterableOnceOps)this.cut.env().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        })).toArray(ClassTag$.MODULE$.apply(String.class));
        CreateContainerCmd containerCmd = this.client.createContainerCmd(this.cut.imgId()).withName(this.cut.dockerName()).withTty(Predef$.MODULE$.boolean2Boolean(true)).withPortBindings(ports).withEnv(env);
        Object object = !links.isEmpty() ? containerCmd.withLinks((Link[])links.toArray(ClassTag$.MODULE$.apply(Link.class))) : BoxedUnit.UNIT;
        containerCmd.exec();
        this.client.startContainerCmd(this.cut.dockerName()).exec();
        return this;
    }

    public Either<Throwable, Tuple3<String, ByteArrayOutputStream, ByteArrayOutputStream>> executeCommand(String user, Seq<String> cmd) {
        Left left;
        this.logger.info((Function0 & Serializable)() -> new StringBuilder(28).append("Executing cmd [").append(cmd.foldLeft((Object)"", (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String v = (String)tuple2._1();
            String e = (String)tuple2._2();
            String string = new StringBuilder(1).append(v).append(" ").append(e).toString();
            return string;
        })).append("] for user [").append(user).append("]").toString());
        try {
            ExecCreateCmd command = this.client.execCreateCmd(this.cut.dockerName()).withUser(user).withCmd((String[])cmd.toArray(ClassTag$.MODULE$.apply(String.class))).withAttachStdout(Predef$.MODULE$.boolean2Boolean(true)).withAttachStderr(Predef$.MODULE$.boolean2Boolean(true));
            String execId = ((ExecCreateCmdResponse)command.exec()).getId();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ExecStartResultCallback rcb = new ExecStartResultCallback((OutputStream)out, (OutputStream)err);
            ExecStartCmd startExec = this.client.execStartCmd(execId).withTty(Predef$.MODULE$.boolean2Boolean(true));
            startExec.exec((ResultCallback)rcb);
            left = package$.MODULE$.Right().apply((Object)new Tuple3((Object)execId, (Object)out, (Object)err));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left2 = package$.MODULE$.Left().apply((Object)e);
            left = left2;
        }
        return left;
    }

    public InspectExecResponse inspectExec(String id) {
        return this.client.inspectExecCmd(id).withExecId(id).exec();
    }

    public InputStream getContainerDirectory(String dir) {
        this.logger.info((Function0 & Serializable)() -> new StringBuilder(38).append("Getting directory [").append(dir).append("] from container [").append($this.cut.ctName()).append("]").toString());
        return this.client.copyArchiveFromContainerCmd(this.cut.dockerName(), dir).exec();
    }

    public boolean writeContainerDirectory(String dir, byte[] content) {
        boolean bl;
        try {
            this.logger.info((Function0 & Serializable)() -> new StringBuilder(58).append("Writing archive of size [").append(content.length).append("] to directory [").append(dir).append("] in container [").append($this.cut.ctName()).append("]").toString());
            CopyArchiveToContainerCmd cmd = this.client.copyArchiveToContainerCmd(this.cut.dockerName());
            cmd.withRemotePath(dir).withTarInputStream((InputStream)new ByteArrayInputStream(content));
            cmd.exec();
            bl = true;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            this.logger.warn(t, true, (Function0 & Serializable)() -> new StringBuilder(38).append("Failed to write container directory [").append(dir).append("]").toString());
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public InspectContainerResponse containerInfo() {
        return this.client.inspectContainerCmd(this.cut.dockerName()).exec();
    }

    public Void removeContainer() {
        this.logger.info((Function0 & Serializable)() -> new StringBuilder(34).append("Removing container [").append($this.cut.dockerName()).append("] from Docker.").toString());
        return this.client.removeContainerCmd(this.cut.dockerName()).withForce(Predef$.MODULE$.boolean2Boolean(true)).withRemoveVolumes(Predef$.MODULE$.boolean2Boolean(true)).exec();
    }

    public DockerContainer stopContainer() {
        this.logger.info((Function0 & Serializable)() -> new StringBuilder(21).append("Stopping container [").append($this.cut.dockerName()).append("]").toString());
        this.client.stopContainerCmd(this.cut.dockerName()).exec();
        return this;
    }

    public DockerContainer(ContainerUnderTest cut, DockerClient client) {
        this.cut = cut;
        this.client = client;
        this.logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(DockerContainer.class));
    }
}

