/*
 * Decompiled with CFR 0.152.
 */
package blended.itestsupport.compress;

import blended.util.io.StreamCopy$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class TarFileSupport$ {
    public static final TarFileSupport$ MODULE$ = new TarFileSupport$();
    private static final Logger log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(TarFileSupport$.class));

    public Map<String, byte[]> untar(InputStream is) {
        ArchiveInputStream tar = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));
        scala.collection.mutable.Map content = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        ObjectRef entry = ObjectRef.create((Object)Option$.MODULE$.apply((Object)tar.getNextEntry()));
        while (((Option)entry.elem).isDefined()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamCopy$.MODULE$.copy((InputStream)tar, (OutputStream)bos);
            bos.close();
            log.debug((Function0 & Serializable)() -> new StringBuilder(22).append("Extracted [").append(((ArchiveEntry)((Option)entry$1.elem).get()).getName()).append("], size [").append(bos.size()).append("].").toString());
            content.put((Object)((ArchiveEntry)((Option)entry.elem).get()).getName(), (Object)bos.toByteArray());
            entry.elem = Option$.MODULE$.apply((Object)tar.getNextEntry());
        }
        tar.close();
        is.close();
        return content.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void tar(File file, OutputStream os, int user, int group) {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        BufferedOutputStream bOut = new BufferedOutputStream(os);
        TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)bOut);
        try {
            this.addFileToTar$1(tarOut, file, "", user, group);
        }
        finally {
            tarOut.finish();
            tarOut.close();
            bOut.close();
            os.close();
        }
    }

    public int tar$default$3() {
        return 0;
    }

    public int tar$default$4() {
        return 0;
    }

    private final void addFileToTar$1(TarArchiveOutputStream tarOs, File file, String base, int user$1, int group$1) {
        String entryName = new StringBuilder(0).append(base).append(file.getName()).toString();
        TarArchiveEntry entry = new TarArchiveEntry(file, entryName);
        entry.setUserId(user$1);
        entry.setGroupId(group$1);
        log.info((Function0 & Serializable)() -> new StringBuilder(48).append("Adding [").append(entryName).append("] to tar archive with [user(").append(user$1).append("), group(").append(group$1).append(")].").toString());
        tarOs.putArchiveEntry((ArchiveEntry)entry);
        if (file.isFile()) {
            StreamCopy$.MODULE$.copy((InputStream)new FileInputStream(file), (OutputStream)tarOs);
            tarOs.closeArchiveEntry();
        } else {
            tarOs.closeArchiveEntry();
            Option files = Option$.MODULE$.apply((Object)file.listFiles());
            files.map((Function1 & Serializable)ff -> {
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ff), (Function1 & Serializable)f -> {
                    $this.addFileToTar$1(tarOs$1, f, new StringBuilder(1).append(entryName$1).append("/").toString(), user$1, group$1);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
    }

    private TarFileSupport$() {
    }
}

