/*
 * Decompiled with CFR 0.152.
 */
package blended.itestsupport.docker;

import blended.itestsupport.ContainerUnderTest;
import blended.itestsupport.NamedContainerPort;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u0001%\u0011q\u0002R8dW\u0016\u00148i\u001c8uC&tWM\u001d\u0006\u0003\u0007\u0011\ta\u0001Z8dW\u0016\u0014(BA\u0003\u0007\u00031IG/Z:ugV\u0004\bo\u001c:u\u0015\u00059\u0011a\u00022mK:$W\rZ\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\t#\u0001\u0011\t\u0011)A\u0005%\u0005\u00191-\u001e;\u0011\u0005M!R\"\u0001\u0003\n\u0005U!!AE\"p]R\f\u0017N\\3s+:$WM\u001d+fgRD\u0001b\u0006\u0001\u0003\u0002\u0003\u0006Y\u0001G\u0001\u0007G2LWM\u001c;\u0011\u0005e\u0011S\"\u0001\u000e\u000b\u0005ma\u0012aA1qS*\u0011QDH\u0001\u000bI>\u001c7.\u001a:kCZ\f'BA\u0010!\u0003\u00199\u0017\u000e\u001e5vE*\t\u0011%A\u0002d_6L!a\t\u000e\u0003\u0019\u0011{7m[3s\u00072LWM\u001c;\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t93\u0006\u0006\u0002)UA\u0011\u0011\u0006A\u0007\u0002\u0005!)q\u0003\na\u00021!)\u0011\u0003\na\u0001%!1Q\u0006\u0001Q\u0001\n9\na\u0001\\8hO\u0016\u0014\bCA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0019\u0014aA8sO&\u0011Q\u0007\r\u0002\u0007\u0019><w-\u001a:\t\u000b]\u0002A\u0011\u0001\u001d\u0002\u001dM$\u0018M\u001d;D_:$\u0018-\u001b8feV\t\u0001\u0006C\u0003;\u0001\u0011\u00051(\u0001\bfq\u0016\u001cW\u000f^3D_6l\u0017M\u001c3\u0015\u0007qr\u0006\r\u0005\u0003>\u000b\"[eB\u0001 D\u001d\ty$)D\u0001A\u0015\t\t\u0005\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u0011A\tD\u0001\ba\u0006\u001c7.Y4f\u0013\t1uI\u0001\u0004FSRDWM\u001d\u0006\u0003\t2\u0001\"!P%\n\u0005);%!\u0003+ie><\u0018M\u00197f!\u0015YAJ\u0014,W\u0013\tiEB\u0001\u0004UkBdWm\r\t\u0003\u001fNs!\u0001U)\u0011\u0005}b\u0011B\u0001*\r\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ic\u0001CA,]\u001b\u0005A&BA-[\u0003\tIwNC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&!\u0006\"zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0006?f\u0002\rAT\u0001\u0005kN,'\u000fC\u0003bs\u0001\u0007!-A\u0002d[\u0012\u00042aC2O\u0013\t!GB\u0001\u0006=e\u0016\u0004X-\u0019;fIzBQA\u001a\u0001\u0005\u0002\u001d\f1\"\u001b8ta\u0016\u001cG/\u0012=fGR\u0011\u0001N\u001c\t\u0003S2l\u0011A\u001b\u0006\u0003Wj\tqaY8n[\u0006tG-\u0003\u0002nU\n\u0019\u0012J\\:qK\u000e$X\t_3d%\u0016\u001c\bo\u001c8tK\")q.\u001aa\u0001\u001d\u0006\u0011\u0011\u000e\u001a\u0005\u0006c\u0002!\tA]\u0001\u0016O\u0016$8i\u001c8uC&tWM\u001d#je\u0016\u001cGo\u001c:z)\t\u0019h\u000f\u0005\u0002Xi&\u0011Q\u000f\u0017\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003xa\u0002\u0007a*A\u0002eSJDQ!\u001f\u0001\u0005\u0002i\fqc\u001e:ji\u0016\u001cuN\u001c;bS:,'\u000fR5sK\u000e$xN]=\u0015\u0007mtx\u0010\u0005\u0002\fy&\u0011Q\u0010\u0004\u0002\b\u0005>|G.Z1o\u0011\u00159\b\u00101\u0001O\u0011\u001d\t\t\u0001\u001fa\u0001\u0003\u0007\tqaY8oi\u0016tG\u000fE\u0003\f\u0003\u000b\tI!C\u0002\u0002\b1\u0011Q!\u0011:sCf\u00042aCA\u0006\u0013\r\ti\u0001\u0004\u0002\u0005\u0005f$X\rC\u0004\u0002\u0012\u0001!\t!a\u0005\u0002\u001b\r|g\u000e^1j]\u0016\u0014\u0018J\u001c4p+\t\t)\u0002E\u0002j\u0003/I1!!\u0007k\u0005aIen\u001d9fGR\u001cuN\u001c;bS:,'OU3ta>t7/\u001a\u0005\b\u0003;\u0001A\u0011AA\u0010\u0003=\u0011X-\\8wK\u000e{g\u000e^1j]\u0016\u0014XCAA\u0011!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u00145\u0006!A.\u00198h\u0013\u0011\tY#!\n\u0003\tY{\u0017\u000e\u001a\u0005\u0007\u0003_\u0001A\u0011\u0001\u001d\u0002\u001bM$x\u000e]\"p]R\f\u0017N\\3s\u0001")
public class DockerContainer {
    private final ContainerUnderTest cut;
    private final DockerClient client;
    private final Logger logger;

    public DockerContainer startContainer() {
        List links = (List)this.cut.links().map((Function1 & Serializable & scala.Serializable)l -> Link.parse((String)new StringBuilder(1).append(l.container()).append(":").append(l.hostname()).toString()), List$.MODULE$.canBuildFrom());
        this.logger.info(new StringBuilder(28).append("Links for container [").append(this.cut.dockerName()).append("] : [").append(links).append("].").toString());
        PortBinding[] ports = (PortBinding[])((TraversableOnce)this.cut.ports().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            NamedContainerPort p = (NamedContainerPort)tuple2._2();
            PortBinding portBinding = p.binding();
            return portBinding;
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(PortBinding.class));
        this.logger.info(new StringBuilder(28).append("Ports for container [").append(this.cut.dockerName()).append("] : [").append(this.cut.ports()).append("].").toString());
        String[] env = (String[])((TraversableOnce)this.cut.env().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        CreateContainerCmd containerCmd = this.client.createContainerCmd(this.cut.imgId()).withName(this.cut.dockerName()).withTty(Predef$.MODULE$.boolean2Boolean(true)).withPortBindings(ports).withEnv(env);
        Object object = !links.isEmpty() ? containerCmd.withLinks((Link[])links.toArray(ClassTag$.MODULE$.apply(Link.class))) : BoxedUnit.UNIT;
        containerCmd.exec();
        this.client.startContainerCmd(this.cut.dockerName()).exec();
        return this;
    }

    public Either<Throwable, Tuple3<String, ByteArrayOutputStream, ByteArrayOutputStream>> executeCommand(String user, Seq<String> cmd) {
        Left left;
        this.logger.info(new StringBuilder(28).append("Executing cmd [").append(cmd.foldLeft((Object)"", (Function2 & Serializable & scala.Serializable)(x0$3, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$3, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String v = (String)tuple2._1();
            String e = (String)tuple2._2();
            String string = new StringBuilder(1).append(v).append(" ").append(e).toString();
            return string;
        })).append("] for user [").append(user).append("]").toString());
        try {
            ExecCreateCmd command = this.client.execCreateCmd(this.cut.dockerName()).withUser(user).withCmd((String[])cmd.toArray(ClassTag$.MODULE$.apply(String.class))).withAttachStdout(Predef$.MODULE$.boolean2Boolean(true)).withAttachStderr(Predef$.MODULE$.boolean2Boolean(true));
            String execId = ((ExecCreateCmdResponse)command.exec()).getId();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ExecStartResultCallback rcb = new ExecStartResultCallback((OutputStream)out, (OutputStream)err);
            ExecStartCmd startExec = this.client.execStartCmd(execId).withTty(Predef$.MODULE$.boolean2Boolean(true));
            startExec.exec((ResultCallback)rcb);
            left = package$.MODULE$.Right().apply((Object)new Tuple3((Object)execId, (Object)out, (Object)err));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left2 = package$.MODULE$.Left().apply((Object)e);
            left = left2;
        }
        return left;
    }

    public InspectExecResponse inspectExec(String id) {
        return this.client.inspectExecCmd(id).withExecId(id).exec();
    }

    public InputStream getContainerDirectory(String dir) {
        this.logger.info(new StringBuilder(38).append("Getting directory [").append(dir).append("] from container [").append(this.cut.ctName()).append("]").toString());
        return this.client.copyArchiveFromContainerCmd(this.cut.dockerName(), dir).exec();
    }

    public boolean writeContainerDirectory(String dir, byte[] content) {
        boolean bl;
        try {
            this.logger.info(new StringBuilder(58).append("Writing archive of size [").append(content.length).append("] to directory [").append(dir).append("] in container [").append(this.cut.ctName()).append("]").toString());
            CopyArchiveToContainerCmd cmd = this.client.copyArchiveToContainerCmd(this.cut.dockerName());
            cmd.withRemotePath(dir).withTarInputStream((InputStream)new ByteArrayInputStream(content));
            cmd.exec();
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public InspectContainerResponse containerInfo() {
        return this.client.inspectContainerCmd(this.cut.dockerName()).exec();
    }

    public Void removeContainer() {
        this.logger.info(new StringBuilder(34).append("Removing container [").append(this.cut.dockerName()).append("] from Docker.").toString());
        return this.client.removeContainerCmd(this.cut.dockerName()).withForce(Predef$.MODULE$.boolean2Boolean(true)).withRemoveVolumes(Predef$.MODULE$.boolean2Boolean(true)).exec();
    }

    public DockerContainer stopContainer() {
        this.logger.info(new StringBuilder(21).append("Stopping container [").append(this.cut.dockerName()).append("]").toString());
        this.client.stopContainerCmd(this.cut.dockerName()).exec();
        return this;
    }

    public DockerContainer(ContainerUnderTest cut, DockerClient client) {
        this.cut = cut;
        this.client = client;
        this.logger = LoggerFactory.getLogger((String)DockerContainer.class.getName());
    }
}

