/*
 * Decompiled with CFR 0.152.
 */
package blended.itestsupport.docker;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.event.LoggingReceive$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import blended.itestsupport.ContainerLink;
import blended.itestsupport.ContainerUnderTest;
import blended.itestsupport.NamedContainerPort;
import blended.itestsupport.VolumeConfig;
import blended.itestsupport.docker.Docker;
import blended.itestsupport.docker.DockerClientProvider;
import blended.itestsupport.docker.DockerContainerHandler;
import blended.itestsupport.docker.DockerContainerMapper;
import blended.itestsupport.docker.InternalContainersStarted;
import blended.itestsupport.docker.InternalDockerContainersMapped;
import blended.itestsupport.docker.InternalMapDockerContainers;
import blended.itestsupport.docker.InternalStartContainers;
import blended.itestsupport.docker.protocol.ContainerManagerStarted;
import blended.itestsupport.docker.protocol.ExecuteContainerCommand;
import blended.itestsupport.docker.protocol.GetContainerDirectory;
import blended.itestsupport.docker.protocol.StartContainerManager;
import blended.itestsupport.docker.protocol.StopContainerManager;
import blended.itestsupport.docker.protocol.WriteContainerDirectory;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015cAB\u0001\u0003\u0001%\tID\u0001\tD_:$\u0018-\u001b8fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007I>\u001c7.\u001a:\u000b\u0005\u00151\u0011\u0001D5uKN$8/\u001e9q_J$(\"A\u0004\u0002\u000f\tdWM\u001c3fI\u000e\u00011#\u0002\u0001\u000b!aY\u0002CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005)\u0011m\u0019;pe*\tQ#\u0001\u0003bW.\f\u0017BA\f\u0013\u0005\u0015\t5\r^8s!\t\t\u0012$\u0003\u0002\u001b%\ta\u0011i\u0019;pe2{wmZ5oOB\u0011A$H\u0007\u0002\u0005%\u0011aD\u0001\u0002\u0007\t>\u001c7.\u001a:\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\u0005\u0011\u0003C\u0001\u000f\u0001\u0011\u001d!\u0003A1A\u0005\u0004\u0015\nq\u0001^5nK>,H/F\u0001'!\t9#&D\u0001)\u0015\tIC#\u0001\u0003vi&d\u0017BA\u0016)\u0005\u001d!\u0016.\\3pkRDa!\f\u0001!\u0002\u00131\u0013\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\t\u000f=\u0002!\u0019!C\u0002a\u0005)Qm\u0011;yiV\t\u0011\u0007\u0005\u00023k5\t1G\u0003\u00025\u0019\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Y\u001a$\u0001G#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;pe\"1\u0001\b\u0001Q\u0001\nE\na!Z\"uqR\u0004\u0003b\u0002\u001e\u0001\u0005\u0004%\taO\u0001\u0007G2LWM\u001c;\u0016\u0003q\u0002\"!\u0010$\u000e\u0003yR!a\u0010!\u0002\u0007\u0005\u0004\u0018N\u0003\u0002B\u0005\u0006QAm\\2lKJT\u0017M^1\u000b\u0005\r#\u0015AB4ji\",(MC\u0001F\u0003\r\u0019w.\\\u0005\u0003\u000fz\u0012A\u0002R8dW\u0016\u00148\t\\5f]RDa!\u0013\u0001!\u0002\u0013a\u0014aB2mS\u0016tG\u000f\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0011M\u0003\u0019\u0019wN\u001c4jOV\tQ\n\u0005\u0002O%6\tqJ\u0003\u0002L!*\u0011\u0011\u000bR\u0001\tif\u0004Xm]1gK&\u00111k\u0014\u0002\u0007\u0007>tg-[4\t\rU\u0003\u0001\u0015!\u0003N\u0003\u001d\u0019wN\u001c4jO\u0002Bqa\u0016\u0001C\u0002\u0013\u0005\u0003,\u0001\u0004m_\u001e<WM]\u000b\u00023B\u0011!,X\u0007\u00027*\u0011A\fF\u0001\u0006KZ,g\u000e^\u0005\u0003=n\u0013a\u0002T8hO&tw-\u00113baR,'\u000f\u0003\u0004a\u0001\u0001\u0006I!W\u0001\bY><w-\u001a:!\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003\u0019i\u0017\r\u001d9feV\tA\r\u0005\u0002\u0012K&\u0011aM\u0005\u0002\t\u0003\u000e$xN\u001d*fM\")\u0001\u000e\u0001C\u0001S\u00069!/Z2fSZ,W#\u00016\u0011\u0005-,hB\u00017t\u001d\ti'O\u0004\u0002oc6\tqN\u0003\u0002q\u0011\u00051AH]8pizJ\u0011!F\u0005\u0003'QI!\u0001\u001e\n\u0002\u000b\u0005\u001bGo\u001c:\n\u0005Y<(a\u0002*fG\u0016Lg/\u001a\u0006\u0003iJAQ!\u001f\u0001\u0005\u0002i\f\u0001b\u001d;beRLgn\u001a\u000b\u0005wz\f\t\u0001\u0005\u0002}{6\t\u0001!\u0003\u0002w-!)q\u0010\u001fa\u0001I\u0006iAm\\2lKJD\u0015M\u001c3mKJDa!a\u0001y\u0001\u0004!\u0017!\u0003:fcV,7\u000f^8s\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\tqA];o]&tw\rF\u0003|\u0003\u0017\ti\u0001\u0003\u0004\u0000\u0003\u000b\u0001\r\u0001\u001a\u0005\t\u0003\u001f\t)\u00011\u0001\u0002\u0012\u0005!1-\u001e;t!!\t\u0019\"a\u0007\u0002\"\u0005\u001db\u0002BA\u000b\u0003/\u0001\"A\u001c\u0007\n\u0007\u0005eA\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\tyBA\u0002NCBT1!!\u0007\r!\u0011\t\u0019\"a\t\n\t\u0005\u0015\u0012q\u0004\u0002\u0007'R\u0014\u0018N\\4\u0011\t\u0005%\u00121F\u0007\u0002\t%\u0019\u0011Q\u0006\u0003\u0003%\r{g\u000e^1j]\u0016\u0014XK\u001c3feR+7\u000f\u001e\u0005\t\u0003c\u0001\u0001\u0015\"\u0003\u00024\u0005A2m\u001c8gS\u001e,(/\u001a#pG.,'oQ8oi\u0006Lg.\u001a:\u0015\t\u0005E\u0011Q\u0007\u0005\t\u0003o\ty\u00031\u0001\u0002\u0012\u0005\u00191-\u001e;\u0013\u000b\u0005m\"%a\u0010\u0007\r\u0005u\u0002\u0001AA\u001d\u00051a$/\u001a4j]\u0016lWM\u001c;?!\ra\u0012\u0011I\u0005\u0004\u0003\u0007\u0012!\u0001\u0006#pG.,'o\u00117jK:$\bK]8wS\u0012,'\u000f")
public class ContainerManager
implements Actor,
ActorLogging,
Docker {
    private final Timeout timeout;
    private final ExecutionContextExecutor eCtxt;
    private final DockerClient client;
    private final Config config;
    private final LoggingAdapter logger;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public Function1<Image, Object> searchByTag(String s) {
        return Docker.searchByTag$(this, s);
    }

    @Override
    public List<Image> images() {
        return Docker.images$(this);
    }

    @Override
    public List<Container> running() {
        return Docker.running$(this);
    }

    @Override
    public List<Image> search(Function1<Image, Object> f) {
        return Docker.search$(this, f);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.postStop$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public ExecutionContextExecutor eCtxt() {
        return this.eCtxt;
    }

    @Override
    public DockerClient client() {
        return this.client;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public LoggingAdapter logger() {
        return this.logger;
    }

    public ActorRef mapper() {
        return this.context().actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DockerContainerMapper(), ClassTag$.MODULE$.apply(DockerContainerMapper.class)));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return LoggingReceive$.MODULE$.apply((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerManager $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StartContainerManager) {
                    BoxedUnit boxedUnit;
                    StartContainerManager startContainerManager = (StartContainerManager)A1;
                    Map<String, ContainerUnderTest> containers = startContainerManager.containerUnderTest();
                    ActorRef requestor = this.$outer.sender();
                    boolean externalCt = this.$outer.config().getBoolean("docker.external");
                    this.$outer.log().info(new StringBuilder(43).append("Containers have been started externally: [").append(externalCt).append("]").toString());
                    ActorRef dockerHandler = this.$outer.context().actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DockerContainerHandler($this.$outer.client()), ClassTag$.MODULE$.apply(DockerContainerHandler.class)), "DockerHandler");
                    boolean bl = externalCt;
                    if (bl) {
                        akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.self()).$bang((Object)new InternalContainersStarted((Either<Exception, Map<String, ContainerUnderTest>>)package$.MODULE$.Right().apply(this.$outer.blended$itestsupport$docker$ContainerManager$$configureDockerContainer(containers))), this.$outer.self());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = akka.pattern.package$.MODULE$.pipe(AskableActorRef$.MODULE$.$qmark$extension1(akka.pattern.package$.MODULE$.ask(dockerHandler), (Object)new InternalStartContainers(this.$outer.blended$itestsupport$docker$ContainerManager$$configureDockerContainer(containers)), this.$outer.timeout(), this.$outer.self()), (ExecutionContext)this.$outer.eCtxt()).pipeTo(this.$outer.self(), this.$outer.self());
                    }
                    this.$outer.context().become(this.$outer.starting(dockerHandler, this.$outer.sender()));
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof StartContainerManager;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(blended.itestsupport.docker.ContainerManager$$anonfun$receive$1 )}, serializedLambda);
            }
        }, this.context());
    }

    public PartialFunction<Object, BoxedUnit> starting(ActorRef dockerHandler, ActorRef requestor) {
        return LoggingReceive$.MODULE$.apply((PartialFunction)new scala.Serializable(this, dockerHandler, requestor){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerManager $outer;
            private final ActorRef dockerHandler$1;
            private final ActorRef requestor$1;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof InternalContainersStarted) {
                    InternalContainersStarted internalContainersStarted = (InternalContainersStarted)A1;
                    Either<Exception, Map<String, ContainerUnderTest>> either = internalContainersStarted.result();
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        Map cuts = (Map)right.value();
                        akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.mapper()).$bang((Object)new InternalMapDockerContainers(this.$outer.self(), (Map<String, ContainerUnderTest>)cuts, this.$outer.client()), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        akka.actor.package$.MODULE$.actorRef2Scala(this.requestor$1).$bang(internalContainersStarted.result(), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof InternalDockerContainersMapped) {
                    InternalDockerContainersMapped internalDockerContainersMapped = (InternalDockerContainersMapped)A1;
                    this.$outer.log().info(new StringBuilder(68).append("Container Manager started with docker attached docker containers: [").append(internalDockerContainersMapped.result()).append("]").toString());
                    akka.actor.package$.MODULE$.actorRef2Scala(this.requestor$1).$bang((Object)new ContainerManagerStarted(internalDockerContainersMapped.result()), this.$outer.self());
                    Either<Exception, Map<String, ContainerUnderTest>> either = internalDockerContainersMapped.result();
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        Map cuts = (Map)right.value();
                        this.$outer.context().become(this.$outer.running(this.dockerHandler$1, (Map<String, ContainerUnderTest>)cuts));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.$outer.context().stop(this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                boolean bl = object instanceof InternalContainersStarted ? true : object instanceof InternalDockerContainersMapped;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dockerHandler$1 = dockerHandler$1;
                this.requestor$1 = requestor$1;
            }
        }, this.context());
    }

    public PartialFunction<Object, BoxedUnit> running(ActorRef dockerHandler, Map<String, ContainerUnderTest> cuts) {
        return LoggingReceive$.MODULE$.apply((PartialFunction)new scala.Serializable(this, dockerHandler){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerManager $outer;
            private final ActorRef dockerHandler$2;

            public final <A1, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof GetContainerDirectory) {
                    GetContainerDirectory getContainerDirectory = (GetContainerDirectory)A1;
                    this.dockerHandler$2.tell((Object)getContainerDirectory, this.$outer.sender());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof WriteContainerDirectory) {
                    WriteContainerDirectory writeContainerDirectory = (WriteContainerDirectory)A1;
                    this.dockerHandler$2.tell((Object)writeContainerDirectory, this.$outer.sender());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ExecuteContainerCommand) {
                    ExecuteContainerCommand executeContainerCommand = (ExecuteContainerCommand)A1;
                    this.dockerHandler$2.tell((Object)executeContainerCommand, this.$outer.sender());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof StopContainerManager) {
                    StopContainerManager stopContainerManager = (StopContainerManager)A1;
                    this.$outer.log().info("Stopping Test Container Manager");
                    this.dockerHandler$2.forward((Object)stopContainerManager, this.$outer.context());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x3) {
                Object object = x3;
                boolean bl = object instanceof GetContainerDirectory ? true : (object instanceof WriteContainerDirectory ? true : (object instanceof ExecuteContainerCommand ? true : object instanceof StopContainerManager));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dockerHandler$2 = dockerHandler$2;
            }
        }, this.context());
    }

    public Map<String, ContainerUnderTest> blended$itestsupport$docker$ContainerManager$$configureDockerContainer(Map<String, ContainerUnderTest> cut) {
        Iterable cuts = (Iterable)cut.values().flatMap((Function1 & Serializable & scala.Serializable)ct -> {
            Function1<Image, Object> searchImg = this.searchByTag(ct.imgPattern());
            List<Image> found = this.search(searchImg);
            return (List)((List)found.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String ctName;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Image img = (Image)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String x$19 = ctName = new StringBuilder(1).append(ct.ctName()).append("_").append(idx).toString();
                String x$20 = new StringBuilder(1).append(ctName).append("_").append(System.currentTimeMillis()).toString();
                String x$21 = img.getId();
                String x$22 = ct.copy$default$2();
                List<VolumeConfig> x$23 = ct.copy$default$5();
                List<ContainerLink> x$24 = ct.copy$default$6();
                Map<String, NamedContainerPort> x$25 = ct.copy$default$7();
                Map<String, String> x$26 = ct.copy$default$8();
                ContainerUnderTest containerUnderTest = ct.copy(x$19, x$22, x$21, x$20, x$23, x$24, x$25, x$26);
                return containerUnderTest;
            }, List$.MODULE$.canBuildFrom());
        }, Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)cuts.map((Function1 & Serializable & scala.Serializable)ct -> new Tuple2((Object)ct.ctName(), ct), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public ContainerManager() {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        Docker.$init$(this);
        this.timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds());
        this.eCtxt = this.context().dispatcher();
        this.client = ((DockerClientProvider)((Object)this)).getClient();
        this.config = this.context().system().settings().config();
        this.logger = this.context().system().log();
    }
}

