/*
 * Decompiled with CFR 0.152.
 */
package blended.itestsupport.compress;

import blended.itestsupport.compress.TarFileSupport;
import blended.util.StreamCopySupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;

public final class TarFileSupport$ {
    public static TarFileSupport$ MODULE$;
    private final Logger log;

    static {
        new TarFileSupport$();
    }

    public Map<String, byte[]> untar(InputStream is) {
        ArchiveInputStream tar = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));
        byte[] bytes = new byte[8192];
        scala.collection.mutable.Map content = Map$.MODULE$.empty();
        Option entry = Option$.MODULE$.apply((Object)tar.getNextEntry());
        while (entry.isDefined()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamCopySupport.copyStream((InputStream)tar, (OutputStream)bos);
            bos.close();
            this.log.debug(new StringBuilder(22).append("Extracted [").append(((ArchiveEntry)entry.get()).getName()).append("], size [").append(bos.size()).append("].").toString());
            content.put((Object)((ArchiveEntry)entry.get()).getName(), (Object)bos.toByteArray());
            entry = Option$.MODULE$.apply((Object)tar.getNextEntry());
        }
        tar.close();
        is.close();
        return content.toMap(Predef$.MODULE$.$conforms());
    }

    public void tar(File file, OutputStream os, int user, int group) {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        BufferedOutputStream bOut = new BufferedOutputStream(os);
        TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)bOut);
        try {
            this.addFileToTar$1(tarOut, file, "", user, group);
        }
        finally {
            tarOut.finish();
            tarOut.close();
            bOut.close();
            os.close();
        }
    }

    public int tar$default$3() {
        return 0;
    }

    public int tar$default$4() {
        return 0;
    }

    public static final /* synthetic */ void $anonfun$tar$1(TarFileSupport$ $this, int user$1, int group$1, TarArchiveOutputStream tarOs$1, String entryName$1, File[] ff) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ff)).foreach((Function1 & Serializable & scala.Serializable)f -> {
            $this.addFileToTar$1(tarOs$1, f, new StringBuilder(1).append(entryName$1).append("/").toString(), user$1, group$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void addFileToTar$1(TarArchiveOutputStream tarOs, File file, String base, int user$1, int group$1) {
        String entryName = new StringBuilder(0).append(base).append(file.getName()).toString();
        TarArchiveEntry entry = new TarArchiveEntry(file, entryName);
        entry.setUserId(user$1);
        entry.setGroupId(group$1);
        this.log.info(new StringBuilder(48).append("Adding [").append(entryName).append("] to tar archive with [user(").append(user$1).append("), group(").append(group$1).append(")].").toString());
        tarOs.putArchiveEntry((ArchiveEntry)entry);
        if (file.isFile()) {
            StreamCopySupport.copyStream((InputStream)new FileInputStream(file), (OutputStream)tarOs);
            tarOs.closeArchiveEntry();
        } else {
            tarOs.closeArchiveEntry();
            Option files = Option$.MODULE$.apply((Object)file.listFiles());
            files.map((Function1 & Serializable & scala.Serializable)ff -> {
                TarFileSupport$.$anonfun$tar$1(this, user$1, group$1, tarOs, entryName, ff);
                return BoxedUnit.UNIT;
            });
        }
    }

    private TarFileSupport$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(TarFileSupport.class);
    }
}

