/*
 * Decompiled with CFR 0.152.
 */
package blended.itestsupport.docker;

import blended.itestsupport.ContainerLink;
import blended.itestsupport.ContainerUnderTest;
import blended.itestsupport.NamedContainerPort;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001%\u0011q\u0002R8dW\u0016\u00148i\u001c8uC&tWM\u001d\u0006\u0003\u0007\u0011\ta\u0001Z8dW\u0016\u0014(BA\u0003\u0007\u00031IG/Z:ugV\u0004\bo\u001c:u\u0015\u00059\u0011a\u00022mK:$W\rZ\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\t#\u0001\u0011\t\u0011)A\u0005%\u0005\u00191-\u001e;\u0011\u0005M!R\"\u0001\u0003\n\u0005U!!AE\"p]R\f\u0017N\\3s+:$WM\u001d+fgRD\u0001b\u0006\u0001\u0003\u0002\u0003\u0006Y\u0001G\u0001\u0007G2LWM\u001c;\u0011\u0005e\u0011S\"\u0001\u000e\u000b\u0005ma\u0012aA1qS*\u0011QDH\u0001\u000bI>\u001c7.\u001a:kCZ\f'BA\u0010!\u0003\u00199\u0017\u000e\u001e5vE*\t\u0011%A\u0002d_6L!a\t\u000e\u0003\u0019\u0011{7m[3s\u00072LWM\u001c;\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t93\u0006\u0006\u0002)UA\u0011\u0011\u0006A\u0007\u0002\u0005!)q\u0003\na\u00021!)\u0011\u0003\na\u0001%!1Q\u0006\u0001Q\u0001\n9\na\u0001\\8hO\u0016\u0014\bCA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0019\u0014aA8sO&\u0011Q\u0007\r\u0002\u0007\u0019><w-\u001a:\t\u000b]\u0002A\u0011\u0001\u001d\u0002\u001dM$\u0018M\u001d;D_:$\u0018-\u001b8feV\t\u0001\u0006C\u0003;\u0001\u0011\u00051(\u0001\bfq\u0016\u001cW\u000f^3D_6l\u0017M\u001c3\u0015\u0007qjv\f\u0005\u0003>\u000b\"[eB\u0001 D\u001d\ty$)D\u0001A\u0015\t\t\u0005\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u0011A\tD\u0001\ba\u0006\u001c7.Y4f\u0013\t1uI\u0001\u0004FSRDWM\u001d\u0006\u0003\t2\u0001\"!P%\n\u0005);%!\u0003+ie><\u0018M\u00197f!\u0015YAJT+V\u0013\tiEB\u0001\u0004UkBdWm\r\t\u0003\u001fJs!a\u0003)\n\u0005Ec\u0011A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015\u0007\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016AA5p\u0015\u0005Q\u0016\u0001\u00026bm\u0006L!\u0001X,\u0003+\tKH/Z!se\u0006Lx*\u001e;qkR\u001cFO]3b[\")a,\u000fa\u0001\u001d\u0006!Qo]3s\u0011\u0015\u0001\u0017\b1\u0001b\u0003\r\u0019W\u000e\u001a\t\u0004\u0017\tt\u0015BA2\r\u0005)a$/\u001a9fCR,GM\u0010\u0005\u0006K\u0002!\tAZ\u0001\fS:\u001c\b/Z2u\u000bb,7\r\u0006\u0002h[B\u0011\u0001n[\u0007\u0002S*\u0011!NG\u0001\bG>lW.\u00198e\u0013\ta\u0017NA\nJ]N\u0004Xm\u0019;Fq\u0016\u001c'+Z:q_:\u001cX\rC\u0003oI\u0002\u0007a*\u0001\u0002jI\")\u0001\u000f\u0001C\u0001c\u0006)r-\u001a;D_:$\u0018-\u001b8fe\u0012K'/Z2u_JLHC\u0001:v!\t16/\u0003\u0002u/\nY\u0011J\u001c9viN#(/Z1n\u0011\u00151x\u000e1\u0001O\u0003\r!\u0017N\u001d\u0005\u0006q\u0002!\t!_\u0001\u0018oJLG/Z\"p]R\f\u0017N\\3s\t&\u0014Xm\u0019;pef$2A_?\u007f!\tY10\u0003\u0002}\u0019\t9!i\\8mK\u0006t\u0007\"\u0002<x\u0001\u0004q\u0005BB@x\u0001\u0004\t\t!A\u0004d_:$XM\u001c;\u0011\u000b-\t\u0019!a\u0002\n\u0007\u0005\u0015ABA\u0003BeJ\f\u0017\u0010E\u0002\f\u0003\u0013I1!a\u0003\r\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012\u0005i1m\u001c8uC&tWM]%oM>,\"!a\u0005\u0011\u0007!\f)\"C\u0002\u0002\u0018%\u0014\u0001$\u00138ta\u0016\u001cGoQ8oi\u0006Lg.\u001a:SKN\u0004xN\\:f\u0011\u001d\tY\u0002\u0001C\u0001\u0003;\tqB]3n_Z,7i\u001c8uC&tWM]\u000b\u0003\u0003?\u0001B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003KI\u0016\u0001\u00027b]\u001eLA!!\u000b\u0002$\t!ak\\5e\u0011\u0019\ti\u0003\u0001C\u0001q\u0005i1\u000f^8q\u0007>tG/Y5oKJ\u0004")
public class DockerContainer {
    private final ContainerUnderTest cut;
    private final DockerClient client;
    private final Logger logger;

    public DockerContainer startContainer() {
        List links = (List)this.cut.links().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Link apply(ContainerLink l) {
                return Link.parse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l.container(), l.hostname()})));
            }
        }, List$.MODULE$.canBuildFrom());
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Links for container [", "] : [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cut.dockerName(), links})));
        PortBinding[] ports = (PortBinding[])((TraversableOnce)this.cut.ports().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final PortBinding apply(Tuple2<String, NamedContainerPort> x0$1) {
                Tuple2<String, NamedContainerPort> tuple2 = x0$1;
                if (tuple2 != null) {
                    NamedContainerPort p = (NamedContainerPort)tuple2._2();
                    PortBinding portBinding = p.binding();
                    return portBinding;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(PortBinding.class));
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ports for container [", "] : [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cut.dockerName(), this.cut.ports()})));
        String[] env = (String[])((TraversableOnce)this.cut.env().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        CreateContainerCmd containerCmd = this.client.createContainerCmd(this.cut.imgId()).withName(this.cut.dockerName()).withTty(Predef$.MODULE$.boolean2Boolean(true)).withPortBindings(ports).withEnv(env);
        Object object = links.isEmpty() ? BoxedUnit.UNIT : containerCmd.withLinks((Link[])links.toArray(ClassTag$.MODULE$.apply(Link.class)));
        containerCmd.exec();
        this.client.startContainerCmd(this.cut.dockerName()).exec();
        return this;
    }

    public Either<Throwable, Tuple3<String, ByteArrayOutputStream, ByteArrayOutputStream>> executeCommand(String user, Seq<String> cmd) {
        Left left;
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executing cmd [", "] for user [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cmd.foldLeft((Object)"", (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x0$3, String x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$1);
                if (tuple2 != null) {
                    String v = (String)tuple2._1();
                    String e = (String)tuple2._2();
                    String string = new StringBuilder().append((Object)v).append((Object)" ").append((Object)e).toString();
                    return string;
                }
                throw new MatchError((Object)tuple2);
            }
        }), user})));
        try {
            ExecCreateCmd command = this.client.execCreateCmd(this.cut.dockerName()).withUser(user).withCmd((String[])cmd.toArray(ClassTag$.MODULE$.apply(String.class))).withAttachStdout(Predef$.MODULE$.boolean2Boolean(true)).withAttachStderr(Predef$.MODULE$.boolean2Boolean(true));
            String execId = ((ExecCreateCmdResponse)command.exec()).getId();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ExecStartResultCallback rcb = new ExecStartResultCallback((OutputStream)out, (OutputStream)err);
            ExecStartCmd startExec = this.client.execStartCmd(execId).withTty(Predef$.MODULE$.boolean2Boolean(true));
            startExec.exec((ResultCallback)rcb);
            left = package$.MODULE$.Right().apply((Object)new Tuple3((Object)execId, (Object)out, (Object)err));
        }
        catch (Throwable throwable) {
            Left left2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            left = left2 = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public InspectExecResponse inspectExec(String id) {
        return this.client.inspectExecCmd(id).withExecId(id).exec();
    }

    public InputStream getContainerDirectory(String dir) {
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Getting directory [", "] from container [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir, this.cut.ctName()})));
        return this.client.copyArchiveFromContainerCmd(this.cut.dockerName(), dir).exec();
    }

    public boolean writeContainerDirectory(String dir, byte[] content) {
        boolean bl;
        try {
            this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing archive of size [", "] to directory [", "] in container [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)content.length), dir, this.cut.ctName()})));
            CopyArchiveToContainerCmd cmd = this.client.copyArchiveToContainerCmd(this.cut.dockerName());
            cmd.withRemotePath(dir).withTarInputStream((InputStream)new ByteArrayInputStream(content));
            cmd.exec();
            bl = true;
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            bl = bl2 = false;
        }
        return bl;
    }

    public InspectContainerResponse containerInfo() {
        return this.client.inspectContainerCmd(this.cut.dockerName()).exec();
    }

    public Void removeContainer() {
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing container [", "] from Docker."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cut.dockerName()})));
        return this.client.removeContainerCmd(this.cut.dockerName()).withForce(Predef$.MODULE$.boolean2Boolean(true)).withRemoveVolumes(Predef$.MODULE$.boolean2Boolean(true)).exec();
    }

    public DockerContainer stopContainer() {
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping container [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cut.dockerName()})));
        this.client.stopContainerCmd(this.cut.dockerName()).exec();
        return this;
    }

    public DockerContainer(ContainerUnderTest cut, DockerClient client) {
        this.cut = cut;
        this.client = client;
        this.logger = LoggerFactory.getLogger((String)DockerContainer.class.getName());
    }
}

