/*
 * Decompiled with CFR 0.152.
 */
package blended.itestsupport.docker;

import blended.itestsupport.ContainerLink;
import blended.itestsupport.ContainerUnderTest;
import blended.itestsupport.NamedContainerPort;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.PortBinding;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u0001%\u0011q\u0002R8dW\u0016\u00148i\u001c8uC&tWM\u001d\u0006\u0003\u0007\u0011\ta\u0001Z8dW\u0016\u0014(BA\u0003\u0007\u00031IG/Z:ugV\u0004\bo\u001c:u\u0015\u00059\u0011a\u00022mK:$W\rZ\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\t#\u0001\u0011\t\u0011)A\u0005%\u0005\u00191-\u001e;\u0011\u0005M!R\"\u0001\u0003\n\u0005U!!AE\"p]R\f\u0017N\\3s+:$WM\u001d+fgRD\u0001b\u0006\u0001\u0003\u0002\u0003\u0006Y\u0001G\u0001\u0007G2LWM\u001c;\u0011\u0005e\u0011S\"\u0001\u000e\u000b\u0005ma\u0012aA1qS*\u0011QDH\u0001\u000bI>\u001c7.\u001a:kCZ\f'BA\u0010!\u0003\u00199\u0017\u000e\u001e5vE*\t\u0011%A\u0002d_6L!a\t\u000e\u0003\u0019\u0011{7m[3s\u00072LWM\u001c;\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t93\u0006\u0006\u0002)UA\u0011\u0011\u0006A\u0007\u0002\u0005!)q\u0003\na\u00021!)\u0011\u0003\na\u0001%!1Q\u0006\u0001Q\u0001\n9\na\u0001\\8hO\u0016\u0014\bCA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0019\u0014aA8sO&\u0011Q\u0007\r\u0002\u0007\u0019><w-\u001a:\t\r]\u0002\u0001\u0015\"\u00039\u0003\tIG-F\u0001:!\tQTH\u0004\u0002\fw%\u0011A\bD\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=\u0019!1\u0011\t\u0001Q\u0005\na\nQbY8oi\u0006Lg.\u001a:OC6,\u0007\"B\"\u0001\t\u0003!\u0015AD:uCJ$8i\u001c8uC&tWM]\u000b\u0002Q!)a\t\u0001C\u0001\u000f\u0006)r-\u001a;D_:$\u0018-\u001b8fe\u0012K'/Z2u_JLHC\u0001%Q!\tIe*D\u0001K\u0015\tYE*\u0001\u0002j_*\tQ*\u0001\u0003kCZ\f\u0017BA(K\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000bE+\u0005\u0019A\u001d\u0002\u0007\u0011L'\u000fC\u0003T\u0001\u0011\u0005A+A\fxe&$XmQ8oi\u0006Lg.\u001a:ESJ,7\r^8ssR\u0019Qk\u001a5\u0011\tYs\u0016\r\u001a\b\u0003/rs!\u0001W.\u000e\u0003eS!A\u0017\u0005\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA/\r\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\r\u0015KG\u000f[3s\u0015\tiF\u0002\u0005\u0002WE&\u00111\r\u0019\u0002\n)\"\u0014xn^1cY\u0016\u0004\"aC3\n\u0005\u0019d!a\u0002\"p_2,\u0017M\u001c\u0005\u0006#J\u0003\r!\u000f\u0005\u0006SJ\u0003\rA[\u0001\bG>tG/\u001a8u!\rY1.\\\u0005\u0003Y2\u0011Q!\u0011:sCf\u0004\"a\u00038\n\u0005=d!\u0001\u0002\"zi\u0016DQ!\u001d\u0001\u0005\u0002I\fQbY8oi\u0006Lg.\u001a:J]\u001a|W#A:\u0011\u0005Q<X\"A;\u000b\u0005YT\u0012aB2p[6\fg\u000eZ\u0005\u0003qV\u0014\u0001$\u00138ta\u0016\u001cGoQ8oi\u0006Lg.\u001a:SKN\u0004xN\\:f\u0011\u0015Q\b\u0001\"\u0001|\u0003=\u0011X-\\8wK\u000e{g\u000e^1j]\u0016\u0014X#\u0001?\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyH*\u0001\u0003mC:<\u0017bAA\u0002}\n!ak\\5e\u0011\u0019\t9\u0001\u0001C\u0001\t\u0006i1\u000f^8q\u0007>tG/Y5oKJ\u0004")
public class DockerContainer {
    private final ContainerUnderTest cut;
    private final DockerClient client;
    private final Logger logger;

    private String id() {
        return this.cut.imgId();
    }

    private String containerName() {
        return this.cut.dockerName();
    }

    public DockerContainer startContainer() {
        List links = (List)this.cut.links().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Link apply(ContainerLink l) {
                return Link.parse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l.container(), l.hostname()})));
            }
        }, List$.MODULE$.canBuildFrom());
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Links for container [", "] : [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cut.dockerName(), links})));
        PortBinding[] ports = (PortBinding[])((TraversableOnce)this.cut.ports().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final PortBinding apply(Tuple2<String, NamedContainerPort> x0$1) {
                Tuple2<String, NamedContainerPort> tuple2 = x0$1;
                if (tuple2 != null) {
                    NamedContainerPort p = (NamedContainerPort)tuple2._2();
                    PortBinding portBinding = p.binding();
                    return portBinding;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(PortBinding.class));
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ports for container [", "] : [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cut.dockerName(), this.cut.ports()})));
        String[] env = (String[])((TraversableOnce)this.cut.env().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        CreateContainerCmd containerCmd = this.client.createContainerCmd(this.id()).withName(this.cut.dockerName()).withTty(Predef$.MODULE$.boolean2Boolean(true)).withPortBindings(ports).withEnv(env);
        Object object = links.isEmpty() ? BoxedUnit.UNIT : containerCmd.withLinks((Link[])links.toArray(ClassTag$.MODULE$.apply(Link.class)));
        containerCmd.exec();
        this.client.startContainerCmd(this.containerName()).exec();
        return this;
    }

    public InputStream getContainerDirectory(String dir) {
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Getting directory [", "] from container [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir, this.cut.ctName()})));
        return this.client.copyArchiveFromContainerCmd(this.containerName(), dir).exec();
    }

    public Either<Throwable, Object> writeContainerDirectory(String dir, byte[] content) {
        Left left;
        try {
            this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing archive of size [", "] to directory [", "] in container [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)content.length), dir, this.cut.ctName()})));
            CopyArchiveToContainerCmd cmd = this.client.copyArchiveToContainerCmd(this.containerName());
            cmd.withRemotePath(dir).withTarInputStream((InputStream)new ByteArrayInputStream(content));
            cmd.exec();
            left = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        catch (Throwable throwable) {
            Left left2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            left = left2 = package$.MODULE$.Left().apply((Object)t);
        }
        return left;
    }

    public InspectContainerResponse containerInfo() {
        return this.client.inspectContainerCmd(this.containerName()).exec();
    }

    public Void removeContainer() {
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing container [", "] from Docker."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerName()})));
        return this.client.removeContainerCmd(this.containerName()).withForce(Predef$.MODULE$.boolean2Boolean(true)).withRemoveVolumes(Predef$.MODULE$.boolean2Boolean(true)).exec();
    }

    public DockerContainer stopContainer() {
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping container [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerName()})));
        this.client.stopContainerCmd(this.containerName()).exec();
        return this;
    }

    public DockerContainer(ContainerUnderTest cut, DockerClient client) {
        this.cut = cut;
        this.client = client;
        this.logger = LoggerFactory.getLogger((String)DockerContainer.class.getName());
    }
}

