/*
 * Decompiled with CFR 0.152.
 */
package blended.itestsupport.docker;

import blended.itestsupport.ContainerLink;
import blended.itestsupport.ContainerUnderTest;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.model.Link;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u0013\tyAi\\2lKJ\u001cuN\u001c;bS:,'O\u0003\u0002\u0004\t\u00051Am\\2lKJT!!\u0002\u0004\u0002\u0019%$Xm\u001d;tkB\u0004xN\u001d;\u000b\u0003\u001d\tqA\u00197f]\u0012,Gm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0003\u0005\u0012\u0001\t\u0005\t\u0015!\u0003\u0013\u0003\r\u0019W\u000f\u001e\t\u0003'Qi\u0011\u0001B\u0005\u0003+\u0011\u0011!cQ8oi\u0006Lg.\u001a:V]\u0012,'\u000fV3ti\"Aq\u0003\u0001B\u0001B\u0003-\u0001$\u0001\u0004dY&,g\u000e\u001e\t\u00033\tj\u0011A\u0007\u0006\u00037q\t1!\u00199j\u0015\tib$\u0001\u0006e_\u000e\\WM\u001d6bm\u0006T!a\b\u0011\u0002\r\u001dLG\u000f[;c\u0015\u0005\t\u0013aA2p[&\u00111E\u0007\u0002\r\t>\u001c7.\u001a:DY&,g\u000e\u001e\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dZCC\u0001\u0015+!\tI\u0003!D\u0001\u0003\u0011\u00159B\u0005q\u0001\u0019\u0011\u0015\tB\u00051\u0001\u0013\u0011\u0019i\u0003\u0001)A\u0005]\u00051An\\4hKJ\u0004\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u000bMdg\r\u000e6\u000b\u0003M\n1a\u001c:h\u0013\t)\u0004G\u0001\u0004M_\u001e<WM\u001d\u0005\u0007o\u0001\u0001K\u0011\u0002\u001d\u0002\u0005%$W#A\u001d\u0011\u0005ijdBA\u0006<\u0013\taD\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f\r\u0011\u0019\t\u0005\u0001)C\u0005q\u0005i1m\u001c8uC&tWM\u001d(b[\u0016DQa\u0011\u0001\u0005\u0002\u0011\u000bab\u001d;beR\u001cuN\u001c;bS:,'/F\u0001)\u0011\u00151\u0005\u0001\"\u0001H\u00035\u0019wN\u001c;bS:,'/\u00138g_V\t\u0001\n\u0005\u0002J\u00196\t!J\u0003\u0002L5\u000591m\\7nC:$\u0017BA'K\u0005aIen\u001d9fGR\u001cuN\u001c;bS:,'OU3ta>t7/\u001a\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u0010e\u0016lwN^3D_:$\u0018-\u001b8feV\t\u0011\u000b\u0005\u0002S/6\t1K\u0003\u0002U+\u0006!A.\u00198h\u0015\u00051\u0016\u0001\u00026bm\u0006L!\u0001W*\u0003\tY{\u0017\u000e\u001a\u0005\u00065\u0002!\t\u0001R\u0001\u000egR|\u0007oQ8oi\u0006Lg.\u001a:")
public class DockerContainer {
    private final ContainerUnderTest cut;
    private final DockerClient client;
    private final Logger logger;

    private String id() {
        return this.cut.imgId();
    }

    private String containerName() {
        return this.cut.dockerName();
    }

    public DockerContainer startContainer() {
        List links = (List)this.cut.links().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Link apply(ContainerLink l) {
                return Link.parse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l.container(), l.hostname()})));
            }
        }, List$.MODULE$.canBuildFrom());
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting container [", "] with container links [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cut.dockerName(), links})));
        CreateContainerResponse container = this.client.createContainerCmd(this.id()).withName(this.cut.dockerName()).withTty(true).exec();
        StartContainerCmd cmd = this.client.startContainerCmd(this.containerName()).withPublishAllPorts(Predef$.MODULE$.boolean2Boolean(true));
        Object object = links.isEmpty() ? BoxedUnit.UNIT : cmd.withLinks((Link[])links.toArray(ClassTag$.MODULE$.apply(Link.class)));
        cmd.exec();
        return this;
    }

    public InspectContainerResponse containerInfo() {
        return this.client.inspectContainerCmd(this.containerName()).exec();
    }

    public Void removeContainer() {
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing container [", "] from Docker."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerName()})));
        return this.client.removeContainerCmd(this.containerName()).withForce(true).withRemoveVolumes(true).exec();
    }

    public DockerContainer stopContainer() {
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping container [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerName()})));
        this.client.stopContainerCmd(this.containerName()).exec();
        return this;
    }

    public DockerContainer(ContainerUnderTest cut, DockerClient client) {
        this.cut = cut;
        this.client = client;
        this.logger = LoggerFactory.getLogger((String)DockerContainer.class.getName());
    }
}

