/*
 * Decompiled with CFR 0.152.
 */
package blended.file;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.pattern.AskableActorRef$;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.Timeout;
import blended.file.FileDropAbort;
import blended.file.FileDropCommand;
import blended.file.FileDropConfig;
import blended.file.FileDropResult;
import blended.streams.FlowHeaderConfig;
import blended.streams.jms.JmsEnvelopeHeader;
import blended.streams.message.BinaryFlowMessage;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelopeLogger;
import blended.streams.message.FlowMessage;
import blended.streams.message.TextFlowMessage;
import blended.util.RichTry$;
import blended.util.logging.LogLevel$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015b\u0001\u0002\u0007\u000e\u0001IA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011!Y\u0004A!A!\u0002\u0017a\u0004\"B \u0001\t\u0003\u0001\u0005\"\u0002%\u0001\t\u0013I\u0005B\u0002.\u0001A\u0013%1\f\u0003\u0004i\u0001\u0001&I!\u001b\u0005\u0007k\u0002\u0001K\u0011\u0002<\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010\t\u0019RI\u001c<fY>\u0004XMR5mK\u0012\u0013x\u000e\u001d9fe*\u0011abD\u0001\u0005M&dWMC\u0001\u0011\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001aE\u0002\u0001'e\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e \u001b\u0005Y\"B\u0001\u000f\u001e\u0003\rQWn\u001d\u0006\u0003==\tqa\u001d;sK\u0006l7/\u0003\u0002!7\t\t\"*\\:F]Z,Gn\u001c9f\u0011\u0016\fG-\u001a:\u0002\u0007\r4w\r\u0005\u0002$I5\tQ\"\u0003\u0002&\u001b\tqa)\u001b7f\tJ|\u0007oQ8oM&<\u0017\u0001\u00045fC\u0012,'oQ8oM&<\u0007C\u0001\u0015*\u001b\u0005i\u0012B\u0001\u0016\u001e\u0005A1En\\<IK\u0006$WM]\"p]\u001aLw-A\u0005ee>\u0004\u0018i\u0019;peB\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0006C\u000e$xN\u001d\u0006\u0002c\u0005!\u0011m[6b\u0013\t\u0019dF\u0001\u0005BGR|'OU3g\u0003\rawn\u001a\t\u0003mej\u0011a\u000e\u0006\u0003qu\tq!\\3tg\u0006<W-\u0003\u0002;o\t\u0011b\t\\8x\u000b:4X\r\\8qK2{wmZ3s\u0003\u0019\u0019\u0018p\u001d;f[B\u0011Q&P\u0005\u0003}9\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u00061A(\u001b8jiz\"R!\u0011#F\r\u001e#\"AQ\"\u0011\u0005\r\u0002\u0001\"B\u001e\u0007\u0001\ba\u0004\"B\u0011\u0007\u0001\u0004\u0011\u0003\"\u0002\u0014\u0007\u0001\u00049\u0003\"B\u0016\u0007\u0001\u0004a\u0003\"\u0002\u001b\u0007\u0001\u0004)\u0014AD3yiJ\f7\r^\"p]R,g\u000e\u001e\u000b\u0003\u0015V\u00032a\u0013(Q\u001b\u0005a%BA'\u0016\u0003\u0011)H/\u001b7\n\u0005=c%a\u0001+ssB\u0011\u0011kU\u0007\u0002%*\u0011Q\nM\u0005\u0003)J\u0013!BQ=uKN#(/\u001b8h\u0011\u00151v\u00011\u0001X\u0003\r)gN\u001e\t\u0003maK!!W\u001c\u0003\u0019\u0019cwn^#om\u0016dw\u000e]3\u0002\r\r|'O]%e)\tav\r\u0005\u0002^I:\u0011aL\u0019\t\u0003?Vi\u0011\u0001\u0019\u0006\u0003CF\ta\u0001\u0010:p_Rt\u0014BA2\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r,\u0002\"\u0002,\t\u0001\u00049\u0016a\u00023s_B\u001cU\u000e\u001a\u000b\u0003UR$\"a[8\u0011\u0007-sE\u000e\u0005\u0002$[&\u0011a.\u0004\u0002\u0010\r&dW\r\u0012:pa\u000e{W.\\1oI\")\u0001/\u0003a\u0001c\u0006\ta\r\u0005\u0003\u0015e^S\u0015BA:\u0016\u0005%1UO\\2uS>t\u0017\u0007C\u0003W\u0013\u0001\u0007q+A\u0006iC:$G.Z#se>\u0014HcA<{wB\u00111\u0005_\u0005\u0003s6\u0011aBR5mK\u0012\u0013x\u000e\u001d*fgVdG\u000fC\u0003W\u0015\u0001\u0007q\u000bC\u0003}\u0015\u0001\u0007Q0A\u0003feJ|'\u000fE\u0002\u007f\u0003\u000fq1a`A\u0002\u001d\ry\u0016\u0011A\u0005\u0002-%\u0019\u0011QA\u000b\u0002\u000fA\f7m[1hK&!\u0011\u0011BA\u0006\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\u0006U\tA\u0002\u001a:pa\u0016sg/\u001a7pa\u0016$B!!\u0005\u0002$A1A#a\u0005m\u0003/I1!!\u0006\u0016\u0005\u0019!V\u000f\u001d7feA)\u0011\u0011DA\u0010o6\u0011\u00111\u0004\u0006\u0004\u0003;)\u0012AC2p]\u000e,(O]3oi&!\u0011\u0011EA\u000e\u0005\u00191U\u000f^;sK\")ak\u0003a\u0001/\u0002")
public class EnvelopeFileDropper
implements JmsEnvelopeHeader {
    private final FileDropConfig cfg;
    private final FlowHeaderConfig headerConfig;
    private final ActorRef dropActor;
    private final FlowEnvelopeLogger log;
    private final ActorSystem system;
    private Function1<String, String> jmsHeaderPrefix;
    private Function1<String, String> srcVendorHeader;
    private Function1<String, String> srcProviderHeader;
    private Function1<String, String> srcDestHeader;
    private Function1<String, String> destHeader;
    private Function1<String, String> corrIdHeader;
    private Function1<String, String> priorityHeader;
    private Function1<String, String> expireHeader;
    private Function1<String, String> deliveryModeHeader;
    private Function1<String, String> replyToHeader;
    private Function1<String, String> timestampHeader;
    private Function1<String, String> typeHeader;
    private Function1<String, String> msgIdHeader;
    private Function1<String, String> redeliveryHeader;
    private String replyToQueueName;

    public Function1<String, String> jmsHeaderPrefix() {
        return this.jmsHeaderPrefix;
    }

    public Function1<String, String> srcVendorHeader() {
        return this.srcVendorHeader;
    }

    public Function1<String, String> srcProviderHeader() {
        return this.srcProviderHeader;
    }

    public Function1<String, String> srcDestHeader() {
        return this.srcDestHeader;
    }

    public Function1<String, String> destHeader() {
        return this.destHeader;
    }

    public Function1<String, String> corrIdHeader() {
        return this.corrIdHeader;
    }

    public Function1<String, String> priorityHeader() {
        return this.priorityHeader;
    }

    public Function1<String, String> expireHeader() {
        return this.expireHeader;
    }

    public Function1<String, String> deliveryModeHeader() {
        return this.deliveryModeHeader;
    }

    public Function1<String, String> replyToHeader() {
        return this.replyToHeader;
    }

    public Function1<String, String> timestampHeader() {
        return this.timestampHeader;
    }

    public Function1<String, String> typeHeader() {
        return this.typeHeader;
    }

    public Function1<String, String> msgIdHeader() {
        return this.msgIdHeader;
    }

    public Function1<String, String> redeliveryHeader() {
        return this.redeliveryHeader;
    }

    public String replyToQueueName() {
        return this.replyToQueueName;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$jmsHeaderPrefix_$eq(Function1<String, String> x$1) {
        this.jmsHeaderPrefix = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcVendorHeader_$eq(Function1<String, String> x$1) {
        this.srcVendorHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcProviderHeader_$eq(Function1<String, String> x$1) {
        this.srcProviderHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcDestHeader_$eq(Function1<String, String> x$1) {
        this.srcDestHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$destHeader_$eq(Function1<String, String> x$1) {
        this.destHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$corrIdHeader_$eq(Function1<String, String> x$1) {
        this.corrIdHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$priorityHeader_$eq(Function1<String, String> x$1) {
        this.priorityHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$expireHeader_$eq(Function1<String, String> x$1) {
        this.expireHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$deliveryModeHeader_$eq(Function1<String, String> x$1) {
        this.deliveryModeHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToHeader_$eq(Function1<String, String> x$1) {
        this.replyToHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$timestampHeader_$eq(Function1<String, String> x$1) {
        this.timestampHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$typeHeader_$eq(Function1<String, String> x$1) {
        this.typeHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$msgIdHeader_$eq(Function1<String, String> x$1) {
        this.msgIdHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$redeliveryHeader_$eq(Function1<String, String> x$1) {
        this.redeliveryHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToQueueName_$eq(String x$1) {
        this.replyToQueueName = x$1;
    }

    private Try<ByteString> extractContent(FlowEnvelope env) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ByteString byteString;
            FlowMessage flowMessage = env.flowMessage();
            if (flowMessage instanceof TextFlowMessage) {
                TextFlowMessage textFlowMessage = (TextFlowMessage)flowMessage;
                String charSet = (String)env.headerWithDefault($this.cfg.charsetHeader(), (Object)"UTF-8", ManifestFactory$.MODULE$.classType(String.class));
                $this.log.logEnv(env, LogLevel$.MODULE$.Debug(), (Function0 & Serializable)() -> new StringBuilder(45).append("Using charset [").append(charSet).append("] to file drop text message [").append(env.id()).append("]").toString(), $this.log.logEnv$default$4());
                byteString = ByteString$.MODULE$.apply(textFlowMessage.getText().getBytes(charSet));
            } else if (flowMessage instanceof BinaryFlowMessage) {
                BinaryFlowMessage binaryFlowMessage = (BinaryFlowMessage)flowMessage;
                byteString = binaryFlowMessage.content();
            } else {
                String eTxt = new StringBuilder(48).append("Dropping files unsupported for msg [").append(env.id()).append("] of type [").append(flowMessage.getClass().getName()).append("]").toString();
                $this.log.logEnv(env, LogLevel$.MODULE$.Error(), (Function0 & Serializable)() -> eTxt, $this.log.logEnv$default$4());
                throw new Exception(eTxt);
            }
            return byteString;
        });
    }

    private String corrId(FlowEnvelope env) {
        return (String)env.headerWithDefault("JMSCorrelationID", env.headerWithDefault((String)this.corrIdHeader().apply((Object)this.headerConfig.prefix()), (Object)env.id(), ManifestFactory$.MODULE$.classType(String.class)), ManifestFactory$.MODULE$.classType(String.class));
    }

    private Try<FileDropCommand> dropCmd(FlowEnvelope env, Function1<FlowEnvelope, Try<ByteString>> f) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> new FileDropCommand(env.id(), (ByteString)RichTry$.MODULE$.toRichTry((Try)f.apply((Object)env)).unwrap(), (String)env.headerWithDefault($this.cfg.dirHeader(), (Object)$this.cfg.defaultDir(), ManifestFactory$.MODULE$.classType(String.class)), (String)env.headerWithDefault($this.cfg.fileHeader(), (Object)"", ManifestFactory$.MODULE$.classType(String.class)), BoxesRunTime.unboxToBoolean((Object)env.headerWithDefault($this.cfg.compressHeader(), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Manifest)ManifestFactory$.MODULE$.Boolean())), BoxesRunTime.unboxToBoolean((Object)env.headerWithDefault($this.cfg.appendHeader(), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Manifest)ManifestFactory$.MODULE$.Boolean())), BoxesRunTime.unboxToBoolean((Object)env.headerWithDefault($this.cfg.errDupHeader(), (Object)BoxesRunTime.boxToBoolean((boolean)$this.cfg.errorOnDuplicate()), (Manifest)ManifestFactory$.MODULE$.Boolean())), BoxesRunTime.unboxToLong((Object)env.headerWithDefault((String)this.timestampHeader().apply((Object)$this.headerConfig.prefix()), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()), (Manifest)ManifestFactory$.MODULE$.Long())), (Map<String, Object>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JMSCorrelationID"), (Object)this.corrId(env))}))).$plus$plus((IterableOnce)env.flowMessage().header().view().mapValues((Function1 & Serializable)x$1 -> x$1.value()))), $this.log.underlying()));
    }

    private FileDropResult handleError(FlowEnvelope env, Throwable error) {
        this.log.logEnv(env, LogLevel$.MODULE$.Error(), (Function0 & Serializable)() -> new StringBuilder(39).append("Error dropping envelope [").append(env.id()).append("] to file : [").append(error.getMessage()).append("]").toString(), this.log.logEnv$default$4());
        FileDropCommand cmd = (FileDropCommand)this.dropCmd(env, (Function1<FlowEnvelope, Try<ByteString>>)(Function1 & Serializable)e -> new Success((Object)ByteString$.MODULE$.apply(""))).get();
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.dropActor);
        FileDropAbort x$1 = new FileDropAbort(env.id(), error);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        return new FileDropResult(cmd, (Option<Throwable>)new Some((Object)error));
    }

    public Tuple2<FileDropCommand, Future<FileDropResult>> dropEnvelope(FlowEnvelope env2) {
        Tuple2 tuple2;
        Promise p = Promise$.MODULE$.apply();
        Try<FileDropCommand> try_ = this.dropCmd(env2, (Function1<FlowEnvelope, Try<ByteString>>)(Function1 & Serializable)env -> this.extractContent((FlowEnvelope)env));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            FileDropCommand cmd = (FileDropCommand)success.value();
            Timeout to = new Timeout(this.cfg.dropTimeout());
            ExecutionContextExecutor eCtxt = this.system.dispatcher();
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.dropActor);
            FileDropCommand x$1 = cmd;
            Timeout x$2 = to;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(FileDropResult.class)).onComplete((Function1 & Serializable)x0$1 -> {
                Promise promise;
                Try try_ = x0$1;
                if (try_ instanceof Success) {
                    Promise promise2;
                    Success success = (Success)try_;
                    FileDropResult r = (FileDropResult)success.value();
                    Option<Throwable> option = r.error();
                    if (None$.MODULE$.equals(option)) {
                        promise2 = p.complete((Try)new Success((Object)r));
                    } else if (option instanceof Some) {
                        Some some = (Some)option;
                        Throwable t = (Throwable)some.value();
                        promise2 = p.complete((Try)new Success((Object)this.handleError(env2, t)));
                    } else {
                        throw new MatchError(option);
                    }
                    promise = promise2;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable t = failure.exception();
                    promise = p.complete((Try)new Success((Object)this.handleError(env2, t)));
                } else {
                    throw new MatchError((Object)try_);
                }
                return promise;
            }, (ExecutionContext)eCtxt);
            tuple2 = new Tuple2((Object)cmd, (Object)p.future());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            FileDropResult r = this.handleError(env2, t);
            p.complete((Try)new Success((Object)r));
            tuple2 = new Tuple2((Object)r.cmd(), (Object)p.future());
        } else {
            throw new MatchError(try_);
        }
        return tuple2;
    }

    public EnvelopeFileDropper(FileDropConfig cfg, FlowHeaderConfig headerConfig, ActorRef dropActor, FlowEnvelopeLogger log, ActorSystem system) {
        this.cfg = cfg;
        this.headerConfig = headerConfig;
        this.dropActor = dropActor;
        this.log = log;
        this.system = system;
        JmsEnvelopeHeader.$init$((JmsEnvelopeHeader)this);
        Statics.releaseFence();
    }
}

