/*
 * Decompiled with CFR 0.152.
 */
package blended.file;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.event.LoggingAdapter;
import blended.file.FileDropCommand;
import blended.file.FileDropResult;
import blended.util.StreamCopySupport;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u000f\tia)\u001b7f\tJ|\u0007/Q2u_JT!a\u0001\u0003\u0002\t\u0019LG.\u001a\u0006\u0002\u000b\u00059!\r\\3oI\u0016$7\u0001A\n\u0005\u0001!qa\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tQ!Y2u_JT\u0011aE\u0001\u0005C.\\\u0017-\u0003\u0002\u0016!\t)\u0011i\u0019;peB\u0011qbF\u0005\u00031A\u0011A\"Q2u_JdunZ4j]\u001eDQA\u0007\u0001\u0005\u0002m\ta\u0001P5oSRtD#\u0001\u000f\u0011\u0005u\u0001Q\"\u0001\u0002\t\u000b}\u0001A\u0011\u0001\u0011\u0002\u001d\rDWmY6ESJ,7\r^8ssR\u0011\u0011\u0005\n\t\u0003\u0013\tJ!a\t\u0006\u0003\u000f\t{w\u000e\\3b]\")QE\ba\u0001M\u0005\u0019A-\u001b:\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013AA5p\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0015\u0003\t\u0019KG.\u001a\u0005\u0006_\u0001!\t\u0001M\u0001\nM&t\u0017\r\u001c$jY\u0016$\"AJ\u0019\t\u000bIr\u0003\u0019A\u001a\u0002\u0007\rlG\r\u0005\u0002\u001ei%\u0011QG\u0001\u0002\u0010\r&dW\r\u0012:pa\u000e{W.\\1oI\")q\u0007\u0001C\u0001q\u00059A/\u001c9GS2,GCA\u001d=!\rI!HJ\u0005\u0003w)\u0011aa\u00149uS>t\u0007\"\u0002\u001a7\u0001\u0004\u0019\u0004\"\u0002 \u0001\t\u0003y\u0014aB8vi\u001aKG.\u001a\u000b\u0003M\u0001CQAM\u001fA\u0002MBQA\u0011\u0001\u0005\u0002\r\u000b1\u0003\u001d:fa\u0006\u0014XmT;uaV$8\u000b\u001e:fC6$2\u0001R$I!\t9S)\u0003\u0002GQ\taq*\u001e;qkR\u001cFO]3b[\")!'\u0011a\u0001g!)q'\u0011a\u0001s!1!\n\u0001Q\u0005\n-\u000bqA]3ta>tG\rF\u0002M\u001fR\u0003\"!C'\n\u00059S!\u0001B+oSRDQ\u0001U%A\u0002E\u000b\u0011B]3rk\u0016\u001cHo\u001c:\u0011\u0005=\u0011\u0016BA*\u0011\u0005!\t5\r^8s%\u00164\u0007\"B+J\u0001\u00041\u0016\u0001\u0003:fgB|gn]3\u0011\u0005u9\u0016B\u0001-\u0003\u000591\u0015\u000e\\3Ee>\u0004(+Z:vYRDQA\u0017\u0001\u0005Bm\u000bqA]3dK&4X-F\u0001]!\tif,D\u0001\u0001\u0013\tyFCA\u0004SK\u000e,\u0017N^3")
public class FileDropActor
implements Actor,
ActorLogging {
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public LoggingAdapter log() {
        return ActorLogging.class.log((ActorLogging)this);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public final ActorRef sender() {
        return Actor.class.sender((Actor)this);
    }

    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.class.aroundReceive((Actor)this, receive2, (Object)msg);
    }

    public void aroundPreStart() {
        Actor.class.aroundPreStart((Actor)this);
    }

    public void aroundPostStop() {
        Actor.class.aroundPostStop((Actor)this);
    }

    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.class.aroundPreRestart((Actor)this, (Throwable)reason, message);
    }

    public void aroundPostRestart(Throwable reason) {
        Actor.class.aroundPostRestart((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.class.supervisorStrategy((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.class.preStart((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.class.postStop((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.class.preRestart((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.class.postRestart((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.class.unhandled((Actor)this, (Object)message);
    }

    public boolean checkDirectory(File dir) {
        Object object;
        if (dir.exists()) {
            object = BoxedUnit.UNIT;
        } else {
            this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating directory [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir.getAbsolutePath()})));
            object = BoxesRunTime.boxToBoolean((boolean)dir.mkdirs());
        }
        return dir.exists() && dir.isDirectory() && dir.canWrite();
    }

    public File finalFile(FileDropCommand cmd) {
        File file;
        File file2 = new File(cmd.directory(), cmd.fileName());
        if (cmd.append()) {
            file = file2;
        } else if (file2.exists()) {
            String string;
            String string2 = cmd.directory();
            int n = cmd.fileName().lastIndexOf(46);
            switch (n) {
                default: {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".dup_", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cmd.fileName().substring(0, n), BoxesRunTime.boxToLong((long)System.currentTimeMillis()), cmd.fileName().substring(n)}));
                    break;
                }
                case -1: {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dup_", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.currentTimeMillis()), cmd.fileName()}));
                }
            }
            file = new File(string2, string);
        } else {
            file = file2;
        }
        return file;
    }

    public Option<File> tmpFile(FileDropCommand cmd) {
        None$ none$;
        if (cmd.append()) {
            File file = this.finalFile(cmd);
            if (file.exists()) {
                String tmpName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cmd.fileName(), BoxesRunTime.boxToLong((long)cmd.timestamp())}));
                File tmpFile = new File(cmd.directory(), tmpName);
                this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating temporary file [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpFile.getAbsolutePath()})));
                file.renameTo(tmpFile);
                none$ = new Some((Object)tmpFile);
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public File outFile(FileDropCommand cmd) {
        return new File(cmd.directory(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".out"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cmd.fileName(), BoxesRunTime.boxToLong((long)cmd.timestamp())})));
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream prepareOutputStream(FileDropCommand cmd, Option<File> tmpFile) {
        void var3_3;
        FileOutputStream os = new FileOutputStream(this.outFile(cmd));
        if (cmd.append()) {
            Option<File> option = tmpFile;
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                File f = (File)some.x();
                this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copying original content before appending into file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.getAbsolutePath()})));
                FileInputStream tmpIn = new FileInputStream(f);
                StreamCopySupport.copyStream((InputStream)tmpIn, (OutputStream)os);
                tmpIn.close();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
        return var3_3;
    }

    public void blended$file$FileDropActor$$respond(ActorRef requestor, FileDropResult response) {
        if (response.cmd().dropNotification()) {
            this.context().system().eventStream().publish((Object)response);
        }
        package$.MODULE$.actorRef2Scala(requestor).$bang((Object)response, this.self());
        this.context().stop(this.self());
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileDropActor $outer;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                Object object;
                A1 A1 = x1;
                if (!(A1 instanceof FileDropCommand)) {
                    object = function1.apply(x1);
                    return (B1)object;
                }
                FileDropCommand fileDropCommand = (FileDropCommand)A1;
                ActorRef requestor = this.$outer.sender();
                File outdir = new File(fileDropCommand.directory());
                None$ os = None$.MODULE$;
                Option<File> tf = None$.MODULE$;
                if (this.$outer.checkDirectory(outdir)) {
                    void var12_13;
                    boolean bl = fileDropCommand.compressed();
                    if (bl) {
                        InflaterInputStream zippedIs;
                        this.$outer.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing content with compression to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.outFile(fileDropCommand)})));
                        InflaterInputStream inflaterInputStream = zippedIs = this.liftedTree1$1(fileDropCommand);
                    } else {
                        if (false != bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                        this.$outer.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing content without compression to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.outFile(fileDropCommand)})));
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileDropCommand.content());
                    }
                    void is = var12_13;
                    try {
                        tf = this.$outer.tmpFile(fileDropCommand);
                        os = new Some((Object)this.$outer.prepareOutputStream(fileDropCommand, tf));
                        os.foreach((Function1)new Serializable(this, (InputStream)is){
                            public static final long serialVersionUID = 0L;
                            private final InputStream is$1;

                            public final void apply(OutputStream s) {
                                StreamCopySupport.copyStream((InputStream)this.is$1, (OutputStream)s);
                                s.close();
                            }
                            {
                                this.is$1 = is$1;
                            }
                        });
                        File ff = this.$outer.finalFile(fileDropCommand);
                        this.$outer.outFile(fileDropCommand).renameTo(ff);
                        tf.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(File f) {
                                return f.delete();
                            }
                        });
                        this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully executed [", "] and created file [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileDropCommand, ff.getAbsolutePath()})));
                        this.$outer.blended$file$FileDropActor$$respond(requestor, new FileDropResult(fileDropCommand, true));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        try {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable t = (Throwable)option.get();
                            this.$outer.log().warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error executing ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileDropCommand, t.getMessage()})));
                            tf.foreach((Function1)new Serializable(this, fileDropCommand){
                                public static final long serialVersionUID = 0L;
                                private final FileDropCommand x2$1;

                                public final boolean apply(File f) {
                                    return f.renameTo(new File(this.x2$1.directory(), this.x2$1.fileName()));
                                }
                                {
                                    this.x2$1 = x2$1;
                                }
                            });
                            this.$outer.outFile(fileDropCommand).delete();
                            this.$outer.blended$file$FileDropActor$$respond(requestor, new FileDropResult(fileDropCommand, false));
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        finally {
                            is.close();
                        }
                    }
                } else {
                    this.$outer.log().warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The directory [", "] does not exist or is not writable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outdir.getAbsolutePath()})));
                    this.$outer.blended$file$FileDropActor$$respond(requestor, new FileDropResult(fileDropCommand, false));
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = boxedUnit;
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof FileDropCommand;
                return bl;
            }

            private final InflaterInputStream liftedTree1$1(FileDropCommand x2$1) {
                InflaterInputStream inflaterInputStream;
                try {
                    this.$outer.log().debug("Trying to use GZIP compression");
                    inflaterInputStream = new GZIPInputStream(new BufferedInputStream(new ByteArrayInputStream(x2$1.content())));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    this.$outer.log().debug("Trying to use ZIP compression");
                    ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(x2$1.content())));
                    zis.getNextEntry();
                    ZipInputStream zipInputStream = zis;
                    inflaterInputStream = zipInputStream;
                }
                return inflaterInputStream;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public FileDropActor() {
        Actor.class.$init$((Actor)this);
        ActorLogging.class.$init$((ActorLogging)this);
    }
}

