package blended.sbt

import sbt._

trait Blended {

  // TODO: Find a way to generate the current version
  def blendedVersion: String // = version.value

  def blended(name: String) = "de.wayofquality.blended" %% name % blendedVersion

  val activemqBrokerstarter = blended("blended.activemq.brokerstarter")
  val activemqClient = blended("blended.activemq.client")
  val activemqDefaultbroker = blended("blended.activemq.defaultbroker")
  val akka = blended("blended.akka")
  val akkaHttp = blended("blended.akka.http")
  val akkaHttpApi = blended("blended.akka.http.api")
  val akkaHttpJmsQueue = blended("blended.akka.http.jmsqueue")
  val akkaHttpProxy = blended("blended.akka.http.proxy")
  val akkaHttpRestJms = blended("blended.akka.http.restjms")
  val akkaHttpSampleHelloworld = blended("blended.akka.http.sample.helloworld")
  val camelUtils = blended("blended.camel.utils")
  val containerContextApi = blended("blended.container.context.api")
  val containerContextImpl = blended("blended.container.context.impl")
  val containerRegistry = blended("blended.container.registry")
  val demoReactor = blended("blended.demo.reactor")
  val demoMgmt = blended("blended.demo.mgmt")
  val demoMgmtResources = blended("blended.demo.mgmt.resources")
  val demoNode = blended("blended.demo.node")
  val demoNodeResources = blended("blended.demo.node.resources")
  val dockerDemoApacheDS = blended("blended.docker.demo.apacheds")
  val dockerReactor = blended("blended.docker.reactor")
  val dockerDemoNode = blended("blended.docker.demo.node")
  val dockerDemoMgmt = blended("blended.docker.demo.mgmt")
  val domino = blended("blended.domino")
  val file = blended("blended.file")
  val hawtioLogin = blended("blended.hawtio.login")
  val itestReactor = blended("blended.itest.reactor")
  val itestSupport = blended("blended.itestsupport")
  val itestMgmt = blended("blended.itest.mgmt")
  val itestNode = blended("blended.itest.node")
  val jettyBoot = blended("blended.jetty.boot")
  val jmsBridge = blended("blended.jms.bridge")
  val jmsSampler = blended("blended.jms.sampler")
  val jmsUtils = blended("blended.jms.utils")
  val jmx = blended("blended.jmx")
  val jolokia = blended("blended.jolokia")
  val launcher = blended("blended.launcher")
  val launcherFeatures = blended("blended.launcher.features")
  val mgmtAgent = blended("blended.mgmt.agent")
  val mgmtBase = blended("blended.mgmt.base")
  val mgmtRepo = blended("blended.mgmt.repo")
  val mgmtRepoRest = blended("blended.mgmt.repo.rest")
  val mgmtMock = blended("blended.mgmt.mock")
  val mgmtRest = blended("blended.mgmt.rest")
  val mgmtServiceJmx = blended("blended.mgmt.service.jmx")
  val mgmtWs = blended("blended.mgmt.ws")
  val persistence = blended("blended.persistence")
  val persistenceH2 = blended("blended.persistence.h2")
  val prickle = blended("blended.prickle")
  val prickleAkkaHttp = blended("blended.prickle.akka.http")
  val samplesReactor = blended("blended.samples.reactor")
  val samplesCamel = blended("blended.samples.camel")
  val samplesJms = blended("blended.samples.jms")
  val security = blended("blended.security")
  val securityAkkaHttp = blended("blended.security.akka.http")
  val securityBoot = blended("blended.security.boot")
  val securityScep = blended("blended.security.scep")
  val securityScepStandalone = blended("blended.security.scep.standalone")
  val securitySsl = blended("blended.security.ssl")
  val securityLoginApi = blended("blended.security.login.api")
  val securityLoginImpl = blended("blended.security.login.impl")
  val securityLoginRest = blended("blended.security.login.rest")
  val sslContext = blended("blended.sslcontext")
  val streams = blended("blended.streams")
  val streamsDispatcher = blended("blended.streams.dispatcher")
  val streamsTestsupport = blended("blended.streams.testsupport")
  val testSupport = blended("blended.testsupport")
  val testSupportPojosr = blended("blended.testsupport.pojosr")
  val updater = blended("blended.updater")
  val updaterConfig = blended("blended.updater.config")
  val updaterRemote = blended("blended.updater.remote")
  val updaterTools = blended("blended.updater.tools")
  val util = blended("blended.util")
  val utilLogging = blended("blended.util.logging")
}
