/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.dispatcher.internal.builder;

import akka.NotUsed;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow$;
import blended.container.context.api.ContainerContext;
import blended.jms.bridge.BridgeProviderConfig;
import blended.jms.bridge.BridgeProviderRegistry;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsDestination$;
import blended.streams.FlowProcessor$;
import blended.streams.dispatcher.internal.ResourceTypeRouterConfig;
import blended.streams.dispatcher.internal.builder.DispatcherBuilderSupport;
import blended.streams.dispatcher.internal.builder.DispatcherOutbound;
import blended.streams.jms.JmsFlowSupport$;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelopeLogger;
import blended.util.logging.LogLevel$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class DispatcherOutbound$ {
    public static final DispatcherOutbound$ MODULE$ = new DispatcherOutbound$();
    private static final Function1<ContainerContext, Function1<DispatcherBuilderSupport, Function1<FlowEnvelope, Try<JmsDestination>>>> resolveDest = (Function1 & Serializable)ctCtxt -> (Function1 & Serializable)bs -> (Function1 & Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
        JmsDestination jmsDestination;
        Option option = (Option)env.getFromContext(bs.bridgeDestinationKey()).get();
        if (None$.MODULE$.equals(option)) {
            throw new Exception(new StringBuilder(35).append("Failed to resolve context object [").append(bs.bridgeDestinationKey()).append("]").toString());
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        Some some = (Some)option;
        Option ctxtDest = (Option)some.value();
        Option option2 = ctxtDest;
        if (None$.MODULE$.equals(option2)) {
            jmsDestination = (JmsDestination)JmsDestination$.MODULE$.create(JmsFlowSupport$.MODULE$.replyToQueueName()).get();
            return jmsDestination;
        } else {
            if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
            Some some2 = (Some)option2;
            String d = (String)some2.value();
            String name = (String)ctCtxt.resolveString(d, env.flowMessage().header().view().mapValues((Function1 & Serializable)x$1 -> x$1.value()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)x$2 -> x$2.toString()).get();
            jmsDestination = (JmsDestination)JmsDestination$.MODULE$.create(name).get();
        }
        return jmsDestination;
    });

    public Try<BridgeProviderConfig> resolveProvider(BridgeProviderRegistry registry, Option<String> vendor, Option<String> provider) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Tuple2 tuple2 = new Tuple2((Object)vendor, (Object)provider);
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String v = (String)some.value();
                    if (option2 instanceof Some) {
                        BridgeProviderConfig r;
                        Some some2 = (Some)option2;
                        String p = (String)some2.value();
                        Option option3 = registry.jmsProvider(v, p);
                        if (None$.MODULE$.equals(option3)) {
                            throw new Exception(new StringBuilder(30).append("Could not resolve provider [").append(vendor).append(":").append(provider).append("]").toString());
                        }
                        if (!(option3 instanceof Some)) throw new MatchError((Object)option3);
                        Some some3 = (Some)option3;
                        BridgeProviderConfig bridgeProviderConfig = r = (BridgeProviderConfig)some3.value();
                        return bridgeProviderConfig;
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            throw new Exception(new StringBuilder(30).append("Could not resolve provider [").append(vendor).append(":").append(provider).append("]").toString());
        });
    }

    public Function1<ContainerContext, Function1<DispatcherBuilderSupport, Function1<FlowEnvelope, Try<JmsDestination>>>> resolveDest() {
        return resolveDest;
    }

    public Try<DispatcherOutbound.DispatcherTarget> outboundRouting(ResourceTypeRouterConfig dispatcherCfg, ContainerContext ctCtxt, DispatcherBuilderSupport bs, FlowEnvelopeLogger streamLogger, FlowEnvelope env) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            BridgeProviderConfig bridgeProviderConfig;
            JmsDestination jmsDestination;
            JmsDestination dest = (JmsDestination)((Try)((Function1)((Function1)MODULE$.resolveDest().apply((Object)ctCtxt)).apply((Object)bs)).apply((Object)env)).get();
            String string = dest.name();
            String string2 = JmsFlowSupport$.MODULE$.replyToQueueName();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                String replyToHeader = (String)JmsFlowSupport$.MODULE$.replyToHeader().apply((Object)bs.headerConfig().prefix());
                Option option = env.header(replyToHeader, ManifestFactory$.MODULE$.classType(String.class));
                if (None$.MODULE$.equals(option)) {
                    throw new Exception(new StringBuilder(49).append("Header [").append(replyToHeader).append("] must be set for replyTo dispatcher flow").toString());
                }
                if (!(option instanceof Some)) {
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                String s2 = (String)some.value();
                JmsDestination jmsDestination2 = (JmsDestination)JmsDestination$.MODULE$.create(s2).get();
                jmsDestination = jmsDestination2;
            } else {
                jmsDestination = dest;
            }
            JmsDestination targetDest = jmsDestination;
            String string4 = dest.name();
            String string5 = JmsFlowSupport$.MODULE$.replyToQueueName();
            String string6 = string4;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                Option v = env.header((String)bs.srcVendorHeader().apply((Object)bs.headerConfig().prefix()), ManifestFactory$.MODULE$.classType(String.class)).map((Function1 & Serializable)s -> (String)ctCtxt.resolveString(s, ctCtxt.resolveString$default$2()).map((Function1 & Serializable)x$3 -> x$3.toString()).get());
                Option p = env.header((String)bs.srcProviderHeader().apply((Object)bs.headerConfig().prefix()), ManifestFactory$.MODULE$.classType(String.class)).map((Function1 & Serializable)s -> (String)ctCtxt.resolveString(s, ctCtxt.resolveString$default$2()).map((Function1 & Serializable)x$4 -> x$4.toString()).get());
                bridgeProviderConfig = (BridgeProviderConfig)MODULE$.resolveProvider(dispatcherCfg.providerRegistry(), (Option<String>)v, (Option<String>)p).get();
            } else {
                BridgeProviderConfig p;
                Option option = (Option)env.getFromContext(bs.bridgeProviderKey()).get();
                if (None$.MODULE$.equals(option)) {
                    throw new Exception(new StringBuilder(35).append("Failed to resolve context object [").append(bs.bridgeProviderKey()).append("]").toString());
                }
                if (!(option instanceof Some)) {
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                BridgeProviderConfig bridgeProviderConfig2 = p = (BridgeProviderConfig)some.value();
                bridgeProviderConfig = bridgeProviderConfig2;
            }
            BridgeProviderConfig bridgeProvider = bridgeProviderConfig;
            DispatcherOutbound.DispatcherTarget result = new DispatcherOutbound.DispatcherTarget(bridgeProvider.vendor(), bridgeProvider.provider(), targetDest);
            streamLogger.logEnv(env, LogLevel$.MODULE$.Debug(), (Function0 & Serializable)() -> new StringBuilder(20).append("Routing for [").append(env.id()).append("] is [").append(result).append("]").toString(), streamLogger.logEnv$default$4());
            return result;
        });
    }

    public Graph<FlowShape<FlowEnvelope, FlowEnvelope>, NotUsed> apply(ResourceTypeRouterConfig dispatcherCfg, ContainerContext ctCtxt, FlowEnvelopeLogger streamLogger, DispatcherBuilderSupport bs) {
        Graph routingDecider = FlowProcessor$.MODULE$.fromFunction("routingDecider", streamLogger, (Function1 & Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
            DispatcherOutbound.DispatcherTarget routing = (DispatcherOutbound.DispatcherTarget)MODULE$.outboundRouting(dispatcherCfg, ctCtxt, bs, streamLogger, (FlowEnvelope)env).get();
            FlowEnvelope qual$1 = (FlowEnvelope)env.withHeader(bs.headerBridgeVendor(), (Object)routing.vendor(), env.withHeader$default$3()).get();
            String x$1 = bs.headerBridgeProvider();
            String x$2 = routing.provider();
            boolean x$3 = qual$1.withHeader$default$3();
            FlowEnvelope qual$2 = (FlowEnvelope)qual$1.withHeader(x$1, (Object)x$2, x$3).get();
            String x$4 = bs.headerBridgeDest();
            String x$5 = routing.dest().asString();
            boolean x$6 = qual$2.withHeader$default$3();
            FlowEnvelope qual$3 = (FlowEnvelope)qual$2.withHeader(x$4, (Object)x$5, x$6).get();
            String x$7 = bs.headerConfig().headerTrack();
            boolean x$8 = true;
            boolean x$9 = qual$3.withHeader$default$3();
            return (FlowEnvelope)qual$3.withHeader(x$7, (Object)BoxesRunTime.boxToBoolean((boolean)true), x$9).get();
        }));
        return Flow$.MODULE$.fromGraph(routingDecider);
    }

    private DispatcherOutbound$() {
    }
}

