/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils.internal;

import akka.actor.ActorSystem;
import blended.jms.utils.BlendedJMSConnection;
import blended.jms.utils.ConnectionConfig;
import blended.jms.utils.Reconnect;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005}b!\u0002\t\u0012\u0003\u0003Q\u0002\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\t\u0011\u001d\u0002!\u0011!Q\u0001\n\rB\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006Y!\u000b\u0005\u0006c\u0001!\tA\r\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u0019)\u0005\u0001)A\u0005u!9a\t\u0001b\u0001\n\u0003I\u0004BB$\u0001A\u0003%!\b\u0003\u0004I\u0001\u0001\u0006I!\u0013\u0005\u0007#\u0002\u0001\u000b\u0015\u0002*\t\ra\u0003\u0001\u0015)\u0003Z\u0011\u0015!\u0007A\"\u0001f\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u001d\tY\u0003\u0001C\u0001\u0003[\u0011\u0001cQ8o]\u0016\u001cG/[8o\u0011>dG-\u001a:\u000b\u0005I\u0019\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Q)\u0012!B;uS2\u001c(B\u0001\f\u0018\u0003\rQWn\u001d\u0006\u00021\u00059!\r\\3oI\u0016$7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017AB2p]\u001aLw-F\u0001$!\t!S%D\u0001\u0014\u0013\t13C\u0001\tD_:tWm\u0019;j_:\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013AB:zgR,W\u000e\u0005\u0002+_5\t1F\u0003\u0002-[\u0005)\u0011m\u0019;pe*\ta&\u0001\u0003bW.\f\u0017B\u0001\u0019,\u0005-\t5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\t\u0019t\u0007\u0006\u00025mA\u0011Q\u0007A\u0007\u0002#!)\u0001\u0006\u0002a\u0002S!)\u0011\u0005\u0002a\u0001G\u00051a/\u001a8e_J,\u0012A\u000f\t\u0003w\ts!\u0001\u0010!\u0011\u0005ujR\"\u0001 \u000b\u0005}J\u0012A\u0002\u001fs_>$h(\u0003\u0002B;\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\tU$A\u0004wK:$wN\u001d\u0011\u0002\u0011A\u0014xN^5eKJ\f\u0011\u0002\u001d:pm&$WM\u001d\u0011\u0002\u00071|w\r\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u00069An\\4hS:<'B\u0001(\u0018\u0003\u0011)H/\u001b7\n\u0005A[%A\u0002'pO\u001e,'/\u0001\u0003d_:t\u0007c\u0001\u000fT+&\u0011A+\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u00112\u0016BA,\u0014\u0005Q\u0011E.\u001a8eK\u0012TUjU\"p]:,7\r^5p]\u0006Q1m\u001c8oK\u000e$\u0018N\\4\u0011\u0005i\u0013W\"A.\u000b\u0005qk\u0016AB1u_6L7M\u0003\u0002_?\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00059\u0003'\"A1\u0002\t)\fg/Y\u0005\u0003Gn\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001F4fi\u000e{gN\\3di&|gNR1di>\u0014\u0018\u0010F\u0001g!\t97.D\u0001i\u0015\t1\u0012NC\u0001k\u0003\u0015Q\u0017M^1y\u0013\ta\u0007NA\tD_:tWm\u0019;j_:4\u0015m\u0019;pef\fQbZ3u\u0007>tg.Z2uS>tG#\u0001*\u0002\u000f\r|gN\\3diR\t\u0011\u000f\u0005\u0002he&\u00111\u000f\u001b\u0002\u000b\u0007>tg.Z2uS>t\u0007f\u0001\bvwB\u0019AD\u001e=\n\u0005]l\"A\u0002;ie><8\u000f\u0005\u0002hs&\u0011!\u0010\u001b\u0002\r\u00156\u001bV\t_2faRLwN\\\u0019\u0006=ib\u0018\u0011F\u0019\tGu\f\t!a\b\u0002\u0004U\u0011\u0011H \u0003\u0007\u007ff\u0011\r!!\u0003\u0003\u0003QKA!a\u0001\u0002\u0006\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!a\u0002\u001e\u0003\u0019!\bN]8xgF!\u00111BA\t!\ra\u0012QB\u0005\u0004\u0003\u001fi\"a\u0002(pi\"Lgn\u001a\t\u0005\u0003'\tIBD\u0002\u001d\u0003+I1!a\u0006\u001e\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0007\u0002\u001e\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003/i\u0012'C\u0012\u0002\"\u0005\r\u0012QEA\u0004\u001d\ra\u00121E\u0005\u0004\u0003\u000fi\u0012'\u0002\u0012\u001d;\u0005\u001d\"!B:dC2\f\u0017G\u0001\u0014y\u0003\u0015\u0019Gn\\:f)\t\ty\u0003\u0005\u0004\u00022\u0005U\u0012\u0011H\u0007\u0003\u0003gQ!AT\u000f\n\t\u0005]\u00121\u0007\u0002\u0004)JL\bc\u0001\u000f\u0002<%\u0019\u0011QH\u000f\u0003\tUs\u0017\u000e\u001e")
public abstract class ConnectionHolder {
    private final ConnectionConfig config;
    public final ActorSystem blended$jms$utils$internal$ConnectionHolder$$system;
    private final String vendor;
    private final String provider;
    public final Logger blended$jms$utils$internal$ConnectionHolder$$log;
    private Option<BlendedJMSConnection> conn;
    private AtomicBoolean connecting;

    public ConnectionConfig config() {
        return this.config;
    }

    public String vendor() {
        return this.vendor;
    }

    public String provider() {
        return this.provider;
    }

    public abstract ConnectionFactory getConnectionFactory();

    public Option<BlendedJMSConnection> getConnection() {
        this.blended$jms$utils$internal$ConnectionHolder$$log.trace((Function0 & Serializable)() -> new StringBuilder(45).append("Underlying connection [").append(this.vendor()).append(":").append(this.provider()).append("] is established : [").append($this.conn.isDefined()).append("]").toString());
        return this.conn;
    }

    public Connection connect() throws JMSException {
        BlendedJMSConnection blendedJMSConnection;
        Option<BlendedJMSConnection> option = this.conn;
        if (option instanceof Some) {
            BlendedJMSConnection c;
            Some some = (Some)option;
            blendedJMSConnection = c = (BlendedJMSConnection)some.value();
        } else if (None$.MODULE$.equals(option)) {
            BlendedJMSConnection blendedJMSConnection2;
            block18: {
                if (!this.connecting.getAndSet(true)) {
                    try {
                        try {
                            Connection connection;
                            this.blended$jms$utils$internal$ConnectionHolder$$log.info((Function0 & Serializable)() -> new StringBuilder(76).append("Creating underlying connection for provider [").append(this.vendor()).append(":").append(this.provider()).append("] as user [").append(this.config().defaultUser()).append("] with client id [").append(this.config().clientId()).append("]").toString());
                            ConnectionFactory cf = this.getConnectionFactory();
                            Option<String> option2 = this.config().defaultUser();
                            if (None$.MODULE$.equals(option2)) {
                                connection = cf.createConnection();
                            } else if (option2 instanceof Some) {
                                Some some = (Some)option2;
                                String user = (String)some.value();
                                connection = cf.createConnection(user, (String)this.config().defaultPassword().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                            } else {
                                throw new MatchError(option2);
                            }
                            Connection c = connection;
                            try {
                                c.setClientID(this.config().clientId());
                                c.setExceptionListener(new ExceptionListener(this){
                                    private final /* synthetic */ ConnectionHolder $outer;

                                    public void onException(JMSException e) {
                                        this.$outer.blended$jms$utils$internal$ConnectionHolder$$log.warn((Function0 & Serializable)() -> new StringBuilder(55).append("Exception encountered in connection for provider [").append($this.$outer.vendor()).append(":").append($this.$outer.provider()).append("] : ").append(e.getMessage()).toString());
                                        this.$outer.blended$jms$utils$internal$ConnectionHolder$$system.eventStream().publish((Object)new Reconnect(this.$outer.vendor(), this.$outer.provider(), (Option<Throwable>)new Some((Object)e)));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }

                                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onException$1(blended.jms.utils.internal.ConnectionHolder$$anon$1 javax.jms.JMSException )}, serializedLambda);
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                Option option3;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option3 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable e = (Throwable)option3.get();
                                    this.blended$jms$utils$internal$ConnectionHolder$$log.error((Function0 & Serializable)() -> new StringBuilder(50).append("Error setting client Id [").append(this.config().clientId()).append("]...Closing Connection...").toString());
                                    c.close();
                                    throw e;
                                }
                                throw throwable;
                            }
                            c.start();
                            this.blended$jms$utils$internal$ConnectionHolder$$log.info((Function0 & Serializable)() -> new StringBuilder(46).append("Successfully connected to [").append(this.vendor()).append(":").append(this.provider()).append("] with clientId [").append(this.config().clientId()).append("]").toString());
                            BlendedJMSConnection wrappedConnection = new BlendedJMSConnection(this.vendor(), this.provider(), c);
                            this.conn = new Some((Object)wrappedConnection);
                            blendedJMSConnection2 = wrappedConnection;
                            break block18;
                        }
                        catch (Throwable throwable) {
                            Option option4;
                            Throwable throwable3 = throwable;
                            if (throwable3 != null && !(option4 = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                                Throwable t = (Throwable)option4.get();
                                String msg = new StringBuilder(34).append("Error creating connection [").append(this.vendor()).append(":").append(this.provider()).append("] : [").append(t.getMessage()).append("]").toString();
                                this.blended$jms$utils$internal$ConnectionHolder$$log.warn((Function0 & Serializable)() -> msg);
                                JMSException e = new JMSException(msg);
                                e.setLinkedException(new Exception(t));
                                throw e;
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        this.connecting.set(false);
                    }
                }
                throw new JMSException(new StringBuilder(56).append("Connection Factory for provider [").append(this.vendor()).append(":").append(this.provider()).append("] is still connecting.").toString());
            }
            blendedJMSConnection = blendedJMSConnection2;
        } else {
            throw new MatchError(option);
        }
        return blendedJMSConnection;
    }

    public Try<BoxedUnit> close() {
        Success success;
        Option<BlendedJMSConnection> option = this.conn;
        if (None$.MODULE$.equals(option)) {
            success = new Success((Object)BoxedUnit.UNIT);
        } else if (option instanceof Some) {
            Success success2;
            Some some = (Some)option;
            BlendedJMSConnection c = (BlendedJMSConnection)some.value();
            this.blended$jms$utils$internal$ConnectionHolder$$log.info((Function0 & Serializable)() -> new StringBuilder(45).append("Closing underlying connection for provider [").append(this.provider()).append("]").toString());
            try {
                try {
                    c.connection().close();
                    success2 = new Success((Object)BoxedUnit.UNIT);
                }
                catch (Throwable throwable) {
                    Option option2;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable t = (Throwable)option2.get();
                    Failure failure = new Failure(t);
                    success2 = failure;
                }
            }
            finally {
                this.conn = None$.MODULE$;
            }
            success = success2;
        } else {
            throw new MatchError(option);
        }
        return success;
    }

    public ConnectionHolder(ConnectionConfig config, ActorSystem system) {
        this.config = config;
        this.blended$jms$utils$internal$ConnectionHolder$$system = system;
        this.vendor = config.vendor();
        this.provider = config.provider();
        this.blended$jms$utils$internal$ConnectionHolder$$log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(ConnectionHolder.class));
        this.conn = None$.MODULE$;
        this.connecting = new AtomicBoolean(false);
    }
}

