/*
 * Decompiled with CFR 0.152.
 */
package blended.activemq.client;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.pattern.package$;
import akka.stream.KillSwitch;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Source;
import blended.activemq.client.ConnectionVerifier;
import blended.activemq.client.RoundtripConnectionVerifier$;
import blended.container.context.api.ContainerContext;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.JmsDestination;
import blended.streams.FlowHeaderConfig;
import blended.streams.FlowHeaderConfig$;
import blended.streams.jms.JmsConsumerSettings;
import blended.streams.jms.JmsDeliveryMode;
import blended.streams.jms.JmsEnvelopeHeader;
import blended.streams.jms.JmsKeyFormatStrategy;
import blended.streams.jms.JmsProducerSettings;
import blended.streams.jms.JmsProducerSettings$;
import blended.streams.jms.JmsStreamSupport;
import blended.streams.jms.MessageDestinationResolver;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelopeLogger;
import blended.streams.message.FlowEnvelopeLogger$;
import blended.streams.processor.Collector;
import blended.util.logging.LogLevel$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001\u0002\f\u0018\u0001yA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003P\u0011!9\u0006A!A!\u0002\u0013A\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011\u0005\u0004!\u0011!Q\u0001\f\tDQA\u001b\u0001\u0005\u0002-Dq!\u001e\u0001C\u0002\u0013%a\u000f\u0003\u0004\u0000\u0001\u0001\u0006Ia\u001e\u0005\n\u0003\u0003\u0001!\u0019!C\u0005\u0003\u0007A\u0001\"!\u0004\u0001A\u0003%\u0011Q\u0001\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\tI\u0005\u0001C\t\u0003\u0017Bq!!\u0018\u0001\t#\ty\u0006C\u0004\u0002h\u0001!I!!\u001b\b\u0013\u0005Et#!A\t\u0002\u0005Md\u0001\u0003\f\u0018\u0003\u0003E\t!!\u001e\t\r)\u0014B\u0011AA<\u0011%\tIHEI\u0001\n\u0003\tY\bC\u0005\u0002\u0012J\t\n\u0011\"\u0001\u0002|\tY\"k\\;oIR\u0014\u0018\u000e]\"p]:,7\r^5p]Z+'/\u001b4jKJT!\u0001G\r\u0002\r\rd\u0017.\u001a8u\u0015\tQ2$\u0001\u0005bGRLg/Z7r\u0015\u0005a\u0012a\u00022mK:$W\rZ\u0002\u0001'\u0015\u0001q$J\u00152!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u0002/%\u0011\u0001f\u0006\u0002\u0013\u0007>tg.Z2uS>tg+\u001a:jM&,'\u000f\u0005\u0002+_5\t1F\u0003\u0002-[\u0005\u0019!.\\:\u000b\u00059Z\u0012aB:ue\u0016\fWn]\u0005\u0003a-\u0012\u0001CS7t'R\u0014X-Y7TkB\u0004xN\u001d;\u0011\u0005)\u0012\u0014BA\u001a,\u0005EQUn]#om\u0016dw\u000e]3IK\u0006$WM]\u0001\taJ|'-Z'tOB!\u0001E\u000e\u001dD\u0013\t9\u0014EA\u0005Gk:\u001cG/[8ocA\u0011\u0011\b\u0011\b\u0003uy\u0002\"aO\u0011\u000e\u0003qR!!P\u000f\u0002\rq\u0012xn\u001c;?\u0013\ty\u0014%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0003\n\u0013aa\u0015;sS:<'BA \"!\t!u)D\u0001F\u0015\t1U&A\u0004nKN\u001c\u0018mZ3\n\u0005!+%\u0001\u0004$m_^,eN^3m_B,\u0017A\u0002<fe&4\u0017\u0010\u0005\u0003!m\r[\u0005C\u0001\u0011M\u0013\ti\u0015EA\u0004C_>dW-\u00198\u0002\u0017I,\u0017/^3ti\u0012+7\u000f\u001e\t\u0003!Rk\u0011!\u0015\u0006\u0003%N\u000bQ!\u001e;jYNT!\u0001L\u000e\n\u0005U\u000b&A\u0004&ng\u0012+7\u000f^5oCRLwN\\\u0001\re\u0016\u001c\bo\u001c8tK\u0012+7\u000f^\u0001\u000ee\u0016$(/_%oi\u0016\u0014h/\u00197\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005u\u000b\u0013AC2p]\u000e,(O]3oi&\u0011qL\u0017\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u00039\u0011XmY3jm\u0016$\u0016.\\3pkR\faa]=ti\u0016l\u0007CA2i\u001b\u0005!'BA3g\u0003\u0015\t7\r^8s\u0015\u00059\u0017\u0001B1lW\u0006L!!\u001b3\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f1|\u0007/\u001d:tiR\u0011QN\u001c\t\u0003M\u0001AQ!\u0019\u0005A\u0004\tDQ\u0001\u000e\u0005A\u0002UBQ!\u0013\u0005A\u0002)CQA\u0014\u0005A\u0002=CQA\u0016\u0005A\u0002=Cqa\u0016\u0005\u0011\u0002\u0003\u0007\u0001\fC\u0004a\u0011A\u0005\t\u0019\u0001-\u0002\u00071|w-F\u0001x!\tAX0D\u0001z\u0015\tQ80A\u0004m_\u001e<\u0017N\\4\u000b\u0005q\\\u0012\u0001B;uS2L!A`=\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u0011Y,'/\u001b4jK\u0012,\"!!\u0002\u0011\u000b\u0005\u001d\u0011\u0011B&\u000e\u0003qK1!a\u0003]\u0005\u001d\u0001&o\\7jg\u0016\f\u0011B^3sS\u001aLW\r\u001a\u0011\u0002!Y,'/\u001b4z\u0007>tg.Z2uS>tG\u0003BA\n\u0003c!B!!\u0006\u0002(Q!\u0011qCA\u000f!\u0015\t9!!\u0007L\u0013\r\tY\u0002\u0018\u0002\u0007\rV$XO]3\t\u000f\u0005}Q\u0002q\u0001\u0002\"\u0005)Qm\u0011;yiB!\u0011qAA\u0012\u0013\r\t)\u0003\u0018\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDq!!\u000b\u000e\u0001\u0004\tY#\u0001\u0002dMB\u0019\u0001+!\f\n\u0007\u0005=\u0012K\u0001\rJI\u0006;\u0018M]3D_:tWm\u0019;j_:4\u0015m\u0019;pefDq!a\r\u000e\u0001\u0004\t)$\u0001\u0004di\u000e#\b\u0010\u001e\t\u0005\u0003o\t)%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u007f\t\t%A\u0004d_:$X\r\u001f;\u000b\u0007\u0005\r3$A\u0005d_:$\u0018-\u001b8fe&!\u0011qIA\u001d\u0005A\u0019uN\u001c;bS:,'oQ8oi\u0016DH/A\bxC&$hi\u001c:SKN\u0004xN\\:f)\u0011\ti%a\u0017\u0015\r\u0005=\u0013QKA,!\r\u0001\u0013\u0011K\u0005\u0004\u0003'\n#\u0001B+oSRDq!!\u000b\u000f\u0001\u0004\tY\u0003\u0003\u0004\u0002Z9\u0001\r\u0001O\u0001\u0003S\u0012Dq!a\r\u000f\u0001\u0004\t)$A\u0003qe>\u0014W\r\u0006\u0003\u0002b\u0005\u0015D\u0003BA(\u0003GBq!!\u000b\u0010\u0001\u0004\tY\u0003C\u0004\u00024=\u0001\r!!\u000e\u0002\u001bM\u001c\u0007.\u001a3vY\u0016\u0014V\r\u001e:z)\u0011\tY'a\u001c\u0015\t\u0005=\u0013Q\u000e\u0005\b\u0003S\u0001\u0002\u0019AA\u0016\u0011\u001d\t\u0019\u0004\u0005a\u0001\u0003k\t1DU8v]\u0012$(/\u001b9D_:tWm\u0019;j_:4VM]5gS\u0016\u0014\bC\u0001\u0014\u0013'\t\u0011r\u0004\u0006\u0002\u0002t\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!! +\u0007a\u000byh\u000b\u0002\u0002\u0002B!\u00111QAG\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015!C;oG\",7m[3e\u0015\r\tY)I\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAH\u0003\u000b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0001")
public class RoundtripConnectionVerifier
implements ConnectionVerifier,
JmsStreamSupport,
JmsEnvelopeHeader {
    private final Function1<String, FlowEnvelope> probeMsg;
    private final Function1<FlowEnvelope, Object> verify;
    private final JmsDestination requestDest;
    private final JmsDestination responseDest;
    private final FiniteDuration retryInterval;
    private final FiniteDuration receiveTimeout;
    private final ActorSystem system;
    private final Logger log;
    private final Promise<Object> verified;
    private Function1<String, String> jmsHeaderPrefix;
    private Function1<String, String> srcVendorHeader;
    private Function1<String, String> srcProviderHeader;
    private Function1<String, String> srcDestHeader;
    private Function1<String, String> destHeader;
    private Function1<String, String> corrIdHeader;
    private Function1<String, String> priorityHeader;
    private Function1<String, String> expireHeader;
    private Function1<String, String> deliveryModeHeader;
    private Function1<String, String> replyToHeader;
    private Function1<String, String> timestampHeader;
    private Function1<String, String> typeHeader;
    private Function1<String, String> msgIdHeader;
    private String replyToQueueName;

    public static FiniteDuration $lessinit$greater$default$6() {
        return RoundtripConnectionVerifier$.MODULE$.$lessinit$greater$default$6();
    }

    public static FiniteDuration $lessinit$greater$default$5() {
        return RoundtripConnectionVerifier$.MODULE$.$lessinit$greater$default$5();
    }

    public Try<KillSwitch> processMessages(Flow<FlowEnvelope, FlowEnvelope, ?> processFlow, Seq<FlowEnvelope> msgs, ActorSystem system) {
        return JmsStreamSupport.processMessages$((JmsStreamSupport)this, processFlow, msgs, (ActorSystem)system);
    }

    public Try<KillSwitch> sendMessages(JmsProducerSettings producerSettings, FlowEnvelopeLogger log, Seq<FlowEnvelope> msgs, ActorSystem system) {
        return JmsStreamSupport.sendMessages$((JmsStreamSupport)this, (JmsProducerSettings)producerSettings, (FlowEnvelopeLogger)log, msgs, (ActorSystem)system);
    }

    public Collector<FlowEnvelope> receiveMessages(FlowHeaderConfig headerCfg, IdAwareConnectionFactory cf, JmsDestination dest, FlowEnvelopeLogger log, Integer listener, Option<FiniteDuration> minMessageDelay, Option<String> selector, Option<Function1<Seq<FlowEnvelope>, Object>> completeOn, Option<FiniteDuration> timeout, ActorSystem system) {
        return JmsStreamSupport.receiveMessages$((JmsStreamSupport)this, (FlowHeaderConfig)headerCfg, (IdAwareConnectionFactory)cf, (JmsDestination)dest, (FlowEnvelopeLogger)log, (Integer)listener, minMessageDelay, selector, completeOn, timeout, (ActorSystem)system);
    }

    public Integer receiveMessages$default$5() {
        return JmsStreamSupport.receiveMessages$default$5$((JmsStreamSupport)this);
    }

    public Option<FiniteDuration> receiveMessages$default$6() {
        return JmsStreamSupport.receiveMessages$default$6$((JmsStreamSupport)this);
    }

    public Option<String> receiveMessages$default$7() {
        return JmsStreamSupport.receiveMessages$default$7$((JmsStreamSupport)this);
    }

    public Option<Function1<Seq<FlowEnvelope>, Object>> receiveMessages$default$8() {
        return JmsStreamSupport.receiveMessages$default$8$((JmsStreamSupport)this);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> jmsProducer(String name, JmsProducerSettings settings, boolean autoAck, ActorSystem system) {
        return JmsStreamSupport.jmsProducer$((JmsStreamSupport)this, (String)name, (JmsProducerSettings)settings, (boolean)autoAck, (ActorSystem)system);
    }

    public Source<FlowEnvelope, NotUsed> jmsConsumer(String name, JmsConsumerSettings settings, Option<FiniteDuration> minMessageDelay, ActorSystem system) {
        return JmsStreamSupport.jmsConsumer$((JmsStreamSupport)this, (String)name, (JmsConsumerSettings)settings, minMessageDelay, (ActorSystem)system);
    }

    public Function1<String, String> jmsHeaderPrefix() {
        return this.jmsHeaderPrefix;
    }

    public Function1<String, String> srcVendorHeader() {
        return this.srcVendorHeader;
    }

    public Function1<String, String> srcProviderHeader() {
        return this.srcProviderHeader;
    }

    public Function1<String, String> srcDestHeader() {
        return this.srcDestHeader;
    }

    public Function1<String, String> destHeader() {
        return this.destHeader;
    }

    public Function1<String, String> corrIdHeader() {
        return this.corrIdHeader;
    }

    public Function1<String, String> priorityHeader() {
        return this.priorityHeader;
    }

    public Function1<String, String> expireHeader() {
        return this.expireHeader;
    }

    public Function1<String, String> deliveryModeHeader() {
        return this.deliveryModeHeader;
    }

    public Function1<String, String> replyToHeader() {
        return this.replyToHeader;
    }

    public Function1<String, String> timestampHeader() {
        return this.timestampHeader;
    }

    public Function1<String, String> typeHeader() {
        return this.typeHeader;
    }

    public Function1<String, String> msgIdHeader() {
        return this.msgIdHeader;
    }

    public String replyToQueueName() {
        return this.replyToQueueName;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$jmsHeaderPrefix_$eq(Function1<String, String> x$1) {
        this.jmsHeaderPrefix = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcVendorHeader_$eq(Function1<String, String> x$1) {
        this.srcVendorHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcProviderHeader_$eq(Function1<String, String> x$1) {
        this.srcProviderHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcDestHeader_$eq(Function1<String, String> x$1) {
        this.srcDestHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$destHeader_$eq(Function1<String, String> x$1) {
        this.destHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$corrIdHeader_$eq(Function1<String, String> x$1) {
        this.corrIdHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$priorityHeader_$eq(Function1<String, String> x$1) {
        this.priorityHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$expireHeader_$eq(Function1<String, String> x$1) {
        this.expireHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$deliveryModeHeader_$eq(Function1<String, String> x$1) {
        this.deliveryModeHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToHeader_$eq(Function1<String, String> x$1) {
        this.replyToHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$timestampHeader_$eq(Function1<String, String> x$1) {
        this.timestampHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$typeHeader_$eq(Function1<String, String> x$1) {
        this.typeHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$msgIdHeader_$eq(Function1<String, String> x$1) {
        this.msgIdHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToQueueName_$eq(String x$1) {
        this.replyToQueueName = x$1;
    }

    private Logger log() {
        return this.log;
    }

    private Promise<Object> verified() {
        return this.verified;
    }

    @Override
    public Future<Object> verifyConnection(ContainerContext ctCtxt, IdAwareConnectionFactory cf, ExecutionContext eCtxt) {
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.probe(ctCtxt, cf), eCtxt);
        return this.verified().future();
    }

    public void waitForResponse(ContainerContext ctCtxt, IdAwareConnectionFactory cf, String id) {
        FlowHeaderConfig headerConfig;
        ExecutionContextExecutor eCtxt = this.system.dispatcher();
        FlowHeaderConfig x$12 = headerConfig = FlowHeaderConfig$.MODULE$.create(ctCtxt);
        IdAwareConnectionFactory x$2 = cf;
        JmsDestination x$3 = this.responseDest;
        FlowEnvelopeLogger x$4 = FlowEnvelopeLogger$.MODULE$.create(headerConfig, this.log());
        Integer x$5 = Predef$.MODULE$.int2Integer(1);
        Some x$6 = new Some((Object)new StringBuilder(19).append("JMSCorrelationID='").append(id).append("'").toString());
        Some x$7 = new Some((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        Some x$8 = new Some((Object)this.receiveTimeout);
        Option<FiniteDuration> x$9 = this.receiveMessages$default$6();
        Collector<FlowEnvelope> collector = this.receiveMessages(x$12, x$2, x$3, x$4, x$5, x$9, (Option<String>)x$6, (Option<Function1<Seq<FlowEnvelope>, Object>>)x$7, (Option<FiniteDuration>)x$8, this.system);
        collector.result().onComplete((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit2;
                Success success = (Success)try_;
                List l = (List)success.value();
                List list = l;
                if (Nil$.MODULE$.equals(list)) {
                    this.log().warn((Function0 & Serializable)() -> new StringBuilder(56).append("No response received to verify connection [").append(cf.vendor()).append(":").append(cf.provider()).append("] with id [").append(id).append("]").toString());
                    this.scheduleRetry(ctCtxt, cf);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    FlowEnvelope h = (FlowEnvelope)colon2.head();
                    boolean result = BoxesRunTime.unboxToBoolean((Object)$this.verify.apply((Object)h));
                    this.log().info((Function0 & Serializable)() -> new StringBuilder(54).append("Verification result [").append(id).append("] for client connection [").append(cf.vendor()).append(":").append(cf.provider()).append("] is [").append(result).append("]").toString());
                    boxedUnit2 = this.verified().complete((Try)new Success((Object)BoxesRunTime.boxToBoolean((boolean)result)));
                } else {
                    throw new MatchError((Object)list);
                }
                boxedUnit = boxedUnit2;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                this.log().warn((Function0 & Serializable)() -> new StringBuilder(72).append("Failed to receive verification response [").append(id).append("] to verify connection [").append(cf.vendor()).append(":").append(cf.provider()).append("] : [").append(t.getMessage()).append("]").toString());
                this.scheduleRetry(ctCtxt, cf);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
            return boxedUnit;
        }, (ExecutionContext)eCtxt);
    }

    public void probe(ContainerContext ctCtxt, IdAwareConnectionFactory cf) {
        FlowHeaderConfig headerConfig = FlowHeaderConfig$.MODULE$.create(ctCtxt);
        FlowEnvelopeLogger envLogger = FlowEnvelopeLogger$.MODULE$.create(headerConfig, this.log());
        String id = UUID.randomUUID().toString();
        FlowEnvelope qual$1 = (FlowEnvelope)this.probeMsg.apply((Object)id);
        String x$1 = (String)this.corrIdHeader().apply((Object)headerConfig.prefix());
        String x$22 = id;
        boolean x$3 = qual$1.withHeader$default$3();
        FlowEnvelope qual$2 = (FlowEnvelope)qual$1.withHeader(x$1, (Object)x$22, x$3).get();
        String x$4 = (String)this.replyToHeader().apply((Object)headerConfig.prefix());
        String x$5 = this.responseDest.asString();
        boolean x$6 = qual$2.withHeader$default$3();
        FlowEnvelope probeEnv = (FlowEnvelope)qual$2.withHeader(x$4, (Object)x$5, x$6).get();
        FlowEnvelopeLogger x$7 = envLogger;
        FlowHeaderConfig x$8 = headerConfig;
        IdAwareConnectionFactory x$9 = cf;
        Some x$10 = new Some((Object)this.requestDest);
        Some x$11 = new Some((Object)this.receiveTimeout.$times(2L));
        Function1 & Serializable x$12 = (Function1 & Serializable)s -> new MessageDestinationResolver(s);
        Function1 & Serializable x$13 = (Function1 & Serializable)x$2 -> LogLevel$.MODULE$.Debug();
        JmsKeyFormatStrategy x$14 = JmsProducerSettings$.MODULE$.apply$default$4();
        FiniteDuration x$15 = JmsProducerSettings$.MODULE$.apply$default$6();
        int x$16 = JmsProducerSettings$.MODULE$.apply$default$8();
        int x$17 = JmsProducerSettings$.MODULE$.apply$default$10();
        JmsDeliveryMode x$18 = JmsProducerSettings$.MODULE$.apply$default$11();
        Function0 x$19 = JmsProducerSettings$.MODULE$.apply$default$13();
        boolean x$20 = JmsProducerSettings$.MODULE$.apply$default$14();
        JmsProducerSettings pSettings = new JmsProducerSettings(x$7, (Function1)x$13, x$8, x$14, x$9, x$15, (Option)x$10, x$16, (Function1)x$12, x$17, x$18, (Option)x$11, x$19, x$20);
        this.log().info((Function0 & Serializable)() -> new StringBuilder(56).append("Running verification probe for connection [").append(cf.vendor()).append(":").append(cf.provider()).append("] with id [").append(id).append("]").toString());
        Try<KillSwitch> try_ = this.sendMessages(pSettings, envLogger, (Seq<FlowEnvelope>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowEnvelope[]{probeEnv}), this.system);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            KillSwitch s2 = (KillSwitch)success.value();
            this.log().info((Function0 & Serializable)() -> new StringBuilder(42).append("Request message [").append(id).append("] sent successfully to [").append($this.requestDest.asString()).append("]").toString());
            s2.shutdown();
            this.waitForResponse(ctCtxt, cf, id);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            this.log().debug((Function0 & Serializable)() -> new StringBuilder(68).append("Failed to send verification request [").append(id).append("] to verify connection [").append(cf.vendor()).append(":").append(cf.provider()).append("] : [").append(t.getMessage()).append("]").toString());
            this.scheduleRetry(ctCtxt, cf);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    private void scheduleRetry(ContainerContext ctCtxt, IdAwareConnectionFactory cf) {
        ExecutionContextExecutor eCtxt = this.system.dispatcher();
        package$.MODULE$.after(this.retryInterval, this.system.scheduler(), () -> RoundtripConnectionVerifier.$anonfun$scheduleRetry$1(this, cf, ctCtxt, (ExecutionContext)eCtxt), (ExecutionContext)eCtxt);
    }

    public static final /* synthetic */ Future $anonfun$scheduleRetry$1(RoundtripConnectionVerifier $this, IdAwareConnectionFactory cf$4, ContainerContext ctCtxt$3, ExecutionContext eCtxt$1) {
        $this.log().debug((Function0 & Serializable)() -> new StringBuilder(47).append("Scheduling retry to verify connection [").append(cf$4.vendor()).append(":").append(cf$4.provider()).append("] in [").append($this.retryInterval).append("]").toString());
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.probe(ctCtxt$3, cf$4), eCtxt$1);
    }

    public RoundtripConnectionVerifier(Function1<String, FlowEnvelope> probeMsg, Function1<FlowEnvelope, Object> verify, JmsDestination requestDest, JmsDestination responseDest, FiniteDuration retryInterval, FiniteDuration receiveTimeout, ActorSystem system) {
        this.probeMsg = probeMsg;
        this.verify = verify;
        this.requestDest = requestDest;
        this.responseDest = responseDest;
        this.retryInterval = retryInterval;
        this.receiveTimeout = receiveTimeout;
        this.system = system;
        JmsStreamSupport.$init$((JmsStreamSupport)this);
        JmsEnvelopeHeader.$init$((JmsEnvelopeHeader)this);
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(RoundtripConnectionVerifier.class));
        this.verified = Promise$.MODULE$.apply();
        Statics.releaseFence();
    }
}

