/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import org.iq80.leveldb.table.BlockHandle;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;

public class Footer {
    public static final int ENCODED_LENGTH = 48;
    private final BlockHandle metaindexBlockHandle;
    private final BlockHandle indexBlockHandle;

    Footer(BlockHandle metaindexBlockHandle, BlockHandle indexBlockHandle) {
        this.metaindexBlockHandle = metaindexBlockHandle;
        this.indexBlockHandle = indexBlockHandle;
    }

    public BlockHandle getMetaindexBlockHandle() {
        return this.metaindexBlockHandle;
    }

    public BlockHandle getIndexBlockHandle() {
        return this.indexBlockHandle;
    }

    public static Footer readFooter(Slice slice) {
        Preconditions.checkNotNull(slice, "slice is null");
        Preconditions.checkArgument(slice.length() == 48, "Expected slice.size to be %s but was %s", 48, slice.length());
        SliceInput sliceInput = slice.input();
        BlockHandle metaindexBlockHandle = BlockHandle.readBlockHandle(sliceInput);
        BlockHandle indexBlockHandle = BlockHandle.readBlockHandle(sliceInput);
        sliceInput.setPosition(40);
        long magicNumber = sliceInput.readUnsignedInt() | sliceInput.readUnsignedInt() << 32;
        Preconditions.checkArgument(magicNumber == -2646017456237118633L, "File is not a table (bad magic number)");
        return new Footer(metaindexBlockHandle, indexBlockHandle);
    }

    public static Slice writeFooter(Footer footer) {
        Slice slice = Slices.allocate(48);
        Footer.writeFooter(footer, slice.output());
        return slice;
    }

    public static void writeFooter(Footer footer, SliceOutput sliceOutput) {
        int startingWriteIndex = sliceOutput.size();
        BlockHandle.writeBlockHandleTo(footer.getMetaindexBlockHandle(), sliceOutput);
        BlockHandle.writeBlockHandleTo(footer.getIndexBlockHandle(), sliceOutput);
        sliceOutput.writeZero(40 - (sliceOutput.size() - startingWriteIndex));
        sliceOutput.writeInt(-1954481321);
        sliceOutput.writeInt(-616073948);
    }
}

