/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.ReadableBuffer;

public interface WritableBuffer {
    public void put(byte var1);

    public void putFloat(float var1);

    public void putDouble(double var1);

    public void put(byte[] var1, int var2, int var3);

    public void putShort(short var1);

    public void putInt(int var1);

    public void putLong(long var1);

    public boolean hasRemaining();

    public int remaining();

    public int position();

    public void position(int var1);

    public void put(ByteBuffer var1);

    public void put(ReadableBuffer var1);

    default public void put(String value) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char low;
            int c = value.charAt(i);
            if ((c & 0xFF80) == 0) {
                this.put((byte)c);
                continue;
            }
            if ((c & 0xF800) == 0) {
                this.put((byte)(0xC0 | c >> 6 & 0x1F));
                this.put((byte)(0x80 | c & 0x3F));
                continue;
            }
            if ((c & 0xD800) != 55296 || c > 56319) {
                this.put((byte)(0xE0 | c >> 12 & 0xF));
                this.put((byte)(0x80 | c >> 6 & 0x3F));
                this.put((byte)(0x80 | c & 0x3F));
                continue;
            }
            if (++i == length || ((low = value.charAt(i)) & 0xDC00) != 56320) {
                throw new IllegalArgumentException("String contains invalid Unicode code points");
            }
            c = 65536 + ((c & 0x3FF) << 10) + (low & 0x3FF);
            this.put((byte)(0xF0 | c >> 18 & 7));
            this.put((byte)(0x80 | c >> 12 & 0x3F));
            this.put((byte)(0x80 | c >> 6 & 0x3F));
            this.put((byte)(0x80 | c & 0x3F));
        }
    }

    public int limit();

    public static class ByteBufferWrapper
    implements WritableBuffer {
        private final ByteBuffer _buf;

        public ByteBufferWrapper(ByteBuffer buf) {
            this._buf = buf;
        }

        @Override
        public void put(byte b) {
            this._buf.put(b);
        }

        @Override
        public void putFloat(float f) {
            this._buf.putFloat(f);
        }

        @Override
        public void putDouble(double d) {
            this._buf.putDouble(d);
        }

        @Override
        public void put(byte[] src, int offset, int length) {
            this._buf.put(src, offset, length);
        }

        @Override
        public void putShort(short s) {
            this._buf.putShort(s);
        }

        @Override
        public void putInt(int i) {
            this._buf.putInt(i);
        }

        @Override
        public void putLong(long l) {
            this._buf.putLong(l);
        }

        @Override
        public boolean hasRemaining() {
            return this._buf.hasRemaining();
        }

        @Override
        public int remaining() {
            return this._buf.remaining();
        }

        @Override
        public int position() {
            return this._buf.position();
        }

        @Override
        public void position(int position) {
            this._buf.position(position);
        }

        @Override
        public void put(ByteBuffer src) {
            this._buf.put(src);
        }

        @Override
        public void put(ReadableBuffer src) {
            src.get(this);
        }

        @Override
        public void put(String value) {
            int length = value.length();
            int pos = this._buf.position();
            for (int i = 0; i < length; ++i) {
                int c = value.charAt(i);
                try {
                    char low;
                    if ((c & 0xFF80) == 0) {
                        this.put(pos++, (byte)c);
                        continue;
                    }
                    if ((c & 0xF800) == 0) {
                        this.put(pos++, (byte)(0xC0 | c >> 6 & 0x1F));
                        this.put(pos++, (byte)(0x80 | c & 0x3F));
                        continue;
                    }
                    if ((c & 0xD800) != 55296 || c > 56319) {
                        this.put(pos++, (byte)(0xE0 | c >> 12 & 0xF));
                        this.put(pos++, (byte)(0x80 | c >> 6 & 0x3F));
                        this.put(pos++, (byte)(0x80 | c & 0x3F));
                        continue;
                    }
                    if (++i == length || ((low = value.charAt(i)) & 0xDC00) != 56320) {
                        throw new IllegalArgumentException("String contains invalid Unicode code points");
                    }
                    c = 65536 + ((c & 0x3FF) << 10) + (low & 0x3FF);
                    this.put(pos++, (byte)(0xF0 | c >> 18 & 7));
                    this.put(pos++, (byte)(0x80 | c >> 12 & 0x3F));
                    this.put(pos++, (byte)(0x80 | c >> 6 & 0x3F));
                    this.put(pos++, (byte)(0x80 | c & 0x3F));
                    continue;
                }
                catch (IndexOutOfBoundsException ioobe) {
                    throw new BufferOverflowException();
                }
            }
            this._buf.position(pos);
        }

        @Override
        public int limit() {
            return this._buf.limit();
        }

        public ByteBuffer byteBuffer() {
            return this._buf;
        }

        public ReadableBuffer toReadableBuffer() {
            return ReadableBuffer.ByteBufferReader.wrap((ByteBuffer)this._buf.duplicate().flip());
        }

        public String toString() {
            return String.format("[pos: %d, limit: %d, remaining:%d]", this._buf.position(), this._buf.limit(), this._buf.remaining());
        }

        public static ByteBufferWrapper allocate(int size2) {
            ByteBuffer allocated = ByteBuffer.allocate(size2);
            return new ByteBufferWrapper(allocated);
        }

        public static ByteBufferWrapper wrap(ByteBuffer buffer) {
            return new ByteBufferWrapper(buffer);
        }

        public static ByteBufferWrapper wrap(byte[] bytes) {
            return new ByteBufferWrapper(ByteBuffer.wrap(bytes));
        }

        private void put(int index, byte value) {
            if (this._buf.hasArray()) {
                this._buf.array()[this._buf.arrayOffset() + index] = value;
            } else {
                this._buf.put(index, value);
            }
        }
    }
}

