/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.jms;

import akka.NotUsed;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow$;
import blended.streams.FlowHeaderConfig;
import blended.streams.FlowProcessor$;
import blended.streams.jms.JmsRetryConfig;
import blended.streams.jms.MissingRetryDestinationException;
import blended.streams.jms.MissingRetryHeaderException;
import blended.streams.jms.RetryCountExceededException;
import blended.streams.jms.RetryTimeoutException;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelopeLogger;
import blended.util.logging.LogLevel$;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005Q4A\u0001D\u0007\u0001)!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0011!a\u0003A!A!\u0002\u0013i\u0003\"B\u001a\u0001\t\u0003!\u0004BB\u001d\u0001A\u0003%!\bC\u0004?\u0001\t\u0007I\u0011A \t\r\u001d\u0003\u0001\u0015!\u0003A\u0011\u001dA\u0005A1A\u0005\u0002%CaA\u0018\u0001!\u0002\u0013Q\u0005bB0\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007g\u0002\u0001\u000b\u0011B1\u0003\u001d)k7OU3uef\u0014v.\u001e;fe*\u0011abD\u0001\u0004U6\u001c(B\u0001\t\u0012\u0003\u001d\u0019HO]3b[NT\u0011AE\u0001\bE2,g\u000eZ3e\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g\u0003\u0011q\u0017-\\3\u0011\u0005u!cB\u0001\u0010#!\tyr#D\u0001!\u0015\t\t3#\u0001\u0004=e>|GOP\u0005\u0003G]\ta\u0001\u0015:fI\u00164\u0017BA\u0013'\u0005\u0019\u0019FO]5oO*\u00111eF\u0001\te\u0016$(/_\"gOB\u0011\u0011FK\u0007\u0002\u001b%\u00111&\u0004\u0002\u000f\u00156\u001c(+\u001a;ss\u000e{gNZ5h\u0003\rawn\u001a\t\u0003]Ej\u0011a\f\u0006\u0003a=\tq!\\3tg\u0006<W-\u0003\u00023_\t\u0011b\t\\8x\u000b:4X\r\\8qK2{wmZ3s\u0003\u0019a\u0014N\\5u}Q!QGN\u001c9!\tI\u0003\u0001C\u0003\u001c\t\u0001\u0007A\u0004C\u0003(\t\u0001\u0007\u0001\u0006C\u0003-\t\u0001\u0007Q&A\u0005iK\u0006$WM]\"gOB\u00111\bP\u0007\u0002\u001f%\u0011Qh\u0004\u0002\u0011\r2|w\u000fS3bI\u0016\u00148i\u001c8gS\u001e\fa\u0001[3bI\u0016\u0014X#\u0001!\u0011\u0005\u0005#eBA\u001eC\u0013\t\u0019u\"A\u0007GY><\bK]8dKN\u001cxN]\u0005\u0003\u000b\u001a\u0013q\"\u00138uK\u001e\u0014\u0018\r^5p]N#X\r\u001d\u0006\u0003\u0007>\tq\u0001[3bI\u0016\u0014\b%\u0001\u0005wC2LG-\u0019;f+\u0005Q\u0005\u0003\u0002\fL\u001b\u0002K!\u0001T\f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001(\\\u001d\ty\u0005L\u0004\u0002Q+:\u0011\u0011k\u0015\b\u0003?IK\u0011AE\u0005\u0003)F\tA!\u001e;jY&\u0011akV\u0001\bY><w-\u001b8h\u0015\t!\u0016#\u0003\u0002Z5\u0006AAj\\4MKZ,GN\u0003\u0002W/&\u0011A,\u0018\u0002\t\u0019><G*\u001a<fY*\u0011\u0011LW\u0001\nm\u0006d\u0017\u000eZ1uK\u0002\nAA\u001a7poV\t\u0011\r\u0005\u0003cO&|W\"A2\u000b\u0005\u0011,\u0017AB:ue\u0016\fWNC\u0001g\u0003\u0011\t7n[1\n\u0005!\u001c'!B$sCBD\u0007\u0003\u00022kY2L!a[2\u0003\u0013\u0019cwn^*iCB,\u0007C\u0001\u0018n\u0013\tqwF\u0001\u0007GY><XI\u001c<fY>\u0004X\r\u0005\u0002qc6\tQ-\u0003\u0002sK\n9aj\u001c;Vg\u0016$\u0017!\u00024m_^\u0004\u0003")
public class JmsRetryRouter {
    private final JmsRetryConfig retryCfg;
    private final FlowEnvelopeLogger log;
    private final FlowHeaderConfig headerCfg;
    private final Function1<FlowEnvelope, Try<FlowEnvelope>> header;
    private final Function1<Enumeration.Value, Function1<FlowEnvelope, Try<FlowEnvelope>>> validate;
    private final Graph<FlowShape<FlowEnvelope, FlowEnvelope>, NotUsed> flow;

    public Function1<FlowEnvelope, Try<FlowEnvelope>> header() {
        return this.header;
    }

    public Function1<Enumeration.Value, Function1<FlowEnvelope, Try<FlowEnvelope>>> validate() {
        return this.validate;
    }

    public Graph<FlowShape<FlowEnvelope, FlowEnvelope>, NotUsed> flow() {
        return this.flow;
    }

    public static final /* synthetic */ long $anonfun$validate$4(FlowEnvelope env$2, String h) {
        long l;
        Option option = env$2.header(h, ManifestFactory$.MODULE$.Long());
        if (None$.MODULE$.equals(option)) {
            throw new MissingRetryHeaderException(h);
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        long l2 = l = BoxesRunTime.unboxToLong((Object)some.value());
        return l2;
    }

    public JmsRetryRouter(String name, JmsRetryConfig retryCfg, FlowEnvelopeLogger log) {
        this.retryCfg = retryCfg;
        this.log = log;
        this.headerCfg = retryCfg.headerCfg();
        this.header = (Function1 & Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
            boolean retrying = env.header($this.headerCfg.headerRetrying(), ManifestFactory$.MODULE$.classType(String.class)).nonEmpty();
            long maxRetries = BoxesRunTime.unboxToLong((Object)env.header($this.headerCfg.headerMaxRetries(), ManifestFactory$.MODULE$.Long()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> $this.retryCfg.maxRetries()));
            long retryCount = retrying ? BoxesRunTime.unboxToLong((Object)env.header($this.headerCfg.headerRetryCount(), ManifestFactory$.MODULE$.Long()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) + 1L : 1L;
            long retryTimeout = BoxesRunTime.unboxToLong((Object)env.header($this.headerCfg.headerRetryTimeout(), ManifestFactory$.MODULE$.Long()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> $this.retryCfg.retryTimeout().toMillis()));
            long firstRetry = BoxesRunTime.unboxToLong((Object)env.header($this.headerCfg.headerFirstRetry(), ManifestFactory$.MODULE$.Long()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> System.currentTimeMillis()));
            FlowEnvelope qual$1 = (FlowEnvelope)env.withHeader($this.headerCfg.headerMaxRetries(), BoxesRunTime.boxToLong((long)maxRetries), env.withHeader$default$3()).get();
            String x$1 = $this.headerCfg.headerRetryCount();
            long x$2 = retryCount;
            boolean x$3 = qual$1.withHeader$default$3();
            FlowEnvelope qual$2 = (FlowEnvelope)qual$1.withHeader(x$1, BoxesRunTime.boxToLong((long)x$2), x$3).get();
            String x$4 = $this.headerCfg.headerRetryTimeout();
            long x$5 = retryTimeout;
            boolean x$6 = qual$2.withHeader$default$3();
            FlowEnvelope qual$3 = (FlowEnvelope)qual$2.withHeader(x$4, BoxesRunTime.boxToLong((long)x$5), x$6).get();
            String x$7 = $this.headerCfg.headerFirstRetry();
            long x$8 = firstRetry;
            boolean x$9 = qual$3.withHeader$default$3();
            FlowEnvelope qual$4 = (FlowEnvelope)qual$3.withHeader(x$7, BoxesRunTime.boxToLong((long)x$8), x$9).get();
            String x$10 = $this.headerCfg.headerRetrying();
            String x$11 = "True";
            boolean x$12 = qual$4.withHeader$default$3();
            return (FlowEnvelope)qual$4.withHeader(x$10, "True", x$12).get();
        });
        this.validate = (Function1 & Serializable)level -> (Function1 & Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Function1 & Serializable mandatoryHeader = (Function1 & Serializable)h -> BoxesRunTime.boxToLong((long)JmsRetryRouter.$anonfun$validate$4(env, h));
            long maxRetries = BoxesRunTime.unboxToLong((Object)mandatoryHeader.apply((Object)$this.headerCfg.headerMaxRetries()));
            long retryCount = BoxesRunTime.unboxToLong((Object)mandatoryHeader.apply((Object)$this.headerCfg.headerRetryCount()));
            long retryTimeout = BoxesRunTime.unboxToLong((Object)mandatoryHeader.apply((Object)$this.headerCfg.headerRetryTimeout()));
            long firstRetry = BoxesRunTime.unboxToLong((Object)mandatoryHeader.apply((Object)$this.headerCfg.headerFirstRetry()));
            FiniteDuration remaining = new package.DurationLong(package$.MODULE$.DurationLong(retryTimeout - (System.currentTimeMillis() - firstRetry))).millis();
            $this.log.logEnv((FlowEnvelope)env, (Enumeration.Value)level, (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Retrying envelope [").append(env.id()).append("] : [").append(retryCount).append(" / ").append(maxRetries).append("] [").append(remaining).append("] remaining").toString(), false);
            if (maxRetries > 0L && retryCount > maxRetries) {
                throw new RetryCountExceededException(maxRetries);
            }
            if (System.currentTimeMillis() - firstRetry > retryTimeout) {
                throw new RetryTimeoutException(firstRetry + retryTimeout);
            }
            if (env.header($this.headerCfg.headerRetryDestination(), ManifestFactory$.MODULE$.classType(String.class)).isEmpty()) {
                throw new MissingRetryDestinationException($this.headerCfg.headerRetryDestination());
            }
            return env;
        });
        this.flow = Flow$.MODULE$.fromGraph(FlowProcessor$.MODULE$.fromFunction(new StringBuilder(7).append(name).append(".header").toString(), log, this.header())).via(FlowProcessor$.MODULE$.fromFunction(new StringBuilder(9).append(name).append(".validate").toString(), log, (Function1<FlowEnvelope, Try<FlowEnvelope>>)((Function1)this.validate().apply((Object)LogLevel$.MODULE$.Debug()))));
    }
}

