/*
 * Decompiled with CFR 0.152.
 */
package blended.websocket.internal;

import akka.actor.ActorSystem;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.ws.Message;
import akka.http.scaladsl.model.ws.TextMessage;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.directives.ParameterDirectives;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import blended.security.login.api.Token;
import blended.security.login.api.TokenStore;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import blended.websocket.WebSocketCommandPackage;
import blended.websocket.WsMessageEncoded;
import blended.websocket.internal.CommandHandlerManager;
import blended.websocket.internal.CommandHandlerManager$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\u0007\u000f\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)\u0001\u0007\u0001C\u0001c!1a\u0007\u0001Q\u0001\n]Baa\u0010\u0001!\u0002\u0017\u0001\u0005B\u0002$\u0001A\u0003%q\tC\u0003K\u0001\u0011\u00051\nC\u0003V\u0001\u0011\u0005a\u000bC\u0003Y\u0001\u0011\u0005\u0011\f\u0003\u0005s\u0001!\u0015\r\u0015\"\u0003Z\u0011\u0019\u0019\b\u0001)C\u0005i\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m!\u0001G,fEN{7m[3u!J|Go\\2pY\"\u000bg\u000e\u001a7fe*\u0011q\u0002E\u0001\tS:$XM\u001d8bY*\u0011\u0011CE\u0001\no\u0016\u00147o\\2lKRT\u0011aE\u0001\bE2,g\u000eZ3e\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0019\u0018p\u001d;f[B\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0006C\u000e$xN\u001d\u0006\u0002E\u0005!\u0011m[6b\u0013\t!sDA\u0006BGR|'oU=ti\u0016l\u0017!B:u_J,\u0007CA\u0014/\u001b\u0005A#BA\u0015+\u0003\r\t\u0007/\u001b\u0006\u0003W1\nQ\u0001\\8hS:T!!\f\n\u0002\u0011M,7-\u001e:jifL!a\f\u0015\u0003\u0015Q{7.\u001a8Ti>\u0014X-\u0001\u0004=S:LGO\u0010\u000b\u0004eQ*\u0004CA\u001a\u0001\u001b\u0005q\u0001\"\u0002\u000f\u0004\u0001\u0004i\u0002\"B\u0013\u0004\u0001\u00041\u0013a\u00017pOB\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\bY><w-\u001b8h\u0015\ta$#\u0001\u0003vi&d\u0017B\u0001 :\u0005\u0019aunZ4fe\u0006)Qm\u0011;yiB\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tG\u0001\u000bG>t7-\u001e:sK:$\u0018BA#C\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0006d[\u0012D\u0015M\u001c3mKJ\u0004\"a\r%\n\u0005%s!!F\"p[6\fg\u000e\u001a%b]\u0012dWM]'b]\u0006<WM]\u0001\u0012C\u0012$7i\\7nC:$\u0007+Y2lC\u001e,GC\u0001'P!\t9R*\u0003\u0002O1\t!QK\\5u\u0011\u0015\u0001v\u00011\u0001R\u0003\r\u00018n\u001a\t\u0003%Nk\u0011\u0001E\u0005\u0003)B\u0011qcV3c'>\u001c7.\u001a;D_6l\u0017M\u001c3QC\u000e\\\u0017mZ3\u0002)I,Wn\u001c<f\u0007>lW.\u00198e!\u0006\u001c7.Y4f)\tau\u000bC\u0003Q\u0011\u0001\u0007\u0011+A\u0003s_V$X-F\u0001[!\tYvN\u0004\u0002]Y:\u0011Q,\u001b\b\u0003=\u001at!a\u00183\u000f\u0005\u0001\u001cW\"A1\u000b\u0005\t$\u0012A\u0002\u001fs_>$h(C\u0001#\u0013\t)\u0017%\u0001\u0003iiR\u0004\u0018BA4i\u0003!\u00198-\u00197bINd'BA3\"\u0013\tQ7.\u0001\u0004tKJ4XM\u001d\u0006\u0003O\"L!!\u001c8\u0002\u000fA\f7m[1hK*\u0011!n[\u0005\u0003aF\u0014QAU8vi\u0016T!!\u001c8\u0002\u0013I|W\u000f^3J[Bd\u0017a\u00035b]\u0012dWM\u001d$m_^$2!^A\b!\u00191(\u0010 ?\u0002\n5\tqO\u0003\u0002hq*\u0011\u00110I\u0001\u0007gR\u0014X-Y7\n\u0005m<(\u0001\u0002$m_^\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005\u0011qo\u001d\u0006\u0004\u0003\u0007Y\u0017!B7pI\u0016d\u0017bAA\u0004}\n9Q*Z:tC\u001e,\u0007cA\f\u0002\f%\u0019\u0011Q\u0002\r\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0012-\u0001\r!a\u0005\u0002\t%tgm\u001c\t\u0004O\u0005U\u0011bAA\fQ\t)Ak\\6f]\u0006\u0001\"/\u001a9peR,%O]8sg\u001acwn^\u000b\u0005\u0003;\t)#\u0006\u0002\u0002 AAaO_A\u0011\u0003C\tI\u0001\u0005\u0003\u0002$\u0005\u0015B\u0002\u0001\u0003\b\u0003Oa!\u0019AA\u0015\u0005\u0005!\u0016\u0003BA\u0016\u0003\u0013\u00012aFA\u0017\u0013\r\ty\u0003\u0007\u0002\b\u001d>$\b.\u001b8h\u0001")
public class WebSocketProtocolHandler {
    private Function1<RequestContext, Future<RouteResult>> routeImpl;
    private final TokenStore store;
    private final Logger log;
    private final ExecutionContext eCtxt;
    private final CommandHandlerManager cmdHandler;
    private volatile boolean bitmap$0;

    public void addCommandPackage(WebSocketCommandPackage pkg) {
        this.cmdHandler.addCommandPackage(pkg);
    }

    public void removeCommandPackage(WebSocketCommandPackage pkg) {
        this.cmdHandler.removeCommandPackage(pkg);
    }

    public Function1<RequestContext, Future<RouteResult>> route() {
        return this.routeImpl();
    }

    private Function1<RequestContext, Future<RouteResult>> routeImpl$lzycompute() {
        WebSocketProtocolHandler webSocketProtocolHandler = this;
        synchronized (webSocketProtocolHandler) {
            if (!this.bitmap$0) {
                this.routeImpl = (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.pathSingleSlash()).apply((Function0 & Serializable)() -> {
                    $this.log.debug((Function0 & Serializable)() -> "Received Web Socket upgrade request");
                    return (Function1)Directive$.MODULE$.addDirectiveApply((Directive)Directives$.MODULE$.parameter(ParameterDirectives.ParamMagnet$.MODULE$.apply((Object)"token", ParameterDirectives.ParamDef$.MODULE$.forString(Unmarshaller$.MODULE$.identityUnmarshaller()))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)token -> {
                        StandardRoute standardRoute;
                        $this.log.debug((Function0 & Serializable)() -> new StringBuilder(19).append("Evaluating token [").append((String)token).append("]").toString());
                        Try try_ = $this.store.verifyToken(token);
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            $this.log.error((Function0 & Serializable)() -> new StringBuilder(30).append("Could not verify token [").append((String)token).append("] : [").append(e.getMessage()).append("]").toString());
                            standardRoute = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.Unauthorized(), Marshaller$.MODULE$.fromStatusCode()));
                        } else if (try_ instanceof Success) {
                            StandardRoute standardRoute2;
                            Success success = (Success)try_;
                            Token verified = (Token)success.value();
                            $this.log.info((Function0 & Serializable)() -> new StringBuilder(48).append("Starting Web Socket message handler for token [").append(verified.id()).append("]").toString());
                            Option option = $this.store.getToken(verified.id());
                            if (None$.MODULE$.equals(option)) {
                                standardRoute2 = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.BadRequest(), Marshaller$.MODULE$.fromStatusCode()));
                            } else if (option instanceof Some) {
                                Some some = (Some)option;
                                Token info = (Token)some.value();
                                standardRoute2 = Directives$.MODULE$.handleWebSocketMessages(this.handlerFlow(info));
                            } else {
                                throw new MatchError((Object)option);
                            }
                            standardRoute = standardRoute2;
                        } else {
                            throw new MatchError((Object)try_);
                        }
                        return standardRoute;
                    });
                });
                this.bitmap$0 = true;
            }
        }
        return this.routeImpl;
    }

    private Function1<RequestContext, Future<RouteResult>> routeImpl() {
        return !this.bitmap$0 ? this.routeImpl$lzycompute() : this.routeImpl;
    }

    private Flow<Message, Message, Object> handlerFlow(Token info) {
        return ((Flow)((Flow)Flow$.MODULE$.apply().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Message, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TextMessage.Strict) {
                    TextMessage.Strict strict = (TextMessage.Strict)A1;
                    String msg = strict.text();
                    object = msg;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Message x1) {
                Message message = x1;
                boolean bl = message instanceof TextMessage.Strict;
                return bl;
            }
        })).via(this.cmdHandler.newClient(info)).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends WsMessageEncoded, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    A1 A12 = A1;
                    object = new TextMessage.Strict(A12.json());
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(WsMessageEncoded x2) {
                WsMessageEncoded wsMessageEncoded = x2;
                boolean bl = wsMessageEncoded != null;
                return bl;
            }
        })).via(this.reportErrorsFlow());
    }

    public <T> Flow<T, T, Object> reportErrorsFlow() {
        return (Flow)Flow$.MODULE$.apply().watchTermination((Function2 & Serializable)(x$1, f) -> {
            f.onComplete((Function1 & Serializable)x0$1 -> {
                WebSocketProtocolHandler.$anonfun$reportErrorsFlow$2($this, x0$1);
                return BoxedUnit.UNIT;
            }, this.eCtxt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$reportErrorsFlow$2(WebSocketProtocolHandler $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable cause = failure.exception();
            $this.log.error(cause, $this.log.error$default$2(), (Function0 & Serializable)() -> new StringBuilder(21).append("WS stream failed : [").append(cause.getMessage()).append("]").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public WebSocketProtocolHandler(ActorSystem system, TokenStore store) {
        this.store = store;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(WebSocketProtocolHandler.class));
        this.eCtxt = system.dispatcher();
        this.cmdHandler = CommandHandlerManager$.MODULE$.create(system);
    }
}

