/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.config;

import blended.updater.config.Artifact;
import blended.updater.config.ArtifactCompanion$;
import blended.updater.config.BundleConfig;
import blended.updater.config.BundleConfigCompanion$;
import blended.updater.config.FeatureConfig;
import blended.updater.config.FeatureConfigCompanion$;
import blended.updater.config.FeatureRef;
import blended.updater.config.FeatureRefCompanion$;
import blended.updater.config.Profile;
import blended.updater.config.Profile$;
import blended.updater.config.util.ConfigPropertyMapConverter$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Formatter;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class ProfileCompanion$ {
    public static final ProfileCompanion$ MODULE$ = new ProfileCompanion$();

    public Try<Profile> read(Config config) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Function1 & Serializable getProperties = (Function1 & Serializable)key -> ConfigPropertyMapConverter$.MODULE$.getKeyAsPropertyMap(config, (String)key, (Option<Function0<scala.collection.immutable.Map<String, String>>>)new Some((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()));
            Config optionals = ConfigFactory.parseResources(MODULE$.getClass(), (String)"RuntimeConfig-optional.conf", (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
            Config reference = ConfigFactory.parseResources(MODULE$.getClass(), (String)"RuntimeConfig-reference.conf", (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
            config.withFallback((ConfigMergeable)optionals).checkValid(reference, new String[0]);
            return new Profile(config.getString("name"), config.getString("version"), (List<BundleConfig>)(config.hasPath("bundles") ? ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(config.getObjectList("bundles")).asScala().map((Function1 & Serializable)bc -> (BundleConfig)BundleConfigCompanion$.MODULE$.read(bc.toConfig()).get())).toList() : List$.MODULE$.empty()), config.getInt("startLevel"), config.getInt("defaultStartLevel"), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)getProperties.apply((Object)"properties")), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)getProperties.apply((Object)"frameworkProperties")), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)getProperties.apply((Object)"systemProperties")), (List<FeatureRef>)(config.hasPath("features") ? ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(config.getObjectList("features")).asScala().map((Function1 & Serializable)f -> (FeatureRef)FeatureRefCompanion$.MODULE$.fromConfig(f.toConfig()).get())).toList() : List$.MODULE$.empty()), (List<Artifact>)(config.hasPath("resources") ? ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(config.getObjectList("resources")).asScala().map((Function1 & Serializable)r -> (Artifact)ArtifactCompanion$.MODULE$.read(r.toConfig()).get())).toList() : List$.MODULE$.empty()), (List<FeatureConfig>)(config.hasPath("resolvedFeatures") ? ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(config.getObjectList("resolvedFeatures")).asScala().map((Function1 & Serializable)r -> (FeatureConfig)FeatureConfigCompanion$.MODULE$.read(r.toConfig()).get())).toList() : List$.MODULE$.empty()));
        });
    }

    public Config toConfig(Profile profile) {
        Function1 & Serializable propCfg = (Function1 & Serializable)m -> ConfigPropertyMapConverter$.MODULE$.propertyMapToConfigValue((scala.collection.immutable.Map<String, String>)m);
        java.util.Map config = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)profile.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)profile.version()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bundles"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)profile.bundles().map((Function1 & Serializable)bundleConfig -> BundleConfigCompanion$.MODULE$.toConfig((BundleConfig)bundleConfig)).map((Function1 & Serializable)x$1 -> x$1.root().unwrapped())).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startLevel"), (Object)BoxesRunTime.boxToInteger((int)profile.startLevel())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultStartLevel"), (Object)BoxesRunTime.boxToInteger((int)profile.defaultStartLevel())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"properties"), propCfg.apply(profile.properties())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"frameworkProperties"), propCfg.apply(profile.frameworkProperties())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"systemProperties"), propCfg.apply(profile.systemProperties())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)profile.features().map((Function1 & Serializable)feature -> FeatureRefCompanion$.MODULE$.toConfig((FeatureRef)feature)).map((Function1 & Serializable)x$2 -> x$2.root().unwrapped())).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resources"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)profile.resources().map((Function1 & Serializable)artifact -> ArtifactCompanion$.MODULE$.toConfig((Artifact)artifact)).map((Function1 & Serializable)x$3 -> x$3.root().unwrapped())).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resolvedFeatures"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)profile.resolvedFeatures().map((Function1 & Serializable)featureConfig -> FeatureConfigCompanion$.MODULE$.toConfig((FeatureConfig)featureConfig)).map((Function1 & Serializable)x$4 -> x$4.root().unwrapped())).asJava())}))).asJava();
        return ConfigFactory.parseMap((java.util.Map)config).resolve();
    }

    public String bytesToString(byte[] digest) {
        StringBuilder result = new StringBuilder(32);
        Formatter f = new Formatter(result);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.byteArrayOps(digest), (Function1 & Serializable)b -> f.format("%02x", BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)b))));
        return result.toString();
    }

    public Option<String> digestFile(File file) {
        None$ none$;
        if (!file.exists()) {
            none$ = None$.MODULE$;
        } else {
            try (DigestInputStream sha1Stream = new DigestInputStream(new BufferedInputStream(new FileInputStream(file)), MessageDigest.getInstance("SHA"));){
                try {
                    while (sha1Stream.read() != -1) {
                    }
                    none$ = Option$.MODULE$.apply((Object)this.bytesToString(sha1Stream.getMessageDigest().digest()));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    None$ none$2 = None$.MODULE$;
                    none$ = none$2;
                }
            }
        }
        return none$;
    }

    public Try<File> download(String url, File file) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            File file;
            File file2;
            File file3 = file.getAbsoluteFile().getParentFile();
            if (file3 == null) {
                file2 = new File(".");
            } else {
                Object object = !file3.exists() ? BoxesRunTime.boxToBoolean((boolean)file3.mkdirs()) : BoxedUnit.UNIT;
                file2 = file3;
            }
            File parentDir = file2;
            File tmpFile = File.createTempFile(new StringBuilder(1).append(".").append(file.getName()).toString(), "", parentDir);
            try {
                FileOutputStream fileStream = new FileOutputStream(tmpFile);
                BufferedOutputStream outStream = new BufferedOutputStream(fileStream);
                try {
                    URLConnection connection = new URL(url).openConnection();
                    connection.setRequestProperty("User-Agent", "Blended Updater");
                    try (BufferedInputStream inStream = new BufferedInputStream(connection.getInputStream());){
                        int bufferSize = 1024;
                        byte[] buffer = new byte[bufferSize];
                        while (true) {
                            boolean bl;
                            int n = inStream.read(buffer, 0, bufferSize);
                            switch (n) {
                                default: 
                            }
                            if (n < 0) {
                                bl = false;
                            } else {
                                outStream.write(buffer, 0, n);
                                bl = true;
                            }
                            if (bl) {
                                continue;
                            }
                            break;
                        }
                    }
                }
                finally {
                    outStream.flush();
                    outStream.close();
                    fileStream.flush();
                    fileStream.close();
                }
                Files.move(Paths.get(tmpFile.toURI()), Paths.get(file.toURI()), StandardCopyOption.ATOMIC_MOVE);
                file = file;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    Object object = tmpFile.exists() ? BoxesRunTime.boxToBoolean((boolean)tmpFile.delete()) : BoxedUnit.UNIT;
                    throw e;
                }
                throw throwable;
            }
            return file;
        });
    }

    public File bundlesBaseDir(File baseDir) {
        return new File(baseDir, "bundles");
    }

    public File bundleLocation(BundleConfig bundle, File baseDir) {
        return new File(this.bundlesBaseDir(baseDir), (String)bundle.jarName().getOrElse((Function0 & Serializable)() -> (String)Profile$.MODULE$.resolveFileName(bundle.url()).get()));
    }

    public File bundleLocation(Artifact artifact, File baseDir) {
        return new File(this.bundlesBaseDir(baseDir), (String)artifact.fileName().getOrElse((Function0 & Serializable)() -> (String)Profile$.MODULE$.resolveFileName(artifact.url()).get()));
    }

    public File resourceArchiveLocation(Artifact resourceArchive, File baseDir) {
        return new File(baseDir, new StringBuilder(10).append("resources/").append(resourceArchive.fileName().getOrElse((Function0 & Serializable)() -> (String)Profile$.MODULE$.resolveFileName(resourceArchive.url()).get())).toString());
    }

    public File resourceArchiveTouchFileLocation(Artifact resourceArchive, File baseDir, Option<String> mvnBaseUrl) {
        File resFile = this.resourceArchiveLocation(resourceArchive, baseDir);
        return new File(resFile.getParentFile(), new StringBuilder(1).append(".").append(resFile.getName()).toString());
    }

    private ProfileCompanion$() {
    }
}

