/*
 * Decompiled with CFR 0.152.
 */
package blended.security.login.rest.internal;

import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.headers.Access;
import akka.http.scaladsl.model.headers.Access$minusControl$minusAllow$minusHeaders$;
import akka.http.scaladsl.model.headers.Access$minusControl$minusAllow$minusMethods$;
import akka.http.scaladsl.model.headers.Access$minusControl$minusAllow$minusOrigin$;
import akka.http.scaladsl.model.headers.HttpChallenge;
import akka.http.scaladsl.model.headers.ResponseHeader;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.directives.AuthenticationDirective;
import akka.http.scaladsl.server.util.ApplyConverter$;
import blended.security.BlendedPermission;
import blended.security.BlendedPermissionManager;
import blended.security.akka.http.BlendedSecurityDirectives;
import blended.security.akka.http.JAASSecurityDirectives;
import blended.security.login.api.Token;
import blended.security.login.api.TokenStore;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.security.auth.Subject;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005]4A\u0001D\u0007\u00011!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00110\u0011!!\u0004A!A!\u0002\u0013\u0001\u0004\u0002C\u001b\u0001\u0005\u0003\u0005\u000b1\u0002\u001c\t\u000bq\u0002A\u0011A\u001f\t\r\u0011\u0003\u0001\u0015!\u0003F\u0011!i\u0005\u0001#b!\n\u0013q\u0005\"\u0002.\u0001\t\u0003Y\u0006BB9\u0001A\u0003%!\u000f\u0003\u0004v\u0001\u0001\u0006IA\u001d\u0005\u0007m\u0002\u0001\u000b\u0011\u0002:\u0003\u00191{w-\u001b8TKJ4\u0018nY3\u000b\u00059y\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005A\t\u0012\u0001\u0002:fgRT!AE\n\u0002\u000b1|w-\u001b8\u000b\u0005Q)\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003Y\tqA\u00197f]\u0012,Gm\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\nA\u0001\u001b;ua*\u0011AeE\u0001\u0005C.\\\u0017-\u0003\u0002'C\t1\"*Q!T'\u0016\u001cWO]5us\u0012K'/Z2uSZ,7/\u0001\u0006u_.,gn\u001d;pe\u0016\u0004\"!\u000b\u0017\u000e\u0003)R!aK\t\u0002\u0007\u0005\u0004\u0018.\u0003\u0002.U\tQAk\\6f]N#xN]3\u0002\u00075<'/F\u00011!\t\t$'D\u0001\u0014\u0013\t\u00194C\u0001\rCY\u0016tG-\u001a3QKJl\u0017n]:j_:l\u0015M\\1hKJ\fA!\\4sA\u0005)Qm\u0011;yiB\u0011qGO\u0007\u0002q)\u0011\u0011hG\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u001e9\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0004}\t\u001bECA B!\t\u0001\u0005!D\u0001\u000e\u0011\u0015)T\u0001q\u00017\u0011\u00159S\u00011\u0001)\u0011\u0015qS\u00011\u00011\u0003\rawn\u001a\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000bq\u0001\\8hO&twM\u0003\u0002K+\u0005!Q\u000f^5m\u0013\tauI\u0001\u0004M_\u001e<WM]\u0001\raV\u0014G.[2LKf\u0004V)T\u000b\u0002\u001fB\u0011\u0001k\u0016\b\u0003#V\u0003\"AU\u000e\u000e\u0003MS!\u0001V\f\u0002\rq\u0012xn\u001c;?\u0013\t16$\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,\u001c\u0003\u0015\u0011x.\u001e;f+\u0005a\u0006CA/o\u001d\tq6N\u0004\u0002`Q:\u0011\u0001-\u001a\b\u0003C\u000et!A\u00152\n\u0003\u0011J!A\t3\u000b\u0003\u0011J!AZ4\u0002\u0011M\u001c\u0017\r\\1eg2T!A\t3\n\u0005%T\u0017AB:feZ,'O\u0003\u0002gO&\u0011A.\\\u0001\ba\u0006\u001c7.Y4f\u0015\tI'.\u0003\u0002pa\n)!k\\;uK*\u0011A.\\\u0001\u000bY><\u0017N\u001c*pkR,\u0007CA:o\u001d\t!8.D\u0001n\u0003-awnZ8viJ{W\u000f^3\u0002\u001dA,(\r\\5d\u0017\u0016L(k\\;uK\u0002")
public class LoginService
implements JAASSecurityDirectives {
    private String publicKeyPEM;
    private final TokenStore tokenstore;
    private final BlendedPermissionManager mgr;
    private final ExecutionContext eCtxt;
    private final Logger log;
    private final Function1<RequestContext, Future<RouteResult>> loginRoute;
    private final Function1<RequestContext, Future<RouteResult>> logoutRoute;
    private final Function1<RequestContext, Future<RouteResult>> publicKeyRoute;
    private Logger blended$security$akka$http$JAASSecurityDirectives$$log;
    private HttpChallenge blended$security$akka$http$JAASSecurityDirectives$$challenge;
    private AuthenticationDirective<Subject> authenticated;
    private volatile byte bitmap$0;

    public Directive<BoxedUnit> requirePermission(BlendedPermission permission) {
        return JAASSecurityDirectives.requirePermission$((JAASSecurityDirectives)this, (BlendedPermission)permission);
    }

    public Directive<BoxedUnit> requireGroup(String group) {
        return JAASSecurityDirectives.requireGroup$((JAASSecurityDirectives)this, (String)group);
    }

    public Directive<BoxedUnit> requirePermission(String permission) {
        return BlendedSecurityDirectives.requirePermission$((BlendedSecurityDirectives)this, (String)permission);
    }

    private Logger blended$security$akka$http$JAASSecurityDirectives$$log$lzycompute() {
        LoginService loginService = this;
        synchronized (loginService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.blended$security$akka$http$JAASSecurityDirectives$$log = JAASSecurityDirectives.blended$security$akka$http$JAASSecurityDirectives$$log$((JAASSecurityDirectives)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.blended$security$akka$http$JAASSecurityDirectives$$log;
    }

    public Logger blended$security$akka$http$JAASSecurityDirectives$$log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.blended$security$akka$http$JAASSecurityDirectives$$log$lzycompute() : this.blended$security$akka$http$JAASSecurityDirectives$$log;
    }

    public HttpChallenge blended$security$akka$http$JAASSecurityDirectives$$challenge() {
        return this.blended$security$akka$http$JAASSecurityDirectives$$challenge;
    }

    public AuthenticationDirective<Subject> authenticated() {
        return this.authenticated;
    }

    public final void blended$security$akka$http$JAASSecurityDirectives$_setter_$blended$security$akka$http$JAASSecurityDirectives$$challenge_$eq(HttpChallenge x$1) {
        this.blended$security$akka$http$JAASSecurityDirectives$$challenge = x$1;
    }

    public void blended$security$akka$http$JAASSecurityDirectives$_setter_$authenticated_$eq(AuthenticationDirective<Subject> x$1) {
        this.authenticated = x$1;
    }

    public BlendedPermissionManager mgr() {
        return this.mgr;
    }

    private String publicKeyPEM$lzycompute() {
        LoginService loginService = this;
        synchronized (loginService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                PublicKey key = this.tokenstore.publicKey();
                byte[] encodedKey = new X509EncodedKeySpec(key.getEncoded()).getEncoded();
                String stringKey = Base64.getEncoder().encodeToString(encodedKey);
                List pemLines = this.lines$1(stringKey, (List)new .colon.colon((Object)"-----BEGIN PUBLIC KEY-----", (List)Nil$.MODULE$)).$colon$colon((Object)"-----END PUBLIC KEY-----").reverse();
                this.publicKeyPEM = pemLines.mkString("\n");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.publicKeyPEM;
    }

    private String publicKeyPEM() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.publicKeyPEM$lzycompute() : this.publicKeyPEM;
    }

    public Function1<RequestContext, Future<RouteResult>> route() {
        return Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation(this.loginRoute).$tilde(this.logoutRoute)).$tilde(this.publicKeyRoute);
    }

    private final List lines$1(String s, List current) {
        while (true) {
            if (s.length() <= 64) break;
            String string = s.substring(0, 64);
            current = current.$colon$colon((Object)string);
            s = s.substring(64);
        }
        String string = s;
        return current.$colon$colon((Object)string);
    }

    public LoginService(TokenStore tokenstore, BlendedPermissionManager mgr, ExecutionContext eCtxt) {
        this.tokenstore = tokenstore;
        this.mgr = mgr;
        this.eCtxt = eCtxt;
        BlendedSecurityDirectives.$init$((BlendedSecurityDirectives)this);
        JAASSecurityDirectives.$init$((JAASSecurityDirectives)this);
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(LoginService.class));
        Seq header = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResponseHeader[]{Access$minusControl$minusAllow$minusOrigin$.MODULE$.$times(), Access$minusControl$minusAllow$minusMethods$.MODULE$.apply(HttpMethods$.MODULE$.GET(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpMethod[]{HttpMethods$.MODULE$.POST(), HttpMethods$.MODULE$.OPTIONS()})), new Access.minusControl.minusMax.minusAge(1000L), Access$minusControl$minusAllow$minusHeaders$.MODULE$.apply("origin", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x-csrftoken", "content-type", "accept", "authorization"}))}));
        this.loginRoute = (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.pathSingleSlash()).apply((Function0 & Serializable)() -> Directives$.MODULE$._enhanceRouteWithConcatenation(Directives$.MODULE$._enhanceRouteWithConcatenation((Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.options()).apply((Function0 & Serializable)() -> Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.OK(), HttpResponse$.MODULE$.apply$default$2(), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4()).withHeaders(header), Marshaller$.MODULE$.fromResponse())))).$tilde((Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.get()).apply((Function0 & Serializable)() -> {
            $this.log.warn((Function0 & Serializable)() -> "Login must be executed with a HTTP Post");
            return Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.Forbidden(), HttpResponse$.MODULE$.apply$default$2(), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4()).withHeaders(header), Marshaller$.MODULE$.fromResponse()));
        }))).$tilde((Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.post()).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.authenticated(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)subj -> Directives$.MODULE$.complete((Function0 & Serializable)() -> {
            ToResponseMarshallable toResponseMarshallable;
            Try try_ = $this.tokenstore.newToken(subj, (Option)new Some((Object)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute()), $this.eCtxt);
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                $this.log.error((Function0 & Serializable)() -> new StringBuilder(27).append("Could not create token : [").append(e.getMessage()).append("]").toString());
                toResponseMarshallable = ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.BadRequest(), HttpResponse$.MODULE$.apply$default$2(), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4()).withHeaders(header), Marshaller$.MODULE$.fromResponse());
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                Token t = (Token)success.value();
                $this.log.info((Function0 & Serializable)() -> new StringBuilder(46).append("User [").append(t.user()).append("] logged in successfully, token-id is [").append(t.id()).append("]").toString());
                StatusCodes.Success x$1 = StatusCodes$.MODULE$.OK();
                HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(t.webToken());
                Seq x$3 = HttpResponse$.MODULE$.apply$default$2();
                HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
                toResponseMarshallable = ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4).withHeaders(header), Marshaller$.MODULE$.fromResponse());
            } else {
                throw new MatchError((Object)try_);
            }
            return toResponseMarshallable;
        })))));
        this.logoutRoute = (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("logout"))).apply((Function0 & Serializable)() -> Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.NotImplemented(), HttpResponse$.MODULE$.apply$default$2(), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4()), Marshaller$.MODULE$.fromResponse())));
        this.publicKeyRoute = (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.path(Directives$.MODULE$._segmentStringToPathMatcher("key"))).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.get()).apply((Function0 & Serializable)() -> Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)this.publicKeyPEM(), Marshaller$.MODULE$.liftMarshaller(Marshaller$.MODULE$.StringMarshaller())))));
        Statics.releaseFence();
    }
}

